<?php

/**
 * sfSiteStructure components.
 *
 * @package    sfSiteStructure
 * @subpackage plugin
 * @author     flyfront <flyfront@gmail.com>
 * @version    SVN: $Id: components.class.php 16 2008-04-30 14:13:09Z flyfront $
 */
class sfSiteStructureComponents extends sfComponents 
{ 
  public function executeSitemap()
  {
      try {
          $structure = sfSiteStructure::getInstance();
          $this->structure_tree = $structure->getStructureTree();
      } catch (sfSiteStructureException $ex){
          $this->structure_tree = array();
      }
  }

  public function executeSitemap_recursive()
  {
      //do nothing;
  }
  
  public function executeTopicPath()
  {   
      try {
          $routing = sfRouting::getInstance();
          $structure = sfSiteStructure::getInstance();
          
          $internal_url = $routing->getCurrentInternalUri(true);
          list($current_name, $params) = $this->getController()->convertUrlStringToParameters($internal_url);
          $current_node = $structure->getNodeByRouting($current_name, $params);
          $this->topicpath_nodes = array($current_node);
          $this->buildTopicPathRecursive($current_node);
          
          $this->topicpath_nodes = array_reverse($this->topicpath_nodes, true);
      } catch (sfSiteStructureException $ex){
          $this->topicpath_nodes = array();
      }
      
      return sfView::SUCCESS;
  }

  /**
   * パンくずリストデータを返す
   * ※ただし�?�?末端)→親(トッ�?の�?��入る�?で、返り連想配�?にkrsort�??
   * @param $last_node sfStructureNode
   */
  private function buildTopicPathRecursive($last_node)
  {
      if ($last_node->hasParentNode()){
          $parent_node = $last_node->getParentNode();
          if (!$parent_node->isNopage()){
              $this->topicpath_nodes[] = $parent_node;
          }
          $this->buildTopicPathRecursive($parent_node);
      }
      return true;
  }
}
