<?php

/**
 * Subclass for performing query and update operations on the 'sweet' table.
 *
 * 
 *
 * @package lib.model
 */ 
class SweetPeer extends BaseSweetPeer
{
    /**
     * @param $parent_node sfStructureNode
     * @return array []
     */
    static public function getDynamicList(sfStructureNode $parent_node)
    {
        $c = new Criteria();
        $c->add(self::IS_DISPLAY, true);
        if ($parent_node) {
            $parent_params = $parent_node->getParams();
            $c->add(self::SWEET_CATEGORY_ID, $parent_params['id']);
        }
    	$sweets = self::doSelectJoinAll($c);
    	
    	$dynamics = array();
    	foreach ($sweets as $sweet) {
    	    /* @var $sweet Sweet  */
    		$dynamics[] = array(
    		  'params' => array(
    		      'id' => $sweet->getId()
    		  ),
    		  'title' => $sweet->getSweetCategory()->getName().':'.$sweet->getName()
    		);
    	}
    	return $dynamics;
    }
}
