package fsoriented.sample.horizontalscroll;

import sample.horizontalscroll.R;
import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

public class MainActivity extends Activity {

	private HorizontalPageScrollView hscroll;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		// load UI widgets
		hscroll = (HorizontalPageScrollView) findViewById(R.id.main_hscroll);
		LinearLayout layout = (LinearLayout) findViewById(R.id.main_layout);

		// 動的にページを追加
		addView(layout, "白", Color.WHITE);
		addView(layout, "灰色", Color.GRAY);

		// ページ遷移時のイベントリスナーを登録する
		hscroll.setOnPageChangedListener(new HorizontalPageScrollView.OnPageChangeListener() {
			public void onPageChanged(int pageIndex, View showing) {
				System.out.println("page changed: " + pageIndex);
				setTitle("Page " + pageIndex);
			}
		});

	}

	// 設定を保存すべきときに呼ばれる
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		outState.putInt("page_id", hscroll.getCurrentPage());
	}

	// 設定を復元すべきときに呼ばれる
	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		hscroll.setCurrentPage(savedInstanceState.getInt("page_id"), true);
	}

	// layoutにTextViewを追加する
	private void addView(LinearLayout layout, String name, int color) {
		TextView view = new TextView(this);
		view.setText(name);
		view.setBackgroundColor(color);
		layout.addView(view);
	}

}
