﻿/**
 * 人工無脳（簡易形態素解析＋マルコフ連鎖）で会話するClass
 */
package {

//	import org.coderepos.text.TinySegmenter; // CodeRepos
	import uwi.tinysegmenter.TinySegmenter; // SparkProject
	
	// mxml名と被るとダメ
	public class Munou {

		// 文頭・文末識別子
		private const START:String = '__START__';
		private const END:String = '__END__';
		
		// 初期化テキストを一応保存
		private var text:String;

		// 形態素解析マシン
		private var segmenter:TinySegmenter;
		
		// 学習した結果
		private var dic:Object;
		
		// コンストラクタ
		public function Munou(text:String) {
			this.text = text;			
			segmenter = new TinySegmenter();
			init(text);
		}

		// 初期化
		public function init(text:String):void {
			dic = {};
			learn(text);
		}
		
		// 学習
		public function learn(text:String):void {

			if (text) {
			
				// スペース・タブは1字に圧縮
				// 改行かタブで区切る（スペース・タブは残したいので\sは使わず）
				// そのほかの記号は無視
				var a:Array = 
					text.replace(/([ 　\t])+/g, '$1')
						.split(/[\r\n]+/);
				
				// Vistaならtraceログは以下に
				// C:\Users\<user>\AppData\Roaming\Macromedia\Flash Player\Logs
				// trace(a.join(','));
				
				for (var i:int = 0; i < a.length; i++) {

					var b:Array = morph(a[i]);
					trace(b.join('|'));
					
					b.unshift(START);
					b.push(END);
					
					for (var j:int = 0; j < b.length - 1; j++) {

						var s:String = b[j];
						if (dic[s]) dic[s].push(b[j + 1])
						else dic[s] = [b[j + 1]];
						
					}	
				}
			}
		}

		// 形態素解析
		private function morph(text:String):Array {
			return segmenter.segment(text);	
		}
		
		// マルコフ連鎖で文章作成
		private function markov(text:String):String {
		
			if (!dic[START]) return '';
			
			var s:String = dic[START][Math.floor(Math.random() * dic[START].length)];
			var r:String = '';
			
			while (s != END) {
				r += s;
				
				// 文末っぽい記号が出ても終了
				if (s.match(/[。！!？?]/)) break;
				s = dic[s][Math.floor(Math.random() * dic[s].length)];
			}
			
			return r;
		}
		
		// 応答
		public function response(msg:String):String {
			
			var func:Function;

			learn(msg);

// 今回はマルコフのみで
//			switch(Math.floor(Math.random() * 10)) {
			
				// 1/10の確立でオウム返し
//				case 0:
//					func = echo;
//					break;
				// 1/10の確立で定型応答
//				case 1:
//					func = random;
//					break;
				// その他はマルコフで
//				default:
					func = markov;	
//			}
			
			return func(msg);
		}
		
		// オウム返し（不使用）
		private function echo(msg:String):String {
			return msg;
		}

		// ランダム応答（不使用）
		private function random(msg:String):String {
			
			var a:Array = [
				'',
			];

			return a[Math.floor(Math.random() * a.length)];
		}

		// 初期化テキスト表示（不使用）
		public function getText():String {
			return text;
		}
		
	} // class
	
} // package
