﻿import flash.events.MouseEvent;
import flash.events.KeyboardEvent;
import mx.events.FlexEvent;
import mx.rpc.http.HTTPService;
import mx.rpc.events.ResultEvent;
import mx.rpc.events.FaultEvent;
import mx.controls.Alert;

// グローバル使わないために関数内で処理
private function init():void {
	
	var munou:Munou;
	
	// テキストを読み込んで学習
	// XMLHttpRequest同様に使える
	var http:HTTPService = new HTTPService();
	http.url = 'test.txt';
	http.resultFormat = 'text'; // デフォルトはXML

	// 成功
	http.addEventListener(ResultEvent.RESULT, function(event:ResultEvent):void {
//		munou = new Munou(event.result as String);
		munou = new Munou(''); // 今回は白紙で
	});

	// 失敗
	http.addEventListener(FaultEvent.FAULT, function(event:FaultEvent):void {
		Alert.show(event.fault.faultString);
	});

	http.send();
	
	// sendクリックで話しかける
	sendButton.addEventListener(MouseEvent.CLICK, send);
	// エンター押下にも同じイベント設定
	msgInput.addEventListener(FlexEvent.ENTER, send);
	
	// 初期化
	initButton.addEventListener(MouseEvent.CLICK, function(event:Event):void {
		// 
		munou.init(sourceArea.text);
		sourceArea.text = '';
	});
	
	// 覚えさせる
	addButton.addEventListener(MouseEvent.CLICK, function(event:Event):void {
		if (sourceArea.text) {
			munou.learn(sourceArea.text);
			sourceArea.text = '';
		}
	});
	
	// 話しかける
	function send(event:Event):void {

		var msg:String = msgInput.text;
		
		// ちょっとだけhtmlが使える
		historyArea.htmlText += '<p>あなたの発言：<br/>\t' + msg + '</p>';
		historyArea.htmlText += '<p><font color="#0000ff">munouの発言：<br/>\t' + munou.response(msg) + '</font></p>';
		msgInput.text = '';
		
		// スクロールバーを最終行に設定
		// （遅延実行？しないと更新前の位置になる）
		callLater(function():void {
			historyArea.verticalScrollPosition = historyArea.maxVerticalScrollPosition; 
		});

	}

	// かぎカッコ内のテキストを抽出（不使用）
	function getTalk(text:String):String {

		var talk:Array = text.match(/「[^」]+?」/g);
	
		for(var i:int = 0; i < talk.length; i++) {
			talk[i] = talk[i].replace(/[「\s　」]+/g, '');
		}
		
		return talk.join('\n');
	}
	
} // init




