
/**
 * Module dependencies.
 */

var express = require('express');

var app = module.exports = express.createServer();

// Configuration

app.configure(function(){
  app.set('views', __dirname + '/views');
  app.set('view engine', 'ejs');
  app.use(express.bodyParser());
  app.use(express.methodOverride());
  app.use(express.cookieParser());
  app.use(express.session({ secret: 'your secret here', cookie: { httpOnly: false } }));
  app.use(app.router);
  app.use(express.static(__dirname + '/public'));
});

app.configure('development', function(){
  app.use(express.errorHandler({ dumpExceptions: true, showStack: true })); 
});

app.configure('production', function(){
  app.use(express.errorHandler()); 
});

// Routes

app.get('/', function(req, res) {
  var pages = require('fs').readdirSync(require('path').join(__dirname, 'views'));
  var pages2 = [];
  for (var i = 0; i < pages.length; i++) {
    if (pages[i] != 'index.ejs' &&  pages[i] != 'layout.ejs' && pages[i].slice(0, 1) != '.') {
       pages2.push(pages[i].replace(/\.[^\.]+$/, ''));
//       pages2.push(pages[i].replace(/_.[^_.]+$/, ''));
    }
  }
  res.render('index', {
    title: 'Express',
    pages: pages2
  });
});

app.get('/:page', function(req, res) {

  if (req.params.page == 'deny') {
    res.header('X-FRAME-OPTIONS', 'DENY');
  }

  res.render(req.params.page, {
    title: req.params.page
  });
});

// Only listen on $ node app.js

if (!module.parent) {
  app.listen(process.argv[2] || 3000);
  console.log("Express server listening on port %d", app.address().port);
}
