using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Chemics
{
    class AxisXYZModel:ServiceClient
    {
        private AxisModel axis = new AxisModel();

        public void Initialize()
        {
            axis.Services = Services;
            axis.Length = 100;
            axis.Initialize();
            GetService<IGraphicsContentManager>().Add(axis);
        }

        public void Draw()
        {
            BasicEffect effect = GetService<BasicEffect>();

            Matrix previousWorld = effect.World;
            effect.World =
                Matrix.CreateTranslation(new Vector3(0, 50, 0))
                * Matrix.CreateScale(0.02f)
                * previousWorld;
            drawAxis(effect);

            effect.World =
                Matrix.CreateTranslation(new Vector3(0, 50, 0))
                * Matrix.CreateScale(0.02f)
                * Matrix.CreateRotationX(MathHelper.ToRadians(90))
                * previousWorld;
            drawAxis(effect);

            effect.World =
                Matrix.CreateTranslation(new Vector3(0, 50, 0))
                * Matrix.CreateScale(0.02f)
                * Matrix.CreateRotationZ(MathHelper.ToRadians(-90))
                * previousWorld;
            drawAxis(effect);
            effect.World = previousWorld;
        }
        
        private void drawAxis(BasicEffect effect)
        {
            foreach (EffectPass pass in effect.CurrentTechnique.Passes)
            {
                pass.Begin();

                axis.Draw();

                pass.End();
            }
        }
    }
}
