﻿using System;

namespace SimpleEvolutionLogics.BooleanNetworks
{
    public class BooleanNode
    {
        public bool IsOn;

        public INextValueSource NextValueSource;

        bool nextIsOn;
        bool isCheckNextCalled;


        public void CheckNext()
        {
            nextIsOn = NextValueSource.NextValue;
            isCheckNextCalled = true;
        }

        public void Update()
        {
            if (!isCheckNextCalled) { throw new InvalidOperationException(); }

            IsOn = nextIsOn;

            isCheckNextCalled = false;
        }

        public void Invert()
        {
            IsOn = !IsOn;
        }
    }

    public interface INextValueSource
    {
        bool NextValue { get; }
    }
}
