﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace SimpleEvolutionLogics.BooleanNetworks
{
    public class TwoConnection : INextValueSource
    {
        public BooleanNode Node1;
        public BooleanNode Node2;
        public BooleanOperator Operator;

        public TwoConnection(BooleanOperator booleanOperator, BooleanNode node1, BooleanNode node2)
        {
            this.Operator = booleanOperator;
            this.Node1 = node1;
            this.Node2 = node2;
        }

        public bool NextValue
        {
            get
            {
                return Operator.Process(Node1.IsOn, Node2.IsOn);
            }
        }

        public override string ToString()
        {
            return Operator.Name;
        }
    }
}
