﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace TrackingAndEvadingVehicles
{
    public partial class MainPage : UserControl
    {
        PointLight light = new PointLight { Quantity = 500 };

        Vehicle tracking = new Vehicle();
        LightSensor leftSensor;
        LightSensor rightSensor;

        Point mousePosition;

        public MainPage()
        {
            InitializeComponent();

            Initialize();

            CompositionTarget.Rendering += delegate
            {
                Update();
                Draw();
            };
        }

        private void Initialize()
        {
            tracking.Position = new Vector2D(200, 200);
            leftSensor = createSensor(-45);
            rightSensor = createSensor(45);
            tracking.LeftWheelInput = rightSensor;
            tracking.RightWheelInput = leftSensor;
            tracking.AddSensor(tracking.LeftWheelInput);
            tracking.AddSensor(tracking.RightWheelInput);
        }

        private LightSensor createSensor(double angleDegree)
        {
            return new LightSensor
            {
                Size = 1,
                Position = tracking.GetSurfacePosition(angleDegree),
                Direction = tracking.GetRotatedDirection(angleDegree),
                Light = light
            };
        }

        private void Update()
        {
            var position = mousePosition;
            light.Position = new Vector2D(position.X, position.Y);
            tracking.Update();
        }

        private void Draw()
        {
            vehicleView.RenderTransform = new RotateTransform { Angle = tracking.Rotation };
            vehicleView.RenderTransformOrigin = new Point(0.5, 0.5);
            Canvas.SetLeft(vehicleView, tracking.Position.X - tracking.Radius);
            Canvas.SetTop(vehicleView, tracking.Position.Y - tracking.Radius);

            Canvas.SetLeft(sensorViewL, tracking.LeftWheelInput.Position.X - 1);
            Canvas.SetTop(sensorViewL, tracking.LeftWheelInput.Position.Y - 1);
            Canvas.SetLeft(sensorViewR, tracking.RightWheelInput.Position.X - 1);
            Canvas.SetTop(sensorViewR, tracking.RightWheelInput.Position.Y - 1);
        }

        protected override void OnMouseMove(MouseEventArgs e)
        {
            base.OnMouseMove(e);
            mousePosition = e.GetPosition(this);
        }

        private void checkBox1_Click(object sender, RoutedEventArgs e)
        {
            if (checkBox1.IsChecked.Value)
            {
                tracking.LeftWheelInput = leftSensor;
                tracking.RightWheelInput = rightSensor;
            }
            else
            {
                tracking.LeftWheelInput = rightSensor;
                tracking.RightWheelInput = leftSensor;
            }
        }

    }
}
