﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SilverlightEvolutionOfRayTrackingVehicle
{
    public struct Vector2D
    {
        public double X;
        public double Y;

        public Vector2D(double x, double y)
        {
            X = x;
            Y = y;
        }

        public static double Multiply(Vector2D v1, Vector2D v2)
        {
            return v1.X * v2.X + v1.Y * v2.Y;
        }

        public static Vector2D operator +(Vector2D v1, Vector2D v2)
        {
            return new Vector2D(v1.X + v2.X, v1.Y + v2.Y);
        }

        public static Vector2D operator -(Vector2D v1, Vector2D v2)
        {
            return v1 + (-v2);
        }

        public static Vector2D operator -(Vector2D v)
        {
            return new Vector2D(-v.X, -v.Y);
        }

        public static Vector2D operator *(Vector2D v1, double scale)
        {
            return new Vector2D(v1.X *scale, v1.Y * scale);
        }

        public static Vector2D operator /(Vector2D v1, double division)
        {
            return new Vector2D(v1.X / division, v1.Y /division);
        }

        public override string ToString()
        {
            return "{X:" + X + ", Y:" + Y + "}";
        }

        public static bool operator ==(Vector2D v1, Vector2D v2)
        {
            return v1.X == v2.X && v1.Y == v2.Y;
        }

        public static bool operator !=(Vector2D v1, Vector2D v2)
        {
            return !(v1 == v2);
        }

        public Vector2D Rotate(double angleDegree)
        {
            var angleRadian = angleDegree / 180 * Math.PI;
            return new Vector2D(
                X * Math.Cos(angleRadian) - Y * Math.Sin(angleRadian),
                X * Math.Sin(angleRadian) + Y * Math.Cos(angleRadian)
                );
        }

        public double Length()
        {
            return Math.Sqrt(Multiply(this, this));
        }

        public static Vector2D Normalize(Vector2D vector2D)
        {
            double length = vector2D.Length();
            return vector2D / length;
        }
    }
}
