﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace BackPropagation.Gui
{
    public class MainWindowViewModel:ViewModel
    {
        private double input1;
        public double Input1
        {
            get { return input1; }
            set
            {
                input1 = value;
                NotifyPropertyChanged("Input1");
            }
        }

        private double input2;
        public double Input2
        {
            get { return input2; }
            set
            {
                input2 = value;
                NotifyPropertyChanged("Input2");
            }
        }

        private double output;
        public double Output {
            get { return output; }
            set 
            {
                output = value;
                NotifyPropertyChanged("Output");
            }
        }

        MultiLayerNeuralNetwork neuralNetwork 
            = new MultiLayerNeuralNetwork(2, 2, 1, new Random());

        BooleanOperationData[] learningData = new[]
            {
                new BooleanOperationData{Input1 = 0, Input2 = 0, Output = 0},
                new BooleanOperationData{Input1 = 1, Input2 = 0, Output = 1},
                new BooleanOperationData{Input1 = 0, Input2 = 1, Output = 1},
                new BooleanOperationData{Input1 = 1, Input2 = 1, Output = 0},
            };
        bool isLearning;

        public MainWindowViewModel()
        {
            PropertyChanged += delegate(object sender, PropertyChangedEventArgs e)
            {
                if (e.PropertyName == "Input1" || e.PropertyName == "Input2")
                {
                    updateOutput();
                }
            };
            updateOutput();
        }

        private void updateOutput()
        {
            neuralNetwork.InputLayer[0].Value = Input1;
            neuralNetwork.InputLayer[1].Value = Input2;
            neuralNetwork.ForwardPropagation();
            Output = neuralNetwork.OutputLayer[0].Value;
        }

        internal void ToggleLearning()
        {
            isLearning = !isLearning;
        }

        internal void Update()
        {
            if (!isLearning) return;

            foreach (var data in learningData)
            {
                neuralNetwork.InputLayer[0].Value = data.Input1;
                neuralNetwork.InputLayer[1].Value = data.Input2;
                neuralNetwork.ForwardPropagation();
                neuralNetwork.OutputLayer[0].ExpectedValue = data.Output;
                neuralNetwork.BackPropagation();
            } 

            if (getError() < 0.01) { isLearning = false; }

            updateOutput();
        }

        private double getError()
        {
            double result = 0;
            foreach (var data in learningData)
            {
                neuralNetwork.InputLayer[0].Value = data.Input1;
                neuralNetwork.InputLayer[1].Value = data.Input2;
                neuralNetwork.ForwardPropagation();
                result += Math.Pow(data.Output - neuralNetwork.OutputLayer[0].Value, 2);
            }
            return result;
        }

        internal void Reset()
        {
            isLearning = false;
            neuralNetwork = new MultiLayerNeuralNetwork(2, 2, 1, new Random());
            updateOutput();
        }
    }

    struct BooleanOperationData
    {
        public double Input1;
        public double Input2;
        public double Output;
    }

    public class ViewModel : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged = delegate { };

        protected void NotifyPropertyChanged(string propertyName)
        {
            PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
