﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BackPropagation
{
    public class MultiLayerNeuralNetwork
    {
        public SignalNode[] InputLayer { get; private set; }
        public HiddenNeuron[] HiddenLayer { get; private set; }
        public OutputNeuron[] OutputLayer { get; private set; }

        List<Connection> inputToHidden = new List<Connection>();
        List<Connection> hiddenToOutput = new List<Connection>();

        public int InputUnitCount{get;private set;}
        public int HiddenUnitCount{get;private set;}
        public int OutputUnitCount { get; private set; }
        private Random random;
        const double Rlow = -0.30;	// 乱数値の下限
        const double Rhigh = 0.30;	// 乱数値の上限


        public MultiLayerNeuralNetwork(int inputUnitCount, int hiddenUnitCount, int outputUnitCount, Random random)
        {
            this.InputUnitCount = inputUnitCount;
            this.HiddenUnitCount = hiddenUnitCount;
            this.OutputUnitCount = outputUnitCount;
            this.random = random;
            initialize();
        }

        double urand()
        {
            return (random.NextDouble() * (Rhigh - Rlow) + Rlow);
        }

        void initialize()
        {
            InputLayer = new SignalNode[InputUnitCount];
            HiddenLayer = new HiddenNeuron[HiddenUnitCount];
            OutputLayer = new OutputNeuron[OutputUnitCount];

            for (int i = 0; i < InputLayer.Length; i++)
            {
                InputLayer[i] = new SignalNode();
            }
            for (int i = 0; i < HiddenLayer.Length; i++)
            {
                HiddenLayer[i] = new HiddenNeuron();
            }
            for(int i = 0; i < OutputLayer.Length;i++)
            {
                OutputLayer[i] = new OutputNeuron();
            }

            foreach (var hidden in HiddenLayer)
            {
                foreach (var input in InputLayer)
                {
                    var connection = new Connection
                    {
                        Source = input,
                        Dest = hidden,
                        Weight = urand()
                    };

                    hidden.SourceConnections.Add(connection);
                    inputToHidden.Add(connection);
                }
            }

            foreach (var output in OutputLayer)
            {
                foreach (var hidden in HiddenLayer)
                {
                    var connection = new Connection
                    {
                        Source = hidden,
                        Dest = output,
                        Weight = urand()
                    };
                    output.SourceConnections.Add(connection);
                    hidden.DestConnections.Add(connection);
                    hiddenToOutput.Add(connection);
                }
            }
        }

        public void ForwardPropagation()
        {
            foreach (var unit in HiddenLayer)
            {
                unit.UpdateOutput();
            }

            foreach (var unit in OutputLayer)
            {
                unit.UpdateOutput();
            }
        }

        public void BackPropagation()
        {
            updateLayer(OutputLayer);

            foreach (var connection in hiddenToOutput)
            {
                connection.UpdateWeight();
            }

            updateLayer(HiddenLayer);

            foreach (var connection in inputToHidden)
            {
                connection.UpdateWeight();
            }
        }

        private static void updateLayer(Neuron[] layer)
        {
            foreach (var unit in layer)
            {
                unit.UpdateDeltaWeight();
            }

            foreach (var unit in layer)
            {
                unit.UpdateBias();
            }
        }
    }
}
