#include "sfr_r8m12a.h"
#include "typedefine.h"
#include "comm.h"

//ʐMA0xFFwb_ƂđMB
//X^[grbg̃pX𑪒ɂbitrate肷B

#define BUFSIZ 16
#define TIMEOUT 10

_UBYTE recieved;

void comm(void);
static void tx(void);

static _UBYTE buf[BUFSIZ];
static _UBYTE idx = 0;
static _UWORD brgval;
static _UWORD rxd;
static _UBYTE timecnt;

typedef enum {
	CMD, LEN, DAT, CHK
};

//荞݂Ăł邱Ɩ邽valatileƂ
volatile void init_comm(void) {
	u0tie = 0;		// M荞݋֎~
	u0rie = 0;		// M荞݋֎~
	u0c1 = 0;		// M֎~
	u0mr = 0;		// VAʐM
	mstuart = 1;	// UARTX^oC
	timecnt = TIMEOUT;	// M^C}
	p46sel0 = 1;	// p4_6 = TRJIO
	p46sel1 = 0;
	p46sel2 = 1;
	msttrj = 0;		// ^C}RJ2ANeBu
	trjcr = 0x04;	// ^C}RJ~
	trjmr = 0b00000011;
	//        |||| +++-- pX胂[h
	//        |+++------ 000:JEg\[Xf1
	//        |          001:JEg\[Xf8
	//        |          010:JEg\[XfHOCO
	//        |          011:JEg\[Xf2
	//        +--------- JEg\[X
	prc4 = 1;			// veNg
	trjiosel = 0;		// TRJIO͊O[qI
	prc4 = 0;			// veNgݒ
	tedgsel_trjioc = 0;	// Lx𑪒
	ilvlb0 = 1;			// 荞ݗDx1
	ilvlb1 = 0;
	trjir = 0x80;		// ^C}RJ荞݋
	tstart_trjcr = 1;	// ^C}RJJn
}

void timeout_comm(void)
{
	if(idx != 0) {
		if(--timecnt == 0) {
			init_comm();
		}
	}
}


// timer RJ2 (software int 22)
#pragma interrupt _timer_rj2(vect=22)
void _timer_rj2(void);
void _timer_rj2(void)
{
	trjif_trjir = 0;
	brgval = (0xFFFF-trj)/16;
	
	trjir = 0;			//^C}RJ荞݋֎~
	ilvlb = 0;			//荞ݗDx0i^C}gp̂߂̂܂ܑj
	trjcr = 0x04;		//^C}RJ~
	msttrj = 1;			//^C}RJ2X^oC

	mstuart = 0;		//UART
	p46sel2 = 0;		//p4_6 = RXD0
	u0mr = 0b00100101;	//peBȂ,Xgbvrbg1
	//        ||||+++--- 000FVAC^tF[X
	//        ||||       101FUART[h]f[^8rbg
	//        |||+------ 0FNbN,    1FONbN
	//        ||+------- 0F1Xgbvrbg, 1F2Xgbvrbg
	//        |+-------- 0FpeB,    1FpeB
	//        +--------- 0FpeB֎~,    1FpeB

	if(brgval <= 0x100) {
		u0c0 = 0b00101000;	//f1
		//       | ||  ++--- 00Ff1, 01Ff8, 10Ff32
		//       | |+------- 0FfW^tB^֎~, 1FfW^tB^
		//       | +-------- 0FTXD0[qCMOSo, 1FTXD0[qN`lI[vhCo
		//       +---------- LSBt@[Xg
	} else if(brgval <= 0x1000){
		brgval /= 8;
		u0c0 = 0b00101001;	//f8
	} else {
		brgval /= 32;
		u0c0 = 0b00101010;	//f32
	}
	u0brg = brgval - 1;
	// BITRATE = 1/((FFFF-TRJ)*1/(f1_CLK))
	// u0brg = f1_CLK/BITRATE/16 - 1;
	//       = f1_CLK*((FFFF-TRJ)*1/(f1_CLK))/16-1
	//       = (FFFF-TRJ)/16-1
	u0c1 = 0b00010110;
	//         || | +--- M֎~
	//         || +----- M
	//         |+------- M荞ݗv͑M(TXEPT = 1)
	//         +-------- AM[h֎~
	idx = 0;		// obt@ʒuNA
	ilvl9 = 1;	// M荞ݗDx1
	u0rie = 1;	// M荞݋
}

// UART0 receive (software int 18)
#pragma interrupt _uart0_receive(vect=18)
void _uart0_receive(void);
void _uart0_receive(void)
{
	rxd = u0rb;
	u0rif = 0;
	// G[ or obt@
	if((rxd > 0x0FFF) || (idx == BUFSIZ)) {
		init_comm();
	// G[Ȃ and obt@
	} else {
		buf[idx++] = (_UBYTE)rxd;
		//f[^擾
		if (idx > DAT + buf[LEN]) {
			recieved = 1;
			re_u0c1 = 0;	// M֎~
			ilvl9 = 0;	// M荞݋֎~
			u0rie = 0;	// M荞݋֎~
		}
	}
}

static void tx(void) {
	_UBYTE i;
	_UBYTE chksum = 0;
	
	for(i=CMD; i<DAT+buf[LEN]; i++) {
		chksum += buf[i];
	}
	buf[i] = -(_SBYTE)chksum;
	idx = 0;		// obt@ʒuNA
	p46sel0 = 0;	// p4_6 = TXD0
	p46sel1 = 1;	
	ilvl8 = 0x10;	// M荞ݗDx1
	u0tie = 1;		// M荞݋
	te_u0c1 = 1;	// M
	u0tbl = 0xFF;	// wb_M
}

// UART0 transmit (software int 17)
#pragma interrupt _uart0_transmit(vect=17)
void _uart0_transmit(void);
void _uart0_transmit(void)
{
	u0tif = 0;
	if(idx <= DAT+buf[LEN]) {
		u0tbl = buf[idx++];
	} else {
		init_comm();
	}
}

void comm(void)
{
	_UBYTE i;
	_UBYTE chksum = 0;
	
	for(i=CMD; i<=DAT+buf[LEN]; i++) {
		chksum += buf[i]; 
	}
	if(chksum != 0) {
		init_comm();
	} else {
		switch(buf[CMD]) {
			case 0x01:
				if(buf[LEN] == 0x00) {
					buf[CMD]   = 0x02;
					buf[LEN]   = 0x03;
					buf[DAT+0] = 0x01;
					buf[DAT+1] = 0x02;
					buf[DAT+2] = 0x03;
					tx();
					return;
				}
				break;
			
			default:
				init_comm();
				break;
		}
	}
}
