/***********************************************************************/
/*                                                                     */
/*  FILE        :initsct.h                                             */
/*  DATE        :Fri, Jun 03, 2011                                     */
/*  DESCRIPTION :define the macro for initialization of sections.      */
/*  CPU GROUP   :M12A                                                  */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.19).    */
/*  NOTE:THIS IS A TYPICAL EXAMPLE.                                    */
/***********************************************************************/
/************************************************************************
*
* Device     : R8C Family
*
* File Name  : initsct.h
*
* Abstract   : Define the macro for initialization of sections.
*              (note: Do not modify)
*
* History    : 1.90  (2007-06-14)
*
* NOTE       : THIS IS A TYPICAL EXAMPLE.
*
* Copyright (C) 2007 Renesas Electronics Corporation.
* and Renesas Solutions Corp.
*
************************************************************************/
#include "cstartdef.h"

#pragma section program interrupt

#if __WATCH_DOG__ != 1

#define scopy(X,Y,Z)	_asm("	.initsct "X","Y","Z"\n"\
			"	.initsct "X"I,rom"Y",noalign\n"\
			"	mov.w	#(topof "X"I)&0ffffH,A0\n"\
			"	mov.b 	#(topof "X"I)>>16,R1H\n"\
			"	mov.w	#(topof "X")&0ffffH,A1\n"\
			"	mov.w	#sizeof	"X",R3\n"\
			"	smovf.b")

#define	sclear(X,Y,Z)	_asm("	.initsct "X","Y","Z"\n"\
			"	mov.b	#00H,R0L\n"\
			"	mov.w	#(topof	"X") ,A1\n"\
			"	mov.w	#sizeof	"X",R3\n"\
			"	sstr.b")
#else

#define scopy(X,Y,Z)	_asm("	.initsct "X","Y","Z"\n"\
			"	.initsct "X"I,rom"Y",noalign\n"\
			"	scopy	"X"I,"X"")

#define	sclear(X,Y,Z)	_asm("	.initsct "X","Y","Z"\n"\
			"	N_BZERO	"X"")

#endif


#define	scopy_f(X,Y,Z)	_asm("	.initsct "X","Y","Z"\n"\
			"	.initsct "X"I,rom"Y",noalign\n"\
			"	push.w	#(sizeof "X") >> 16\n"\
			"	push.w	#(sizeof "X") & 0ffffH\n"\
			"	push.w	#(topof "X") >> 16\n"\
			"	push.w	#(topof "X") & 0ffffH\n"\
			"	push.w	#(topof "X"I) >> 16\n"\
			"	push.w	#(topof "X"I) & 0ffffH\n"\
			"	.stk	12\n"\
			"	.glb	_bcopy\n"\
			"	.call	_bcopy,G\n"\
			"	jsr.a	_bcopy\n"\
			"	add.b	#12,sp\n"\
			"	.stk	-12")

#define sclear_f(X,Y,Z)	_asm("	.initsct "X","Y","Z"\n"\
			"	push.w	#(sizeof "X")>>16\n"\
			"	push.w	#(sizeof "X")&0ffffH\n"\
			"	push.w	#(topof "X")>>16\n"\
			"	push.w	#(topof "X")&0ffffH\n"\
			"	.stk	8\n"\
			"	.glb	_bzero\n"\
			"	.call	_bzero,G\n"\
			"	jsr.a	_bzero\n"\
			"	add.b	#8H,sp\n"\
			"	.stk	-8")
			

#if __WATCH_DOG__ == 1
#pragma ASM
scopy		.macro	FROM_,TO_
		mov.b	#00,0DH
		mov.b	#0ffH,0DH
		mov.w	#0000H,R0
		.local M1
	M1:
		cmp.w	#sizeof TO_,R0
		.local	M2
		jeq	M2
		mov.b	#00,0DH
		mov.b	#0ffH,0DH
		mov.w	#(topof FROM_)&0ffffH,A0	
		mov.w	#(topof TO_)&0ffffH,A1	
		add.w	R0,A0
		add.w	R0,A1
		mov.b	[A0],[A1]	
		add.w	#1,R0
		jmp	M1
	M2:
		.endm

N_BZERO		.macro	SECT_
		mov.b	#00,0DH
		mov.b	#0ffH,0DH
		mov.w	#0000H,R0
		.local	M1	
	M1:
		cmp.w	#sizeof SECT_,R0
		.local	M2
		jeq	M2
		mov.b	#00,0DH
		mov.b	#0ffH,0DH
		mov.w	#(topof	SECT_)&0ffffH,A0	
		add.w	R0,A0
		mov.b	#00H,[A0]
		add.w	#1H,R0
		jmp	M1
	M2:
		.endm
#pragma ENDASM
#endif
