/*******************************************************************************

    Input port macros used by many games in multiple Toaplan drivers
    (similar to Taito but bits are ACTIVE_HIGH instead of ACTIVE_LOW)

*******************************************************************************/

#ifndef __TOAPLIPT_H__
#define __TOAPLIPT_H__

/******************************* Active Level *********************************/

#define TOAPLAN_IP_ACTIVE_LEVEL IP_ACTIVE_HIGH
#define TOAPLAN_IP_INVERTED_ACTIVE_LEVEL IP_ACTIVE_LOW


/************************** Unused or Unknown Bits ****************************/

/* Toaplan generic fill unknown or unused */
#define TOAPLAN_INPUT_GENERIC_FILL_UNKNOWN(MASK) \
	PORT_BIT(MASK, TOAPLAN_IP_ACTIVE_LEVEL, IPT_UNKNOWN )

#define TOAPLAN_INPUT_GENERIC_FILL_UNUSED(MASK) \
	PORT_BIT(MASK, TOAPLAN_IP_ACTIVE_LEVEL, IPT_UNUSED )


/********************* Unused, Unknown or Spare Dip Switch *********************/

#define TOAPLAN_DIP_1_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x01, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")
#define TOAPLAN_DIP_2_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x02, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_DIP_3_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x04, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_DIP_4_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x08, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_DIP_5_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x10, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!5")
#define TOAPLAN_DIP_6_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x20, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!6")
#define TOAPLAN_DIP_7_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x40, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!7")
#define TOAPLAN_DIP_8_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x80, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!8")

#define TOAPLAN_DIP_1_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x01, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")
#define TOAPLAN_DIP_2_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x02, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_DIP_3_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x04, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_DIP_4_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x08, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_DIP_5_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x10, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!5")
#define TOAPLAN_DIP_6_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x20, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!6")
#define TOAPLAN_DIP_7_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x40, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!7")
#define TOAPLAN_DIP_8_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x80, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!8")

#define TOAPLAN_DIP_1_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x0100, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")
#define TOAPLAN_DIP_2_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x0200, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_DIP_3_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x0400, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_DIP_4_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x0800, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_DIP_5_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x1000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!5")
#define TOAPLAN_DIP_6_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x2000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!6")
#define TOAPLAN_DIP_7_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x4000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!7")
#define TOAPLAN_DIP_8_UNKNOWN_HIGH(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x8000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!8")

#define TOAPLAN_DIP_1_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x0100, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")
#define TOAPLAN_DIP_2_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x0200, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_DIP_3_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x0400, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_DIP_4_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x0800, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_DIP_5_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x1000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!5")
#define TOAPLAN_DIP_6_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x2000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!6")
#define TOAPLAN_DIP_7_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x4000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!7")
#define TOAPLAN_DIP_8_UNUSED_HIGH(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x8000, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!8")

#define TOAPLAN_DIP_X_SPARE(MASK, DIPBANK, DIPNUMBER) \
	PORT_DIPNAME( MASK,    0, "Spare" ) PORT_DIPLOCATION(#DIPBANK":!"#DIPNUMBER) \
	PORT_DIPSETTING(       0, DEF_STR( Off ) ) \
	PORT_DIPSETTING(    MASK, DEF_STR( On ) )

#define TOAPLAN_DIP_1_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x01, DIPBANK, 1)
#define TOAPLAN_DIP_2_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x02, DIPBANK, 2)
#define TOAPLAN_DIP_3_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x04, DIPBANK, 3)
#define TOAPLAN_DIP_4_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x08, DIPBANK, 4)
#define TOAPLAN_DIP_5_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x10, DIPBANK, 5)
#define TOAPLAN_DIP_6_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x20, DIPBANK, 6)
#define TOAPLAN_DIP_7_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x40, DIPBANK, 7)
#define TOAPLAN_DIP_8_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x80, DIPBANK, 8)

#define TOAPLAN_DIP_1_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x0100, DIPBANK, 1)
#define TOAPLAN_DIP_2_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x0200, DIPBANK, 2)
#define TOAPLAN_DIP_3_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x0400, DIPBANK, 3)
#define TOAPLAN_DIP_4_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x0800, DIPBANK, 4)
#define TOAPLAN_DIP_5_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x1000, DIPBANK, 5)
#define TOAPLAN_DIP_6_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x2000, DIPBANK, 6)
#define TOAPLAN_DIP_7_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x4000, DIPBANK, 7)
#define TOAPLAN_DIP_8_SPARE_HIGH(DIPBANK) TOAPLAN_DIP_X_SPARE(0x8000, DIPBANK, 8)


/********************* Unused, Unknown or Spare Jumper *********************/

/* reverse order to DIPSW */
#define TOAPLAN_JMPR_4_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x01, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_JMPR_3_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x02, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_JMPR_2_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x04, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_JMPR_1_UNKNOWN(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x08, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")

#define TOAPLAN_JMPR_4_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x01, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_JMPR_3_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x02, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_JMPR_2_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x04, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_JMPR_1_UNUSED(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x08, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")

#define TOAPLAN_JMPR_4_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x01, DIPBANK, 4)
#define TOAPLAN_JMPR_3_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x02, DIPBANK, 3)
#define TOAPLAN_JMPR_2_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x04, DIPBANK, 2)
#define TOAPLAN_JMPR_1_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x08, DIPBANK, 1)

#define TOAPLAN_JMPR_4_UNKNOWN_HIGH_NIBBLE(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x10, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_JMPR_3_UNKNOWN_HIGH_NIBBLE(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x20, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_JMPR_2_UNKNOWN_HIGH_NIBBLE(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x40, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_JMPR_1_UNKNOWN_HIGH_NIBBLE(DIPBANK) PORT_DIPUNKNOWN_DIPLOC(0x80, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")

#define TOAPLAN_JMPR_4_UNUSED_HIGH_NIBBLE(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x10, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!4")
#define TOAPLAN_JMPR_3_UNUSED_HIGH_NIBBLE(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x20, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3")
#define TOAPLAN_JMPR_2_UNUSED_HIGH_NIBBLE(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x40, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!2")
#define TOAPLAN_JMPR_1_UNUSED_HIGH_NIBBLE(DIPBANK) PORT_DIPUNUSED_DIPLOC(0x80, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1")

#define TOAPLAN_JMPR_4_SPARE_HIGH_NIBBLE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x10, DIPBANK, 4)
#define TOAPLAN_JMPR_3_SPARE_HIGH_NIBBLE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x20, DIPBANK, 3)
#define TOAPLAN_JMPR_2_SPARE_HIGH_NIBBLE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x40, DIPBANK, 2)
#define TOAPLAN_JMPR_1_SPARE_HIGH_NIBBLE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x80, DIPBANK, 1)

	/* snowbro2 --- another bit */
#define SNOWBRO2_JMPR_4_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x0400, DIPBANK, 4) /* printed "JP20" */
#define SNOWBRO2_JMPR_3_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x0800, DIPBANK, 3) /* printed "JP19" */
#define SNOWBRO2_JMPR_2_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x1000, DIPBANK, 2) /* printed "JP18" */
#define SNOWBRO2_JMPR_1_SPARE(DIPBANK) TOAPLAN_DIP_X_SPARE(0x2000, DIPBANK, 1) /* printed "JP17" */


/**************************** Dip Switch A ****************************/

#define TOAPLAN_DIP_A1_CABINET(DIPBANK) \
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Cabinet ) ) PORT_DIPLOCATION(#DIPBANK":!1") \
	PORT_DIPSETTING(    0x01, DEF_STR( Upright ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( Cocktail ) )

	/* grindstm --- inverted active level */
#define GRINDSTM_DIP_A1_CABINET(DIPBANK) \
	PORT_DIPNAME( 0x01, 0x00, DEF_STR( Cabinet ) ) PORT_DIPLOCATION(#DIPBANK":!1") \
	PORT_DIPSETTING(    0x00, DEF_STR( Upright ) ) \
	PORT_DIPSETTING(    0x01, DEF_STR( Cocktail ) )

#define TOAPLAN_DIP_A2_FLIP_SCREEN(DIPBANK) \
	PORT_DIPNAME( 0x02, 0x00, DEF_STR( Flip_Screen ) ) PORT_DIPLOCATION(#DIPBANK":!2") \
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) ) \
	PORT_DIPSETTING(    0x02, DEF_STR( On ) )

#define TOAPLAN_DIP_A3_SERVICE_MODE(DIPBANK) \
	PORT_SERVICE_DIPLOC( 0x04, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!3" )

#define TOAPLAN_DIP_A4_DEMO_SOUNDS(DIPBANK) \
	PORT_DIPNAME( 0x08, 0x00, DEF_STR( Demo_Sounds ) ) PORT_DIPLOCATION(#DIPBANK":!4") \
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

/*
#define TOAPLAN_DIP_A56_COINAGE_A(DIPBANK) \
	PORT_DIPNAME( 0x30, 0x00, DEF_STR( Coin_A ) ) PORT_DIPLOCATION(#DIPBANK":!5,!6") \
	PORT_DIPSETTING(    0x00, ? ) \
	PORT_DIPSETTING(    0x10, ? ) \
	PORT_DIPSETTING(    0x20, ? ) \
	PORT_DIPSETTING(    0x30, ? )
*/

/*
#define TOAPLAN_DIP_A78_COINAGE_B(DIPBANK) \
	PORT_DIPNAME( 0xc0, 0x00, DEF_STR( Coin_B ) ) PORT_DIPLOCATION(#DIPBANK":!7,!8") \
	PORT_DIPSETTING(    0x00, ? ) \
	PORT_DIPSETTING(    0x40, ? ) \
	PORT_DIPSETTING(    0x80, ? ) \
	PORT_DIPSETTING(    0xc0, ? )
*/

	/* RAIZING --- another bit */
#define RAIZING_DIP_A1_SERVICE_MODE(DIPBANK) \
	PORT_SERVICE_DIPLOC( 0x01, TOAPLAN_IP_ACTIVE_LEVEL, #DIPBANK":!1" )

#define RAIZING_DIP_A2_CREDITS_TO_START(DIPBANK) \
	PORT_DIPNAME( 0x02, 0x00, "Credits to Start" ) PORT_DIPLOCATION(#DIPBANK":!2") \
	PORT_DIPSETTING(    0x00, "1" ) \
	PORT_DIPSETTING(    0x02, "2" )


/**************************** Dip Switch B ****************************/

#define TOAPLAN_DIP_B12_DIFFICULTY(DIPBANK) \
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Difficulty ) ) PORT_DIPLOCATION(#DIPBANK":!1,!2") \
	PORT_DIPSETTING(    0x01, DEF_STR( Easy ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( Normal ) ) \
	PORT_DIPSETTING(    0x02, DEF_STR( Hard ) ) \
	PORT_DIPSETTING(    0x03, DEF_STR( Very_Hard ) )

/*
#define TOAPLAN_DIP_B34_BONUS_LIFE(DIPBANK) \
	PORT_DIPNAME( 0x0c, 0x00, DEF_STR( Bonus_Life ) ) PORT_DIPLOCATION(#DIPBANK":!3,!4") \
	PORT_DIPSETTING(    0x00, ? ) \
	PORT_DIPSETTING(    0x04, ? ) \
	PORT_DIPSETTING(    0x08, ? ) \
	PORT_DIPSETTING(    0x0c, ? )
*/

/*
#define TOAPLAN_DIP_B56_LIVES(DIPBANK) \
	PORT_DIPNAME( 0x30, 0x00, DEF_STR( Lives ) ) PORT_DIPLOCATION(#DIPBANK":!5,!6") \
	PORT_DIPSETTING(    0x00, ? ) \
	PORT_DIPSETTING(    0x10, ? ) \
	PORT_DIPSETTING(    0x20, ? ) \
	PORT_DIPSETTING(    0x30, ? )
*/

#define TOAPLAN_DIP_B7_SHOW_DIPSW_SETTINGS(DIPBANK) \
	PORT_DIPNAME( 0x40, 0x00, "Show Dip Switches Settings" ) PORT_DIPLOCATION(#DIPBANK":!7") \
	PORT_DIPSETTING(    0x00, DEF_STR( No ) ) \
	PORT_DIPSETTING(    0x40, DEF_STR( Yes ) )

#define TOAPLAN_DIP_B7_INVULNERABILITY(DIPBANK) \
	PORT_DIPNAME( 0x40, 0x00, "Invulnerability (Cheat)" ) PORT_DIPLOCATION(#DIPBANK":!7") \
	PORT_DIPSETTING(    0x00, DEF_STR( No ) ) \
	PORT_DIPSETTING(    0x40, DEF_STR( Yes ) )

#define TOAPLAN_DIP_B8_ALLOW_CONTINUE_OFF_YES(DIPBANK) \
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Allow_Continue ) ) PORT_DIPLOCATION(#DIPBANK":!8") \
	PORT_DIPSETTING(    0x80, DEF_STR( No ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )

	/* twincobr, fshark --- inverted active level */
#define TWINCOBR_DIP_B8_ALLOW_CONTINUE_OFF_NO(DIPBANK) \
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Allow_Continue ) ) PORT_DIPLOCATION(#DIPBANK":!8") \
	PORT_DIPSETTING(    0x00, DEF_STR( No ) ) \
	PORT_DIPSETTING(    0x80, DEF_STR( Yes ) )

	/* wardner --- another bit */
#define WARDNER_DIP_B7_ALLOW_CONTINUE_OFF_YES(DIPBANK) \
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Allow_Continue ) ) PORT_DIPLOCATION(#DIPBANK":!7") \
	PORT_DIPSETTING(    0x40, DEF_STR( No ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )


/**************************** Coinage Dip Swicthes ****************************/

#define TOAPLAN_DIP_A56_COINAGE_A_JAPAN(DIPBANK) \
	PORT_DIPNAME( 0x30, 0x00, DEF_STR( Coin_A ) ) PORT_DIPLOCATION(#DIPBANK":!5,!6") \
	PORT_DIPSETTING(    0x20, DEF_STR( 2C_1C ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) \
	PORT_DIPSETTING(    0x30, DEF_STR( 2C_3C ) ) \
	PORT_DIPSETTING(    0x10, DEF_STR( 1C_2C ) )
	//Very similar to TAITO JAPAN OLD A (but active level is different)

#define TOAPLAN_DIP_A78_COINAGE_B_JAPAN(DIPBANK) \
	PORT_DIPNAME( 0xc0, 0x00, DEF_STR( Coin_B ) ) PORT_DIPLOCATION(#DIPBANK":!7,!8") \
	PORT_DIPSETTING(    0x80, DEF_STR( 2C_1C ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) \
	PORT_DIPSETTING(    0xc0, DEF_STR( 2C_3C ) ) \
	PORT_DIPSETTING(    0x40, DEF_STR( 1C_2C ) )
	//Very similar to TAITO JAPAN OLD B (but active level is different)

#define TOAPLAN_DIP_A56_COINAGE_A_EUROPE(DIPBANK) \
	PORT_DIPNAME( 0x30, 0x00, DEF_STR( Coin_A ) ) PORT_DIPLOCATION(#DIPBANK":!5,!6") \
	PORT_DIPSETTING(    0x30, DEF_STR( 4C_1C ) ) \
	PORT_DIPSETTING(    0x20, DEF_STR( 3C_1C ) ) \
	PORT_DIPSETTING(    0x10, DEF_STR( 2C_1C ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	//Very similar to TAITO WORLD A (but active level is different)

#define TOAPLAN_DIP_A78_COINAGE_B_EUROPE(DIPBANK) \
	PORT_DIPNAME( 0xc0, 0x00, DEF_STR( Coin_B ) ) PORT_DIPLOCATION(#DIPBANK":!7,!8") \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_2C ) ) \
	PORT_DIPSETTING(    0x40, DEF_STR( 1C_3C ) ) \
	PORT_DIPSETTING(    0x80, DEF_STR( 1C_4C ) ) \
	PORT_DIPSETTING(    0xc0, DEF_STR( 1C_6C ) )
	//Very similar to TAITO WORLD B (but active level is different)

#define TOAPLAN_DIP_A5678_COINAGE_JAPAN(DIPBANK) \
	TOAPLAN_DIP_A56_COINAGE_A_JAPAN(DIPBANK) \
	TOAPLAN_DIP_A78_COINAGE_B_JAPAN(DIPBANK)

#define TOAPLAN_DIP_A5678_COINAGE_EUROPE(DIPBANK) \
	TOAPLAN_DIP_A56_COINAGE_A_EUROPE(DIPBANK) \
	TOAPLAN_DIP_A78_COINAGE_B_EUROPE(DIPBANK)

#define TOAPLAN_DIP_A5678_COINAGE_DUAL_FORM(COMPAREPORT, MASK, VALUE, DIPBANK, TRUECOND, FALSECOND) \
	PORT_DIPNAME( 0x30, 0x00, DEF_STR( Coin_A ) ) PORT_DIPLOCATION(#DIPBANK":!5,!6") \
	PORT_DIPSETTING(    0x30, DEF_STR( 4C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x20, DEF_STR( 3C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x10, DEF_STR( 2C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x20, DEF_STR( 2C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPSETTING(    0x30, DEF_STR( 2C_3C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPSETTING(    0x10, DEF_STR( 1C_2C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPNAME( 0xc0, 0x00, DEF_STR( Coin_B ) ) PORT_DIPLOCATION(#DIPBANK":!7,!8") \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_2C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x40, DEF_STR( 1C_3C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x80, DEF_STR( 1C_4C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0xc0, DEF_STR( 1C_6C ) ) PORT_CONDITION(#COMPAREPORT,MASK,TRUECOND,VALUE) \
	PORT_DIPSETTING(    0x80, DEF_STR( 2C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPSETTING(    0xc0, DEF_STR( 2C_3C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE) \
	PORT_DIPSETTING(    0x40, DEF_STR( 1C_2C ) ) PORT_CONDITION(#COMPAREPORT,MASK,FALSECOND,VALUE)

#define TOAPLAN_DIP_A5678_COINAGE_DUAL(COMPAREPORT, MASK, VALUE, DIPBANK) \
	TOAPLAN_DIP_A5678_COINAGE_DUAL_FORM(COMPAREPORT, MASK, VALUE, DIPBANK, PORTCOND_EQUALS, PORTCOND_NOTEQUALS)
	/* If EQUAL then same as COINAGE_EUROPE
	            else same as COINAGE_JAPAN */

#define TOAPLAN_DIP_A5678_COINAGE_DUAL_GREATERTHAN(COMPAREPORT, MASK, VALUE, DIPBANK) \
	TOAPLAN_DIP_A5678_COINAGE_DUAL_FORM(COMPAREPORT, MASK, VALUE, DIPBANK, PORTCOND_GREATERTHAN, PORTCOND_NOTGREATERTHAN)
	/* If GREATERTHAN then same as COINAGE_EUROPE
	                  else same as COINAGE_JAPAN */


	/* RAIZING */
#define RAIZING_DIP_A345_COINAGE_A(DIPBANK) \
	PORT_DIPNAME( 0x1c, 0x00, DEF_STR( Coin_A ) ) PORT_DIPLOCATION(#DIPBANK":!3,!4,!5") \
	PORT_DIPSETTING(    0x18, DEF_STR( 4C_1C ) ) \
	PORT_DIPSETTING(    0x14, DEF_STR( 3C_1C ) ) \
	PORT_DIPSETTING(    0x10, DEF_STR( 2C_1C ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) \
	PORT_DIPSETTING(    0x04, DEF_STR( 1C_2C ) ) \
	PORT_DIPSETTING(    0x08, DEF_STR( 1C_3C ) ) \
	PORT_DIPSETTING(    0x0c, DEF_STR( 1C_4C ) ) \
	PORT_DIPSETTING(    0x1c, DEF_STR( Free_Play ) )

#define RAIZING_DIP_A678_COINAGE_B_IF_A_ISNT_FREE(COMPAREPORT, DIPBANK) \
	PORT_DIPNAME( 0xe0, 0x00, DEF_STR( Coin_B ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) PORT_DIPLOCATION(#DIPBANK":!6,!7,!8") \
	PORT_DIPSETTING(    0xc0, DEF_STR( 4C_1C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0xa0, DEF_STR( 3C_1C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x80, DEF_STR( 2C_1C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	/* PORT_DIPSETTING( 0xe0, DEF_STR( 1C_1C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) */ \
	PORT_DIPSETTING(    0x20, DEF_STR( 1C_2C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x40, DEF_STR( 1C_3C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x60, DEF_STR( 1C_4C ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \

#define RAIZING_DIP_A678_COINAGE_B_IF_A_ISNT_FREE_DUP(COMPAREPORT, DIPBANK) \
	PORT_DIPNAME( 0xe0, 0x00, DEF_STR( Coin_B ) ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) PORT_DIPLOCATION(#DIPBANK":!6,!7,!8") \
	PORT_DIPSETTING(    0xc0, " 4 Coins/1 Credit" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0xa0, " 3 Coins/1 Credit" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x80, " 2 Coins/1 Credit" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x00, " 1 Coin/1 Credit" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0xe0, " 1 Coin/1 Credit" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) /* duplicated setting */ \
	PORT_DIPSETTING(    0x20, " 1 Coin/2 Credits" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x40, " 1 Coin/3 Credits" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c) \
	PORT_DIPSETTING(    0x60, " 1 Coin/4 Credits" ) PORT_CONDITION(#COMPAREPORT, 0x001c, PORTCOND_NOTEQUALS, 0x001c)
	/* Current(0.141) MAME doesn't allow duplicated settins about coinage
	   (see function "validate_dip_settings()" in file "src\emu\validity.c")
	   We can not write "PORT_DIPSETTING( 0x00, DEF_STR( 1C_1C ) )"
	   But we can write "PORT_DIPSETTING( 0x00, " 1 Coin/1 Credit" )"
	                                             ^ Don't delete this space (to pass function "get_defstr_index()") */


/************************** Joysticks *****************************/

/* generic (might be moved elsewhere) */
#define INPUT_GENERIC_JOY_NIBBLE(PL, LOWZERO, STATE, WAY, BIT0, BIT1, BIT2, BIT3) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_JOYSTICK_##BIT0) WAY PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_JOYSTICK_##BIT1) WAY PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_JOYSTICK_##BIT2) WAY PORT_PLAYER(PL) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_JOYSTICK_##BIT3) WAY PORT_PLAYER(PL)

/* Toaplan generic joysticks */
#define TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	INPUT_GENERIC_JOY_NIBBLE(PL, , TOAPLAN_IP_ACTIVE_LEVEL, PORT_8WAY, UP, DOWN, LEFT, RIGHT)

#define TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	INPUT_GENERIC_JOY_NIBBLE(PL, 00, TOAPLAN_IP_ACTIVE_LEVEL, PORT_8WAY, UP, DOWN, LEFT, RIGHT)


/************************** Buttons *****************************/

/* generic (might be moved elsewhere) */
/*
#define INPUT_GENERIC_BUTTONS_NIBBLE(PL, LOWZERO, STATE, BIT0, BIT1, BIT2, BIT3) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_##BIT0) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_##BIT1) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_##BIT2) PORT_PLAYER(PL) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_##BIT3) PORT_PLAYER(PL)
*/

/* Toaplan generic buttons (more might be needed) */
#define TOAPLAN_INPUT_GENERIC_1_BUTTON_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 2)") \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_BUTTON3) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 3)") \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 4)")

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_BUTTON3) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 3)") \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 4)")

#define TOAPLAN_INPUT_GENERIC_3_BUTTONS_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_BUTTON3) PORT_PLAYER(PL) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 4)")

#define TOAPLAN_INPUT_GENERIC_4_BUTTONS_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_BUTTON3) PORT_PLAYER(PL) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL)

#define TOAPLAN_INPUT_GENERIC_1_BUTTON_INCLUDING_START_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 2)") \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_START##PL ) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_UNKNOWN )

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS_INCLUDING_START_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_START##PL ) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_UNKNOWN )

/*
#define TOAPLAN_INPUT_GENERIC_1_BUTTON_INCLUDING_START_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 2)") \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_START##PL ) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 4)")

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS_INCLUDING_START_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_START##PL ) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL) PORT_NAME("Spare (P"#PL" Button 4)")

#define TOAPLAN_INPUT_GENERIC_3_BUTTONS_INCLUDING_START_NIBBLE(PL, LOWZERO, STATE) \
	PORT_BIT(0x1##LOWZERO, STATE, IPT_BUTTON1) PORT_PLAYER(PL) \
	PORT_BIT(0x2##LOWZERO, STATE, IPT_BUTTON2) PORT_PLAYER(PL) \
	PORT_BIT(0x4##LOWZERO, STATE, IPT_START##PL ) \
	PORT_BIT(0x8##LOWZERO, STATE, IPT_BUTTON4) PORT_PLAYER(PL)
*/

/* Assign 8bits or low_of_16bits */
#define TOAPLAN_INPUT_GENERIC_1_BUTTON(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_3_BUTTONS(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_4_BUTTONS(PL) \
	TOAPLAN_INPUT_GENERIC_4_BUTTONS_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_1_BUTTON_START(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_INCLUDING_START_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS_START(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_INCLUDING_START_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_3_BUTTONS_START(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_INCLUDING_START_NIBBLE(PL, 0, TOAPLAN_IP_ACTIVE_LEVEL)


/* Assign high_of_16bits */
#define TOAPLAN_INPUT_GENERIC_1_BUTTON_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_3_BUTTONS_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_4_BUTTONS_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_4_BUTTONS_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_1_BUTTON_START_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_INCLUDING_START_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_2_BUTTONS_START_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_INCLUDING_START_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)

#define TOAPLAN_INPUT_GENERIC_3_BUTTONS_START_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_INCLUDING_START_NIBBLE(PL, 000, TOAPLAN_IP_ACTIVE_LEVEL)


/************************** Merge Joysticks And Buttons *****************************/

#define TOAPLAN_JOY_UDLR_1_BUTTON(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON(PL)

#define TOAPLAN_JOY_UDLR_2_BUTTONS(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS(PL)

#define TOAPLAN_JOY_UDLR_3_BUTTONS(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS(PL)

#define TOAPLAN_JOY_UDLR_4_BUTTONS(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_4_BUTTONS(PL)

#define TOAPLAN_JOY_UDLR_1_BUTTON_START(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_START(PL)

#define TOAPLAN_JOY_UDLR_2_BUTTONS_START(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_START(PL)

#define TOAPLAN_JOY_UDLR_3_BUTTONS_START(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_START(PL)

#define TOAPLAN_JOY_UDLR_1_BUTTON_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_HIGH(PL)

#define TOAPLAN_JOY_UDLR_2_BUTTONS_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_HIGH(PL)

#define TOAPLAN_JOY_UDLR_3_BUTTONS_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_HIGH(PL)

#define TOAPLAN_JOY_UDLR_4_BUTTONS_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_4_BUTTONS_HIGH(PL)

#define TOAPLAN_JOY_UDLR_1_BUTTON_START_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_1_BUTTON_START_HIGH(PL)

#define TOAPLAN_JOY_UDLR_2_BUTTONS_START_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_2_BUTTONS_START_HIGH(PL)

#define TOAPLAN_JOY_UDLR_3_BUTTONS_START_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_JOY_UDLR_HIGH(PL) \
	TOAPLAN_INPUT_GENERIC_3_BUTTONS_START_HIGH(PL)


/******************************* System switchs **********************************/

#define TOAPLAN_SYSTEM_INPUT \
	PORT_BIT(0x01, TOAPLAN_IP_ACTIVE_LEVEL, IPT_SERVICE1) \
	PORT_BIT(0x02, TOAPLAN_IP_ACTIVE_LEVEL, IPT_TILT) \
	PORT_BIT(0x04, TOAPLAN_IP_ACTIVE_LEVEL, IPT_SERVICE2) PORT_NAME(DEF_STR(Test)) /* JAMMA "Test" */ \
	PORT_BIT(0x08, TOAPLAN_IP_ACTIVE_LEVEL, IPT_COIN1) \
	PORT_BIT(0x10, TOAPLAN_IP_ACTIVE_LEVEL, IPT_COIN2) \
	PORT_BIT(0x20, TOAPLAN_IP_ACTIVE_LEVEL, IPT_START1) \
	PORT_BIT(0x40, TOAPLAN_IP_ACTIVE_LEVEL, IPT_START2)
	/* "Service Coin 2" is substitute for "Test".
	   The right JAMMA connecter doesn't have "Service Coin 2". */

#define TOAPLAN_SYSTEM_INPUT_WITHOUT_VBLANK \
	TOAPLAN_SYSTEM_INPUT \
	PORT_BIT(0x80, TOAPLAN_IP_ACTIVE_LEVEL, IPT_UNKNOWN)

#define TOAPLAN_SYSTEM_INPUT_WITH_VBLANK \
	TOAPLAN_SYSTEM_INPUT \
	PORT_BIT(0x80, TOAPLAN_IP_ACTIVE_LEVEL, IPT_VBLANK)

#define TOAPLAN_VBLANK_INPUT_8BITS \
	PORT_BIT(0x7f, TOAPLAN_IP_ACTIVE_LEVEL, IPT_UNKNOWN) \
	PORT_BIT(0x80, TOAPLAN_IP_ACTIVE_LEVEL, IPT_VBLANK)

#define TOAPLAN_VBLANK_INPUT_16BITS \
	PORT_BIT(0x0001, TOAPLAN_IP_ACTIVE_LEVEL, IPT_VBLANK) \
	PORT_BIT(0xfffe, TOAPLAN_IP_ACTIVE_LEVEL, IPT_UNKNOWN)

/******************************* Modify Test Switch **********************************/

#define TOAPLAN_TEST_SWITCH_RENAME(_name) \
	PORT_BIT(0x04, TOAPLAN_IP_ACTIVE_LEVEL, IPT_SERVICE2) PORT_NAME(_name)

#define TOAPLAN_TEST_SWITCH_TOGGLE_RENAME(_name) \
	TOAPLAN_TEST_SWITCH_RENAME(_name) PORT_TOGGLE

#define TOAPLAN_TEST_SWITCH_TOGGLE \
	TOAPLAN_TEST_SWITCH_TOGGLE_RENAME("Test (Toggle Switch)")
	/* If toggle_switch is more convenient than push_switch, set and describe it. */

#define TOAPLAN_TEST_SWITCH_SPARE \
	TOAPLAN_TEST_SWITCH_RENAME("Spare (Test)")
	/* No effect is found.
	   Don't set "Unused" or you seal up the unknown easter eggs. */

/*******************************************************************************/

#endif	/* __TOAPLIPT_H__ */
