/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"
#include "lcd.h"

//=================================================================

static volatile U16 s_nBeep;
static U8 s_fLCD = FALSE;
static U8 s_fSDC = FALSE;
static U16 s_nCount = 0;

//=================================================================

// TuVXed
extern void SubPower(U8 on)
{
	if (on)
	{
		if (!PWC)
		{
			PWC = 1;
			LCD_RD = 1;
			LCD_WR = 1;

			DelayMs(100);
		}
	}
	else
	{
		if (PWC)
		{
			LCD_RD = 0;
			LCD_WR = 0;
			PWC = 0;

			DelayMs(500);
			s_fLCD = FALSE;
		}
	}
}

// LCDp[Abv
extern void EnableLCD(U8 flag)
{
	if (flag)
	{
		if (!s_fLCD)
		{
			InitLCD();
			s_fLCD = TRUE;
		}
		BLC = 0;
	}
	else
	{
		BLC = 1;
	}
}

// 錟o
extern U8 GetCDS(void)
{
	AD1CON1bits.ADON = 1;
	DelayMs(1);

	AD1CON1bits.DONE = 0;
	while (!AD1CON1bits.DONE);
	AD1CON1bits.ADON = 0;

	// 邢̉񐔐璋ɂȂƔf
	if ((ADC1BUF0 & 0x0FFF) >= OPT_SLEVEL)
	{
		if (s_nCount >= OPT_DCOUNT)
			return TRUE;
		s_nCount++;
	}
	else {
		s_nCount = 0;
	}

	return FALSE;
}

// o
extern U8 GetSW(void)
{
	if (!TSW)
	{
		DelayMs(5);
		if (!TSW)
		{
			Beep(900, 50);
			while (!TSW);
			return TRUE;
		}
	}

	return FALSE;
}

// J[h(SDC2)o
extern U8 Detect(void)
{
	if (!s_fSDC)
	{
		if (!SDC2_CD)
		{
			int i = 100;
			do DelayMs(10);
			while (!SDC2_CD && --i > 0);

			if (i == 0)
			{
				Beep(1100, 75);
				DelayMs(200);
				if (!SDC2_CD)
				{
					Beep(1100, 75);
					s_fSDC = TRUE;
				}
			}
		}
	}
	else if (SDC2_CD) {
		s_fSDC = FALSE;
	}

	return s_fSDC;
}

// r[v
extern void Beep(int freq, U16 ms)
{
	U32 n;
	PMD3bits.T6MD = 0;
	PMD3bits.T8MD = 0;
	PMD3bits.T9MD = 0;

	// TMR6(16Bit) U (Fcy:39.61375MHz)
	n = 0xFFFF - (39613750UL / 2 / freq) - 0x0F;
	n += 0xF0; // CRUő̌덷
	TMR6 = s_nBeep = (U16)n;

	IFS2bits.T6IF = 0;
	IEC2bits.T6IE = 1;
	T6CON = 0b1010000000000000;

	// Fcy:39.61375MHz
	// TMR8(32Bit) ~^C}
	T8CON = 0;
	
	n = 0xFFFFFFFFUL - (39613UL * (U32)ms);
	TMR9 = n >> 16;
	TMR8 = n & 0xFFFF;

	IFS3bits.T9IF = 0;
	IEC3bits.T9IE = 1;
	T8CON = 0b1010000000001000;
}

// LEDuN
extern void Blink(U16 blink)
{
	if (blink == BLINK_SLOW || blink == BLINK_FAST)
	{
		PMD3bits.T7MD = 0;

		// TMR7(16Bit)
		T7CON = (blink == BLINK_SLOW)? 0x2030 : 0x2020;
		LED = 1;
		TMR7 = 0;
		IFS3bits.T7IF = 0;
		IEC3bits.T7IE = 1;
		T7CONbits.TON = 1;
	}
	else
	{
		T7CONbits.TON = 0;
		IEC3bits.T7IE = 0;
		LED = blink;

		PMD3bits.T7MD = 1;
	}
}

// x
extern void DelayMs(U16 ms)
{
	while (ms >= 100)
	{
		__delay_ms(100);
		ms -= 100;
	}
	if (ms != 0) {
		__delay_ms(ms);
	}
}

// TMR6(BEEPU)
void _ISRNOPSV _T6Interrupt(void)
{
	BEEP = !BEEP;
	TMR6 = s_nBeep;
	IFS2bits.T6IF = 0;
}

// TMR7(LEDuN)
void _ISRNOPSV _T7Interrupt(void)
{
	LED = !LED;
	IFS3bits.T7IF = 0;
}

// TMR9(BEEP~^C})
void _ISRNOPSV _T9Interrupt(void)
{
	T8CONbits.TON = 0;
	IEC3bits.T9IE = 0;
	IFS3bits.T9IF = 0;

	T6CONbits.TON = 0;
	IEC2bits.T6IE = 0;
	IFS2bits.T6IF = 0;
	BEEP = 0;

	PMD3bits.T6MD = 1;
	PMD3bits.T8MD = 1;
	PMD3bits.T9MD = 1;
}

// ͒ʒm
void _ISRNOPSV _CNInterrupt(void)
{
	IFS1bits.CNIF = 0;
}
