/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#ifndef _BOARD_H_
#define _BOARD_H_

#include "main.h"

#define SDC1_CS		_LATD11
#define SDC2_CS		_LATG9
#define SDC2_CD		_RA7

#define LCD_CS		_LATA12
#define LCD_RS		_LATF4
#define LCD_RD		_LATA9
#define LCD_WR		_LATA10
#define LCD_D17		_LATD15
#define LCD_D16		_LATD14
#define LCD_DATA	LATB

#define PWC			_LATF5
#define BLC			_LATF3
#define BEEP		_LATD3
#define LED			_LATE3
#define TSW			_RA6

#define BLINK_OFF	0x0000
#define BLINK_SLOW	0x8000
#define BLINK_FAST	0x4000
#define BLINK_ON	0xFFFF

extern void SubPower(U8 on);
extern void EnableLCD(U8 flag);
extern U8 GetCDS(void);
extern U8 GetSW(void);
extern U8 Detect(void);
extern void Beep(int freq, U16 ms);
extern void Blink(U16 blink);
extern void DelayMs(U16 ms);

#endif
