/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"
#include "lcd.h"
#include "ff.h"

// 192GC02 Commands
#define CMD_MODE		0x36
#define CMD_CASET		0x2A
#define CMD_RASET		0x2B
#define CMD_COLMOD		0x3A
#define CMD_IFMOD		0xC2
#define CMD_RAMWR		0x2C
#define CMD_SLPOUT		0x11
#define CMD_DISPON		0x29

//=================================================================

static void WriteArea(const rect_t* rc);
static UINT WriteBits(const BYTE* buf, UINT btf);
static void WriteCmd(U8 cmd);
static void WriteDat(U32 data);

#define FastOut(x) \
	LCD_DATA = (U16)((U8)(x)); \
	LCD_WR = 0; \
	LCD_WR = 1;

//=================================================================

// LCD
extern void InitLCD(void)
{
	LCD_CS = 0;

	WriteCmd(0xB0);
	WriteDat(0xCA);
	WriteDat(0x90);
	WriteDat(0x37);
	WriteDat(0x01);
	WriteDat(0x48);
	WriteDat(0x01);
	WriteDat(0x40);
	WriteDat(0x04);
	WriteDat(0x00);
	WriteDat(0x00);

	WriteCmd(0x26);
	WriteDat(0x01);
	
	WriteCmd(0xB1);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x08);
	WriteDat(0x00);
	WriteDat(0x04);
	WriteDat(0x10);
	WriteDat(0x48);
	WriteDat(0x82);
	WriteDat(0x20);
	WriteDat(0x84);
	WriteDat(0x92);
	WriteDat(0x2A);
	WriteDat(0x52);
	WriteDat(0xAA);
	WriteDat(0x5A);
	WriteDat(0x55);
	WriteDat(0x2A);
	WriteDat(0x55);
	WriteDat(0xAE);
	WriteDat(0xFF);
	WriteDat(0xFE);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x04);

	WriteCmd(0xB2);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x04);
	WriteDat(0x00);
	WriteDat(0x02);
	WriteDat(0x08);
	WriteDat(0x48);
	WriteDat(0x82);
	WriteDat(0x20);
	WriteDat(0x84);
	WriteDat(0x42);
	WriteDat(0x48);
	WriteDat(0x92);
	WriteDat(0x2A);
	WriteDat(0x52);
	WriteDat(0xAA);
	WriteDat(0x5A);
	WriteDat(0x55);
	WriteDat(0x2A);
	WriteDat(0x55);
	WriteDat(0xAE);
	WriteDat(0xFF);
	WriteDat(0xFE);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x00);
	WriteDat(0x04);

	// Entry Mode  AM=1, I/D[1:0]=01
	WriteCmd(CMD_MODE);
	WriteDat(0x29);

	// Color mode  666 262K color
	WriteCmd(CMD_COLMOD);
	WriteDat(0x06);

	// Inteface mode  18-bit
	WriteCmd(CMD_IFMOD);
	WriteDat(0x04);

	WriteCmd(0xBA);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);
	WriteDat(0x55);	
	WriteDat(0x55);

	WriteCmd(CMD_SLPOUT);
	DelayMs(1);

	LCD_CS = 1;
	FillLCD(NULL, COL_BLACK);
	LCD_CS = 0;

	WriteCmd(CMD_DISPON);
	DelayMs(80);

	LCD_CS = 1;
	LCD_RS = 0;

	LCD_DATA = 0;
	LCD_D16 = 0;
	LCD_D17 = 0;
}

// ̈hԂ
extern void FillLCD(const rect_t* rc, U32 c)
{
	rect_t scr;
	U16 w, h;

	if (rc == NULL)
	{
		scr.x = scr.y = 0;
		scr.w = LCD_CX;
		scr.h = LCD_CY;
		rc = &scr;
	}

	LCD_CS = 0;

	WriteArea(rc);

	LCD_RS = 0;
	FastOut(CMD_RAMWR);

	LCD_RS = 1;
	LCD_DATA = (U16)c;
	LCD_D16 = ((c & 0x10000) != 0);
	LCD_D17 = ((c & 0x20000) != 0);

	h = rc->h;
	do {
		w = rc->w;
		do {
			LCD_WR = 0;
			LCD_WR = 1;
		}
		while(--w > 0);
	}
	while(--h > 0);

	LCD_CS = 1;
	LCD_RS = 0;

	LCD_DATA = 0;
	LCD_D16 = 0;
	LCD_D17 = 0;
}

// rbg}bv]
extern void BlitLCD(const rect_t* rc, const U8* bm)
{
	U16 w, h;

	LCD_CS = 0;

	WriteArea(rc);

	LCD_RS = 0;
	FastOut(CMD_RAMWR);

	LCD_RS = 1;

	h = rc->h;
	do {
		w = rc->w;
		do {
			U16 R = bm[0] >> 2;
			LCD_D17 = ((R & 0x20) != 0);
			LCD_D16 = ((R & 0x10) != 0);
			LCD_DATA = (R << 12) | ((U16)(bm[1] >> 2) << 6) | ((U16)(bm[2] >> 2) << 0);

			LCD_WR = 0;
			bm += 3;
			LCD_WR = 1;
		}
		while(--w > 0);
	}
	while(--h > 0);

	LCD_CS = 1;
	LCD_RS = 0;

	LCD_DATA = 0;
	LCD_D16 = 0;
	LCD_D17 = 0;
}

// 摜t@C]
extern void DrawLCD(const rect_t* rc, const char* fname)
{
	rect_t scr;
	FIL file;

	if (rc == NULL)
	{
		scr.x = scr.y = 0;
		scr.w = LCD_CX;
		scr.h = LCD_CY;
		rc = &scr;
	}

	LCD_CS = 0;

	if (f_open(&file, fname, FA_READ) == FR_OK)
	{
		DWORD len = file.fsize;
		UINT cb;
		
		WriteArea(rc);

		LCD_RS = 0;
		FastOut(CMD_RAMWR);

		LCD_RS = 1;
		while (len > 0)
		{
			f_forward(&file, WriteBits, (len > 32768)? 32768 : len, &cb);
			len -= cb;
		}

		f_close(&file);
	}

	LCD_CS = 1;
	LCD_RS = 0;

	LCD_DATA = 0;
	LCD_D16 = 0;
	LCD_D17 = 0;
}

//=================================================================

// AhXݒ
static void WriteArea(const rect_t* rc)
{
	// AM=1, I/D[1:0]=01
	U16 x1 = rc->x + 0x08;
	U16 y1 = rc->y + 0x0C;
	U16 x2 = x1 + rc->w - 1;
	U16 y2 = y1 + rc->h - 1;

	// Column Address Set
	LCD_RS = 0;
	FastOut(CMD_CASET);
	LCD_RS = 1;
	FastOut(x1 >> 8);
	FastOut(x1 & 0xFF);
	FastOut(x2 >> 8);
	FastOut(x2 & 0xFF);

	// Row Address Set
	LCD_RS = 0;
	FastOut(CMD_RASET);
	LCD_RS = 1;
	FastOut(y1 >> 8);
	FastOut(y1 & 0xFF);
	FastOut(y2 >> 8);
	FastOut(y2 & 0xFF);
}

// ]R[obN
static UINT WriteBits(const BYTE* buf, UINT btf)
{
	if (btf > 0)
	{
		UINT i = btf / 4;
		do {
			LCD_D17 = ((buf[1] & 0x2) != 0);
			LCD_D16 = ((buf[1] & 0x1) != 0);
			LCD_DATA = ((U16)buf[2] << 8) | ((U16)buf[3] << 0);

			LCD_WR = 0;
			buf += 4;
			LCD_WR = 1;
		}
		while(--i > 0);
		return btf;
	}
	return 1;
}

// R}hM
static void WriteCmd(U8 cmd)
{
	LCD_RS = 0;
	FastOut(cmd);
}

// f[^M
static void WriteDat(U32 data)
{
	LCD_RS = 1;
	FastOut(data);
}
