/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#include "main.h"
#include "board.h"
#include "sdc.h"
#include "lcd.h"
#include "jpeg.h"
#include "fcpy.h"
#include "disp.h"
#include "ff.h"

//=================================================================

// Configuration
_FBS(BWRP_WRPROTECT_OFF & BSS_NO_BOOT_CODE & RBS_NO_BOOT_RAM)
_FSS(SWRP_WRPROTECT_OFF & SSS_NO_SEC_CODE & RSS_NO_SEC_RAM)
_FGS(GSS_OFF & GCP_OFF & GWRP_OFF)
_FOSCSEL(IESO_ON & FNOSC_FRCPLL)
_FOSC(POSCMD_NONE & OSCIOFNC_ON & FCKSM_CSECMD)
_FWDT(FWDTEN_OFF & WINDIS_OFF & WDTPRE_PR32 & WDTPOST_PS4096)
_FPOR(FPWRT_PWR16)
_FICD(JTAGEN_OFF & ICS_PGD2)

_FUID0(0x00)
_FUID1(0x00)
_FUID2(0x00)
_FUID3(0x00)

//=================================================================

// fA|[gobt@
static FATFS s_FS1 __attribute__ ((space(dma)));
U8 g_DmaBuf[SDCBLK] __attribute__ ((space(dma)));

static int s_nLCD = 0;
static int s_nSDC = 0;

static U16 s_nTime = 0;
static U8 s_fTime = FALSE;
static U8 s_fDstop = FALSE;

// ݒl
#define SETTINGS_FILE	"\\S\\SETTINGS.DAT"
settings_t g_Settings = {
	{0}, { 0, 0, 3, 0 }
};

#define WDTPRD	4
#define HUR		* 3600 / WDTPRD
#define MIN		* 60 / WDTPRD
#define SEC		/ WDTPRD

const U16 g_nVals[4][6] = {
	{ 4 SEC,  30 SEC,   1 MIN,  10 MIN,  30 MIN,  60 MIN }, /*ʐ^ؑ֊Ԋu*/
	{   0x0,     0x2,     0x4,     0x6,     0x8,     0xA }, /*\x~*/
	{ 0x950,   0x700,   0x500,   0x350,   0x200,   0x100 }, /*ʌox*/
	{ 0 SEC,  30 MIN,   1 HUR,   2 HUR,   3 HUR,   4 HUR }, /*Ԕfx*/
};

#define OPT_ONTIME	s_OnOff[OPT_DLEVEL + 0]
#define OPT_OFFTIME	s_OnOff[OPT_DLEVEL + 1]

const int s_OnOff[12] = {
	0 SEC, 0 SEC,
	8 HUR, 2 HUR,
	4 HUR, 2 HUR,
	2 HUR, 2 HUR,
	2 HUR, 4 HUR,
	2 HUR, 8 HUR
};

// j[ʃ\[X摜
#define IMG_MENU		"\\S\\MENU"
#define IMG_CUR1		"\\S\\CUR1"
#define IMG_CUR2		"\\S\\CUR2"
#define IMG_BAR1		"\\S\\BAR1"
#define IMG_BAR2		"\\S\\BAR2"
#define COL_BACK		0x37F3DUL

// Cxg
#define EV_NONE			0	// Ȃ
#define EV_SWITCH		1	// \씽]
#define EV_CANCEL		2	// Rs[LZ
#define EV_REFRESH		3	// \tbV
#define EV_SDCDET		4	// J[h}o
#define EV_DAYMODE		5	// ωo

// \^XN
#define DISP_IDLE		0
#define DISP_DPAUSE		1
#define DISP_NACTIV		2
#define DISP_ACTIVE		3
static int s_nDisp = DISP_IDLE;

// Rs[^XN
#define COPY_IDLE		0
#define COPY_ACTIVE		1
#define COPY_CANCEL		2
#define COPY_BREAK		3
#define COPY_COMPL		4
static int s_nCopy = COPY_IDLE;

//=================================================================

static void InitSystem(void);
static void Run(void);

static int Menu(void);
static void DrawMenu(void);
static void SelVal(int nIdx);
static void DrawBar(int nIdx);
static void DrawCur(int nPos, U8 flag);
static U8 DispTask(int nEvent, U8 nParam);
static void SetDisp(U8 flag, int state);
static U8 CopyTask(int nEvent, U8 nParam);
static void LockLCD(U8 flag);
static void LockSDC(U8 flag);
static void SwitchClock(U8 flag);

//=================================================================

// CGg
int main(void)
{
	InitSystem();
	InitJPG();

	LockSDC(TRUE);
	LoadSettings();
	LockSDC(FALSE);

	Run();
}

// VXe
static void InitSystem(void)
{
	// W[iߓdj
	// AD1 ͏펞ON SPI1/2,TMR6/7/8/9 ͓sx ͖gp
	PMD1 = 0xFFFF;
	PMD2 = 0xFFFF;
	PMD3 = 0xFFFF;
	PMD1bits.AD1MD = 0;

	// NbNݒ
	// CRUo͂PLLŖ40MHzɂ܂ŏグ
	CLKDIVbits.PLLPRE = 0;	// N1:1/2
	CLKDIVbits.PLLPOST = 0;	// N2:1/2
	PLLFBD = 41;			// FOC:79.2275MHz Fcy:39.61375MHz
 
	// |[gNA
	PORTA = 0;
	PORTB = 0;
	PORTC = 0;
	PORTD = 0;
	PORTE = 0;
	PORTF = 0;
	PORTG = 0;

	LATA = 0;
	LATB = 0;
	LATC = 0;
	LATD = 0;
	LATE = 0;
	LATF = 0;
	LATG = 0;

	// fWAiݒ
	AD1PCFGH=0b0000100011010000;
	AD1PCFGL=0b1111111111111111;
	AD2PCFGL=AD1PCFGL;

	// vAbvݒ
	CNPU2bits.CN22PUE = 1;
	CNPU2bits.CN23PUE = 1;
	
	// lݒ
	LATA = 0b0001000000000000;
	LATB = 0b0000000000000000;
	LATC = 0b0000000000000000;
	LATD = 0b0000100000000000;
	LATE = 0b0000000000000000;
	LATF = 0b0000000000001000;
	LATG = 0b0000001000000000;

	// ݒ
	TRISA = 0b1110100111111111;
	TRISB = 0b0000000000000000;
	TRISC = 0b1111111111111111;
	TRISD = 0b0011011111110111;
	TRISE = 0b1111111111110111;
	TRISF = 0b1111111111000111;
	TRISG = 0b1111110111111111;

	// `cRo[^
	AD1CON2 = 0b0000000000000000;
	AD1CON3 = 0b1001111100000000;
	AD1CON1 = 0b0000010011100101;
	AD1CHS0 = 0b0000000000011100; // AN28

	// ͕ωʒmݒ
	CNEN2bits.CN22IE = 1;
	CNEN2bits.CN23IE = 1;
	IEC1bits.CNIE = 1;
}

// s[v
static void Run(void)
{
	U8 fSDC = FALSE;
	U8 fCDS = FALSE;
	U8 fWorking = 0;

	// Cxg[v
	for (;;)
	{
		// L[
		if (GetSW())
		{
			switch (Menu())
			{
			case EV_SWITCH:
				DispTask(EV_SWITCH, 0);
				s_fDstop = FALSE;
				break;

			case EV_CANCEL:
				CopyTask(EV_CANCEL, 0);
			default:
				DispTask(EV_REFRESH, FALSE);
				break;
			}
		}
		// ωo
		if (GetCDS() != fCDS)
		{
			fCDS = !fCDS;
			DispTask(EV_DAYMODE, fCDS);
		}
		// J[h}o
		if (Detect() != fSDC)
		{
			fSDC = !fSDC;
			CopyTask(EV_SDCDET, fSDC);
		}
		
		// |[O
		DispTask(EV_NONE, 0);
		fWorking = CopyTask(EV_NONE, 0);

		// SĂȂȂ珊̊ԃX[vorACh
		fWorking |= T6CONbits.TON | T8CONbits.TON;
		fWorking |= T7CONbits.TON;

		if (!fWorking)
		{
			// EHb`hbO^C}ɂ@N𗘗p
			RCONbits.SWDTEN = 1;
			if (PWC)
			{
				// |[go͂ωƃ}YĈŃACh
				// sȂ̂ŃNbN_E
				SwitchClock(FALSE);
				Idle();
				SwitchClock(TRUE);
			}
			else {
				// SẴ|[go͂OFFĂ悢
				// NbN̓Vbg_E
				Sleep();
			}
			RCONbits.SWDTEN = 0;
			DelayMs(1);
			
			// d̓[h_
			LED = !LED;
			DelayMs(50);
			LED = !LED;

			// \x~JEg
			s_nTime++;
			if (s_fTime)
			{
				// ܂łJEg
				if (OPT_ONTIME != 0 && s_nTime >= OPT_OFFTIME)
				{
					// 
					if (s_fDstop && s_nDisp == DISP_DPAUSE)
						DispTask(EV_SWITCH, 0);
					s_fDstop = FALSE;
					s_nTime = 0;
					s_fTime = FALSE;
				}
			}
			else
			{
				// x~܂łJEg
				if (OPT_OFFTIME != 0 && s_nTime >= OPT_ONTIME)
				{
					// x~
					if (s_nDisp == DISP_ACTIVE)
					{
						DispTask(EV_SWITCH, 0);
						s_fDstop = TRUE;
					}
					s_nTime = 0;
					s_fTime = TRUE;
				}
			}
		}
	}
}

//=================================================================

// j[[h
static int Menu(void)
{
	int nEvent = EV_NONE;

	if (f_chdrive(DRV_PRIMARY) == FR_OK)
	{
		int nCur= 0, nCount = 0;

		LockSDC(TRUE);
		LockLCD(TRUE);
		DrawMenu();

		// ڑI
		for(;;)
		{
			if (GetSW())
			{
				// J[\ړ
				if (++nCur > 5)
					break; // LZ

				DrawCur(nCur, TRUE);
				nCount = 0;
				continue;
			}
			// 蔻
			if (nCount < 2000)
			{
				nCount++;
				DelayMs(1);
				continue;
			}

			// ڂɉ
			DrawCur(nCur, FALSE);
			Beep(1200, 50);

			switch (nCur)
			{
			case 0: // 񎦏Ԑؑ
				DelayMs(100);
				nEvent = EV_SWITCH;
				break;
			case 1: // Rs[LZ
				DelayMs(100);
				nEvent = EV_CANCEL;
				break;
			case 2: // ʐ^ؑ֊Ԋu
				SelVal(IDX_DPERIOD);
				break;
			case 3: // \x~
				SelVal(IDX_DLEVEL);
				break;
			case 4: // ʌox
				SelVal(IDX_SLEVEL);
				break;
			case 5: // Ԕfx
				SelVal(IDX_DCOUNT);
				break;
			}
			break;
		}

		FillLCD(NULL, COL_BLACK);
		LockLCD(FALSE);
		LockSDC(FALSE);
	}

	return nEvent;
}

// j[`
static void DrawMenu(void)
{
	int i = 0;
	DrawLCD(NULL, IMG_MENU);
	do DrawBar(i);
	while (++i < 4);
}

// lύX
static void SelVal(int nIdx)
{
	int nCount = 0;
	for(;;)
	{
		if (GetSW())
		{
			// lI
			g_Settings.Idxes[nIdx] = 
				(g_Settings.Idxes[nIdx] + 1) % 6;

			DrawBar(nIdx);
			nCount = 0;
			continue;
		}
		// 蔻
		if (nCount < 2000)
		{
			nCount++;
			DelayMs(1);
			continue;
		}
		break;
	}

	Beep(1200, 50);
	SaveSettings();
}

// l`
static void DrawBar(int nIdx)
{
	int i = 0, v = g_Settings.Idxes[nIdx];

	rect_t rc;
	rc.x = 199; rc.y = 92 + nIdx * 30, rc.w = 13; rc.h = 23;
	do {
		DrawLCD(&rc, (i <= v)? IMG_BAR1 : IMG_BAR2);
		rc.x += 18;
	}
	while (++i < 6);
}

// J[\ړ`
static void DrawCur(int nPos, U8 flag)
{
	rect_t rc;
	rc.x = 8; rc.w = 29; rc.h = 16;
	
	if (flag)
	{
		int nOld = (nPos == 0)? 5 : nPos - 1;
		rc.y = nOld * 30 + 36;
		FillLCD(&rc, COL_BACK);
	}

	rc.y = nPos * 30 + 36;
	DrawLCD(&rc, (flag)? IMG_CUR1 : IMG_CUR2);
}

// \^XN
static U8 DispTask(int nEvent, U8 nParam)
{
	switch (nEvent)
	{
	// ωo
	case EV_DAYMODE:
		switch (s_nDisp)
		{
		case DISP_IDLE:
			if (nParam)
				SetDisp(TRUE, DISP_ACTIVE);
			break;
		case DISP_DPAUSE:
			if (!nParam)
				s_nDisp = DISP_IDLE;
			break;
		case DISP_NACTIV:
			if (nParam)
				s_nDisp = DISP_ACTIVE;
			break;
		case DISP_ACTIVE:
			if (!nParam)
				SetDisp(FALSE, DISP_IDLE);
			break;
		}
		break;

	// \씽]
	case EV_SWITCH:
		if (s_nDisp == DISP_ACTIVE || s_nDisp == DISP_NACTIV) {
			SetDisp(FALSE,
				(s_nDisp == DISP_ACTIVE)? DISP_DPAUSE : DISP_IDLE);
		}
		else {
			SetDisp(TRUE,
				(s_nDisp == DISP_IDLE)? DISP_NACTIV : DISP_ACTIVE);
		}
		break;

	// \tbV
	case EV_REFRESH:
		if (s_nDisp == DISP_ACTIVE || s_nDisp == DISP_NACTIV)
			Display((nParam)? DSP_NEWFILE : DSP_FORCE);
		break;

	// |[O
	default:
		if (s_nDisp == DISP_ACTIVE || s_nDisp == DISP_NACTIV)
		{
			if (s_nCopy == COPY_IDLE || s_nCopy == COPY_COMPL)
			{
				if (Display(DSP_PERIOD))
					s_nTime++; // \Ԃ
			}
		}
		break;
	}

	return (s_nDisp == DISP_ACTIVE || s_nDisp == DISP_NACTIV);
}

// \Ԑݒ
static void SetDisp(U8 flag, int state)
{
	s_nDisp = state;
	if (flag)
	{
		LockSDC(TRUE);
		LockLCD(TRUE);
		Display(DSP_FORCE);
	}
	else
	{
		FillLCD(NULL, COL_BLACK);
		LockLCD(FALSE);
		LockSDC(FALSE);
	}
}

// Rs[^XN
static U8 CopyTask(int nEvent, U8 nParam)
{
	int nRet;
	switch (nEvent)
	{
	// J[h}o
	case EV_SDCDET:
		switch (s_nCopy)
		{
		case COPY_IDLE:
			if (nParam)
			{
				s_nCopy = COPY_ACTIVE;
				LockSDC(TRUE);
				Blink(BLINK_SLOW);
			}
			break;
		case COPY_ACTIVE:
		case COPY_CANCEL:
			if (!nParam)
				s_nCopy = COPY_BREAK;
			break;
		case COPY_BREAK:
			break;
		case COPY_COMPL:
			if (!nParam)
			{
				s_nCopy = COPY_IDLE;
				Blink(BLINK_OFF);
			}
			break;
		}
		break;

	// Rs[LZ
	case EV_CANCEL:
		if (s_nCopy == COPY_ACTIVE)
			s_nCopy = COPY_CANCEL;
		break;

	// |[O
	default:
		switch (s_nCopy)
		{
		case COPY_ACTIVE:
		case COPY_CANCEL:
			nRet = CopyFiles(s_nCopy == COPY_CANCEL, &s_FS1);
			if (nRet != CPF_PROGRESS && nRet != CPF_FILEEND)
			{
				const char* fname;

				s_nCopy = COPY_COMPL;
				if (nRet == CPF_COMPLETE)
				{
					Beep(1400, 2000);
					Blink(BLINK_ON);
				}
				else
				{
					Beep(500, 2000);
					Blink(BLINK_FAST);
				}
				LockSDC(FALSE);

				fname = GetStart();
				if (fname[0] != '\0')
					SetPos((OPT_DPERIOD == -1)? NULL : fname);
			}
			if (nRet == CPF_FILEEND)
				DispTask(EV_REFRESH, TRUE);
			break;

		case COPY_BREAK:
			nRet = CopyFiles(TRUE, &s_FS1);
			if (nRet != CPF_PROGRESS && nRet != CPF_FILEEND)
			{
				s_nCopy = COPY_IDLE;
				Blink(BLINK_OFF);
				LockSDC(FALSE);
			}
			break;
		}
		break;
	}

	return (s_nCopy != COPY_IDLE && s_nCopy != COPY_COMPL);
}

// LCDʓd
static void LockLCD(U8 flag)
{
	if (flag)
	{
		if (s_nLCD == 0)
		{
			if (s_nSDC == 0)
				SubPower(TRUE);
			EnableLCD(TRUE);
		}
		s_nLCD++;
	}
	else
	{
		s_nLCD--;
		if (s_nLCD == 0)
		{
			EnableLCD(FALSE);
			if (s_nSDC == 0)
				SubPower(FALSE);
		}
	}
}

// SDCʓd
static void LockSDC(U8 flag)
{
	if (flag)
	{
		if (s_nSDC == 0)
		{
			if (s_nLCD == 0)
				SubPower(TRUE);

			f_mount(DRV_PRIMARY, &s_FS1);
			SetPos(NULL);
		}
		s_nSDC++;
	}
	else
	{
		s_nSDC--;
		if (s_nSDC == 0)
		{
			f_unmount(DRV_PRIMARY);

			if (s_nLCD == 0)
				SubPower(FALSE);
		}
	}
}

// NbNXCb`
static void SwitchClock(U8 flag)
{
#ifndef _DEBUG
	IEC1bits.CNIE = 0;

	if (flag) {
		// CRU PLLt(FOC=79.2275MHz)
		ASM("MOV #0b00000001, w4");
	}
	else {
		// dCRU(FOC=32.768kHz)
		ASM("MOV #0b00000101, w4");
	}
	// OSCCON ւ̉V[PX݂Ɛݒ
	ASM("MOV #OSCCONH, w1");
	ASM("MOV #0x78, w2");
	ASM("MOV #0x9A, w3");
	ASM("MOV.b w2, [w1]");
	ASM("MOV.b w3, [w1]");
	ASM("MOV.b w4, [w1]");
	ASM("MOV #OSCCONL, w1");
	ASM("MOV #0x46, w2");
	ASM("MOV #0x57, w3");
	ASM("MOV.b w2, [w1]");
	ASM("MOV.b w3, [w1]");
	ASM("BSET OSCCON, #0");

	while (OSCCONbits.OSWEN);
	IEC1bits.CNIE = 1;
#endif	
}

//=================================================================

// A}Eg
extern void f_unmount(U8 drv)
{
	f_mount(drv, NULL);

	// J[hrW[Ԃ̉SPIW[OFF
	if (drv == DRV_PRIMARY)
		CloseSDC1();
	else
		CloseSDC2();
}

// t@CRs[
extern void CopyFn(char* buf, const char* src)
{
	while (*src) {
		*buf++ = *src++;
	}
	*buf = '\0';
}

// ݒǍ
extern void LoadSettings(void)
{
	FIL file;

	if (f_chdrive(DRV_PRIMARY) == FR_OK)
	{
		if (f_open(&file, SETTINGS_FILE, FA_READ) == FR_OK)
		{
			UINT cb;
			if (f_read(&file, g_DmaBuf, sizeof(g_Settings), &cb) == FR_OK)
			{
				if (cb == sizeof(g_Settings))
					g_Settings = *((settings_t*)g_DmaBuf);
			}
			f_close(&file);
		}
	}
}

// ݒۑ
extern void SaveSettings(void)
{
	FIL file;

	if (f_chdrive(DRV_PRIMARY) == FR_OK)
	{
		if (f_open(&file, SETTINGS_FILE, FA_CREATE_ALWAYS | FA_WRITE) == FR_OK)
		{
			UINT cb;
			if (f_write(&file, &g_Settings, sizeof(g_Settings), &cb) != FR_OK
				|| cb != sizeof(g_Settings))
			{
				f_lseek(&file, 0);
				f_truncate(&file);
			}
			f_close(&file);
		}
	}
}
