/****************************************************************************
  PhotoFrame
   2010(C) Mr.Honey
****************************************************************************/

#ifndef _MAIN_H_
#define _MAIN_H_

#ifndef _MSC_VER
#include <p33Fxxxx.h>

#define FCY 39613750UL
#include <libpic30.h>
#endif

// Type defs
typedef unsigned char U8;
typedef unsigned short U16;
typedef unsigned long U32;

#define RET_OK	0
#define RET_NG	1

#ifndef NULL
#define NULL	0
#endif

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

#define ASM(x)	__asm__ volatile (x)
#define _ISRNOPSV __attribute__((interrupt, no_auto_psv))

// FileSystem
#define DRV_PRIMARY		0
#define DRV_SECOND		1

extern void f_unmount(U8 drv);
extern void CopyFn(char* buf, const char* src);

extern U8 g_DmaBuf[];

// Settings
typedef struct _settings_t {
	char LastFile[16];
	int Idxes[4];
	int Reserved[5];
} settings_t;

extern const U16 g_nVals[4][6];
extern settings_t g_Settings;

extern void LoadSettings(void);
extern void SaveSettings(void);

#define IDX_DPERIOD		0
#define IDX_DLEVEL		1
#define IDX_SLEVEL		2
#define IDX_DCOUNT		3

#define OPT_DPERIOD	g_nVals[IDX_DPERIOD][g_Settings.Idxes[IDX_DPERIOD]]
#define OPT_DLEVEL	g_nVals[IDX_DLEVEL][g_Settings.Idxes[IDX_DLEVEL]]
#define OPT_SLEVEL	g_nVals[IDX_SLEVEL][g_Settings.Idxes[IDX_SLEVEL]]
#define OPT_DCOUNT	g_nVals[IDX_DCOUNT][g_Settings.Idxes[IDX_DCOUNT]]

#endif
