/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/
#ifndef _HONEY_BOARD_H_
#define _HONEY_BOARD_H_

// Clock
#define SYS_CLOCK			30000000UL	// Hz

// SRAM
#define SRAM_CE_TRIS_SET	TRISFSET
#define SRAM_CE_TRIS_CLR	TRISFCLR
#define SRAM_CE_TRIS_MASK	_TRISF_TRISF4_MASK
#define SRAM_CE_IO			PORTFbits.RF4
#define SRAM_ADVLD_TRIS_SET	TRISFSET
#define SRAM_ADVLD_TRIS_CLR	TRISFCLR
#define SRAM_ADVLD_TRIS_MSK	_TRISF_TRISF5_MASK
#define SRAM_ADVLD_SET		LATFSET
#define SRAM_ADVLD_CLR		LATFCLR
#define SRAM_ADVLD_MASK		_LATF_LATF5_MASK

#define ADDR_L_ADPC_SET		AD1PCFGSET
#define ADDR_L_ADPC_MASK	0x0000FFFC
#define ADDR_L_TRIS_SET		TRISBSET
#define ADDR_L_TRIS_CLR		TRISBCLR
#define ADDR_L_TRIS_MASK	0x0000FFFC
#define ADDR_L				LATB
#define ADDR_L_MASK			0x0000FFFC
#define ADDR_H_TRIS_SET		TRISESET
#define ADDR_H_TRIS_CLR		TRISECLR
#define ADDR_H_TRIS_MASK	0x00000007
#define ADDR_H				LATE
#define ADDR_H_MASK			0x00000007

// LCD
#define LCD_DE_TRIS			TRISDbits.TRISD10
#define LCD_DE_SET			LATDSET
#define LCD_DE_CLR			LATDCLR
#define LCD_DE_MASK			_TRISD_TRISD10_MASK
#define LCD_VS_TRIS			TRISDbits.TRISD0
#define LCD_VS_SET			LATDSET
#define LCD_VS_CLR			LATDCLR
#define LCD_VS_MASK			_LATD_LATD0_MASK
#define LCD_HS_TRIS			TRISCbits.TRISC14
#define LCD_HS_SET			LATCSET
#define LCD_HS_CLR			LATCCLR
#define LCD_HS_MASK			_LATC_LATC14_MASK

// MCU1
#define DISP_TRIS			TRISFbits.TRISF0
#define DISP_IO				PORTFbits.RF0
#define VS_INT_TRIS			TRISDbits.TRISD5
#define VS_INT_SET			LATDSET
#define VS_INT_CLR			LATDCLR
#define VS_INT_MASK			_TRISD_TRISD5_MASK
#define HS_INT_TRIS			TRISDbits.TRISD6
#define HS_INT_SET			LATDSET
#define HS_INT_CLR			LATDCLR
#define HS_INT_MASK			_TRISD_TRISD6_MASK

// LED
#define LED_TRIS			TRISDbits.TRISD1
#define LED_IO				LATDbits.LATD1

// Inverter
#define INV_TRIS			TRISDbits.TRISD3
#define INV_IO				LATDbits.LATD3

// NC(Output LO)
#define NC_TRIS_MASK_C		0x0000A000	// RC13,RC15
#define NC_TRIS_MASK_D		0x00000B94	// RD2,RD4,RD7,RD8,RD9,RD11
#define NC_TRIS_MASK_E		0x000000F8	// RE3,RE4,RE5,RE6,RE7
#define NC_TRIS_MASK_F		0x0000004E	// RF1,RF2,RF3,RF6
#define NC_TRIS_MASK_G		0x000003CC	// RG2,RG3,RG6,RG7,RG8,RG9


#endif //_HONEY_BOARD_H_
