/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include "Compiler.h"
#include "GenericTypeDefs.h"
#include "HoneyBoard.h"

//=================================================================

// Configuration
#ifndef _MSC_VER

// DEVCFG0
#pragma config DEBUG = ON			// Disabled
#pragma config ICESEL = ICS_PGx1	// ICE pins are shared with PGC1, PGD1
#pragma config PWP = OFF			// Disabled
#pragma config BWP = OFF			// Disabled
#pragma config CP = OFF				// Disabled

// DEVCFG1
#pragma config FNOSC = PRI			// Primary oscillator (XT, HS, EC)
#pragma config FSOSCEN = OFF		// Disabled
#pragma config IESO = OFF			// Disabled
#pragma config POSCMOD = EC			// EC oscillator
#pragma config OSCIOFNC = OFF		// Disabled
#pragma config FPBDIV = DIV_1		// Divide by 1
#pragma config FCKSM = CSDCMD		// Clock Switching Disabled, Clock Monitoring Disabled
#pragma config WDTPS = PS4096		// 1:4096
#pragma config FWDTEN = OFF			// Disabled 

// DEVCFG2
#pragma config FPLLIDIV = DIV_6		// Divide by 6 (5MHz)
#pragma config FPLLMUL = MUL_24		// Multiply by 24 (120MHz)
#pragma config FPLLODIV = DIV_2		// Divide by 2 (60MHz for test)

#endif

//=================================================================

#define INPUT		1
#define OUTPUT		0

#define VT_CNT		480
#define HS_CNT		800
#define LINE_PITCH	1024

//=================================================================

static void InitSystem(void);
static void Run(void);
static void Vertical(void);
static void Horizontal(BOOL fEnd);
static void BlankTdel(void);
static void BlankTvb(void);

static void DelayMs(WORD ms);
static void Delay10us(DWORD dwCount);

//=================================================================

static DWORD_VAL s_nAddr;

//=================================================================

// CGg
int main(void)
{
	InitSystem();

	// LED_
	DelayMs(100);
	LED_IO = 0;
	DelayMs(100);
	LED_IO = 1;
	DelayMs(100);
	LED_IO = 0;

	for(;;) Run();
}

// n[h
static void InitSystem(void)
{
	// ptH[}XœK
	SYSTEMConfigPerformance(SYS_CLOCK);
	mOSCSetPBDIV(OSC_PB_DIV_1);

	// JTAG
	DDPCONbits.JTAGEN = 0;

	// |[g
	PORTB = PORTC = PORTD = PORTE = PORTF = PORTG = 0;
	LATB = LATC = LATD = LATE = LATF = LATG = 0;

	// 󂫃fW^s(LOo)
	TRISCCLR = NC_TRIS_MASK_C;
	TRISDCLR = NC_TRIS_MASK_D;
	TRISECLR = NC_TRIS_MASK_E;
	TRISFCLR = NC_TRIS_MASK_F;
	TRISGCLR = NC_TRIS_MASK_G;

	// LED(_)
	LED_IO = 1;
	LED_TRIS = OUTPUT;

	// SRAM
	SRAM_CE_TRIS_SET = SRAM_CE_TRIS_MASK;
	SRAM_ADVLD_TRIS_SET = SRAM_ADVLD_TRIS_MSK;
	ADDR_L_ADPC_SET = ADDR_L_ADPC_MASK;
	ADDR_L_TRIS_SET = ADDR_L_TRIS_MASK;
	ADDR_H_TRIS_SET = ADDR_H_TRIS_MASK;

	// LCD
	LCD_DE_TRIS = OUTPUT;
	LCD_VS_TRIS = OUTPUT;
	LCD_HS_TRIS = OUTPUT;

	// MCU1
	DISP_TRIS = INPUT;
	VS_INT_TRIS = OUTPUT;
	HS_INT_TRIS = OUTPUT;

	// Inverter
	INV_TRIS = OUTPUT;
}

// s[v
static void Run(void)
{
	// 艻
	DelayMs(100);

	// tbV[v
	//  (489800TCNƂ傢)
	for(;;) Vertical();
}

// (TdeluNԊ܂)
#define DOHORZ Horizontal(FALSE); BlankTdel();
#define DOHORZx10 \
	DOHORZ DOHORZ DOHORZ DOHORZ DOHORZ \
	DOHORZ DOHORZ DOHORZ DOHORZ DOHORZ
#define DOHORZx100 \
	DOHORZx10 DOHORZx10 DOHORZx10 DOHORZx10 DOHORZx10 \
	DOHORZx10 DOHORZx10 DOHORZx10 DOHORZx10 DOHORZx10

// 
static void Vertical(void)
{
	// x\
	LED_IO = 0;

	// JnAhXݒ
	// ➑̂t܂ɐݒu邪ADMMT-7000WVGA ̐][q
	// Ȃ߁A`悷
	s_nAddr.Val = (VT_CNT - 1) * LINE_PITCH;

	//  480(480xTdeh + 479xTdel = 479800TCN)
	// VS_INT HI>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	VS_INT_SET = VS_INT_MASK;

	LCD_VS_SET = LCD_VS_MASK; // HS ->HI (M)
	DOHORZ
	LCD_VS_CLR = LCD_VS_MASK; // HS ->LO

	DOHORZ DOHORZ DOHORZ
	DOHORZ DOHORZ DOHORZ DOHORZ DOHORZ
	DOHORZx10 DOHORZx10
	DOHORZx10 DOHORZx10 DOHORZx10 DOHORZx10 DOHORZx10
	DOHORZx100 DOHORZx100 DOHORZx100 DOHORZx100

	Horizontal(TRUE);
	// VS_INT HI<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	// obNCg̕\
	INV_IO = DISP_IO;

	// uN
	BlankTvb();
}

// o[Xg[h(4NbNTCN)
#define BURST_READ							\
{											\
	/* SRAM_ADVLD_SET = SRAM_ADVLD_MASK; */ \
	asm("sw		$t3, 24936($t0)");			\
											\
	/* ADDR_L += 4; */						\
	asm("addiu	$t7, $t7, 4");				\
	asm("sw		$t7, 24672($t0)");			\
											\
	/* SRAM_ADVLD_CLR = SRAM_ADVLD_MASK; */ \
	asm("sw		$t3, 24932($t0)");			\
}

// BURST_READ x10
#define BURST_READx10						\
	BURST_READ BURST_READ BURST_READ BURST_READ BURST_READ	\
	BURST_READ BURST_READ BURST_READ BURST_READ BURST_READ

// 
static void Horizontal(BOOL fEnd)
{
	// t0,t1,t2,t3,t4,t5 WX^
	asm("lui	$t0, 0xbf88");		// x[XAhX
	asm("addiu	$t1, $zero, 16");	// SRAM_CE_TRIS_MASK
	asm("addiu	$t2, $zero, 32");	// SRAM_ADVLD_TRIS_MSK
	asm("addiu	$t3, $zero, 32");	// SRAM_ADVLD_MASK
	asm("addiu	$t4, $zero, 1024");	// LCD_DE_MASK
	asm("addiu	$t5, $zero, 16384");// LCD_HS_MASK

	// HS_INT HI>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	HS_INT_SET = HS_INT_MASK;

	// ÔCECmF
	if (!SRAM_CE_IO)
	{
		// XVԂɃCSRAMoXJĂȂꍇ
		// LEDx\違҂
		LED_IO = 1;
		while (!SRAM_CE_IO);
	}

	// HS ->HI (M)
	/* LCD_HS_SET = LCD_HS_MASK; */
	asm("sw		$t5, 24744($t0)");

	// Address->data
	ADDR_L = s_nAddr.word.LW;
	ADDR_H = s_nAddr.word.HW;
	ADDR_L_TRIS_CLR = ADDR_L_TRIS_MASK;
	ADDR_H_TRIS_CLR = ADDR_H_TRIS_MASK;

	// t7 initialize
	/* t7 = ADDR_L */
	asm("lw     $t7, 24672($t0)");

	// ADVLD:output(LO)
	/* SRAM_ADVLD_TRIS_CLR = SRAM_ADVLD_TRIS_MSK; */
	asm("sw		$t2, 24900($t0)");

	// HS ->LO
	/* LCD_HS_CLR = LCD_HS_MASK; */
	asm("sw		$t5, 24740($t0)");

	// CE:output(LO)
	/* SRAM_CE_TRIS_CLR = SRAM_CE_TRIS_MASK; */
	asm("sw		$t1, 24900($t0)");

	// DE ->HI
	/* LCD_DE_SET = LCD_DE_MASK; */
	asm("sw		$t4, 24808($t0)");

	// SRAMo[Xg[hAhXo(4NbNx200 = 800f[^)
	BURST_READx10 BURST_READx10 BURST_READx10 BURST_READx10
	BURST_READx10 BURST_READx10 BURST_READx10 BURST_READx10
	BURST_READx10 BURST_READx10 BURST_READx10 BURST_READx10
	BURST_READx10 BURST_READx10 BURST_READx10 BURST_READx10
	BURST_READx10 BURST_READx10 BURST_READx10 BURST_READx10

	// DE ->LO
	/* LCD_DE_CLR = LCD_DE_MASK; */
	asm("sw		$t4, 24804($t0)");

	// CE:input(HI)
	/* SRAM_CE_TRIS_SET = SRAM_CE_TRIS_MASK; */
	asm("sw		$t1, 24904($t0)");

	// ADVLD:floating
	/* SRAM_ADVLD_TRIS_SET = SRAM_ADVLD_TRIS_MSK; */
	asm("sw		$t2, 24904($t0)");
	
	// Address:floating
	ADDR_L_TRIS_SET = ADDR_L_TRIS_MASK;
	ADDR_H_TRIS_SET = ADDR_H_TRIS_MASK;

	// 1CI
	if (fEnd) {
		// 1t[I
		VS_INT_CLR = VS_INT_MASK;
	}
	HS_INT_CLR = HS_INT_MASK;
	// HS_INT HI<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	// ()̃C
	s_nAddr.Val -= LINE_PITCH;
}

// uNԗp
#define NOPx10 \
	Nop(); Nop(); Nop(); Nop(); Nop(); \
	Nop(); Nop(); Nop(); Nop(); Nop();
#define NOPx100 \
	NOPx10 NOPx10 NOPx10 NOPx10 NOPx10 \
	NOPx10 NOPx10 NOPx10 NOPx10 NOPx10
#define NOPx1000 \
	NOPx100 NOPx100 NOPx100 NOPx100 NOPx100 \
	NOPx100 NOPx100 NOPx100 NOPx100 NOPx100
	
// uNԏ(Tdel)
static void BlankTdel(void)
{
	// Tdex1000TCNƂȂ悤ɒ
	// Tdel200TCNƂ邪A֐ďoȂǂ
	// ߃TCN񐔂Nop鎖
	// Tdeh(800) + Tdel = 1000 TCN ƂȂ
	// 悤ɂ
	NOPx100
	NOPx10 NOPx10 NOPx10
}

// uNԏ(Tvb)
static void BlankTvb(void)
{
	// Min.10Tde = 10000TCN
	NOPx1000 NOPx1000 NOPx1000 NOPx1000 NOPx1000
	NOPx1000 NOPx1000 NOPx1000 NOPx1000 NOPx1000
}

//=================================================================

// (Delay.c )
static void DelayMs(WORD ms)
{
    BYTE i;
    while(ms--)
    {
        i=4;
        while(i--)
        {
            Delay10us(25);
        }
    }
}

// (Delay.c )
static void Delay10us(DWORD dwCount)
{
	volatile DWORD _dcnt;

	_dcnt = dwCount*((DWORD)(0.00001/(1.0/SYS_CLOCK)/10));
	while(_dcnt--)
	{
		Nop();
		Nop();
		Nop();
	}
}
