/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include "Image Decoders\ImageDecoder.h"
#include "Main.h"
#include "SDC.h"
#include "GFX.h"
#include "ff.h"

#define BUF_SIZE	(800 * 16 * 3)

//=================================================================

static void PixelJpg(IMG_PIXEL_XY_RGB_888 *pPix);
static void PixelOut(IMG_PIXEL_XY_RGB_888 *pPix);

static IMG_FILE_SYSTEM_API s_FileAPIs;
static size_t FRead(void *ptr, size_t size, size_t n, void *stream);
static int FSeek(void *stream, long offset, int whence);
static long FTell(void *fo);
static int FFeof(void *stream);

//=================================================================

static const rect_t s_Scr = { 0, 0, LCD_CX, LCD_CY };
static rect_t s_Rect;
static rect_t s_Jpg0;
static rect_t s_Jpg1;
static int s_nCy;
static int s_nMax;
static int s_nBtm;
static int s_nCount;
static int s_nBC;

static BYTE s_Buf1[BUF_SIZE];
static BYTE s_Buf2[BUF_SIZE];
static BYTE* s_pBits;
static BYTE* s_pCur;

//=================================================================

// 
extern void InitGFX(void)
{
	ImageDecoderInit();

	s_FileAPIs.pFread = FRead;
    s_FileAPIs.pFseek = FSeek;
    s_FileAPIs.pFtell = FTell;
    s_FileAPIs.pFeof = FFeof;

	s_nBC = 0;
}

// JPGt@C̕\
extern void DrawJpg(const char* path, const rect_t* rc)
{
	FIL file;
	if (f_open(&file, path, FA_READ) == FR_OK)
	{
		if (rc == NULL)
			rc = &s_Scr;

		s_Jpg0 = *rc;
		s_Jpg1.x = (WORD)-1;
		s_nCount = 0;
		s_pBits = (s_nBC & 1)? s_Buf1 : s_Buf2;

		// fR[h
		if (ImageDecode(&file, IMG_JPEG, rc->x, rc->y, rc->w, rc->h,
			IMG_DOWN_SCALE | IMG_ALIGN_CENTER, &s_FileAPIs, PixelJpg) != 0) {
			LOG("DrawJpg() error\r\n");
		}
		VERIFY(f_close(&file) == FR_OK);
		return;
	}
	LOG("f_open() error\r\n");
}

// GIFt@C̕\
extern void DrawGif(const char* path, const rect_t* rc)
{
	FIL file;
	if (f_open(&file, path, FA_READ) == FR_OK)
	{
		if (rc == NULL)
			rc = &s_Scr;

		s_nBtm = rc->y + rc->h;
		s_nCy = BUF_SIZE / (rc->w * 3);
		if (s_nCy > rc->h)
			s_nCy = rc->h;
		s_nMax = rc->w * s_nCy;

		s_Rect.x = rc->x;
		s_Rect.y = rc->y;
		s_Rect.w = rc->w;
		s_Rect.h = s_nCy;

		s_nCount = 0;
		s_pBits = (s_nBC & 1)? s_Buf1 : s_Buf2;
		s_pCur = s_pBits;

		// fR[h
		if (ImageDecode(&file, IMG_GIF, rc->x, rc->y, rc->w, rc->h,
			0, &s_FileAPIs, PixelOut) != 0) {
			//LOG("DrawGif() error\r\n"); ł0ȊOԂlq
		}
		VERIFY(f_close(&file) == FR_OK);
		return;
	}
	LOG("f_open() error\r\n");
}

// BMPt@C̕\
extern void DrawBmp(const char* path, const rect_t* rc)
{
	FIL file;
	if (f_open(&file, path, FA_READ) == FR_OK)
	{
		if (rc == NULL)
			rc = &s_Scr;

		s_nBtm = rc->y + rc->h;
		s_nCy = BUF_SIZE / (rc->w * 3);
		if (s_nCy > rc->h)
			s_nCy = rc->h;
		s_nMax = rc->w * s_nCy;

		s_Rect.x = rc->x;
		s_Rect.y = rc->y;
		s_Rect.w = rc->w;
		s_Rect.h = s_nCy;

		s_nCount = 0;
		s_pBits = (s_nBC & 1)? s_Buf1 : s_Buf2;
		s_pCur = s_pBits;

		// fR[h
		if (ImageDecode(&file, IMG_BMP, rc->x, rc->y, rc->w, rc->h,
			0, &s_FileAPIs, PixelOut) != 0) {
			LOG("DrawBmp() error\r\n");
		}
		VERIFY(f_close(&file) == FR_OK);
		return;
	}
	LOG("f_open() error\r\n");
}

// ̕`(O[XP[uht)
extern void DrawChar(const char* path, WORD x, WORD y, BYTE c, COLOR col)
{
	FIL file;
	if (f_open(&file, path, FA_READ) == FR_OK)
	{
		WORD w, h;
		UINT cb;
		BOOL fOk = (f_read(&file, &w, 2, &cb) == FR_OK && cb == 2);
		fOk &= (f_read(&file, &h, 2, &cb) == FR_OK && cb == 2);
		if (fOk)
		{
			rect_t rc = { x, y, w, h };
			int nBtm = rc.y + rc.h;

			rc.h = BUF_SIZE / ((int)w * 3);
			if (rc.h > h)
				rc.h = h;

			if (c != 0)
			{
				// Yʒu܂ŃV[N
				if (f_lseek(&file, 4 + (DWORD)w * (DWORD)h * (DWORD)c) != FR_OK)
				{
					LOG("f_read() error\r\n");
					return;
				}
			}
			for (;;)
			{
				BYTE *s, *p, *e;
				
				// \̃f[^擾
				GetBits(&rc, s_Buf1);

				// f[^[h
				if (f_read(&file, s_Buf2, rc.w * rc.h, &cb) != FR_OK || cb != (rc.w * rc.h))
				{
					LOG("f_read() error\r\n");
					return;
				}
				// ҂uh
				if (col == COL_BLACK)
				{
					for (s = s_Buf1, p = s_Buf2, e = p + rc.w * rc.h; p < e; s += 3, p++)
					{
						if (*p != 255)
						{
							s[0] = (BYTE)(((DWORD)s[0] * (DWORD)*p) / 255UL);
							s[1] = (BYTE)(((DWORD)s[1] * (DWORD)*p) / 255UL);
							s[2] = (BYTE)(((DWORD)s[2] * (DWORD)*p) / 255UL);
						}
					}
				}
				else
				{
					DWORD r = (col >>  0) & 0xFF;
					DWORD g = (col >>  8) & 0xFF;
					DWORD b = (col >> 16) & 0xFF;
					for (s = s_Buf1, p = s_Buf2, e = p + rc.w * rc.h; p < e; s += 3, p++)
					{
						if (*p != 255)
						{
							s[0] = (BYTE)(((DWORD)s[0] * (DWORD)*p) / 255UL + (r * (255UL - (DWORD)*p)) / 255UL);
							s[1] = (BYTE)(((DWORD)s[1] * (DWORD)*p) / 255UL + (g * (255UL - (DWORD)*p)) / 255UL);
							s[2] = (BYTE)(((DWORD)s[2] * (DWORD)*p) / 255UL + (b * (255UL - (DWORD)*p)) / 255UL);
						}
					}
				}
				// o
				BlitLCD(&rc, s_Buf1);

				// ̈
				rc.y += rc.h;
				if ((rc.y + rc.h) > nBtm)
				{
					rc.h = nBtm - rc.y;
					if (rc.h == 0)
						break;
				}
			}
			return;
		}
	}
	LOG("f_open() error\r\n");
}

//=================================================================

// sNZo̓R[obN
static void PixelJpg(IMG_PIXEL_XY_RGB_888 *pPix)
{
	static BYTE bDownScalingFactor;
	static WORD nLastY;

	if (s_Jpg1.x == (WORD)-1)
	{
		// 摜̎ۂ̕`GA(kZ^ǑʂŌ܂)ɊÂ
		// p[^ݒ肷.̈ʒułȂΎ擾łȂ
        bDownScalingFactor = (IMG_bDownScalingFactor <= 1)? 1: IMG_bDownScalingFactor;
		s_Jpg1.x = IMG_wStartX;
		s_Jpg1.y = IMG_wStartY;
		s_Jpg1.w = IMG_wImageWidth / bDownScalingFactor;
		s_Jpg1.h = IMG_wImageHeight / bDownScalingFactor;

		s_nBtm = s_Jpg1.y + s_Jpg1.h;
		s_nCy = BUF_SIZE / (s_Jpg1.w * 3);
		s_nCy = (s_nCy / 16) * 16;
		if (s_nCy > s_Jpg1.h)
			s_nCy = s_Jpg1.h;
		s_nMax = s_Jpg1.w * s_nCy;

		s_Rect.x = s_Jpg1.x;
		s_Rect.y = s_Jpg1.y;
		s_Rect.w = s_Jpg1.w;
		s_Rect.h = s_nCy;

		nLastY = 0xFFFF;

		// pfBÖh
		if (s_Jpg1.y > s_Jpg0.y)
		{
			// 
			rect_t r = s_Jpg0;
			r.h = s_Jpg1.y - s_Jpg0.y;
			FillLCD(&r, COL_WHITE);
		}
		if (s_Jpg1.x > s_Jpg0.x)
		{
			// 
			rect_t r;
			r.x = s_Jpg0.x;
			r.w = s_Jpg1.x - s_Jpg0.x;
			r.y = s_Jpg1.y;
			r.h = s_Jpg1.h;
			FillLCD(&r, COL_WHITE);
		}
		if ((s_Jpg0.x + s_Jpg0.w) > (s_Jpg1.x + s_Jpg1.w))
		{
			// E
			rect_t r;
			r.x = s_Jpg1.x + s_Jpg1.w;
			r.w = (s_Jpg0.x + s_Jpg0.w) - r.x;
			r.y = s_Jpg1.y;
			r.h = s_Jpg1.h;
			FillLCD(&r, COL_WHITE);
		}
		if ((s_Jpg0.y + s_Jpg0.h) > (s_Jpg1.y + s_Jpg1.h))
		{
			// 
			rect_t r = s_Jpg0;
			r.y = s_Jpg1.y + s_Jpg1.h;
			r.h = (s_Jpg0.y + s_Jpg0.h) - r.y;
			FillLCD(&r, COL_WHITE);
		}

	}
	if (bDownScalingFactor > 1)
	{
		// JpegDecoder̕sΉ(kA͈͊O̍WnĂ鎖)
		if (pPix->X >= (s_Jpg1.x + s_Jpg1.w))
			return;
		if (pPix->Y >= (s_Jpg1.y + s_Jpg1.h))
			return;
	}
	if (pPix->Y != nLastY)
	{
		s_pCur = s_pBits + ((pPix->X - s_Jpg1.x) + (pPix->Y - s_Rect.y) * s_Jpg1.w) * 3;
		nLastY = pPix->Y;
	}
	else {
		s_pCur += 3;
	}
	ASSERT((s_pCur + 2) < (s_pBits + BUF_SIZE));
	s_pCur[0] = pPix->R;
	s_pCur[1] = pPix->G;
	s_pCur[2] = pPix->B;

	if (++s_nCount == s_nMax)
	{
		BlitLCD(&s_Rect, s_pBits);
		s_Rect.y += s_nCy;
		if ((s_nBtm - s_Rect.y) < s_nCy)
		{
			s_nCy = s_nBtm - s_Rect.y;
			s_nMax = s_Rect.w * s_nCy;
			s_Rect.h = s_nCy;
		}
		s_nCount = 0;
		s_nBC++;
		s_pBits = (s_nBC & 1)? s_Buf1 : s_Buf2;
	}

	// ɑSʂƎԂꍇ̂ŃNAĂ
	ClearWDT();
}

// sNZo̓R[obN
static void PixelOut(IMG_PIXEL_XY_RGB_888 *pPix)
{
	ASSERT((s_pCur + 2) < (s_pBits + BUF_SIZE));
	s_pCur[0] = pPix->R;
	s_pCur[1] = pPix->G;
	s_pCur[2] = pPix->B;
	s_pCur += 3;

	if (++s_nCount == s_nMax)
	{
		BlitLCD(&s_Rect, s_pBits);
		s_Rect.y += s_nCy;
		if ((s_nBtm - s_Rect.y) < s_nCy)
		{
			s_nCy = s_nBtm - s_Rect.y;
			s_nMax = s_Rect.w * s_nCy;
			s_Rect.h = s_nCy;
		}
		s_nCount = 0;
		s_nBC++;
		s_pBits = (s_nBC & 1)? s_Buf1 : s_Buf2;
		s_pCur = s_pBits;
	}

	// ɑSʂƎԂꍇ̂ŃNAĂ
	ClearWDT();
}

//=================================================================

// t@CAPI(fread)
static size_t FRead(void *ptr, size_t size, size_t n, void *stream)
{
	UINT cb;
	if (f_read((FIL*)stream, ptr, size * n, &cb) != FR_OK)
		LOG("FRead() error\r\n");
	return cb;
}

// t@CAPI(fseek)
static int FSeek(void *stream, long offset, int whence)
{
	if (whence == 1) {
		offset = f_tell((FIL*)stream) + offset;
	}
	else {
		ASSERT(whence == 0);
	}
	if (f_lseek((FIL*)stream, offset) != FR_OK)
	{
		LOG("FSeek() error\r\n");
		return 1;
	}
	return 0;
}

// t@CAPI(ftell)
static long FTell(void *stream)
{
	return f_tell((FIL*)stream);
}

// t@CAPI(feof)
static int FFeof(void *stream)
{
	return f_eof((FIL*)stream);
}
