/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/
#ifndef _LCD_H_
#define _LCD_H_

extern void InitLCD(void);
extern void TaskLCD(void);
extern void EnableLCD(void);
extern void DisableLCD(void);
extern BOOL IsEnabledLCD(void);
extern BOOL IsDisabledLCD(void);

typedef struct _rect_t {
	WORD x; WORD y; WORD w; WORD h;
} rect_t;
typedef DWORD COLOR;

extern void FillLCD(const rect_t* rc, COLOR c);
extern void BlitLCD(const rect_t* rc, const BYTE* bm);
extern void GetBits(const rect_t* rc, BYTE* bm);

#define COL_WHITE	0x00FCFCFCUL
#define COL_BLACK	0x00000000UL
#define COL_RED		0x000000FCUL
#define COL_GREEN	0x0000FC00UL
#define COL_BLUE	0x00FC0000UL
#define COL_CYAN	(COL_GREEN | COL_BLUE)
#define COL_MAGENTA	(COL_RED | COL_BLUE)
#define COL_YELLOW	(COL_RED | COL_GREEN)

#define IsBusyLCD()	HS_INT_IE

#define LCD_CX		800
#define LCD_CY		480


#endif //_LCD_H_
