/*-----------------------------------------------------------------------*/
/* Low level disk I/O module skeleton for FatFs     (C)ChaN, 2007        */
/*-----------------------------------------------------------------------*/
/* This is a stub disk I/O module that acts as front end of the existing */
/* disk I/O modules and attach it to FatFs module with common interface. */
/*-----------------------------------------------------------------------*/

#include "diskio.h"
#include "system/sdcard/sdcard.h"

/*-----------------------------------------------------------------------*/
/* Inidialize a Drive                                                    */

DSTATUS disk_initialize (
	byte drv				/* Physical drive nmuber (0..) */
)
{
	return RES_OK;
}

/*-----------------------------------------------------------------------*/
/* Return Disk Status                                                    */

DSTATUS disk_status (
	byte drv		/* Physical drive nmuber (0..) */
)
{
	return RES_OK;
}

/*-----------------------------------------------------------------------*/
/* Read Sector(s)                                                        */

DRESULT disk_read (
	byte drv,		/* Physical drive nmuber (0..) */
	byte *buff,		/* Data buffer to store read data */
	dword sector,	/* Sector address (LBA) */
	byte count		/* Number of sectors to read (1..255) */
)
{
	byte i = count;

	do {
		if (SectorRead(sector++, buff) != sdcValid)
			return RES_ERROR;
		buff += SDC_SECTOR_SIZE;
	}
	while (--i > 0);

	return RES_OK;
}
