/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include <p18cxxx.h>

// Ports
#define SDC_CS			LATBbits.LATB3
#define SDC_DI			PORTCbits.RC7
#define SDC_DO			PORTBbits.RB0
#define SDC_SCK			PORTBbits.RB1

#define LCD_CS			LATCbits.LATC6
#define LCD_RD			PORTCbits.RC0
#define LCD_WR			PORTCbits.RC1
#define LCD_CD			PORTCbits.RC2
#define LCD_DATA		PORTD

#define MP3_XRESET		LATEbits.LATE0
#define MP3_XCS			LATEbits.LATE1
#define MP3_XDCS		LATEbits.LATE2
#define MP3_DREQ		PORTEbits.RE3
#define MP3_SI			PORTDbits.RD1
#define MP3_SO			PORTDbits.RD2
#define MP3_SCLK		PORTCbits.RC1

#define FM_SEN			LATAbits.LATA5
#define FM_SDIO			PORTDbits.RD0
#define FM_SCLK			PORTCbits.RC0

#define POW_BLC			LATBbits.LATB2
#define POW_PWC			LATBbits.LATB5
#define POW_PSW			PORTAbits.RA0

#define BEEP			LATBbits.LATB4
#define MUTE			LATBbits.LATB4
#define LED_R			LATBbits.LATB6
#define LED_G			LATBbits.LATB7
#define LED_B			LATAbits.LATA4

#define SW_DATA			(PORTA & 0b00001110)
#define SW_NONE			0b00001110
#define SW_UP			0b00001100
#define SW_VDOWN		0b00001010
#define SW_PLAY			0b00001000
#define SW_STOP			0b00000110
#define SW_PREV			0b00000100
#define SW_NEXT			0b00000010
#define SW_MENU			0b00000000
#define SW_POWER		0b01111111

// Directions
#define DIR_MP3_SO		TRISDbits.TRISD2
#define DIR_FM_SDIO		TRISDbits.TRISD0
#define DIR_LCD_DATA	TRISD

// Timer0 Period
// 1398.101333ms = (1/48MHz *4 *256Scale *65536Count) / 1000
#define TMR0MS		1398

// Types
#define S8	char
#define U8	unsigned char
#define S16	short
#define U16	unsigned short
#define S32	long
#define U32	unsigned long

// Functions
#define LEDO	0x00
#define LEDB	0x01
#define LEDG	0x02
#define LEDR	0x04
#define PUSHING	0x80

extern void Shutdown(void);
extern void ClearWDT(void);
extern void DelayMs(U16 ms);
extern void DelaySec(U8 sec);
extern void SetLED(U8 c);
extern U8 GetKey(void);
extern void SetKeyRate(U16 rate);
extern U8 GetPow(void);
extern U8 CheckBAT(U8 lev, U8 led);
extern void SetOffTmr(void);
extern U8 CheckOFF(void);

extern U8 Menu(void);
extern void DrawBase(U8 title, U8 area);

#define EnableINT()		INTCONbits.GIE = 1
#define DisableINT()	INTCONbits.GIE = 0
#define SetLEDR(flag)	LED_R = (flag)
#define SetLEDG(flag)	LED_G = (flag)
#define SetLEDB(flag)	LED_B = (flag)

#define LOBYTE(x)		((x) & 0xFF)
#define HIBYTE(x)		(((x) >> 8) & 0xFF)
#define MAKEWORD(h, l)	(((U16)(h) << 8) | (U16)l)

#ifdef ENABLE_BEEP
extern void Beep(U8 freq, U16 time);
#define KeyBeep()		Beep(15, 40)
#else
#define KeyBeep()
#endif

// Variables
extern volatile U32 s_nT0C;
#ifdef ENABLE_BEEP
extern volatile U8 g_nBeepH;
extern volatile U8 g_nBeepL;
extern volatile U16 g_nBeepC;
#endif

// Params
#define UPPER_POW	255 // 4.8V
#define LOWER_POW	172 // 3.2V
#define LIMIT_POW	160 // 3.0V
#define MAX_POWER	10
#define POWER_UNIT	((UPPER_POW - LOWER_POW) / MAX_POWER)
#define POWER_THR	1

#define MAX_VOLUME	16
