/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include "board.h"
#include "romdat.h"
#include "LCD/lcd.h"
#include "MP3/mp3.h"
#include "FMR/fmr.h"
#include "MSD/system/usb/usb.h"
#include "MSD/system/usb/usb_compile_time_validation.h"
#include "ff.h"
#include "resource.h"

//=================================================================

//300000h CONFIG1L
#pragma config	USBDIV=2, CPUDIV=OSC1_PLL2, PLLDIV=5

//300001h CONFIG1H
#pragma config	IESO=OFF, FCMEN=OFF, FOSC=HSPLL_HS

//300002h CONFIG2L
#pragma config	VREGEN=ON, BORV=1, BOR=OFF, PWRT=ON

//300003h CONFIG2H
#pragma config	WDTPS=4096, WDT=ON

//300005h CONFIG3H
#pragma config	MCLRE=OFF, LPT1OSC=ON, PBADEN=OFF, CCP2MX=OFF

//300006h CONFIG4L
#pragma config	DEBUG=OFF, XINST=OFF, ICPRT=ON, LVP=OFF, STVREN=ON

//300008h CONFIG5L
#pragma config	CP3=OFF, CP2=OFF, CP1=OFF, CP0=OFF

//300009h CONFIG5H
#pragma config	CPD=OFF, CPB=OFF

//30000Ah CONFIG6L
#pragma config	WRT3=OFF, WRT2=OFF, WRT1=OFF, WRT0=OFF

//30000Bh CONFIG6H
#pragma config	WRTD=OFF, WRTB=OFF, WRTC=OFF

//30000Ch CONFIG7L
#pragma config	EBTR3=OFF, EBTR2=OFF, EBTR1=OFF, EBTR0=OFF

//30000Dh CONFIG7H
#pragma config	EBTRB=OFF

//=================================================================

// MACROS
#define MODE_MENU	0
#define MODE_MP3	1
#define MODE_FMR	2
#define MODE_CURR	0xFE
#define MODE_POFF	0xFF

#ifndef _DEBUG
#define WDT_ON()	WDTCONbits.SWDTEN = 1
#endif
#define WDT_OFF()	WDTCONbits.SWDTEN = 0

// VARIABLES
#pragma udata overlay share=0x500
static FATFS s_FS;

#pragma udata
static U16 s_nT1C = 0;
static U8 s_nLED = 0b00100100;
static U8 s_nVolume;

// PRIVATE
static void InitSystem(void);
static void InitDevice(void);
static void Run(void);
static U8 MP3(void);
static U8 FMR(void);

static void FirstDraw(void);
static void UpdateVol(U8 lev);

// VECTOR REMAPPING
extern void _startup (void);
#pragma code _RESET_INTERRUPT_VECTOR = 0x000020
void _reset (void) {
    _asm goto _startup _endasm
}

static void Interrupt(void);
#pragma code INTERRUPT_VECTOR = 0x00008
void _Interrupt(void) {
	_asm GOTO Interrupt _endasm
}
#pragma code

//=================================================================

// CGg
void main(void)
{
	// 
	WDT_OFF();
	InitSystem();
	InitDevice();

	// AvP[Vs
	WDT_ON();
	Run();

	// df
	WDT_OFF();
	Shutdown();
}

// VXe
static void InitSystem(void)
{
	// ZY-FGD1442701V1-RSTB, RDA5800C-RST C
	// mHIɂȂ̂҂
	DelayMs(10);

	// |[gNA
	PORTA = 0;
	PORTB = 0;
	PORTC = 0;
	PORTD = 0;
	PORTE = 0;

	LATA = 0;
	LATB = 0;
	LATC = 0;
	LATD = 0;
	LATE = 0;

	// vAbvݒ
	INTCON2bits.RBPU = 0;	// PORTB ON
	PORTEbits.RDPU = 1;		// PORTD ON

	// fWAiݒ
	ADCON1 = 0b00001111;// Reference=VDD/VSS, ALL Digital

	// lݒ@
	PORTA = 0b00100000; // FM_SEN(RSTHIɂȂĂv30ns)
	PORTB = 0b00111110;	// SDC_CS, MUTE, SDC_SCK, POW_BLC, POW_PWC
	PORTC = 0b11000011;	// SDC_DI, LCD_CS, LCD_RD/FM_SCLK, LCD_WR/MP3_SCLK
	PORTD = 0b00000000;
	PORTE = 0b10000110;	// MP3_XCS, MP3_XDCS

	// ݒ
	TRISA = 0b11001111;
	TRISB = 0b00000001;
	TRISC = 0b00110000;
	TRISD = 0b00000000;
	TRISE = 0b11111000;

	// lݒA
	PORTA = 0b00100000;
	PORTB = 0b00111110;
	PORTC = 0b11000011;
	PORTD = 0b00000000;
	PORTE = 0b10000110;

	// `cRo[^
	ADCON0 = 0b00000001; // Channel:0, ADON
	ADCON2 = 0b00111010; // Left, Acquisition:20TAD, 32Tosc(TAD 1.6uS)

	// 荞݃Cl[u
	INTCONbits.PEIE = 1;
	EnableINT();

	// TMR1(NLED\)
	SetLEDR(1);
	PIE1bits.TMR1IE = 1;
	T1CON = 0b10110001;
	
	#if 0
	SetLED(LEDR); DelayMs(250);
	SetLED(LEDG); DelayMs(250);
	SetLED(LEDB); DelayMs(250);
	SetLED(LEDO);
	#endif

	// TMR0(It^C}[)
	INTCONbits.TMR0IE = 1;
	T0CON = 0b10000111;

	// d{^܂ő҂
	while(!POW_PSW);
}

// foCX
static void InitDevice(void)
{
	// t@CVXe
	SDCardInit();
	f_mount(0, &s_FS);
	f_chdrive(0);

	InitLCD();

	// NʂƃobNCg_
	LCD_Blit(&g_Scr, IMG_SPLASH);
	POW_BLC = 0;
	DelaySec(2);

	InitMP3();
	InitFMR();

	mInitializeUSBDriver();
}

// AvP[Vs
static void Run(void)
{
	// Xg[h[h
	U8 nLastMode = Read_b_eep(&LAST_MODE);
	U8 nNextMode = nLastMode;

	// Xg{[[h
	s_nVolume = Read_b_eep(&LAST_VOL);
	if (s_nVolume > MAX_VOLUME)
		s_nVolume = MAX_VOLUME;

	// `
	FirstDraw();

	for (;;)
	{
		// e[h֕
		switch (nNextMode)
		{
		default:
			// j[
			if (Menu())
			{
				UpdateVol(0);
				nNextMode = MODE_FMR;
			}
			else {
				nNextMode = MODE_POFF;
			}
			break;

		case MODE_MP3:
			// MP3vC[
			nNextMode = MP3();
			break;

		case MODE_FMR:
			// FMWI
			nNextMode = FMR();
			break;
		}
		
		// Vbg_E
		if (nNextMode == MODE_POFF) {
			break;
		}

		// ŏI[hL^
		if (nNextMode != MODE_MENU)
		{
			nLastMode = nNextMode;
			Write_b_eep(&LAST_MODE, nLastMode);
			Busy_eep();
		}
	}
}

//=================================================================

// MP3[h
static U8 MP3(void)
{
	U8 nNextMode = MODE_CURR;

	// Jn
	SetLEDB(1);
	SetKeyRate(350);
	MP3_Enable(1);
	MP3_Volume(s_nVolume);

	// Đ[v
	for (;;)
	{
		U8 nKey = GetKey();
		ClearWDT();
		switch (nKey & ~PUSHING)
		{
		case SW_NONE:
			break;

		case SW_VDOWN:
			if (s_nVolume > 0)
			{
				KeyBeep();
				MP3_Volume(--s_nVolume);
				UpdateVol(2);

				Busy_eep();
				Write_b_eep(&LAST_VOL, s_nVolume);
			}
			break;
		case SW_UP:
			if (s_nVolume < MAX_VOLUME)
			{
				KeyBeep();
				MP3_Volume(++s_nVolume);
				UpdateVol(2);

				Busy_eep();
				Write_b_eep(&LAST_VOL, s_nVolume);
			}
			break;

		case SW_PLAY:
			if (!MP3_IsPlaying())
			{
				KeyBeep();
				MP3_Play();
				SetKeyRate(10);
			}
			break;
		case SW_STOP:
			KeyBeep();
			if (MP3_IsPlaying()) {
				MP3_Stop();
				SetKeyRate(350);
			}
			else {
				SetOffTmr();
			}
			break;

		case SW_PREV:
			KeyBeep();
			MP3_Seek(0, (nKey & PUSHING)? 1 : 0);
			break;
		case SW_NEXT:
			MP3_Seek(1, (nKey & PUSHING)? 1 : 0);
			KeyBeep();
			break;

		case SW_MENU:
			KeyBeep();
			nNextMode = MODE_MENU;
			break;
		case SW_POWER:
			nNextMode = MODE_POFF;
			break;
		}

		if (nNextMode == MODE_CURR)
		{
			U8 flag = MP3_Pump();
			if (((flag & 0x01) != 0 && !CheckBAT(1, LEDB)) ||
				((flag & 0x02) != 0 && !CheckOFF()))
			{
				nNextMode = MODE_POFF;
				break;
			}
			continue;
		}
		break;
	}

	// I
	Busy_eep();
	MP3_Stop();
	MP3_Enable(0);
	SetLEDB(0);

	return nNextMode;
}

//=================================================================

// FMR[h
static U8 FMR(void)
{
	U8 nNextMode = MODE_CURR;
	U16 nCheck = 0;

	// Jn
	SetLEDG(1);
	SetKeyRate(350);
	FMR_Enable(1);
	FMR_Volume(s_nVolume);
	FMR_Start();

	// Đ[v
	do {
		U8 nKey = GetKey();
		ClearWDT();
		switch (nKey & ~PUSHING)
		{
		case SW_NONE:
			break;

		case SW_VDOWN:
			if (s_nVolume > 0)
			{
				KeyBeep();
				FMR_Volume(--s_nVolume);
				UpdateVol(2);

				Busy_eep();
				Write_b_eep(&LAST_VOL, s_nVolume);
			}
			break;
		case SW_UP:
			if (s_nVolume < MAX_VOLUME)
			{
				KeyBeep();
				FMR_Volume(++s_nVolume);
				UpdateVol(2);

				Busy_eep();
				Write_b_eep(&LAST_VOL, s_nVolume);
			}
			break;

		case SW_PLAY:
			KeyBeep();
			FMR_Seek();
			break;

		case SW_STOP:
			KeyBeep();
			SetOffTmr();
			break;

		case SW_PREV:
			KeyBeep();
			FMR_Select(0);
			break;
		case SW_NEXT:
			KeyBeep();
			FMR_Select(1);
			break;

		case SW_MENU:
			KeyBeep();
			nNextMode = MODE_MP3;
			break;
		case SW_POWER:
			nNextMode = MODE_POFF;
			break;
		}
		if ((++nCheck == 0 && !CheckBAT(1, LEDG)) || !CheckOFF())
		{
			nNextMode = MODE_POFF;
			break;
		}
	}
	while (nNextMode == MODE_CURR);

	// I
	Busy_eep();
	FMR_Stop();
	FMR_Enable(0);
	SetLEDG(0);

	return nNextMode;
}

//=================================================================

// CXN[\
static void FirstDraw(void)
{
	LCD_Blit(&g_Scr, IMG_SCREEN);
	CheckBAT(0, LEDO);	// S̍XV
	UpdateVol(1);	// Q[WS̍XV
}

// {[\XV
static void UpdateVol(U8 lev)
{
	static rect_t VolR = { 0, VOL_Y, VOL_W, VOL_H };
	U8 i;

	if (lev == 0)
	{
		// g`܂ޑS̍XV
		static const rect_t VAR = {
			VAREA_X, VAREA_Y, VAREA_W, VAREA_H };
		LCD_Blit(&VAR, VOL_IMG);
	}

	VolR.x = VOL_X;

	if (lev <= 1)
	{
		// S̍XV
		for (i = s_nVolume; i > 0; i--)
		{
			LCD_Fill(&VolR, VOL_C);
			VolR.x += VOL_W + VOL_SP;
		}
		return;
	}

	// 1StepXV
	if (s_nVolume == 0)
	{
		LCD_Fill(&VolR, COL_SCREEN);
		return;
	}

	VolR.x += (s_nVolume - 1) * (VOL_W + VOL_SP);
	if (s_nVolume >= MAX_VOLUME)
	{
		LCD_Fill(&VolR, VOL_C);
		return;
	}

	LCD_Fill(&VolR, VOL_C);
	VolR.x += VOL_W + VOL_SP;
	LCD_Fill(&VolR, COL_SCREEN);
}

//=================================================================

// 荞݃nh
#pragma interrupt Interrupt
static void Interrupt(void)
{
	// USBCxg
	if (PIR2bits.USBIF)
	{
		PIR2bits.USBIF = 0;
		USBDriverService();
	}

	// TMR0(It^C}[)
	if (INTCONbits.TMR0IF)
	{
		s_nT0C++;
		INTCONbits.TMR0IF = 0;
	}

	// TMR1(NLED\)
	if (PIR1bits.TMR1IF)
	{
		PIR1bits.TMR1IF = 0;
		s_nT1C++;

		if ((s_nT1C % 5) == 0)
		{
			SetLED(s_nLED >>= 1);
			if (s_nLED == 0)
			{
				T1CONbits.TMR1ON = 0;
				PIE1bits.TMR1IE = 0;
			}
		}
	}

	// r[vU
#ifdef ENABLE_BEEP
	if (PIR2bits.TMR3IF)
	{
		PIR2bits.TMR3IF = 0;
		
		if (g_nBeepC > 0)
		{
			BEEP = !BEEP;
			TMR3H = g_nBeepH;	
			TMR3L = g_nBeepL;
			g_nBeepC--;
		}
		else
		{
			T3CONbits.TMR3ON = 0;
			PIE2bits.TMR3IE = 0;
			BEEP = 0;
		}
	}
#endif
}
