/****************************************************************************
  HoneyBox
   2010(C) Mr.Honey
****************************************************************************/

#include <eep.h>
#include "board.h"
#include "resource.h"

//=================================================================

volatile U32 s_nT0C = 0;
#ifdef ENABLE_BEEP
volatile U8 g_nBeepH;
volatile U8 g_nBeepL;
volatile U16 g_nBeepC = 0;
#endif

static U8 s_nLast = SW_NONE;
static U16 s_nRate = 500;
static S16 s_nCount = 0;
static S8 s_nPower = 0xFF;
static U8 s_nOffMin = 0;
static S8 s_nRemain = -1;

//=================================================================

// Vbg_E
extern void Shutdown(void)
{
	INTCONbits.PEIE = 0;
	INTCONbits.GIE = 0;

	// Ô
	POW_BLC = 1;
	LCD_CS = 1;
	MP3_XCS = 1;
	MP3_XDCS = 1;
	MP3_XRESET = 0;
	SDC_CS = 1;
	FM_SEN = 1;

	Busy_eep();
	SetLED(LEDO);

	// d~̐M̃o^h~邽
	// TCN~(Sleep)
	for(;;)
	{
		POW_PWC = 0;
		Sleep();
	}
}

// EHb`hbO^C}NA
extern void ClearWDT(void)
{
	// œKȂȂ邽ߊ֐
	ClrWdt();
}

// x(ms)
extern void DelayMs(U16 ms)
{
	U16 count = ms * 250 - 2;
	do {
		 count -= 1;
		 Nop();Nop();Nop();Nop();Nop();
	}
	while(count);
}

// x(ms)
extern void DelaySec(U8 sec)
{
	do {
		DelayMs(250);
		DelayMs(250);
		DelayMs(250);
		DelayMs(250);
   	}
	while(--sec > 0);
}

// LED\
extern void SetLED(U8 c)
{
	LED_R = ((c & LEDR)? 1 : 0);
	LED_G = ((c & LEDG)? 1 : 0);
	LED_B = ((c & LEDB)? 1 : 0);
}

// L[
extern U8 GetKey(void)
{
	if (POW_PSW)
	{
		U8 nCode;
		if (SW_DATA == SW_NONE)
		{
			s_nCount = 0;
			s_nLast = SW_NONE;
			return SW_NONE;
		}

		DelayMs(2);
		nCode = SW_DATA;
		if (nCode != s_nLast)
		{
			s_nLast = nCode;
			return nCode;
		}

		if (s_nCount++ >= s_nRate)
		{
			s_nCount = 0;
			return (PUSHING | nCode);
		}

		return SW_NONE;
	}

	return SW_POWER;
}

// [gݒ
extern void SetKeyRate(U16 rate)
{
	s_nRate = rate;
	s_nCount = 0;
}

// dd
extern U8 GetPow(void)
{
	if (POW_PSW)
	{
		U8 nV;

		// dv
		ADCON1bits.PCFG0 = 0; // AN0:A/D Port
		ADCON0bits.GO = 1;
		while(ADCON0bits.DONE);
		nV = ADRESH;
		ADCON1bits.PCFG0 = 1;

		#if 0
		{
			static text_t DV = {
				BAT_X, 1, TXT_WHITE, 11, 0, 0, 0, 0 };
			DV.num = nV;
			LCD_Text(&DV);
		}
		#endif

		// Pʕϊ
		if (nV <= LIMIT_POW) return 0xFE;
		if (nV >= UPPER_POW) return MAX_POWER;
		if (nV <= LOWER_POW) return 0;
		return (nV - LOWER_POW) / POWER_UNIT;
	}

	return 0xFF;
}

// r[v
#ifdef ENABLE_BEEP
extern void Beep(U8 freq, U16 time)
{
	if (!T3CONbits.TMR3ON)
	{
		U16 cycle = 0xFFFF - (50000 / (U16)freq) - 0x100;
		g_nBeepH = HIBYTE(cycle);
		g_nBeepL = LOBYTE(cycle);
		g_nBeepC = (U16)freq * time / 10;

		T3CON = 0x80;
		TMR3H = 0xFF;	
		TMR3L = 0xFF;
		
		PIE2bits.TMR3IE = 1;
		T3CONbits.TMR3ON = 1;
	}
}
#endif

// obe`FbN
extern U8 CheckBAT(U8 lev, U8 led)
{
	S8 n = GetPow();

	if (n != 0xFF)
	{
		// E`FbN
		if (lev != 0 && n == 0xFE)
		{
		#ifdef ENABLE_BEEP
			Beep(10, 700);
		#endif
			while(PIE2bits.TMR3IE);
			return 0;
		}

		if (s_nPower != n)
		{
			static rect_t BatR = { 0, BAT_Y, BAT_W, BAT_H };
			U16 col;

			BatR.x = BAT_X;

			// 臒lׂ͑Ŝ̐Fω邽ߋIɑSXV
			if ((s_nPower == (POWER_THR + 1) && n <= POWER_THR) ||
				(s_nPower == POWER_THR && n > POWER_THR))
				lev = 0;

			if (lev == 0)
			{
				S8 i;

				// S̍XV
				if (n <= POWER_THR) {
					col = BAT_C0;
					SetLED(LEDR);
				}
				else {
					col = BAT_C1;
					SetLED(led);
				}
				LCD_Fill(&BatR, col);
				BatR.x += BAT_W + BAT_SP;

				for (i = 0 ; i < n; i++)
				{
					LCD_Fill(&BatR, col);
					BatR.x += BAT_W + BAT_SP;
				}
				for (; i < s_nPower; i++)
				{
					LCD_Fill(&BatR, BAT_BK);
					BatR.x += BAT_W + BAT_SP;
				}

				s_nPower = n;
			}
			else
			{
				// 1StepXV
				s_nPower += (n < s_nPower)? -1 : 1;
				BatR.x += s_nPower * (BAT_W + BAT_SP);

				if (s_nPower < 1)
				{
					LCD_Fill(&BatR, BAT_BK);
					return 1;
				}

				col = (s_nPower <= POWER_THR)? BAT_C0 : BAT_C1;
				if (s_nPower >= MAX_POWER)
				{
					LCD_Fill(&BatR, col);
					return 1;
				}

				LCD_Fill(&BatR, col);
				BatR.x += BAT_W + BAT_SP;
				LCD_Fill(&BatR, BAT_BK);
			}
		}
	}

	return 1;
}

// It^C}[ݒ肷
extern void SetOffTmr(void)
{
	s_nOffMin += 15;
	if (s_nOffMin > 60)
		s_nOffMin = 0;
	s_nT0C = 0;
}

// It^C}[`FbN
extern U8 CheckOFF(void)
{
	if (s_nOffMin > 0)
	{
		S8 nRemain = s_nOffMin - (U8)((s_nT0C * TMR0MS) / 60000);
		
		// Ԑ؂`FbN
		if (nRemain <= 0)
			return 0;

		if (nRemain != s_nRemain)
		{
			static text_t TimeI = {
				APF_X, APF_Y, APF_C, APF_S, 0, 0, 0, TXT_2DIG };

			if (s_nRemain == -1)
			{
				static const rect_t IconR = {
					APF_IX, APF_IY, APF_IW, APF_IH };
				LCD_Blit(&IconR, APF_IMG);
			}

			TimeI.num = nRemain;
			LCD_Text(&TimeI);

			s_nRemain = nRemain;
		}
	}
	else
	{
		if (s_nRemain != -1)
		{
			static const rect_t ApfR = {
				APF_IX, APF_IY, APF_W, APF_H };

			LCD_Fill(&ApfR, COL_SCREEN);

			s_nRemain = -1;
		}
	}

	return 1;
}

// x[X`
extern void DrawBase(U8 title, U8 area)
{
	static const rect_t Title = {
		TITLE_X, TITLE_Y, TITLE_W, TITLE_H };
	static const rect_t Area = {
		CAREA_X, CAREA_Y, CAREA_W, CAREA_H };

	LCD_Blit(&Title, title);
	LCD_Blit(&Area, area);
}
