/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include <time.h>
#include "TCPIP Stack/TCPIP.h"
#include "Main.h"
#include "LCD.h"
#include "SDC.h"
#include "STK.h"
#include "GFX.h"
#include "APP.h"

#define ENABLE_COMM

#define STATE_INIT			0
#define STATE_SLEEP			1
#define STATE_IDLE			2
#define STATE_DISPLAY		3
#define STATE_CHKNET		4
#define STATE_ERASE			5
#define STATE_FORCENET		6
#define STATE_CONSOLE		7

#define SUBST_HOME			0
#define SUBST_WAITING		1
#define SUBST_REQUEST		2
#define SUBST_RESPONSE		3
#define SUBST_ANALIZE		4
#define SUBST_CONNECT		5
#define SUBST_USER			6
#define SUBST_PASS			7
#define SUBST_STAT			8
#define SUBST_CHECK			9
#define SUBST_TOP			10
#define SUBST_HEAD			11
#define SUBST_SDCON			12
#define SUBST_RETR			13
#define SUBST_BODY			14
#define SUBST_DELE			15
#define SUBST_QUIT			16
#define SUBST_COMPLETE		90
#define SUBST_ERROR			99

#define STAGE_START			0
#define STAGE_BOUND			1
#define STAGE_CONTENT		2
#define STAGE_NAME			3
#define STAGE_CRCR			4
#define STAGE_DECODE		5
#define STAGE_END			6

#define FLAG_TADJ			0x00000001UL
#define FLAG_WETH			0x00000002UL
#define FLAG_POP3			0x00000004UL
#define UPF_DATE			0x00000001UL
#define UPF_WETHER			0x00000002UL
#define UPF_PHOTO			0x00000004UL
#define FST_OPEN			0x00000001UL
#define FST_ERROR			0x10000000UL

#define DISP_NONE			0
#define DISP_CALEND			1
#define DISP_WETHER			2
#define DISP_PHOTO			3
#define DISP_COUNT			3

#define INTERVAL_CALEND		TICKS_OF(0, 0, 10)	// J_[\
#define INTERVAL_WETHER		TICKS_OF(0, 0, 30)	// VC\
#define INTERVAL_PHOTO		TICKS_OF(0, 0, 30)	// ʐ^\
#define INTERVAL_TADJ		TICKS_OF(24, 0, 0)	// XVԊu
#define INTERVAL_WETH		TICKS_OF(2, 0, 0)	// VCXVԊu
#define INTERVAL_POP3		TICKS_OF(0, 5, 0)	// [`FbNԊu
#define SOCKET_TIMEOUT		TICKS_OF(0, 0, 10)	// ʐM^CAEg

#define ADJ_JST				(9 * 60 * 60)		// {
#define IS_VALID_TIME(x)	((x) > (40UL * 365UL * 24UL * 60UL * 60UL))

#define WETH_SERVER_NAME	"tenki.jp"
#define WETH_SERVER_PORT	80
#define WETH_THR_SIZE		(10 * 1024)
#define WETH_GET_SIZE		(26 * 1024)
#define POP3_SERVER_PORT	110

#define WDT_WEEKDAY			0
#define WDT_WEEKSAT			1
#define WDT_WEEKSUN			2
#define WDT_HOLIDAY			3

#define DIR_SYS_IMAGE		"\\SYS\\IMAGES"
#define DIR_SYS_CHARS		"\\SYS\\CHARS"
#define DIR_JPG_IMAGE		"\\"
//=================================================================

static BOOL Display(void);
static BOOL Regular(void);
static BOOL TskTadj(void);
static BOOL TskWeth(void);
static BOOL TskPop3(void);

static void DispUpdating(void);
static void DispCalend(void);
static void DispWether(void);
static void DispPhoto(void);

static void LoadSetting(void);
static void CheckDateChange(void);
static BOOL CheckDispCond(void);
static BOOL CanDisp(int nDisplay);
static BOOL IsValidFile(const FILINFO* pInfo);

static void PowerSave(void);
static void PowerUp(void);

static BOOL AdjustDateTime(void);
static time_t RtccToEpoch(rtccTime Tm, rtccDate pDt);
static void EpochToRtcc(rtccTime* pTm, rtccDate* pDt, time_t tVal);

static int GetWeekdayType(struct tm* p);
static BOOL IsHolyday(struct tm* p);
static BOOL IsFurikae(struct tm* p);

static BOOL CheckSubject(void);
static BOOL GetSaveFile(void);
static void Squeeze(void);
static void NewFileName(char* pName);
static void MarkErase(void);

static BOOL Analize(void);
static const char* Find(const char* p, const char* key);
static BOOL GetNum(const char* p, char* n);
static BOOL GetTenki(const char* p, char* t, BOOL night);

//=================================================================

static char s_WethReqURL[32];
static char s_PopServer[32];
static char s_PopUser[32];
static char s_PopPass[32];
static char s_Subject[32];
static char s_Base64[128];
static char s_DispScheduleA[25];
static char s_DispScheduleB[25];
static DWORD s_dwIntervals[3];

static int s_nState;
static int s_nSubSt;

static int s_nDisplay;
static char s_LastFile[16];
static char s_NextFile[16];
static DWORD s_dwUpdates;
static DWORD s_dwNextDisp;
static DWORD s_dwNextTadj;
static DWORD s_dwNextWeth;
static DWORD s_dwNextPop3;
static DWORD s_dwFlags;
static BOOL s_fPowerSave;
static TCP_SOCKET s_Socket;
static char s_Buf[16 * 1024];
static int s_nRecv;
static BOOL s_fMark;
static BOOL s_fSW;
static int s_nStage;
static const char* s_pPos;
static char s_Boundary[64];
static int s_nBound;
static char s_SaveName[16];
static DWORD s_dwSaveStat;
static FIL s_FileObj;
static BOOL s_fErase;
static BYTE s_Back[20 * 20 *3];
static int s_nWethErr;
static int s_nMailErr;

#define TENKI_UNKNOWN		0	// s
#define TENKI_HARE			1	// ()
#define TENKI_TUKI			2	// ()
#define TENKI_KUMO			3	// ܂
#define TENKI_AMEH			4	// J
#define TENKI_AMEL			5	// J
#define TENKI_YUKK			6	// 
#define TENKI_YUKS			7	// 
#define TENKI_MIZO			8	// ݂

typedef struct _tenki_t {
	time_t tTime;
	char nTenki;
	char nKion;
	char nKosui; 
} tenki_t;
static tenki_t s_Tenki[16];

//=================================================================

// 
extern void InitAPP(void)
{
	const char* p =
		"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	int i;

	memset(s_Base64, 0, sizeof(s_Base64));
	ASSERT(strlen(p) == 64);
	for (i = 0 ; i < 64; i++, p++)
		s_Base64[(int)*p] = i;
	s_Base64['='] = 0xFF;

	s_WethReqURL[0] = '\0';
	s_PopServer[0] = '\0';
	s_PopUser[0] = '\0';
	s_PopPass[0] = '\0';
	s_Subject[0] = '\0';

	strcpy(s_DispScheduleA, "111111111111111111111111");
	strcpy(s_DispScheduleB, "111111111111111111111111");
	s_dwIntervals[0] = INTERVAL_CALEND;
	s_dwIntervals[1] = INTERVAL_WETHER;
	s_dwIntervals[2] = INTERVAL_PHOTO;

	s_nDisplay = DISP_NONE;
	s_LastFile[0] = '\0';
	s_NextFile[0] = '\0';
	s_dwUpdates = 0;
	s_dwNextDisp = 0;
	s_dwNextTadj = 0;
	s_dwNextWeth = 0;
	s_dwNextPop3 = 0;
	s_fPowerSave = FALSE;
	s_Socket = INVALID_SOCKET;
	memset(&s_FileObj, 0, sizeof(s_FileObj));
	s_dwSaveStat = 0;
	memset(s_Tenki, 0, sizeof(s_Tenki));
	s_fErase = FALSE;
	s_nWethErr = 0;
	s_nMailErr = 0;

	LoadSetting();

	s_nState = STATE_INIT;
	s_nSubSt = SUBST_HOME;
}

// ^XN
extern void TaskAPP(void)
{
	static DWORD dwTick;
	static int nIdle = 0;
	BOOL fSW;

	// Xe[g\
	static int nLast = -1;
	if (s_nState != nLast)
	{
		const char* msgs[] = {
			"TaskAPP(): STATE_INIT\r\n",
			"TaskAPP(): STATE_SLEEP\r\n",
			"TaskAPP(): STATE_IDLE\r\n",
			"TaskAPP(): STATE_DISPLAY\r\n",
			"TaskAPP(): STATE_CHKNET\r\n",
			"TaskAPP(): STATE_ERASE\r\n",
			"TaskAPP(): STATE_FORCENET\r\n",
			"TaskAPP(): STATE_CONSOLE\r\n",
		};
		LOG(msgs[s_nState]);
		nLast = s_nState;
	}

	// AChJE^
	nIdle = (s_nState == STATE_IDLE)? (nIdle + 1) : 0;

	switch (s_nState)
	{
	case STATE_INIT:
		EnableLCD();
		s_nState = STATE_IDLE;
		break;

	case STATE_SLEEP: // X[v[h
		ASSERT(!s_fPowerSave);
		ASSERT(!IsEnabledSTK());
		ASSERT(!IsEnabledSDC());
		ASSERT(!IsEnabledLCD());
		
		// \`FbN
		fSW = GetSW();
		if (!fSW && !CheckDispCond())
		{
			// X[v
			LOG("Sleep...\r\n");
			Delay(1);

			INTDisableInterrupts();
#ifdef __DEBUG
			EnableWDT();
#endif
			PowerSaveSleep();
#ifdef __DEBUG
			DisableWDT();
#endif
			INTEnableInterrupts();
			LOG("Wake up.\r\n");
		}
		else
		{
			// N
			if (fSW) Beep(400, 50);

			s_nDisplay = DISP_NONE;
			s_dwUpdates = 0;
			s_dwNextDisp = 0;
			s_dwNextTadj = 0;
			s_dwNextWeth = 0;
			s_dwNextPop3 = 0;

			EnableLCD();
			s_nState++;
		}
		break;

	case STATE_IDLE: // ACh[h
		dwTick = TickGet();

		// \XV
		CheckDateChange();
		if (s_dwUpdates != 0 || dwTick >= s_dwNextDisp)
		{
			PowerUp();
			if (IsEnabledLCD())
			{
				EnableSDC();
				s_nState = STATE_DISPLAY;
			}
			break;
		}

		// ʐM
#ifdef ENABLE_COMM
		s_dwFlags = 0;
		if (dwTick >= s_dwNextTadj) {
			s_dwFlags |= FLAG_TADJ;
		}
		if (IS_VALID_TIME(Time()))
		{
			if (dwTick >= s_dwNextWeth && s_WethReqURL[0] != '\0' && s_nWethErr < 3)
				s_dwFlags |= FLAG_WETH;
			if (dwTick >= s_dwNextPop3 && s_PopServer[0] != '\0' && s_nMailErr < 5)
				s_dwFlags |= FLAG_POP3;
		}
		if (s_dwFlags != 0)
		{
			PowerUp();
			EnableSTK();
			s_nState = STATE_CHKNET;
			s_nSubSt = SUBST_HOME;
			break;
		}
#endif
		// SW
		fSW = GetSW();
		if (fSW)
		{
			if (!s_fSW)
			{
				PowerUp();
				Beep(400, 50);
				if (s_nDisplay != DISP_PHOTO)
				{
#ifdef ENABLE_COMM
					// ʐMR\[[h
					EnableSTK();
					s_nState = STATE_FORCENET;
					s_nSubSt = SUBST_HOME;
					s_dwFlags = FLAG_TADJ | FLAG_WETH | FLAG_POP3;
#endif
				}
				else {
					// 폜}[Nؑւ
					EnableSDC();
					s_nState = STATE_ERASE;
				}
			}
			s_fSW = fSW;
			break;
		}
		s_fSW = fSW;

		// 鎖͂ȂƂ܂ŗ
		if (nIdle > 1000)
		{
			if (IsEnabledSDC())
			{
				DisableSDC();
				break;
			}
			if (IsEnabledSTK())
			{
				DisableSTK();
				break;
			}
			// p[Z[u(NbN_E)
			if (!s_fPowerSave)
			{
				if (IsDisabledSDC() && IsDisabledSTK() && !IsBusyTimer() && !IsBusyLCD())
					PowerSave();
				break;
			}
			// \`FbN
			if (!CheckDispCond())
			{
				PowerUp();
				DisableLCD();
				s_nState--;
			}
		}
		break;

	case STATE_DISPLAY: // \XV[h
		ASSERT(!s_fPowerSave);
		if (IsEnabledSDC())
		{
			if (!Display())
				s_nState = STATE_IDLE;
		}
		break;

	case STATE_ERASE: // t@C[h
		ASSERT(!s_fPowerSave);
		if (IsEnabledSDC())
		{
			MarkErase();
			s_nState = STATE_IDLE;
		}
		break;

	case STATE_CHKNET: // ʐM[h
	case STATE_FORCENET: // ʐM[h
		ASSERT(!s_fPowerSave);
		if (IsDisabledSTK())
		{
			// ʐMG[(1)
			LOG("Error: EnableSTK()\r\n");
			s_dwNextTadj += TICKS_OF(0, 1, 0); 
			s_dwNextWeth += TICKS_OF(0, 1, 0); 
			s_dwNextPop3 += TICKS_OF(0, 1, 0); 
			s_nState = STATE_IDLE;
			break;
		}
		if (IsEnabledSTK())
		{
			if (!Regular())
			{
				if (s_nState == STATE_FORCENET) 
				{
					// 3Ԑڑێ(WFConsoleg悤ɂ)
					dwTick = TickGet() + TICKS_OF(0, 3, 0);
					s_nState = STATE_CONSOLE;
				}
				else {
					s_nState = STATE_IDLE;
				}
			}
		}
		break;

	case STATE_CONSOLE: // R\[[h
		ASSERT(!s_fPowerSave);
		if (GetSW())
		{
			// SW ؒfACh ւƐ؊
			Beep(400, 50);
			//if (WFisConnected()) // ȂWFisConnected()FALSEԂ߂܂Ȃ
			//{
			//	WF_CMDisconnect();
			//	break;
			//}
		}
		else if (TickGet() < dwTick) {
			break;
		}
		s_dwNextTadj += TICKS_OF(0, 3, 0); 
		s_dwNextWeth += TICKS_OF(0, 3, 0); 
		s_dwNextPop3 += TICKS_OF(0, 3, 0); 
		s_nState = STATE_IDLE;
		break;

	default:
		ASSERT(FALSE);
		break;
	}
}

// ^XN(\XV)
static BOOL Display(void)
{
	// \e肷
	if (s_dwUpdates == 0)
	{
		// 񂪓ɍXVĂȂΎ̕\\ȏ\
		int i = (s_nDisplay == DISP_NONE)? 0 : 1; 
		int nDisplay = (s_nDisplay % DISP_COUNT) + 1;
		do {
			if (CanDisp(nDisplay)) {
				break;
			}
			nDisplay = (nDisplay % DISP_COUNT) + 1;
		} while (++i < DISP_COUNT);

		if (i == DISP_COUNT)
		{
			// ɕ\ł̂Ȃ
			if (!CanDisp(nDisplay))
			{
				// Jg\sɂȂꍇ(VCf[^ÂȂ)
				// Updating... \
				DispUpdating();
				s_nDisplay = DISP_NONE;
			}
			else {
				LOG("Display(): Current only.\r\n");
			}
			// Ƃ́Aʐ^̏ꍇȊO͏XV܂ŕ\ؑ֕sv
			if (nDisplay != DISP_PHOTO) {
				s_dwNextDisp = (DWORD)-1;
			}
			return FALSE;
		}

		// \ؑ֌
		ASSERT(nDisplay != DISP_NONE);
		s_nDisplay = nDisplay;
	}
	else
	{
		// XVꂽD悵ĕ\
		if (s_dwUpdates & UPF_PHOTO)
		{
			// D揇ʍ
			s_nDisplay = DISP_PHOTO;
		}
		else if (s_dwUpdates & UPF_DATE)
		{
			// D揇ʒ
			s_nDisplay = DISP_CALEND;
		}
		else {
			// D揇ʒ
			ASSERT(s_dwUpdates == UPF_WETHER);
			s_nDisplay = DISP_WETHER;
		}
		s_dwUpdates = 0;
	}

	// 摜
	if (s_fErase)
	{
		VERIFY(f_chdir(DIR_JPG_IMAGE) == FR_OK);
		VERIFY(f_unlink(s_LastFile) == FR_OK);
		Beep(400, 50);
		s_fErase = FALSE;
	}

	// \
	switch (s_nDisplay)
	{
	case DISP_CALEND:
		DispCalend();
		break;
	case DISP_WETHER:
		DispWether();
		break;
	case DISP_PHOTO:
		DispPhoto();
		break;
	default:
		ASSERT(FALSE);
	}

	// ̕\ؑ֎
	s_dwNextDisp = TickGet() + s_dwIntervals[s_nDisplay - 1];

	return FALSE;
}

// ^XN(ʐM)
static BOOL Regular(void)
{
	// C
	if (s_dwFlags & FLAG_TADJ)
	{
		if (!TskTadj()) {
			s_dwFlags &= ~FLAG_TADJ;
		}
		return TRUE;
	}
	// VC`FbN
	if (s_dwFlags & FLAG_WETH)
	{
		if (!TskWeth()) {
			s_dwFlags &= ~FLAG_WETH;
		}
		return TRUE;
	}
	// [`FbN
	if (s_dwFlags & FLAG_POP3)
	{
		if (!TskPop3()) {
			s_dwFlags &= ~FLAG_POP3;
		}
		return TRUE;
	}

	// I
	return FALSE;
}

// ^XN(XV)
static BOOL TskTadj(void)
{
	static DWORD dwTick;

	switch (s_nSubSt)
	{
	case SUBST_HOME:
		LOG("DateTime Adjust.\r\n");
		dwTick = TickGet() + TICKS_OF(0, 0, 3);
		s_nSubSt = SUBST_WAITING;
		break;

	case SUBST_WAITING:
		if (TickGet() >= dwTick)
		{
			s_dwNextTadj = TickGet() + INTERVAL_TADJ;
			if (!AdjustDateTime())
			{
				// G[
				LOG("Error: AdjustDateTime()\r\n");
				SetLED(500, 30);
				s_dwNextTadj = TickGet() + INTERVAL_TADJ;
			}
			// I
			s_nSubSt = SUBST_HOME;
			return FALSE;
		}
		break;

	default:
		ASSERT(FALSE);
	}

	return TRUE;
}

// ^XN(VC擾)
static BOOL TskWeth(void)
{
	static DWORD dwTick;
	WORD nSize;

	switch (s_nSubSt)
	{
	case SUBST_HOME:
		// \PbgI[v(ڑ)
		ASSERT(s_Socket == INVALID_SOCKET);
		s_Socket = TCPOpen((DWORD)WETH_SERVER_NAME, TCP_OPEN_ROM_HOST,
			WETH_SERVER_PORT, TCP_PURPOSE_GENERIC_TCP_CLIENT);
		
		if (s_Socket == INVALID_SOCKET)
			break; // \Pbgɋ󂫂o܂

		LOG("Wether Check.\r\n");
		SetLED(LED_ON, 0); // VC擾LED_͂
		dwTick = TickGet() + SOCKET_TIMEOUT;
		s_nSubSt = SUBST_REQUEST;
		break;

	case SUBST_REQUEST:
		// ڑ҂
		if (!TCPIsConnected(s_Socket))
		{
			if (TickGet() >= dwTick)
			{
				LOG("Error: SUBST_REQUEST\r\n");
				s_nSubSt = SUBST_ERROR;
			}
			break;
		}
		// NGXgM
		ASSERT(TCPIsPutReady(s_Socket) >= 64);
		TCPPutROMString(s_Socket, (BYTE*)"GET ");
		TCPPutString(s_Socket, (BYTE*)s_WethReqURL);
		TCPPutROMString(s_Socket, (BYTE*)" HTTP/1.0\r\nHost: ");
		TCPPutROMString(s_Socket, (BYTE*)WETH_SERVER_NAME);
		TCPPutROMString(s_Socket, (BYTE*)"\r\nConnection: close\r\n\r\n");
		TCPFlush(s_Socket);
		
		s_nRecv = 0;
		s_nSubSt++;
		break;

	case SUBST_RESPONSE:
		// M
		nSize = TCPIsGetReady(s_Socket);
		if (nSize == 0)
		{
			if (!TCPIsConnected(s_Socket))
			{
				LOG("Error: SUBST_RESPONSE\r\n");
				s_nSubSt = SUBST_ERROR;
			}
			break;
		}
		if (s_nRecv < WETH_THR_SIZE)
		{
			// 10KBǂݎ̂
			ASSERT(sizeof(s_Buf) >= WETH_THR_SIZE);
			if (nSize > (WETH_THR_SIZE - s_nRecv))
				nSize = WETH_THR_SIZE - s_nRecv;

			s_nRecv += nSize;
			while (nSize > 0) {
				nSize -= TCPGetArray(s_Socket, (BYTE*)s_Buf, nSize);
			}
		}
		else if (s_nRecv < WETH_GET_SIZE)
		{
			// 16KB擾
			ASSERT(sizeof(s_Buf) >= (WETH_GET_SIZE - WETH_THR_SIZE));
			if (nSize > (WETH_GET_SIZE - s_nRecv))
				nSize = WETH_GET_SIZE - s_nRecv;
			do {
				WORD nRead = TCPGetArray(s_Socket,
					(BYTE*)s_Buf + s_nRecv - WETH_THR_SIZE, nSize);
				s_nRecv += nRead;
				nSize -= nRead;
			} while (nSize > 0);
		}
		else
		{
			// 㔼͖
			s_Buf[sizeof(s_Buf) - 1] = 0;
			TCPDisconnect(s_Socket);
			s_Socket = INVALID_SOCKET;
			s_nSubSt++;
		}
		break;
		
	case SUBST_ANALIZE:
		// 
		if (!Analize()) {
			// G[
			LOG("Error: Analize()\r\n");
			SetLED(500, 30);
			s_nWethErr++;
		}
		else
		{
			LOG("Tenki analize successfull.\r\n");
			SetLED(LED_OFF, 0);
			s_nWethErr = 0;
		}
		// I
		s_dwNextWeth = TickGet() + INTERVAL_WETH; 
		s_nSubSt = SUBST_HOME;
		return FALSE;
	
	case SUBST_ERROR:
		// G[
		TCPDisconnect(s_Socket);
		s_Socket = INVALID_SOCKET;
		s_dwNextWeth = TickGet() + INTERVAL_WETH;
		s_nWethErr++;

		SetLED(500, 30);
		s_nSubSt = SUBST_HOME;
		return FALSE;

	default:
		ASSERT(FALSE);
	}

	return TRUE;
}

// ^XN([M)
static BOOL TskPop3(void)
{
	static DWORD dwTick;
	static int nNext, i;
	static char Line[64];
	static char nCount, nTop;

	WORD nSize;
	char buf[16];
	BYTE c;

	#define GETLINE_ANDNEXT(x) \
		{ s_nSubSt = SUBST_RESPONSE; nNext = (x); i = 0; }

	switch (s_nSubSt)
	{
	case SUBST_HOME:
		// \PbgI[v(ڑ)
		ASSERT(s_Socket == INVALID_SOCKET);
		s_Socket = TCPOpen((DWORD)s_PopServer, TCP_OPEN_RAM_HOST,
			POP3_SERVER_PORT, TCP_PURPOSE_GENERIC_TCP_CLIENT);
		
		if (s_Socket == INVALID_SOCKET)
			break; // \Pbgɋ󂫂o܂

		LOG("E-Mail Check.\r\n");
		dwTick = TickGet() + SOCKET_TIMEOUT;
		s_nSubSt = SUBST_CONNECT;
		break;

	case SUBST_CONNECT:
		// ڑ҂
		if (!TCPIsConnected(s_Socket))
		{
			if (TickGet() >= dwTick)
			{
				LOG("Error: SUBST_REQUEST\r\n");
				s_nSubSt = SUBST_ERROR;
			}
			break;
		}
		GETLINE_ANDNEXT(SUBST_USER);
		break;

	case SUBST_USER:
		// USER
		ASSERT(TCPIsPutReady(s_Socket) >= (strlen(s_PopUser) + 2));
		TCPPutROMString(s_Socket, (BYTE*)"USER ");
		TCPPutString(s_Socket, (BYTE*)s_PopUser);
		TCPPutROMString(s_Socket, (BYTE*)"\r\n");
		TCPFlush(s_Socket);
		GETLINE_ANDNEXT(SUBST_PASS);
		break;

	case SUBST_PASS:
		// PASS
		ASSERT(TCPIsPutReady(s_Socket) >= (strlen(s_PopPass) + 2));
		TCPPutROMString(s_Socket, (BYTE*)"PASS ");
		TCPPutString(s_Socket, (BYTE*)s_PopPass);
		TCPPutROMString(s_Socket, (BYTE*)"\r\n");
		TCPFlush(s_Socket);
		GETLINE_ANDNEXT(SUBST_STAT);
		break;

	case SUBST_STAT:
		// STAT
		ASSERT(TCPIsPutReady(s_Socket) >= 6);
		TCPPutROMString(s_Socket, "STAT\r\n");
		TCPFlush(s_Socket);
		GETLINE_ANDNEXT(SUBST_CHECK);
		break;

	case SUBST_CHECK:
		// ǌ擾
		if (!GetNum(Line + 3, &nCount))
		{
			LOG("Error: SUBST_CHECK\r\n");
			s_nSubSt = SUBST_ERROR;
			break;
		}
		nTop = 0;
		s_nSubSt++;
		break;

	case SUBST_TOP:
		if (nTop < nCount)
		{
			// TOP
			sprintf(buf, "TOP %d 0\r\n", nTop + 1);
			ASSERT(TCPIsPutReady(s_Socket) >= strlen(buf));
			TCPPutString(s_Socket, (BYTE*)buf);
			TCPFlush(s_Socket);

			SetLED(LED_ON, 0); // [MLED_͂
			s_nRecv = 0;
			GETLINE_ANDNEXT(SUBST_HEAD);
		}
		else {
			s_nSubSt = SUBST_QUIT;
		}
		break;

	case SUBST_HEAD:
		// bZ[Wwb_M
		nSize = TCPIsGetReady(s_Socket);
		if (nSize == 0)
		{
			if (!TCPIsConnected(s_Socket))
			{
				LOG("Error: SUBST_HEAD\r\n");
				s_nSubSt = SUBST_ERROR;
			}
			break;
		}
		do {
			WORD nRead = TCPGetArray(s_Socket, (BYTE*)s_Buf + s_nRecv, nSize);
			s_nRecv += nRead;
			nSize -= nRead;
		} while (nSize > 0);

		if (s_nRecv >= 5 &&
			memcmp(s_Buf + s_nRecv - 5, "\r\n.\r\n", 5) == 0)
		{
			// `FbN
			if (!CheckSubject())
			{
				// sv̏ꍇ͎̃[
				nTop++;
				s_nSubSt = SUBST_TOP;
			}
			else
			{
				Beep(550, 50);
				EnableSDC();
				s_nSubSt++;
			}
		}
		break;

	case SUBST_SDCON:
		if (IsEnabledSDC())
			s_nSubSt++;
		break;

	case SUBST_RETR:
		// RETR
		sprintf(buf, "RETR %d\r\n", nTop + 1);
		ASSERT(TCPIsPutReady(s_Socket) >= strlen(buf));
		TCPPutString(s_Socket, (BYTE*)buf);
		TCPFlush(s_Socket);

		// MJn
		ASSERT(s_dwSaveStat == 0);
		s_nRecv = 0;
		s_fMark = FALSE;
		s_pPos = s_Buf;
		s_nStage = STAGE_START;
		GETLINE_ANDNEXT(SUBST_BODY);
		break;

	case SUBST_BODY:
		// {̎M
		nSize = TCPIsGetReady(s_Socket);
		if (s_nRecv == 0 && nSize == 0)
		{
			if (!TCPIsConnected(s_Socket))
			{
				LOG("Error: SUBST_BODY\r\n");
				if (s_dwSaveStat != 0)
				{
					VERIFY(f_close(&s_FileObj) == FR_OK);
					VERIFY(f_unlink(s_SaveName) == FR_OK);
					s_dwSaveStat = 0;
				}
				s_nSubSt = SUBST_ERROR;
			}
			break;
		}
		if ((s_nRecv + nSize) > (sizeof(s_Buf) - 1))
			nSize = sizeof(s_Buf) - 1 - s_nRecv;
		while (nSize > 0)
		{
			WORD nRead = TCPGetArray(s_Socket, (BYTE*)s_Buf + s_nRecv, nSize);
			s_nRecv += nRead;
			nSize -= nRead;
		}
		s_Buf[s_nRecv] = '\0';

		// Ytt@C̎擾ƕۑ
		if (GetSaveFile())
			s_nSubSt++;
		break;

	case SUBST_DELE:
		// DELE
		sprintf(buf, "DELE %d\r\n", nTop + 1);
		ASSERT(TCPIsPutReady(s_Socket) >= strlen(buf));
		TCPPutString(s_Socket, (BYTE*)buf);
		TCPFlush(s_Socket);

		nTop++; // ̃[
		s_nSubSt = SUBST_TOP;
		break;

	case SUBST_QUIT:
		// QUIT
		ASSERT(TCPIsPutReady(s_Socket) >= 6);
		TCPPutROMString(s_Socket, "QUIT\r\n");
		TCPFlush(s_Socket);
		GETLINE_ANDNEXT(SUBST_COMPLETE);
		break;

	case SUBST_RESPONSE:
		// M(1s擾)
		for(;;)
		{
			if (!TCPGet(s_Socket, &c))
			{
				if (!TCPIsConnected(s_Socket))
				{
					LOG("Error: SUBST_RESPONSE\r\n");
					s_nSubSt = SUBST_ERROR;
				}
				break;
			}
			Line[i++] = c;
			if (c == '\n')
			{
				ASSERT(i < (sizeof(Line) - 1));
				Line[i] = '\0';
				LOG(Line);
				s_nSubSt = (Line[0] == '+')? nNext : SUBST_ERROR;
				break;
			}
		}
		break;

	case SUBST_COMPLETE:
		// I
		TCPDisconnect(s_Socket);
		s_Socket = INVALID_SOCKET;
		s_dwNextPop3 = TickGet() + INTERVAL_POP3;
		s_nMailErr = 0;

		SetLED(LED_OFF, 0);
		s_nSubSt = SUBST_HOME;
		return FALSE;

	case SUBST_ERROR:
		// G[
		TCPDisconnect(s_Socket);
		s_Socket = INVALID_SOCKET;
		s_dwNextPop3 = TickGet() + INTERVAL_POP3;
		s_nMailErr++;

		SetLED(500, 30);
		s_nSubSt = SUBST_HOME;
		return FALSE;

	default:
		ASSERT(FALSE);
	}

	return TRUE;
}

//=================================================================

// XV\
static void DispUpdating(void)
{
	rect_t rc;

	LOG("DispUpdating()\r\n");
	VERIFY(f_chdir(DIR_SYS_IMAGE) == FR_OK);

	// \
	FillLCD(NULL, 0x00BE9270);

	rc.w = 172; rc.h = 48;
	rc.x = (LCD_CX - rc.w) / 2;
	rc.y = (LCD_CY - rc.h) / 2;
	DrawGif("UPDATE.gif", &rc);
}

// J_[\
static void DispCalend(void)
{
	static COLOR Cols[] = {
		COL_BLACK, // 
		0x0600000, // yj
		0x0000060, // j,U֋x
		0x0006000  // j
	};
	time_t tt;
	struct tm Tm, Tp;
	char fname[16];
	COLOR col;
	int n;

	LOG("DispCalend()\r\n");

	tt = Time();
	Tm = Tp = *gmtime(&tt);
	Tm.tm_year += 1900;
	Tm.tm_mon++;

	// wi
	VERIFY(f_chdir(DIR_SYS_IMAGE) == FR_OK);
	sprintf(fname, "CALBK%d.gif", (Tm.tm_mon % 12) / 3);
	DrawGif(fname, NULL);

	// 
	VERIFY(f_chdir(DIR_SYS_CHARS) == FR_OK);
	DrawChar("F48N.chr", 303 + 49 * 0, 12, (BYTE)(Tm.tm_year / 1000), COL_BLACK);
	DrawChar("F48N.chr", 303 + 49 * 1, 12, (BYTE)((Tm.tm_year % 1000) / 100), COL_BLACK);
	DrawChar("F48N.chr", 303 + 49 * 2, 12, (BYTE)((Tm.tm_year % 100) / 10), COL_BLACK);
	DrawChar("F48N.chr", 303 + 49 * 3, 12, (BYTE)(Tm.tm_year % 10), COL_BLACK);

	// a
	DrawChar("Part1.chr", 530, 10, 0, COL_BLACK); 
	n = (Tm.tm_year % 100) + 12;
	DrawChar("F48N.chr", 656 + 49 * 0, 12, (BYTE)(n / 10), COL_BLACK);
	DrawChar("F48N.chr", 656 + 49 * 1, 12, (BYTE)(n % 10), COL_BLACK);

	// 
	if (Tm.tm_mon >= 10)
		DrawChar("F72N.chr", 9 + 72 * 0, 41, 1, COL_BLACK);
	DrawChar("F72N.chr", 9 + 72 * 1, 41, (BYTE)(Tm.tm_mon % 10), COL_BLACK);
	DrawChar("Part2.chr", 108, 103, 0, COL_BLACK); 

	// 
	col = Cols[GetWeekdayType(&Tp)];
	if (Tm.tm_mday >= 10)
	{
		DrawChar("F230N.chr", 182 + 221 * 0, 166, (BYTE)(Tm.tm_mday / 10), col);
		DrawChar("F230N.chr", 182 + 221 * 1, 166, (BYTE)(Tm.tm_mday % 10), col);
	}
	else {
		DrawChar("F230N.chr", 292, 166, (BYTE)(Tm.tm_mday % 10), col);
	}

	// j
	DrawChar("F72W.chr", 650, 374, (BYTE)Tm.tm_wday, COL_BLACK);
}

// VC\\
static void DispWether(void)
{
	time_t tt;
	struct tm *ptm;
	const tenki_t *s, *p;
	char fname[16];
	rect_t rc;
	int i, j;

	LOG("DispWether()\r\n");
	VERIFY(f_chdir(DIR_SYS_IMAGE) == FR_OK);

	// \Jnf[^
	tt = Time();
	ptm = gmtime(&tt);
	ptm->tm_hour = (ptm->tm_hour / 3) * 3;
	ptm->tm_min = ptm->tm_sec = 0;
	tt = mktime(ptm);
	for (j = 0; j < 8; j++)
	{
		if (s_Tenki[j].tTime >= tt)
			break;
	}
	s = s_Tenki + j;

	// wi
	DrawGif("TENKIBK.gif", NULL);

	// 
	rc.w = 50; rc.h = 28;
	for (i = 0; i < 8; i++)
	{
		rc.x = 200 * (i % 4) + 74;
		rc.y = 239 * (i / 4) + 8;

		sprintf(fname, "TITLE%d.bmp", ((i + j) % 8) * 3);
		DrawBmp(fname, &rc);
	}

	// VC
	rc.w = 132; rc.h = 120;
	for (i = 0, p = s; i < 8; i++, p++)
	{
		rc.x = 200 * (i % 4) + 34;
		rc.y = 239 * (i / 4) + 56;
		
		sprintf(fname, "TENKI%d.gif", p->nTenki);
		DrawGif(fname, &rc);
	}

	// C
	rc.w = 24; rc.h = 32;
	for (i = 0, p = s; i < 8; i++, p++)
	{
		rc.x = 200 * (i % 4) + 74;
		rc.y = 239 * (i / 4) + 192;
		
		sprintf(fname, "N%d.bmp", p->nKion % 10);
		DrawBmp(fname, &rc);

		if (p->nKion >= 10)
		{
			rc.x -= rc.w;
			sprintf(fname, "N%d.bmp", p->nKion / 10);
			DrawBmp(fname, &rc);
		}
	}

	// ~
	rc.w = 33; rc.h = 70;
	for (i = 0, p = s; i < 8; i++, p++)
	{
		rc.x = 200 * (i % 4) + 159;
		rc.y = 239 * (i / 4) + 158;
		
		sprintf(fname, "KOSUI%d.bmp", p->nKosui);
		DrawBmp(fname, &rc);
	}
}

// tHg\
static void DispPhoto(void)
{
	DIR dir;
	const char* pFile = NULL;
	FILINFO Info;
	int i;

	LOG("DispPhoto()\r\n");
	VERIFY(f_chdir(DIR_JPG_IMAGE) == FR_OK);

	// \t@Č
	if (f_opendir(&dir, DIR_JPG_IMAGE) == FR_OK)
	{
		// Jnt@Cʒu܂Ői߂
		BOOL fNext = (s_NextFile[0] == '\0');
		const char* pBase = (s_NextFile[0] != '\0')? s_NextFile : s_LastFile;
		if (pBase[0] != '\0')
		{
			for(;;)
			{
				if (f_readdir(&dir, &Info) != FR_OK)
				{
					fNext = TRUE;
					break;
				}
				if (Info.fname[0] == '\0')
				{
					f_readdir(&dir, NULL);
					fNext = TRUE;
					break;
				}
				if (strcmp(Info.fname, pBase) == 0)
					break;
			}
		}
		if (fNext)
		{
			// t@Cʒu֐i߂
			for(i = 0;;)
			{
				if (f_readdir(&dir, &Info) != FR_OK)
					break;
				
				if (Info.fname[0] == '\0')
				{
					// GhXĐ
					if (i > 0)
					{
						// t@C͉œhԂ
						// CanDisp()Ń`FbNĂ̂œrŃt@C铙
						// Ȃ肱͒ʂȂ
						ASSERT(FALSE);
						FillLCD(NULL, COL_YELLOW);
						return;
					}
					if (f_readdir(&dir, NULL) != FR_OK)
						break;
					i++;
					continue;
				}

				// `FbN
				if ((Info.fattrib & (AM_HID | AM_SYS | AM_DIR)) != 0)
					continue;
				if (!IsValidFile(&Info))
					continue;

				pFile = Info.fname;
				break;
			}
		}
		else {
			pFile = Info.fname;
		}
	}
	// t@CVXeُ펞͉œhԂ
	if (pFile == NULL)
	{
		FillLCD(NULL, COL_YELLOW);
		return;
	}

	// \
	DrawJpg(pFile, NULL);

	strcpy(s_LastFile, pFile);
	s_NextFile[0] = '\0';
}

//=================================================================
// ݒ胍[h
static void LoadSetting(void)
{
	setting_t Setting;
	ASSERT(IsEnabledSDC());

	// ݒt@CI[v
	if (!OpenSettings(&Setting))
	{
	    LOG("LoadSetting() - OpenSettings error\r\n");
		return;
	}

	// Display schedule
	if (ReadSettingStr(&Setting, "DispScheduleA")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_DispScheduleA));
		strcpy(s_DispScheduleA, Setting.Str);
	}
	if (ReadSettingStr(&Setting, "DispScheduleB")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_DispScheduleB));
		strcpy(s_DispScheduleB, Setting.Str);
	}
	// Calender display interval
	if (ReadSettingNum(&Setting, "CalenderDisp")) {
		s_dwIntervals[DISP_CALEND - 1] = TICKS_OF(0, 0, Setting.Num);
	}
	// Weather display interval
	if (ReadSettingNum(&Setting, "WeatherDisp")) {
		s_dwIntervals[DISP_WETHER - 1] = TICKS_OF(0, 0, Setting.Num);
	}
	// Photo display interval
	if (ReadSettingNum(&Setting, "PhotoDisp")) {
		s_dwIntervals[DISP_PHOTO - 1] = TICKS_OF(0, 0, Setting.Num);
	}
	// Weather Request URL to tenki.jp
	if (ReadSettingStr(&Setting, "WeatherRequest")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_WethReqURL));
		strcpy(s_WethReqURL, Setting.Str);
	}
	// POP3 Server
	if (ReadSettingStr(&Setting, "POP3Server")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_PopServer));
		strcpy(s_PopServer, Setting.Str);
	}
	// POP3 User
	if (ReadSettingStr(&Setting, "POP3User")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_PopUser));
		strcpy(s_PopUser, Setting.Str);
	}
	// POP3 Pass
	if (ReadSettingStr(&Setting, "POP3Pass")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_PopPass));
		strcpy(s_PopPass, Setting.Str);
	}
	// Subject to accept
	if (ReadSettingStr(&Setting, "Subject")) {
		ASSERT(strlen(Setting.Str) < sizeof(s_Subject));
		strcpy(s_Subject, Setting.Str);
	}

	// ݓ(YYYY/MM/DD HH:MM:SS)
	if (ReadSettingStr(&Setting, "DateTime"))
	{
		char buf[64];
		struct tm t;
		rtccDate Dt;
		rtccTime Tm;

		ASSERT(strlen(Setting.Str) == 19);
		strcpy(buf, Setting.Str);

		buf[4] = '\0';
		t.tm_year = (BYTE)(atoi(buf) - 1900);
		buf[7] = '\0';
		t.tm_mon = (BYTE)(atoi(buf + 5) - 1);
		buf[10] = '\0';
		t.tm_mday = (BYTE)atoi(buf + 8);

		buf[13] = '\0';
		t.tm_hour = (BYTE)atoi(buf + 11);
		buf[16] = '\0';
		t.tm_min = (BYTE)atoi(buf + 14);
		buf[19] = '\0';
		t.tm_sec = (BYTE)atoi(buf + 17);

		t.tm_wday = 0;
		t.tm_yday = 0;
		t.tm_isdst = -1;
		
		EpochToRtcc(&Tm, &Dt, mktime(&t));
		RtccSetTimeDate(Tm.l, Dt.l);

		sprintf(buf, "RTCC time updated by Setting [20%d%d/%d%d/%d%d %d%d:%d%d:%d%d]\r\n",
			Dt.year >> 4, Dt.year & 0x0F, Dt.mon >> 4, Dt.mon & 0x0F, Dt.mday >> 4, Dt.mday & 0x0F,
			Tm.hour >> 4, Tm.hour & 0x0F, Tm.min >> 4, Tm.min & 0x0F, Tm.sec >> 4, Tm.sec & 0x0F);
		LOG(buf);
	}

	// ݒt@CN[Y
	CloseSettings(&Setting);
}

// tXVꂽǂׂ
static void CheckDateChange(void)
{
	static int nLastDay = -1;
	int nTemp = -1;

	if (IS_VALID_TIME(Time()))
	{
		time_t t = Time();
		struct tm* p = gmtime(&t);
		nTemp = p->tm_mday;
	}
	if (nTemp != nLastDay)
	{
		s_dwUpdates |= UPF_DATE;
		nLastDay = nTemp;

		s_nWethErr = 0;
		s_nMailErr = 0;
	}
}

// \\ǂׂ
static BOOL CanDisp(int nDisplay)
{
	time_t tt;
	struct tm Tm;
	DIR dir;

	switch (nDisplay)
	{
	case DISP_CALEND:
		// 擾oĂȂ͕\s
		return IS_VALID_TIME(Time());

	case DISP_WETHER:

		tt = Time();
		Tm = *gmtime(&tt);
		Tm.tm_hour = (Tm.tm_hour / 3) * 3;
		Tm.tm_min = 0;
		Tm.tm_sec = 0;
		Tm.tm_wday = 0;
		Tm.tm_yday = 0;
		Tm.tm_isdst = -1;
		tt = mktime(&Tm);

		// f[^(tTime==0)AÂ͕\s
		return (s_Tenki[15].tTime >= (tt + 3600 * 21));

	case DISP_PHOTO:
		VERIFY(f_chdir(DIR_JPG_IMAGE) == FR_OK);
		if (f_opendir(&dir, "\\") == FR_OK)
		{
			// LJPEGt@Cȏ゠鎞\\.
			for(;;)
			{
				FILINFO info;
				if (f_readdir(&dir, &info) != FR_OK)
					break;
				if (info.fname[0] == '\0')
					break;
				if ((info.fattrib & (AM_HID | AM_SYS | AM_DIR)) != 0)
					continue;
				if (!IsValidFile(&info))
					continue;
				return TRUE;
			}
		}
		break;

	default:
		ASSERT(FALSE);
	}

	return FALSE;
}

// \`FbN
static BOOL CheckDispCond(void)
{
#ifndef __DEBUG
	// 邳`FbN
	if (GetCDS())
	{
		struct tm Tm;
		time_t tt = Time();
		if (!IS_VALID_TIME(tt))
			return TRUE;

		// XPW[`FbN
		Tm = *gmtime(&tt);
		return (GetWeekdayType(&Tm) == WDT_WEEKDAY)?
			(s_DispScheduleA[Tm.tm_hour] != '0') : (s_DispScheduleB[Tm.tm_hour] != '0');
	}

	return FALSE;
#else
	return TRUE;
#endif
}

// Lȃt@C`FbN
static BOOL IsValidFile(const FILINFO* pInfo)
{
	const char* p;

	// Lȃt@C`FbN
	if (pInfo->fsize < 256)
		return FALSE;

	// gq".JPG"̂
	for (p = pInfo->fname; *p != '.'; p++) {
		if (*p == '\0')
			return FALSE;
	}
	if (*(++p) != 'J' && *p != 'j') return FALSE;
	if (*(++p) != 'P' && *p != 'p') return FALSE;
	if (*(++p) != 'G' && *p != 'g') return FALSE;
	if (*(++p) != '\0') return FALSE;

	return TRUE;
}

// p[Z[u
static void PowerSave(void)
{
	if (!s_fPowerSave)
	{
		// SOSC(32.768KHz)
		LOG("Power saving. (SYSCLK = SOSC(32.768KHz)\r\n");
		while(BusyUART1());

		OSCConfig(OSC_SOSC, OSC_PLL_MULT_20, OSC_PLL_POST_1, OSC_FRC_POST_1);
		s_fPowerSave = TRUE;
	}
}

// p[Abv
static void PowerUp(void)
{
	if (s_fPowerSave)
	{
		// ʏ80MHz
		OSCConfig(OSC_POSC_PLL, OSC_PLL_MULT_20, OSC_PLL_POST_1, OSC_FRC_POST_1);
		Delay(10);

		LOG("Power up.(SYSCLK = 80MHz)\r\n");
		s_fPowerSave = FALSE;
	}
}

// C
static BOOL AdjustDateTime(void)
{
	// NPTT[o[擾擾
	DWORD dwNPT = SNTPGetUTCSeconds() + ADJ_JST;
	if (IS_VALID_TIME(dwNPT))
	{
		rtccDate Dt;
		rtccTime Tm;

		// RTCC擾
		ASSERT(RtccGetClkStat() == RTCC_CLK_ON);
		RtccGetTimeDate(&Tm, &Dt);

		// 덷2bȏ゠ꍇɂ̂ݍZ
		if ((dwNPT - RtccToEpoch(Tm, Dt)) > 1)
		{
			char buf[64];
			EpochToRtcc(&Tm, &Dt, dwNPT);
			RtccSetTimeDate(Tm.l, Dt.l);

			sprintf(buf, "RTCC time updated by SNPT [20%d%d/%d%d/%d%d %d%d:%d%d:%d%d]\r\n",
				Dt.year >> 4, Dt.year & 0x0F, Dt.mon >> 4, Dt.mon & 0x0F, Dt.mday >> 4, Dt.mday & 0x0F,
				Tm.hour >> 4, Tm.hour & 0x0F, Tm.min >> 4, Tm.min & 0x0F, Tm.sec >> 4, Tm.sec & 0x0F);
			LOG(buf);
		}
		return TRUE;
	}
	return FALSE;
}

// RTCCtH[}bgG|bN`֕ϊ
static time_t RtccToEpoch(rtccTime Tm, rtccDate Dt)
{
	struct tm t;

	t.tm_sec = ((Tm.sec >> 4) * 10) + (Tm.sec & 0xF);
	t.tm_min = ((Tm.min >> 4) * 10) + (Tm.min & 0xF);
	t.tm_hour = ((Tm.hour >> 4) * 10) + (Tm.hour & 0xF);
	t.tm_mday = ((Dt.mday >> 4) * 10) + (Dt.mday & 0xF);
	t.tm_mon = ((Dt.mon >> 4) * 10) + (Dt.mon & 0xF) - 1;
	t.tm_year = ((Dt.year >> 4) * 10) + (Dt.year & 0xF) + 2000 - 1900;
	t.tm_wday = 0;
	t.tm_yday = 0;
	t.tm_isdst = -1;

	return (DWORD)mktime(&t);
}

// G|bN`RTCCtH[}bg֕ϊ
static void EpochToRtcc(rtccTime* pTm, rtccDate* pDt, time_t tVal)
{
	struct tm* p = gmtime(&tVal);

	p->tm_year += 1900 - 2000;
	p->tm_mon++;

	pDt->year = ((p->tm_year / 10) << 4) + (p->tm_year % 10);
	pDt->mon = ((p->tm_mon / 10) << 4) + (p->tm_mon % 10);
	pDt->mday = ((p->tm_mday / 10) << 4) + (p->tm_mday % 10);
	pDt->wday = p->tm_wday;
	pTm->hour = ((p->tm_hour / 10) << 4) + (p->tm_hour % 10);
	pTm->min = ((p->tm_min / 10) << 4) + (p->tm_min % 10);
	pTm->sec = ((p->tm_sec / 10) << 4) + (p->tm_sec % 10);
}

// j^Cv̎擾
static int GetWeekdayType(struct tm* p)
{
	// j
	if (IsHolyday(p))
		return WDT_HOLIDAY;
	// U֋x
	if (IsFurikae(p))
		return WDT_WEEKSUN;
	// j
	if (p->tm_wday == 0) 
		return WDT_WEEKSUN;
	// yj
	if (p->tm_wday == 6) 
		return WDT_WEEKSAT;
	// 
	return WDT_WEEKDAY;
}

// jǂ𒲂ׂ
static BOOL IsHolyday(struct tm* p)
{
	//yt/Hz
	// 2010N 321()  923()
	// 2011N 321()  923()
	// 2012N 320()  922(y)
	// 2013N 320()  923()
	// 2014N 321()  923()
	// 2015N 321(y)  923()
	// 2016N 320()  922()
	// 2017N 320()  923(y)
	// 2018N 321()  923()
	// 2019N 321()  923()
	// 2020N 320()  922()
	// 2021N 320(y)  923()
	// 2022N 321()  923()
	// 2023N 321()  923(y)
	// 2024N 320()  922()
	// 2025N 320()  923()
	// 2026N 320()  923()
	// 2027N 321()  923()
	// 2028N 320()  922()
	// 2029N 320()  923()
	// 2030N 320()  923()
	static int syun[] = {
		21, 21, 20, 20, 21, 21, 20, 20, 21, 21,
		20, 20, 21, 21, 20, 20, 20, 21, 20, 20, 20
	};
	static int Syuu[] = {
		23, 23, 22, 23, 23, 23, 22, 23, 23, 23,
		22, 23, 23, 23, 22, 23, 23, 23, 22, 23, 23
	};
	//y{̋xz
	switch (p->tm_mon + 1)
	{
	case 1:
		// F1/1
		if (p->tm_mday == 1)
			return TRUE;
		// l̓F12j
		if (p->tm_wday == 1 && ((p->tm_mday - 1) / 7) == 1)
			return TRUE;
		break;
	case 2:
		// LO̓F2/11
		if (p->tm_mday == 11)
			return TRUE;
		break;
	case 3:
		// t̓Ft
		if (p->tm_mday == syun[p->tm_year - 110])
			return TRUE;
		break;
	case 4:
		// a̓F4/29
		if (p->tm_mday == 29)
			return TRUE;
		break;
	case 5:
		// @LO	F5/3
		// ݂ǂ̓F5/4
		// ǂ̓F5/5
		if (3 <= p->tm_mday && p->tm_mday <= 5)
			return TRUE;
		break;
	case 6:
		break;
	case 7:
		// C̓F73j
		if (p->tm_wday == 1 && ((p->tm_mday - 1) / 7) == 2)
			return TRUE;
		break;
	case 8:
		break;
	case 9:
		// hV̓F93j
		if (p->tm_wday == 1 && ((p->tm_mday - 1) / 7) == 2)
			return TRUE;
		// ̋x	F́uH̓vj
		if (p->tm_wday == 2 && (p->tm_mday + 1) == Syuu[p->tm_year - 110])
			return TRUE;
		// H̓FH
		if (p->tm_mday == Syuu[p->tm_year - 110])
			return TRUE;
		break;
	case 10:
		// ̈̓F102j
		if (p->tm_wday == 1 && ((p->tm_mday - 1) / 7) == 1)
			return TRUE;
		break;
	case 11:
		// ̓F11/3
		if (p->tm_mday == 3)
			return TRUE;
		// ΘJӂ̓F11/23
		if (p->tm_mday == 23)
			return TRUE;
		break;
	case 12:
		// VcaF12/23
		if (p->tm_mday == 23)
			return TRUE;
		break;
	}

	return FALSE;
}

// U֓ǂ𒲂ׂ
static BOOL IsFurikae(struct tm* p)
{
	// j͐U֓łȂ
	if (p->tm_wday != 0)
	{
		// ̏T̓jjȂ
		time_t tt = mktime(p) - p->tm_wday * 86400;
		if (IsHolyday(gmtime(&tt)))
		{
			// ł߂jU֓
			struct tm* ptm;
			do {
				tt += 86400;
				ptm = gmtime(&tt);
			}
			while (IsHolyday(ptm));
			
			if (ptm->tm_wday == p->tm_wday)
				return TRUE;
		}
	}

	return FALSE;
}

// time()֐
time_t Time (void)
{
	rtccDate Dt;
	rtccTime Tm;

	ASSERT(RtccGetClkStat() == RTCC_CLK_ON);
	RtccGetTimeDate(&Tm, &Dt);

	return RtccToEpoch(Tm, Dt);
}

// `FbN
static BOOL CheckSubject(void)
{
	if (s_Subject[0] != '\0')
	{
		const char *p, *e;
		int nLen;

		// ʒu̎擾
		p = Find(s_Buf, "\r\nSubject: ");
		if (p == NULL)
			return FALSE;
		e = Find(p, "\r\n");
		if (e == NULL)
			return FALSE;

		// r
		nLen = e - p - 2;
		if (nLen != strlen(s_Subject) || memcmp(p, s_Subject, nLen) != 0)
		{
			LOG("CheckSubject() : Unmatch.\r\n");
			return FALSE;
		}
	}
	return TRUE;
}

// Ytt@C擾ۑ
static BOOL GetSaveFile(void)
{
	static BYTE Out[SECTOR_SIZE + 2];
	static UINT nCount;
	const char *p, *e, *s;

	switch (s_nStage)
	{
	case STAGE_START:
		// Content-Type: multipart/mixed; boundary
		for (e = s_Buf + s_nRecv;; s_pPos = p + 1)
		{
			// 1smF
			for (p = s_pPos ; p < e && *p != '\n'; p++);
			if (p >= e) {
				break;
			}
			// Content-TypemF
			if (memcmp(s_pPos, "Content-Type:", 13) == 0)
			{
				*((char*)(p - 1)) = '\0';
				LOG(s_pPos); LOG("\r\n");

				s = Find(s_pPos + 13, "multipart/mixed;");
				if (s == NULL)
				{
					LOG("GetSaveFile(): Not suported\n");
					return TRUE;
				}
				// boundary擾
				s = Find(s, "boundary=\"");
				if (s == NULL)
				{
					LOG("GetSaveFile(): Format error\n");
					return TRUE;
				}
				e = Find(s, "\"");
				if (e == NULL)
				{
					LOG("GetSaveFile(): Format error\n");
					return TRUE;
				}
				s_nBound = e - s - 1;
				if (s_nBound <= 0)
				{
					LOG("GetSaveFile(): Format error\n");
					return TRUE;
				}
				memcpy(s_Boundary + 2, s, s_nBound);
				s_nBound += 2;
				s_Boundary[0] = '-';
				s_Boundary[1] = '-';
				s_Boundary[s_nBound] = '\0';

				s_pPos = p + 1;
				s_nStage++;
				break;
			}
		}
		break;

	case STAGE_BOUND:
		// boundary;
		for (e = s_Buf + s_nRecv;; s_pPos = p + 1)
		{
			// 1smF
			for (p = s_pPos ; p < e && *p != '\n'; p++);
			if (p >= e)
			{
				Squeeze();
				break;
			}
			// boundarymF
			if (memcmp(s_pPos, s_Boundary, s_nBound) == 0)
			{
				if (s_pPos[s_nBound] != '\r')
				{
					ASSERT(s_pPos[s_nBound] == '-');
					s_nStage = STAGE_END;
				}
				else {
					s_nStage++;
				}
				s_pPos = p + 1;
				Squeeze();
				break;
			}
		}
		break;

	case STAGE_CONTENT:
		// Content-Type: image/jpeg;
		for (e = s_Buf + s_nRecv;; s_pPos = p + 1)
		{
			// 1smF
			for (p = s_pPos ; p < e && *p != '\n'; p++);
			if (p >= e) {
				break;
			}
			// Content-TypemF
			if (memcmp(s_pPos, "Content-Type:", 13) == 0)
			{
				*((char*)(p - 1)) = '\0';
				LOG(s_pPos); LOG("\r\n");
				if (Find(s_pPos + 13, "image/jpeg;") != NULL)
				{
					// fȃ[[̏ꍇ
					s_pPos = p + 1;
					s_nStage = STAGE_CRCR;
					break;
				}
				s = Find(s_pPos + 13, "application/octet-stream;");
				s_pPos = p + 1;
				if (s != NULL)
				{
					// 蔲ȃ[[̏ꍇ
					s = Find(s, "name=\"");
					if (s != NULL)
					{
						if (Find(s, ".jpg\"") != NULL || Find(s, ".JPG\"") != NULL)
						{
							s_nStage = STAGE_CRCR;
							break;
						}
					}
					else
					{
						// s`FbN
						s_nStage = STAGE_NAME;
						break;
					}
				}
				// ̓Ytt@C
				s_nStage = STAGE_BOUND;
				break;
			}
		}
		break;

	case STAGE_NAME:
		// 1smF
		for (p = s_pPos, e = s_Buf + s_nRecv; p < e && *p != '\n'; p++);
		if (p >= e) {
			break;
		}
		s = Find(s_pPos, "name=\"");
		s_pPos = p + 1;
		if (s != NULL)
		{
			if (Find(s, ".jpg\"") != NULL || Find(s, ".JPG\"") != NULL)
			{
				s_nStage = STAGE_CRCR;
				break;
			}
		}
		s_nStage = STAGE_BOUND;
		break;

	case STAGE_CRCR:
		p = Find(s_pPos, "\r\n\r\n");
		if (p != NULL)
		{
			s_pPos = p;
			NewFileName(s_SaveName);
			LOG("Start Base64 decode and file save -> ");
			LOG(s_SaveName); LOG("\r\n");

			ASSERT(s_dwSaveStat == 0);
			VERIFY(f_chdir(DIR_JPG_IMAGE) == FR_OK);
			if (f_open(&s_FileObj, s_SaveName, FA_CREATE_ALWAYS | FA_WRITE) != FR_OK)
			{
				LOG("Error: f_open(FA_WRITE)\r\n");
				s_nStage = STAGE_END;
				break;
			}
			s_dwSaveStat = FST_OPEN;
			nCount = 0;
			s_nStage++;
		}
		break;

	case STAGE_DECODE:
		p = s_pPos;
		e = s_Buf + s_nRecv;
		while (p < e)
		{
			BYTE i1, i2, i3, i4;
			if (*p == '\r')
			{
				p += 2;
				if (p >= e)
					break;

				if (*p == '\r')
				{
					p += 2;
					if (p >= e)
						break;

					// fR[hI
					LOG(" Complete.\r\n");
					Beep(400, 50);
					ASSERT(*(p - 1) == '\n');
					s_pPos = p;
					if (nCount > 0)
					{
						UINT cb;
						if (f_write(&s_FileObj, Out, nCount, &cb) == FR_OK && cb == nCount)
						{
							// ۑ
							s_dwUpdates |= UPF_PHOTO;
							if (!s_fMark && s_NextFile[0] == '\0')
								strcpy(s_NextFile, s_SaveName);
							s_fMark = TRUE;
						}
						else
						{
							LOG("Error: f_write()\r\n");
							s_dwSaveStat |= FST_ERROR;
						}
					}
					VERIFY(f_close(&s_FileObj) == FR_OK);
					if (s_dwSaveStat & FST_ERROR)
					{
						VERIFY(f_unlink(s_LastFile) == FR_OK);
						s_nStage = STAGE_END;
					}
					else {
						s_nStage = STAGE_BOUND;
					}
					s_dwSaveStat = 0;
					break;
				}
				s_pPos = p;
			}

			// 4Byte擾
			i1 = s_Base64[(int)p[0]];
			i2 = s_Base64[(int)p[1]];
			i3 = s_Base64[(int)p[2]];
			i4 = s_Base64[(int)p[3]];
			p += 4;
			if (p > e)
				break;
			s_pPos = p;

			// 4Byte3Byte
			Out[nCount++] = (i1 & 0x3F) << 2 | (i2 & 0x30) >> 4;
			if (i4 != 0xFF)
			{
				Out[nCount++] = (i2 & 0x0F) << 4 | (i3 & 0x3C) >> 2;
				Out[nCount++] = (i3 & 0x03) << 6 | (i4 & 0x3F) >> 0;
			}
			else if (i3 != 0xFF) {
				Out[nCount++] = (i2 & 0x0F) << 4 | (i3 & 0x3C) >> 2;
			}
			// t@Co
			if (nCount >= SECTOR_SIZE)
			{
				UINT cb;
				if (f_write(&s_FileObj, Out, SECTOR_SIZE, &cb) != FR_OK || cb != SECTOR_SIZE)
				{
					LOG("Error: f_write()\r\n");
					s_dwSaveStat |= FST_ERROR;
					break;
				}
				nCount -= SECTOR_SIZE;
				if (nCount > 0)
				{
					Out[0] = Out[SECTOR_SIZE + 0];
					if (nCount > 1)
						Out[1] = Out[SECTOR_SIZE + 1];
				}
				if ((s_FileObj.fsize % 4096) == 0) {
					LOG(".");
				}
			}
		}
		Squeeze();
		break;

	case STAGE_END:
		// I
		for (e = s_Buf + s_nRecv;; s_pPos = p + 1)
		{
			// 1smF
			for (p = s_pPos ; p < e && *p != '\n'; p++);
			if (p >= e)
			{
				Squeeze();
				break;
			}
			// .mF
			if (memcmp(s_pPos, ".\r\n", 3) == 0)
			{
				LOG("GetSaveFile(): STAGE_END\r\n");
				ASSERT((s_pPos + 3) == e);
				return TRUE;
			}
		}
		break;
	}
	
	ASSERT(s_pPos <= (s_Buf + s_nRecv));
	return FALSE;
}

// M̈mۂ
static void Squeeze(void)
{
	int nSize = s_pPos - s_Buf;
	ASSERT(s_nRecv >= nSize);
	if (nSize >= 1024)
	{
		// sv̈j
		int nMove = s_nRecv - nSize;
		memmove(s_Buf, s_pPos, nMove + 1);
		s_pPos = s_Buf;
		s_nRecv = nMove;
		ASSERT(s_pPos[s_nRecv] == '\0');
	}
}

// Vt@C̎擾
static void NewFileName(char* pName)
{
	DWORD dwTick;
	ASSERT(IsEnabledSDC());
	for(dwTick = TickGet();; dwTick++)
	{
		FILINFO info;
		sprintf(pName, "%08X.JPG", (int)dwTick);
		if (f_stat(pName, &info) != FR_OK)
			return;
	}
}

// 폜}[Nؑւ
static void MarkErase(void)
{
	rect_t rc = { LCD_CX - 20, 0, 20, 20 };
	if (!s_fErase)
	{
		if (s_LastFile[0] != '\0')
		{
			// 폜}[N
			GetBits(&rc, s_Back);
	
			VERIFY(f_chdir(DIR_SYS_IMAGE) == FR_OK);
			DrawBmp("ERASE.bmp", &rc);
			s_fErase = TRUE;
		}
	}
	else
	{
		// LZ
		BlitLCD(&rc, s_Back);
		s_fErase = FALSE;
	}
}

// VCHTML
static BOOL Analize(void)
{
	// UTF-8
	static const char Kyo[] =
		{ 0xE4, 0xBB, 0x8A, 0xE6, 0x97, 0xA5, 0x00 }; // 
	static const char Gatu[] =
		{ 0xE6, 0x9C, 0x88, 0x00 }; // 
	static const char Tenki[] =
		{ 0x3E, 0xE5, 0xA4, 0xA9, 0xE6, 0xB0, 0x97, 0x3C, 0x00 }; // >VC<
	static const char Kion[] =
		{ 0xE6, 0xB0, 0x97, 0xE6, 0xB8, 0xA9, 0x00 }; // C
	static const char Kosuiryo[] = 
		{ 0xE9, 0x99, 0x8D, 0xE6, 0xB0, 0xB4, 0xE9, 0x87, 0x8F, 0x00 }; // ~

	char nMon, nDay;
	tenki_t temp[16];
	int i;

	time_t tt = Time();
	struct tm Tm = *gmtime(&tt);

	const char* p = Find(s_Buf, "leisurePinpointWeather");
	if (p == NULL)
	{
		LOG("A(0)\r\n");
		return FALSE;
	}
	p = Find(p, Kyo);
	if (p == NULL)
	{
		LOG("A(1)\r\n");
		return FALSE;
	}
	if (!GetNum(p, &nMon) || nMon < 1 || nMon > 12)
	{
		LOG("A(2)\r\n");
		return FALSE;
	}
	p = Find(p, Gatu);
	if (p == NULL)
	{
		LOG("A(3)\r\n");
		return FALSE;
	}
	if (!GetNum(p, &nDay) || nDay < 1 || nDay > 31)
	{
		LOG("A(4)\r\n");
		return FALSE;
	}
	p = Find(p, Tenki);
	if (p == NULL)
	{
		LOG("A(5)\r\n");
		return FALSE;
	}
	
	Tm.tm_sec = 0;
	Tm.tm_min = 0;
	Tm.tm_hour = 0;
	Tm.tm_mday = nDay;
	Tm.tm_mon = nMon - 1;
	Tm.tm_wday = 0;
	Tm.tm_yday = 0;
	Tm.tm_isdst = -1;
	tt = mktime(&Tm);

	for (i = 0; i < 16; i++, tt += 3 * 3600)
	{
		tenki_t* pt = temp + i;
		int j = i % 8;
		
		p = Find(p, "alt=\"");
		if (p == NULL)
			break;
		
		if (!GetTenki(p, &pt->nTenki, j < 2 || 6 < j))
			break;
		
		pt->tTime = tt;
	}
	if (i != 16)
	{
		LOG("A(6)\r\n");
		return FALSE;
	}
	p = Find(p, Kion);
	if (p == NULL)
	{
		LOG("A(7)\r\n");
		return FALSE;
	}
	for (i = 0; i < 16; i++)
	{
		p = Find(p, "<td>");
		if (p == NULL)
			break;

		if (!GetNum(p, &temp[i].nKion))
			break;
	}
	if (i != 16)
	{
		LOG("A(8)\r\n");
		return FALSE;
	}
	p = Find(p, Kosuiryo);
	if (p == NULL)
	{
		LOG("A(9)\r\n");
		return FALSE;
	}
	for (i = 0; i < 16; i++)
	{
		char nKosui;
		p = Find(p, "alt=\"");
		if (p == NULL)
			break;

		if (!GetNum(p, &nKosui))
			break;

		nKosui = (nKosui + 2) / 3;
		if (nKosui > 5) nKosui = 5;
		temp[i].nKosui = nKosui;
	}
	if (i != 16)
	{
		LOG("A(10)\r\n");
		return FALSE;
	}

	// 擾
	if (memcmp(temp, s_Tenki, sizeof(temp)) != 0)
	{
		memcpy(s_Tenki, temp, sizeof(s_Tenki));
		s_dwUpdates |= UPF_WETHER;
	}
	return TRUE;
}

// w肵Ď̈ʒuԂ
static const char* Find(const char* p, const char* key)
{
	const char* k = key;

	for (; *p != '\0'; p++)
	{
		if (*p == *k)
		{
			for(p++, k++;; p++, k++)
			{
				if (*k == '\0')
					return p;

				if (*p != *k)
				{
					p--;
					k = key;
					break;
				}
			}
		}
	}

	return NULL;
}

// w肵ʒu琔lǂݎ
static BOOL GetNum(const char* p, char* n)
{
	int nS = 1;

	// Jnʒun܂^O͖
	if (*p == '<')
	{
		for (p++; *p != '>'; p++)
		{
			if (*p == '\0')
				return FALSE;
		}
		p++;
	}

	// ÕXy[X͖
	while (*p == ' ') p++;

	// }CiX
	if (*p == '-')
	{
		nS = -1;
		p++;
	}

	// 10ilǂݎ
	if ('0' <= *p && *p <= '9')
	{
		*n = 0;
		do {
			*n = *n * 10 + *p - '0';
			p++;
		}
		while ('0' <= *p && *p <= '9');
		return TRUE;
	}

	return FALSE;
}

// w肵ʒuVCǂݎ
static BOOL GetTenki(const char* p, char* t, BOOL night)
{
	// UTF-8
	static const char Hare[] = 
		{ 0xE6, 0x99, 0xB4, 0xE3, 0x82, 0x8C }; // ""
	static const char kumo[] = 
		{ 0xE6, 0x9B, 0x87, 0xE3, 0x82, 0x8A }; // "܂"
	static const char kyoa[] = 
		{ 0xE5, 0xBC, 0xB7, 0xE9, 0x9B, 0xA8 }; // "J"
	static const char yowa[] = 
		{ 0xE5, 0xBC, 0xB1, 0xE9, 0x9B, 0xA8 }; // "J"
	static const char Kans[] = 
		{ 0xE4, 0xB9, 0xBE, 0xE9, 0x9B, 0xAA }; // ""
	static const char Situ[] = 
		{ 0xE6, 0xB9, 0xBF, 0xE9, 0x9B, 0xAA }; // ""
	static const char MiZo[] = 
		{ 0xE3, 0x81, 0xBF, 0xE3, 0x81, 0x9E }; // "݂"
	static const char Humi[] = 
		{ 0xE4, 0xB8, 0x8D, 0xE6, 0x98, 0x8E }; // "s"

	// tenki.jp(s撬X֔ԍƂ̓VC)ɂ
	if (memcmp(p, Hare, 6) == 0)
	{
		*t = (night)? TENKI_TUKI : TENKI_HARE;
		return TRUE;
	}
	if (memcmp(p, kumo, 6) == 0)
	{
		*t = TENKI_KUMO;
		return TRUE;
	}
	if (memcmp(p, kyoa, 6) == 0)
	{
		*t = TENKI_AMEH;
		return TRUE;
	}
	if (memcmp(p, yowa, 6) == 0)
	{
		*t = TENKI_AMEL;
		return TRUE;
	}
	if (memcmp(p, Kans, 6) == 0)
	{
		*t = TENKI_YUKK;
		return TRUE;
	}
	if (memcmp(p, Situ, 6) == 0)
	{
		*t = TENKI_YUKS;
		return TRUE;
	}
	if (memcmp(p, MiZo, 6) == 0)
	{
		*t = TENKI_MIZO;
		return TRUE;
	}
	if (memcmp(p, Humi, 6) == 0)
	{
		*t = TENKI_UNKNOWN;
		return TRUE;
	}

	return FALSE;
}

