/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/
#ifndef _HONEY_BOARD_H_
#define _HONEY_BOARD_H_

#include "Compiler.h"

// Clock
#define SYS_CLOCK			80000000UL	// Hz

// MRF24WB0M
#define _WF_CS_TRIS			TRISCbits.TRISC1
#define _WF_CS_IO			LATCbits.LATC1
#define _WF_SDI_TRIS		TRISGbits.TRISG7
#define _WF_SCK_TRIS		TRISGbits.TRISG6
#define _WF_SDO_TRIS		TRISGbits.TRISG8
#define _WF_RESET_TRIS		TRISCbits.TRISC2
#define _WF_RESET_IO		LATCbits.LATC2
#define _WF_HIBERNATE_TRIS	TRISGbits.TRISG15
#define _WF_HIBERNATE_IO	LATGbits.LATG15
#define _WF_INT_TRIS		TRISEbits.TRISE8
#define _WF_INT_IO			PORTEbits.RE8	// INT1
#define _WF_INT_EDGE		INTCONbits.INT1EP
#define _WF_INT_IE			IEC0bits.INT1IE
#define _WF_INT_IF			IFS0bits.INT1IF
#define _WF_INT_IE_CLEAR	IEC0CLR
#define _WF_INT_IF_CLEAR	IFS0CLR
#define _WF_INT_IE_SET		IEC0SET
#define _WF_INT_IF_SET		IFS0SET
#define _WF_INT_BIT			0x00000080
#define _WF_INT_IPCSET		IPC1SET
#define _WF_INT_IPCCLR		IPC1CLR
#define _WF_INT_IPC_MASK	0xFF000000
#define _WF_INT_IPC_VALUE	0x0C000000

#define _WF_SSPBUF			SPI2BUF
#define _WF_SPISTAT			SPI2STAT
#define _WF_SPISTATbits		SPI2STATbits
#define _WF_SPICON1			SPI2CON
#define _WF_SPICON1bits		SPI2CONbits
#define _WF_SPI_IE_CLEAR	IEC1CLR
#define _WF_SPI_IF_CLEAR	IFS1CLR
#define _WF_SPI_INT_BITS	(_IEC1_SPI2EIE_MASK | _IEC1_SPI2RXIE_MASK | _IEC1_SPI2TXIE_MASK)
#define _WF_SPI_BRG			SPI2BRG
#define _WF_MAX_SPI_FREQ	25000000UL	// Hz

#define WF_SCK_IO			LATGbits.LATG6
#define WF_SDO_IO			LATGbits.LATG8
#define WF_SDI_IO			LATGbits.LATG7

// Helper Timer
#define _HT_TCON			T2CON
#define _HT_TMR				TMR2
#define _HT_PR				PR2

// Beep Clock Timer
#define BC_TCONbits			T3CONbits
#define BC_TCON				T3CON
#define BC_TMR				TMR3
#define BC_PR				PR3
#define BC_IP				IPC3bits.T3IP
#define BC_IE				IEC0bits.T3IE
#define BC_IF_CLR			IFS0CLR
#define BC_IF_MASK			_IFS0_T3IF_MASK

// Beep Stop Timer
#define BS_TCONbits			T4CONbits
#define BS_TCON				T4CON
#define BS_TMR				TMR4
#define BS_PR				PR4
#define BS_IP				IPC4bits.T4IP
#define BS_IE				IEC0bits.T4IE
#define BS_IF_CLR			IFS0CLR
#define BS_IF_MASK			_IFS0_T4IF_MASK

// LED Blink Timer
#define LB_TCONbits			T5CONbits
#define LB_TCON				T5CON
#define LB_TMR				TMR5
#define LB_PR				PR5
#define LB_IP				IPC5bits.T5IP
#define LB_IE				IEC0bits.T5IE
#define LB_IF				IFS0bits.T5IF

// SDC
#define SDC_CS_TRIS			TRISAbits.TRISA9
#define SDC_CS_IO			LATAbits.LATA9
#define SDC_SDI_TRIS		TRISFbits.TRISF4
#define SDC_SDI_IO			LATFbits.LATF4
#define SDC_SCK_TRIS		TRISFbits.TRISF13
#define SDC_SCK_IO			LATFbits.LATF13
#define SDC_SDO_TRIS		TRISFbits.TRISF5
#define SDC_SDO_IO			LATFbits.LATF5
#define SDC_SPICON			SPI4CONbits
#define SDC_SPISTAT			SPI4STATbits
#define SDC_SPIBUF			SPI4BUF
#define SDC_SPIBRG			SPI4BRG

// SRAM
#define SRAM_CE_TRIS		TRISAbits.TRISA10
#define SRAM_CE_TRIS_SET	TRISASET
#define SRAM_CE_TRIS_CLR	TRISACLR
#define SRAM_CE_TRIS_MASK	_TRISA_TRISA10_MASK
#define SRAM_WE_TRIS		TRISAbits.TRISA1
#define SRAM_WE_IO			LATAbits.LATA1
#define SRAM_WE_SET			LATASET
#define SRAM_WE_CLR			LATACLR
#define SRAM_WE_MASK		_LATA_LATA1_MASK
#define SRAM_ADVLD_TRIS		TRISAbits.TRISA5
#define SRAM_ADVLD_TRIS_SET	TRISASET
#define SRAM_ADVLD_TRIS_CLR	TRISACLR
#define SRAM_ADVLD_TRIS_MSK	_TRISA_TRISA5_MASK
#define SRAM_ADVLD_IO		LATAbits.LATA5
#define SRAM_ADVLD_SET		LATASET
#define SRAM_ADVLD_CLR		LATACLR
#define SRAM_ADVLD_MASK		_LATA_LATA5_MASK

#define ADDR_L_TRIS_SET		TRISDSET
#define ADDR_L_TRIS_CLR		TRISDCLR
#define ADDR_L_A0A1_MASK	(_TRISA_TRISA0_MASK | _TRISA_TRISA1_MASK)
#define ADDR_L_TRIS_MASK	0x0000FFFC
#define ADDR_L				LATD
#define ADDR_L_CLR			LATDCLR
#define ADDR_L_MASK			0x0000FFFF
#define ADDR_H_TRIS_SET		TRISASET
#define ADDR_H_TRIS_CLR		TRISACLR
#define ADDR_H_TRIS_MASK	0x0000001C
#define ADDR_H				LATA
#define ADDR_H_SET			LATASET
#define ADDR_H_CLR			LATACLR
#define ADDR_H_MASK			0x0000001C
#define ADDR_H_SHIFT		14

#define DATA_L_ADPC_SET		AD1PCFGSET
#define DATA_L_ADPC_MASK	0x0000FFFF
#define DATA_L_TRIS_SET		TRISBSET
#define DATA_L_TRIS_CLR		TRISBCLR
#define DATA_L_TRIS_MASK	0x0000FFFF
#define DATA_L				PORTB
#define DATA_H_TRIS_SET		TRISESET
#define DATA_H_TRIS_CLR		TRISECLR
#define DATA_H_TRIS_MASK	0x000000FC
#define DATA_H				PORTE

// Multiplexer
#define MUX_SEL_TRIS		TRISFbits.TRISF12
#define MUX_SEL_IO			LATFbits.LATF12
#define MUX_SEL_SET			LATFSET
#define MUX_SEL_CLR			LATFCLR
#define MUX_SEL_MASK		_LATF_LATF12_MASK
#define MUX_CLK_TRIS		TRISFbits.TRISF3
#define MUX_CLK_IO			LATFbits.LATF3
#define MUX_CLK_SET			LATFSET
#define MUX_CLK_CLR			LATFCLR
#define MUX_CLK_MASK		_LATF_LATF3_MASK

// MCU2
#define BKLT_TRIS			TRISGbits.TRISG1
#define BKLT_IO				LATGbits.LATG1
#define VS_INT_TRIS			TRISAbits.TRISA15
#define VS_INT_IO			PORTAbits.RA15	// INT4
#define HS_INT_TRIS			TRISAbits.TRISA14
#define HS_INT_IO			PORTAbits.RA14	// INT3
#define HS_INT_IE			IEC0bits.INT3IE			
#define HS_INT_IE_SET		IEC0SET
#define HS_INT_IE_CLR		IEC0CLR
#define HS_INT_IE_MASK		_IEC0_INT3IE_MASK
#define HS_INT_IF_SET		IFS0SET
#define HS_INT_IF_CLR		IFS0CLR
#define HS_INT_IF_MASK		_IFS0_INT3IF_MASK
#define HS_INT_IP			IPC3bits.INT3IP
#define HS_INT_EDGE			INTCONbits.INT3EP

// Power
#define POWER_B_TRIS		TRISAbits.TRISA6
#define POWER_B_IO			LATAbits.LATA6
#define POWER_C_TRIS		TRISGbits.TRISG0
#define POWER_C_IO			LATGbits.LATG0

// LED
#define LED_TRIS			TRISGbits.TRISG14
#define LED_IO				LATGbits.LATG14
#define LED_IO_INV			LATGINV
#define LED_IO_MASK			_LATG_LATG14_MASK

// BZ
#define BZ_TRIS				TRISAbits.TRISA7
#define BZ_IO_CLR			LATACLR
#define BZ_IO_INV			LATAINV
#define BZ_IO_MASK			_LATA_LATA7_MASK

// SW
#define SW_TRIS				TRISGbits.TRISG12
#define SW_IO				PORTGbits.RG12

// CDS
#define CDS_TRIS			TRISGbits.TRISG13
#define CDS_IO				PORTGbits.RG13

// UART
#define ENABLE_UART

#define UART_TX_TRIS		TRISFbits.TRISF8
#define UART_RX_TRIS		TRISFbits.TRISF2

#ifdef ENABLE_UART
#define UART_BAUD_RATE		19200	// bps
#define _BusyUART()			BusyUART1()
#define _CloseUART()		CloseUART1()
#define _ConfigIntUART(a)	ConfigIntUART1(a)
#define _DataRdyUART()		DataRdyUART1()
#define _OpenUART(a,b,c)	OpenUART1(a,b,c)
#define _ReadUART()			ReadUART1()
#define _WriteUART(a)		WriteUART1(a)
#define _getsUART(a,b,c)	getsUART1(a,b,c)
#define _putsUART(a)		putsUART1(a)
#define _getcUART()			getcUART1()
#define _putrsUART(a)		putrsUART1(a)
#define LOG(x)				putsUART1(x)
#else
#define _BusyUART()			0
#define _CloseUART()
#define _ConfigIntUART(a)
#define _DataRdyUART()		1
#define _OpenUART(a,b,c)
#define _ReadUART()			0
#define _WriteUART(a)
#define _getsUART(a,b,c)
#define _putsUART(a)
#define _getcUART()			0
#define _putrsUART(a)
#define LOG(x)
#endif

// NC(Output LO)
#define NC_TRIS_MASK_A		0x00000001	// RA0
#define NC_TRIS_MASK_C		0x00000018	// RC3,RC4
#define NC_TRIS_MASK_E		0x00000203	// RE0,RE1,RE9
#define NC_TRIS_MASK_F		0x00000003	// RF0,RF1
#define NC_TRIS_MASK_G		0x0000020C	// RG2,RG3,RG9

#endif //_HONEY_BOARD_H_
