/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include "diskio.h"
#include "SDC.h"
#include "APP.h"

#define DRV_SDC		0
#define IS_VALID_TIME(x)	((x) > (40UL * 365UL * 24UL * 60UL * 60UL))

//=================================================================

// fBXNEhCȕ
DSTATUS disk_initialize(BYTE drv)
{
	if (drv == DRV_SDC)
	{
		if (OpenSDC())
			return 0;
	}
	return STA_NOINIT;
}

// fBXNEhCȕԎ擾
DSTATUS disk_status(BYTE drv)
{
	if (drv == DRV_SDC)
	{
		if (IsEnabledSDC())
			return 0;
	}
	return STA_NOINIT;
}

// fBXN̓ǂݍ
DRESULT disk_read(BYTE drv, BYTE *buff, DWORD sector, BYTE count)
{
	if (drv == DRV_SDC)
	{
		do {
			if (!ReadSDC(sector++, buff))
				return RES_ERROR;
			buff += SECTOR_SIZE;
		}
		while (--count > 0);
		return RES_OK;
	}
	return RES_PARERR;
}

// fBXNւ̏
DRESULT disk_write(BYTE drv, const BYTE *buff, DWORD sector, BYTE count)
{
	if (drv == DRV_SDC)
	{
		do {
			if (!WriteSDC(sector++, buff))
				return RES_ERROR;
			buff += SECTOR_SIZE;
		}
		while (--count > 0);
		return RES_OK;
	}
	return RES_PARERR;
}

// ̑̃hCu
DRESULT disk_ioctl(BYTE drv, BYTE ctrl, void *buff)
{
	if (drv == DRV_SDC)
	{
		if (ctrl == CTRL_SYNC)
			return RES_OK;
	}
	return RES_PARERR;
}

// ̎擾
DWORD get_fattime(void)
{
	time_t t;
	struct tm* p;
	DWORD ret = 0;

	t = Time();
	if (IS_VALID_TIME(t))
	{
		p = gmtime(&t);

		// bit31:25 - 1980NN_ƂN(0..127)
		ret = (p->tm_year - 80) << 25;

		// bit24:21 - (1..12)
		ret |= (p->tm_mon + 1) << 21;

		// bit20:16 - (1..31)
		ret |= p->tm_mday << 16;

		// bit15:11 - (0..23)
		ret |= p->tm_hour << 11;

		// bit10:5 - (0..59)
		ret |= p->tm_min << 5;

		// bit4:0 - b/2(0..29)
		ret |= p->tm_sec / 2;

		return ret;
	}

	return 0;
}
