/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/

#include "TCPIP Stack/TCPIP.h"
#include "HardwareProfile.h"
#include "Main.h"
#include "LCD.h"
#include "SDC.h"
#include "STK.h"
#include "APP.h"
#include "GFX.h"

#define SETTINGFILE	"\\SYS\\Settings.ini"

//=================================================================

// Configuration
#ifndef _MSC_VER

// DEVCFG0
#pragma config DEBUG = ON			// Disabled
#pragma config ICESEL = ICS_PGx1	// ICE pins are shared with PGC1, PGD1
#pragma config PWP = OFF			// Disabled
#pragma config BWP = OFF			// Disabled
#pragma config CP = OFF				// Disabled

// DEVCFG1
#pragma config FNOSC = PRIPLL		// Primary oscillator (XT, HS, EC) w/ PLL
#pragma config FSOSCEN = ON			// Enabled
#pragma config IESO = OFF			// Disabled
#pragma config POSCMOD = XT			// XT oscillator
#pragma config OSCIOFNC = OFF		// Disabled
#pragma config FPBDIV = DIV_1		// Divide by 1
#pragma config FCKSM = CSECMD		// Clock Switching Enabled, Clock Monitoring Disabled
#pragma config WDTPS = PS8192		// 1:8192
#pragma config FWDTEN = OFF			// Disabled 

// DEVCFG2
#pragma config FPLLIDIV = DIV_2		// Divide by 2 (4MHz)
#pragma config FPLLMUL = MUL_20		// Multiply by 20 (80MHz)
#pragma config UPLLIDIV = DIV_2		// Divide by 2 
#pragma config UPLLEN = ON			// Enabled
#pragma config FPLLODIV = DIV_1		// Divide by 1 (80MHz)

// DEVCFG3
#pragma config FUSBIDIO = OFF		// USBID pin is controlled by the Port Function
#pragma config FVBUSONIO = OFF		// VBUS_ON pin is controlled by the Port Function

#endif

//=================================================================

static void InitSystem(void);
static void Run(void);

//=================================================================

static int s_nPowerB = 0;
static int s_nPowerC = 0;

static volatile DWORD s_nBeep;
static volatile DWORD s_nLedV;
static volatile DWORD s_nLedS;
static volatile int s_nBlink;

//=================================================================

// CGg
int main(void)
{
	// {̏
	InitSystem();

	// NANV
	SetLED(500, 2);
	Beep(500, 100);
    LOG("\r\n");
    LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \r\n");
    LOG(">>>>>>>>>> HoneyInfo Start. >>>>>>>>>> \r\n");
    LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \r\n");
    LOG("\r\n");

	InitLCD();
	InitSDC();

	// ȍ~̏łmicroSDݒǂ߂Ԃɂ
	EnableSDC();
	while (!IsEnabledSDC()) TaskSDC();

	InitSTK();
	InitAPP();
	InitGFX();

	DisableSDC();
	for(;;) Run();
}

// n[h
static void InitSystem(void)
{
	// }`xN^荞
	INTEnableSystemMultiVectoredInt();
	
	// ptH[}XœK
	SYSTEMConfigPerformance(GetSystemClock());
	mOSCSetPBDIV(OSC_PB_DIV_1);
	
	// JTAG
	DDPCONbits.JTAGEN = 0;

	// |[g
	PORTA = PORTB = PORTC = PORTD = PORTE = PORTF = PORTG = 0;
	LATA = LATB = LATC = LATD = LATE = LATF = LATG = 0;

	// 󂫃fW^s(LOo)
	TRISACLR = NC_TRIS_MASK_A;
	TRISCCLR = NC_TRIS_MASK_C;
	TRISECLR = NC_TRIS_MASK_E;
	TRISFCLR = NC_TRIS_MASK_F;
	TRISGCLR = NC_TRIS_MASK_G;

	// LED(_)
	LED_IO = 1;
	LED_TRIS = OUTPUT;

	// Power,BZ,SW,CDS
	POWER_B_TRIS = OUTPUT;
	POWER_C_TRIS = OUTPUT;
	BZ_TRIS = OUTPUT;
	SW_TRIS = INPUT;
	CDS_TRIS = INPUT;

	// MRF24WB0M
	WF_HIBERNATE_TRIS = OUTPUT;
	WF_CS_TRIS = INPUT;
	WF_RESET_TRIS = INPUT;
	WF_INT_TRIS = INPUT;
	WF_SCK_TRIS = OUTPUT;
	WF_SDO_TRIS = OUTPUT;
	WF_SDI_TRIS = OUTPUT;

	// SDC
	SDC_CS_TRIS = INPUT;
	SDC_SDI_TRIS = OUTPUT;
	SDC_SCK_TRIS = OUTPUT;
	SDC_SDO_TRIS = OUTPUT;

	// SRAM
	SRAM_CE_TRIS = INPUT;
	SRAM_WE_TRIS = OUTPUT;
	SRAM_ADVLD_TRIS = OUTPUT;
	ADDR_L_TRIS_CLR = ADDR_L_A0A1_MASK;
	ADDR_L_TRIS_CLR = ADDR_L_TRIS_MASK;
	ADDR_H_TRIS_CLR = ADDR_H_TRIS_MASK;
	DATA_L_ADPC_SET = DATA_L_ADPC_MASK;
	DATA_L_TRIS_CLR = DATA_L_TRIS_MASK;
	DATA_H_TRIS_CLR = DATA_H_TRIS_MASK;

	// Multiplexer
	MUX_SEL_TRIS = OUTPUT;
	MUX_CLK_TRIS = OUTPUT;

	// MCU2
	BKLT_TRIS = OUTPUT;
	VS_INT_TRIS = OUTPUT;
	HS_INT_TRIS = OUTPUT;

	// RTCC
	while (RtccGetClkStat() == RTCC_SOSC_NRDY);
	RtccInit();
	RtccOpen(0x00000000, 0x00010106, 0); //2000/01/01 00:00:00

	// Tick(Timer 1)
	TickInit();

	// UART
#ifdef ENABLE_UART
	UART_TX_TRIS = OUTPUT;
	UART_RX_TRIS = INPUT;
	#define CLOSEST_UBRG_VALUE ((GetPeripheralClock()+8ul*UART_BAUD_RATE)/16/UART_BAUD_RATE-1)
	#define BAUD_ACTUAL (GetPeripheralClock()/16/(CLOSEST_UBRG_VALUE+1))
	#define BAUD_ERROR ((BAUD_ACTUAL > UART_BAUD_RATE) ? BAUD_ACTUAL-UART_BAUD_RATE : UART_BAUD_RATE-BAUD_ACTUAL)
	#define BAUD_ERROR_PRECENT	((BAUD_ERROR*100+UART_BAUD_RATE/2)/UART_BAUD_RATE)
	#if (BAUD_ERROR_PRECENT > 3)
		#warning UART frequency error is worse than 3%
	#elif (BAUD_ERROR_PRECENT > 2)
		#warning UART frequency error is worse than 2%
	#endif
	OpenUART(UART_EN, UART_RX_ENABLE | UART_TX_ENABLE, CLOSEST_UBRG_VALUE);
#else
	UART_TX_TRIS = OUTPUT;
	UART_RX_TRIS = OUTPUT;
#endif

	// 荞݋
	INTEnableInterrupts();
}

// s[v
static void Run(void)
{
#ifndef __DEBUG
	EnableWDT();
#endif
	for(;;)
	{
		TaskSTK();
		ClearWDT();

		TaskSDC();
		ClearWDT();

		TaskLCD();
		ClearWDT();

		TaskAPP();
		ClearWDT();
	}
}

//=================================================================

// d𐧌䂷(3.3V Bn)
extern void PowerCtrlB(BOOL fOn)
{
	ASSERT(0 <= s_nPowerB && s_nPowerB <= 2);

	if (fOn)
	{
		if (++s_nPowerB == 1)
		{
			// MRF24WB0M
			ASSERT(WF_HIBERNATE_TRIS == OUTPUT);
			ASSERT(WF_HIBERNATE_IO == 0);
			ASSERT(WF_CS_TRIS == INPUT);
			ASSERT(WF_RESET_TRIS == INPUT);
			ASSERT(WF_INT_TRIS == INPUT);
			ASSERT(WF_SCK_TRIS == OUTPUT);
			ASSERT(WF_SCK_IO == 0);
			ASSERT(WF_SDO_TRIS == OUTPUT);
			ASSERT(WF_SDO_IO == 0);
			ASSERT(WF_SDI_TRIS == OUTPUT);
			ASSERT(WF_SDI_IO == 0);
			WF_SDI_TRIS = INPUT;

			// SDC
			ASSERT(SDC_CS_TRIS == INPUT);
			ASSERT(SDC_SCK_TRIS == OUTPUT);
			ASSERT(SDC_SCK_IO == 0);
			ASSERT(SDC_SDO_TRIS == OUTPUT);
			ASSERT(SDC_SDO_IO == 0);
			ASSERT(SDC_SDI_TRIS == OUTPUT);
			ASSERT(SDC_SDI_IO == 0);
			SDC_SDI_TRIS = INPUT;

			// dON
		    LOG("3.3V(B) power supply ON\r\n");
			POWER_B_IO = 1;
			Delay(100);
		}
	}
	else
	{
		if (--s_nPowerB == 0)
		{
			// dOFF
		    LOG("3.3V(B) power supply OFF\r\n");
			POWER_B_IO = 0;
			Delay(100);

			// MRF24WB0M
			WF_HIBERNATE_IO = 0;
			WF_HIBERNATE_TRIS = OUTPUT;
			WF_CS_TRIS = INPUT;
			WF_CS_IO = 0;
			WF_RESET_TRIS = INPUT;
			WF_RESET_IO = 0;
			WF_INT_TRIS = INPUT;
			WF_INT_IO = 0;
			WF_SCK_IO = 0;
			WF_SCK_TRIS = OUTPUT;
			WF_SDO_IO = 0;
			WF_SDO_TRIS = OUTPUT;
			WF_SDI_IO = 0;
			WF_SDI_TRIS = OUTPUT;

			// SDC
			SDC_CS_TRIS = INPUT;
			SDC_CS_IO = 0;
			SDC_SCK_IO = 0;
			SDC_SCK_TRIS = OUTPUT;
			SDC_SDO_IO = 0;
			SDC_SDO_TRIS = OUTPUT;
			SDC_SDI_IO = 0;
			SDC_SDI_TRIS = OUTPUT;
		}
	}
}

// d𐧌䂷(3.3V Cn)
extern void PowerCtrlC(BOOL fOn)
{
	ASSERT(0 <= s_nPowerC && s_nPowerC <= 1);

	if (fOn)
	{
		if (++s_nPowerC == 1)
		{
			// Multiplexer
			ASSERT(MUX_SEL_TRIS == OUTPUT);
			ASSERT(MUX_SEL_IO == 0);
			ASSERT(MUX_CLK_TRIS == OUTPUT);
			ASSERT(MUX_CLK_IO == 0);
			
			// MCU2
			ASSERT(BKLT_TRIS == OUTPUT);
			ASSERT(BKLT_IO == 0);
			ASSERT(VS_INT_TRIS == OUTPUT);
			ASSERT(VS_INT_IO == 0);
			VS_INT_TRIS = INPUT;
			ASSERT(HS_INT_TRIS == OUTPUT);
			ASSERT(HS_INT_IO == 0);
			HS_INT_TRIS = INPUT;

			// SRAM
			ASSERT(SRAM_CE_TRIS == INPUT);
			ASSERT(SRAM_WE_TRIS == OUTPUT);
			ASSERT(SRAM_WE_IO == 0);
			ASSERT(SRAM_ADVLD_TRIS == OUTPUT);
			ASSERT(SRAM_ADVLD_IO == 0);
			SRAM_ADVLD_TRIS = INPUT;

			ADDR_L_TRIS_SET = ADDR_L_TRIS_MASK;
			ADDR_H_TRIS_SET = ADDR_H_TRIS_MASK;
			DATA_L_TRIS_SET = DATA_L_TRIS_MASK;
			DATA_H_TRIS_SET = DATA_H_TRIS_MASK;

			// dON
		    LOG("3.3V(C) power supply ON\r\n");
			SRAM_WE_IO = 1;
			MUX_SEL_IO = 1;
			POWER_C_IO = 1;
			Delay(100);
		}
	}
	else
	{
		if (--s_nPowerC == 0)
		{
			// Multiplexer
			ASSERT(MUX_SEL_IO == 1);
			ASSERT(MUX_CLK_IO == 0);
			MUX_SEL_IO = 0;

			// SRAM(1)
			ASSERT(SRAM_WE_IO == 1);
			SRAM_WE_IO = 0;

			// dOFF
		    LOG("3.3V(C) power supply OFF\r\n");
			POWER_C_IO = 0;
			Delay(100);

			// MCU2
			ASSERT(BKLT_IO == 0);
			VS_INT_TRIS = OUTPUT;
			HS_INT_TRIS = OUTPUT;

			// SRAM(2)
			ASSERT(SRAM_CE_TRIS == INPUT);
			ASSERT(SRAM_ADVLD_TRIS == INPUT);
			SRAM_ADVLD_IO = 0;
			SRAM_ADVLD_TRIS = OUTPUT;

			ADDR_L = 0;
			ADDR_L_TRIS_CLR = ADDR_L_TRIS_MASK;
			ADDR_H_CLR = ADDR_H_MASK;
			ADDR_H_TRIS_CLR = ADDR_H_TRIS_MASK;
			DATA_L = 0;
			DATA_L_TRIS_CLR = DATA_L_TRIS_MASK;
			DATA_H = 0;
			DATA_H_TRIS_CLR = DATA_H_TRIS_MASK;
		}
	}
}

// LCD\
extern void BackLight(BOOL fOn)
{
	BKLT_IO = fOn;
	if (fOn) {
		Delay(25);
	}
}

// LED\
extern void SetLED(DWORD nPeriod, int nCount)
{
	if (nPeriod != LED_OFF && nPeriod != LED_ON && nCount != 0)
	{
		LED_IO = 1;
	
		s_nLedS = s_nLedV = (GetPeripheralClock() / 256UL * (DWORD)nPeriod) / 1000UL;
		s_nBlink = nCount * 2 - 1;

		// \]^C}[
		LB_TCON = 0x70;	// TCKPS:256  312500 count at 1sec
		LB_PR = (s_nLedV > 0xFFFF)? 0xFFFF : s_nLedV;
		LB_TMR = 0;
		LB_IP = 2;
		LB_IF = 0;
		LB_IE = 1;
		LB_TCONbits.TON = 1;
	}
	else
	{
		LED_IO = (nPeriod == LED_OFF)? 0 : 1;
		LB_TCON = 0;
		LB_IE = 0;
		LB_IF = 0;
	}
}

// r[v
extern void Beep(UINT nFreq, int nTime)
{
	// r[vNbN^C}[
	BC_TCON = 0x10;	// TCKPS:1  2500 count at 1KHz
	BC_PR = GetPeripheralClock() / 8 / 2 / nFreq - 3;
	BC_TMR = 0;
	BC_IP = 2;

	// r[v~^C}[
	s_nBeep = (GetPeripheralClock() / 256UL * (DWORD)nTime) / 1000UL;
	BS_TCON = 0x70;	// TCKPS:256  312500 count at 1sec
	BS_PR = (s_nBeep > 0xFFFF)? 0xFFFF : s_nBeep;
	BS_TMR = 0;
	BS_IP = 2;

	// Jn
	BC_IF_CLR = BC_IF_MASK;
	BS_IF_CLR = BS_IF_MASK;
	BC_IE = BS_IE = 1;
	BC_TCONbits.TON = 1;
	BS_TCONbits.TON = 1;
}

// ^C}[쒆ǂԂ
extern BOOL IsBusyTimer(void)
{
	return (LB_IE != 0) || (BC_IE != 0);
}

// CDS
extern BOOL GetCDS(void)
{
	static int nCount = 5;
	static BOOL fOn = TRUE;

	// 
	CDS_TRIS = OUTPUT;
	CDS_TRIS = INPUT;
	Delay(1);

	if (CDS_IO)
	{
		// 邢
		if (nCount < 5)
			nCount++;
	}
	else
	{
		// Â
		if (nCount > 0)
			nCount--;
	}
	if (fOn)
	{
		if (nCount == 0)
			fOn = FALSE;
	}
	else
	{
		if (nCount == 5)
			fOn = TRUE;
	}

	return fOn;
}

// SW
extern BOOL GetSW(void)
{
	return (SW_IO == 0);
}

// MSfBC(p[Z[ủe󂯂Ȃ)
extern void Delay(DWORD dwMs)
{
	DWORD dwTick = (TICKS_PER_SECOND * dwMs) / 1000;
	dwTick += TickGet();
	while (TickGet() < dwTick);
}

// ݒt@CJ
extern BOOL OpenSettings(setting_t* obj)
{
	ASSERT(IsEnabledSDC());
	VERIFY(f_chdrive(DRV_SDC) == FR_OK);
	return (f_open(&obj->file, SETTINGFILE, FA_READ) == FR_OK);
}

// ݒǍ()
extern BOOL ReadSettingStr(setting_t* obj, const char* key)
{
	ASSERT(IsEnabledSDC());
	if (f_lseek(&obj->file, 0) == FR_OK)
	{
		while (f_gets(obj->buf, sizeof(obj->buf), &obj->file) != NULL)
		{
			if (obj->buf[0] != '#') // Rgs
			{
				char* p;
				const char* k = key;
				for (p = obj->buf; *k != '\0' && *p != '\0'; k++, p++)
				{
					if (*k == *p)
					{
						if (p[1] == '=') // Name=Value`
						{
							int nLen = strlen(p += 2);
							if (nLen > 0 && p[nLen - 1] == '\n')
								p[nLen - 1] = '\0';

							obj->Str = p;
							return TRUE;
						}
						continue;
					}
					break;
				}
			}
		}
	}
	return FALSE;
}

// ݒǍ(10il)
extern BOOL ReadSettingNum(setting_t* obj, const char* key)
{
	ASSERT(IsEnabledSDC());
	if (ReadSettingStr(obj, key))
	{
		obj->Num = atoi(obj->Str);
		return TRUE;
	}
	return FALSE;
}

// ݒǍ(IP/MACAhX)
extern BOOL ReadSettingAddr(setting_t* obj, const char* key, BYTE radix)
{
	ASSERT(IsEnabledSDC());
	if (f_lseek(&obj->file, 0) == FR_OK)
	{
		while (f_gets(obj->buf, sizeof(obj->buf), &obj->file) != NULL)
		{
			if (obj->buf[0] != '#') // Rgs
			{
				char* p;
				const char *e, *k = key;
				for (p = obj->buf; *k != '\0' && *p != '\0'; k++, p++)
				{
					if (*k == *p)
					{
						if (p[1] == '=') // Name=Value`
						{
							BYTE* n = obj->Addr;
							BYTE* s = n + sizeof(obj->Addr);

							int nLen = strlen(p += 2);
							if (nLen > 0 && p[nLen - 1] == '\n')
								p[nLen - 1] = '\0';

							memset(n, 0, sizeof(obj->Addr));
							for (; *p != '\0' && n < s; n++)
							{
								for(e = p; *e != '.' && *e != '\0'; e++);
								for(; p < e; p++) {
									BYTE v = ('0' <= *p && *p <= '9')? (*p - '0') :
										(('A' <= *p && *p <= 'F')? (*p - 'A' + 10) :
											(('a' <= *p && *p <= 'f')? (*p - 'a' + 10) : 0));
									*n = *n * radix + v;
								}
								if (*p == '.') p++;
							}
							return TRUE;
						}
						continue;
					}
					break;
				}
			}
		}
	}
	return FALSE;
}

// ݒt@C
extern void CloseSettings(setting_t* obj)
{
	ASSERT(IsEnabledSDC());
	VERIFY(f_close(&obj->file) == FR_OK);
}

// AT[V
#if (defined(_DEBUG) || defined(__DEBUG))
extern void _Assert(BOOL cond, const char* msg)
{
	if (!cond)
	{
		LOG("\r\nASSERT: ");
		LOG(msg);
		LOG("\r\n");
		for(;;);
	}
}
#endif

//=================================================================

static enum
{
	EXCEP_IRQ = 0,			// interrupt
	EXCEP_AdEL = 4,			// address error exception (load or ifetch)
	EXCEP_AdES,				// address error exception (store)
	EXCEP_IBE,				// bus error (ifetch)
	EXCEP_DBE,				// bus error (load/store)
	EXCEP_Sys,				// syscall
	EXCEP_Bp,				// breakpoint
	EXCEP_RI,				// reserved instruction
	EXCEP_CpU,				// coprocessor unusable
	EXCEP_Overflow,			// arithmetic overflow
	EXCEP_Trap,				// trap (possible divide by zero)
	EXCEP_IS1 = 16,			// implementation specfic 1
	EXCEP_CEU,				// CorExtend Unuseable
	EXCEP_C2E				// coprocessor 2
} _excep_code;
static UINT _excep_addr;

// C30 and C32 Exception Handlers
void _general_exception_handler(unsigned cause, unsigned status)
{
	asm volatile("mfc0 %0,$13" : "=r" (_excep_code));
	asm volatile("mfc0 %0,$14" : "=r" (_excep_addr));
	_excep_code = (_excep_code & 0x0000007C) >> 2;

	LOG("general_exception!!\r\n");
}

// r[vNbN
void __ISR(_TIMER_3_VECTOR, ipl2) _T3Interrupt(void)
{
	// BZ_IO ]
	BZ_IO_INV = BZ_IO_MASK;
	BC_IF_CLR = BC_IF_MASK;
}

// r[v~
void __ISR(_TIMER_4_VECTOR, ipl2) _T4Interrupt(void)
{
	s_nBeep -= BS_PR;
	if (s_nBeep == 0)
	{
		// ~
		BS_TCON = 0;
		BC_TCON = 0;
		BS_IE = 0;
		BC_IE = 0;
		BC_IF_CLR = BC_IF_MASK;
		BZ_IO_CLR = BZ_IO_MASK;
	}
	else {
		BS_PR = (s_nBeep > 0xFFFF)? 0xFFFF : s_nBeep;
	}

	BS_IF_CLR = BS_IF_MASK;
}

// \]
void __ISR(_TIMER_5_VECTOR, ipl2) _T5Interrupt(void)
{
	s_nLedV -= LB_PR;
	if (s_nLedV == 0)
	{
		// ]
		LED_IO_INV = LED_IO_MASK;
		if (--s_nBlink == 0)
		{
			// ~
			LB_TCON = 0;
			LB_IE = 0;
		}
		else {
			s_nLedV = s_nLedS;
		}
	}
	LB_PR = (s_nLedV > 0xFFFF)? 0xFFFF : s_nLedV;
	LB_IF = 0;
}
