/****************************************************************************

	Honey Information Terminal
		Copyright(C) 2011 Mr.Honey

****************************************************************************/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "GenericTypeDefs.h"
#include "HoneyBoard.h"

extern void PowerCtrlB(BOOL fOn);
extern void PowerCtrlC(BOOL fOn);
extern void BackLight(BOOL fOn);
extern void SetLED(DWORD nPeriod, int nCount);
extern void Beep(UINT nFreq, int nTime);
extern BOOL IsBusyTimer(void);
extern BOOL GetCDS(void);
extern BOOL GetSW(void);
extern void Delay(DWORD dwMs);

#if (defined(_DEBUG) || defined(__DEBUG))
#define ASSERT(x)	_Assert(x, __FUNCTION__)
#define VERIFY(x)	ASSERT(x)
extern void _Assert(BOOL cond, const char* msg);
#else
#define ASSERT(x)
#define VERIFY(x)	(void)(x)
#endif

#define LED_OFF		0
#define LED_ON		0xFFFFFFFF
#define INPUT		1
#define OUTPUT		0
#define TICKS_OF(h, m, s)	(TICK_HOUR * (h) + TICK_MINUTE * (m) + TICK_SECOND * (s))

#include "ff.h"
#define DRV_SDC		0

typedef struct _setting_t {
	char buf[64];
	FIL file;
	const char* Str;
	int Num;
	BYTE Addr[6];
} setting_t;

extern BOOL OpenSettings(setting_t* obj);
extern BOOL ReadSettingStr(setting_t* obj, const char* key);
extern BOOL ReadSettingNum(setting_t* obj, const char* key);
extern BOOL ReadSettingAddr(setting_t* obj, const char* key, BYTE radix);
extern void CloseSettings(setting_t* obj);

#endif //_MAIN_H_
