/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "diskio.h"
#include "SDC.h"

#define DRV_SDC		0

//=================================================================

// fBXNEhCȕ
DSTATUS disk_initialize(BYTE drv)
{
	if (drv == DRV_SDC)
	{
		if (OpenSDC())
			return 0;
	}
	return STA_NOINIT;
}

// fBXNEhCȕԎ擾
DSTATUS disk_status(BYTE drv)
{
	if (drv == DRV_SDC)
	{
		if (IsOpenSDC())
			return 0;
	}
	return STA_NOINIT;
}

// fBXN̓ǂݍ
DRESULT disk_read(BYTE drv, BYTE *buff, DWORD sector, BYTE count)
{
	if (drv == DRV_SDC)
	{
		do {
			if (!ReadSDC(sector++, buff))
				return RES_ERROR;
			buff += SECTOR_SIZE;
		}
		while (--count > 0);
		return RES_OK;
	}
	return RES_PARERR;
}

// fBXNւ̏
DRESULT disk_write(BYTE drv, const BYTE *buff, DWORD sector, BYTE count)
{
	if (drv == DRV_SDC)
	{
		do {
			if (!WriteSDC(sector++, buff))
				return RES_ERROR;
			buff += SECTOR_SIZE;
		}
		while (--count > 0);
		return RES_OK;
	}
	return RES_PARERR;
}

// ̑̃hCu
DRESULT disk_ioctl(BYTE drv, BYTE ctrl, void *buff)
{
	if (drv == DRV_SDC)
	{
		if (ctrl == CTRL_SYNC)
			return RES_OK;
	}
	return RES_PARERR;
}

// ̎擾
DWORD get_fattime(void)
{
	return 0;
}
