/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"
#include "Volume.h"
#include "Network.h"
#include "User.h"
#include "TCPIP Stack/TCPIP.h"

//=================================================================

#define ST_NONE			0
#define ST_WAIT			1
#define ST_PROC			2

//=================================================================

static void Update(void);

//=================================================================

static int s_nState = ST_NONE;
static DWORD s_dwTick;

//=================================================================

// 
extern void InitUser(void)
{
	// 󉽂Ȃ
}

// Jn
extern void StartUser(void)
{
	ASSERT(s_nState == ST_NONE);

	// xJn
	s_dwTick = TickGet() + TICKS_OFMS(500);
	s_nState = ST_WAIT;
	Update();
}

// ~
extern void StopUser(void)
{
	ASSERT(s_nState != ST_NONE);

	// ~
	if (s_nState >= ST_PROC)
	{
		SetMute(TRUE);

		EnableNet(FALSE);
		while (!IsDisableNet()) {
			TaskNet();
		}
		SetDefClock();
	}

	// ~
	s_nState = ST_NONE;
}

// ^XN
extern void TaskUser(void)
{
	switch (s_nState)
	{
	case ST_WAIT:
		ASSERT(GetSystemClock() == DEFAULT_CLK);
		if (TickGet() >= s_dwTick)
		{
			// FTPp
			VERIFY(f_chdir("\\") == FR_OK);
	
			// NbN_E(WiFiL40MHz)
			SetClock(CLK_32KHz);
			SetMute(FALSE);
			s_nState = ST_PROC;
		}
		break;

	case ST_PROC:
		if (GetPushingSW(SW_PREV | SW_NEXT) == SW_NONE)
		{
			if (GetPressedSW(SW_FUNC))
			{
				if (IsDisplay())
				{
					if (IsDisableNet())
					{
						// WiFiڑ
						SetClock(CLK_40MHz);
						EnableNet(TRUE);
					}
					else if (IsEnabledNet())
					{
						// WiFiؒf
						EnableNet(FALSE);
						while (!IsDisableNet()) {
							TaskNet();
						}
						SetClock(CLK_32KHz);
					}
				}
				else {
					DisplayCtrl(DISPLAY_AUTO);
				}
			}
			else if (GetHoldingSW(SW_FUNC))
			{
				// It^C}[
				SetOffTimer(TRUE);
				ResetInput();
			}
		}
		else
		{
			// _̂
			DisplayCtrl(DISPLAY_AUTO);
			ResetInput();
		}

		// TCP/IP̂
		Update();
		TaskNet();
		break;

	default:
		ASSERT(s_nState == ST_NONE);
	}
}

// \XV
static void Update(void)
{
	static int s_nLastNet = -1;

	if (s_nState == ST_WAIT)
	{
		/* IN:        [   ] */
		DisplayText(0, 0, "IN:        ");
		DisplayText(0, 1, "                ");
		s_nLastNet = -1;
		DisplayCtrl(DISPLAY_AUTO);
		return;
	}

	int nCurrent = GetNetState();
	if (nCurrent != s_nLastNet)
	{
		/* Wi-Fi Disabled.  */
		/* Wi-Fi Connecting */
		/* #XXX.XXX.XXX.XXX */
		/* Wi-Fi Error.     */
		char buf1[32], buf2[32];
		switch (nCurrent)
		{
		case NET_DISABLED:
			DisplayText(0, 1, "Wi-Fi Disabled. ");
			break;
		case NET_CONNECTING:
			DisplayText(0, 1, "Wi-Fi Connecting");
			break;
		case NET_ENABLED:
			GetIPString(buf1);
			sprintf(buf2, "#%s        ", buf1);
			buf2[16] = '\0';
			DisplayText(0, 1, buf2);
			break;
		case NET_ERROR:
			DisplayText(0, 1, "Wi-Fi Error.    ");
			break;
		}

		s_nLastNet = nCurrent;
		DisplayCtrl(DISPLAY_AUTO);
	}
}
