/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Volume.h"

#define MAX_STEP	25
#define VOL_RANGE	144

//=================================================================

static BYTE ToData(UINT vol);
static void SendData(BYTE data);

//=================================================================

static BOOL s_fMute = TRUE;
static BYTE s_nVol = 0;
static int s_nLevel = 0;

//=================================================================

// 
extern void InitVolume(void)
{
	// |[g
	VR_LDSH_IO = 1;
	VR_LDSH_TRIS = OUTPUT;
	VR_CLOCK_IO = 0;
	VR_CLOCK_TRIS = OUTPUT;
	VR_DATA_IO = 0;
	VR_DATA_TRIS = OUTPUT;
}

// ~[g
extern void SetMute(BOOL fMute)
{
	if (s_fMute != fMute)
	{
		if (fMute) {
			SendData(0xFF);
		}
		else {
			SendData(ToData(s_nVol));
		}
		s_fMute = fMute;
	}
}

// ~[gԂ̎擾
extern BOOL IsMute(void)
{
	return s_fMute;
}

// xݒ
extern void SetLevel(int nLevel)
{
	ASSERT(nLevel <= (158 - VOL_RANGE));
	s_nLevel = nLevel;
	SetVolume(s_nVol);
}

// {[lݒ
extern void SetVolume(int nVol)
{
	if (s_nVol != nVol)
	{
		if (0 <= nVol && nVol <= MAX_STEP)
		{
			s_nVol = nVol;
			if (!s_fMute) {
				SendData(ToData(s_nVol));
			}
		}
	}
}

// {[l擾
extern int GetVolume(void)
{
	return s_nVol;
}

//=================================================================

// {[lATTENUATIONl֕ϊ
static BYTE ToData(UINT vol)
{
	BYTE data = ((MAX_STEP - vol) * VOL_RANGE) / MAX_STEP;

	if (data >= VOL_RANGE) {
		data = VOL_RANGE - 1;
	}
	data += s_nLevel;

	if (data > 96) {
		data = 96 + (data - 96) / 2;
	}
	return data;
}

// f[^M(2Channel)
static void SendData(BYTE data)
{
	BYTE nCh = 0, nMask;
	do
	{
		VR_LDSH_IO = 0;
		DelayUS(100);

		// Address Register(Byte0)
		nMask = 0x80;
		do {
			VR_DATA_IO = (nCh & nMask)? 1 : 0;
			DelayUS(100);
			VR_CLOCK_IO = 1;
			DelayUS(100);
			VR_CLOCK_IO = 0;
		}
		while (nMask >>= 1);

		// Data Register(Byte1)
		nMask = 0x80;
		do {
			VR_DATA_IO = (data & nMask)? 1 : 0;
			DelayUS(100);
			VR_CLOCK_IO = 1;
			DelayUS(100);
			VR_CLOCK_IO = 0;
		}
		while (nMask >>= 1);

		DelayUS(100);
		VR_LDSH_IO = 1;
	}
	while (++nCh < 2);

	VR_DATA_IO = 0;
}
