/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/
#ifndef _HONEY_SYSTEM_H_
#define _HONEY_SYSTEM_H_

#include "Compiler.h"

// Clock
extern DWORD g_dwSysClock;
#define SYS_CLOCK			g_dwSysClock
#define GetSystemClock()		(SYS_CLOCK)
#define GetInstructionClock()	(GetSystemClock()/1)	// for PIC32
#define GetPeripheralClock()	(GetSystemClock()/1)	// for PIC32

// MRF24WB0M
#define _WF_CS_TRIS			TRISBbits.TRISB15
#define _WF_CS_IO			LATBbits.LATB15
#define _WF_RESET_TRIS		TRISBbits.TRISB8
#define _WF_RESET_IO		LATBbits.LATB8
#define _WF_HIBERNATE_TRIS	TRISBbits.TRISB13
#define _WF_HIBERNATE_IO	LATBbits.LATB13
#define _WF_INT_TRIS		TRISDbits.TRISD8
#define _WF_INT_IO			PORTDbits.RD8	// INT1
#define _WF_INT_EDGE		INTCONbits.INT1EP
#define _WF_INT_IE			IEC0bits.INT1IE
#define _WF_INT_IF			IFS0bits.INT1IF
#define _WF_INT_IE_CLEAR	IEC0CLR
#define _WF_INT_IF_CLEAR	IFS0CLR
#define _WF_INT_IE_SET		IEC0SET
#define _WF_INT_IF_SET		IFS0SET
#define _WF_INT_BIT			_IEC0_INT1IE_MASK
#define _WF_INT_IPCSET		IPC1SET
#define _WF_INT_IPCCLR		IPC1CLR
#define _WF_INT_IPC_MASK	(_IPC1_INT1IP_MASK | _IPC1_INT1IS_MASK)
#define _WF_INT_IPC_VALUE	0x0C000000
#define _WF_SSPBUF			SPI4BUF
#define _WF_SPISTAT			SPI4STAT
#define _WF_SPISTATbits		SPI4STATbits
#define _WF_SPICON1			SPI4CON
#define _WF_SPICON1bits		SPI4CONbits
#define _WF_SPI_IE_CLEAR	IEC1CLR
#define _WF_SPI_IF_CLEAR	IFS1CLR
#define _WF_SPI_INT_BITS	(_IEC1_SPI4EIE_MASK | _IEC1_SPI4RXIE_MASK | _IEC1_SPI4TXIE_MASK)
#define _WF_SPI_BRG			SPI4BRG
#define _WF_MAX_SPI_FREQ	25000000UL // 25MHz

// SDCard
#define SDC_CS_TRIS			TRISGbits.TRISG9
#define SDC_CS_IO			LATGbits.LATG9
#define SDC_SPICON			SPI2CONbits
#define SDC_SPISTAT			SPI2STATbits
#define SDC_SPIBUF			SPI2BUF
#define SDC_SPIBRG			SPI2BRG

// LCD-09052
#define LCD_RS_TRIS			TRISFbits.TRISF1
#define LCD_RS_IO			LATFbits.LATF1
#define LCD_E_TRIS			TRISFbits.TRISF0
#define LCD_E_IO			LATFbits.LATF0
#define LCD_DAT_TRISCLR		TRISECLR
#define LCD_DAT_IOCLR		LATECLR
#define LCD_DAT_IO			LATE
#define LCD_DAT_MASK		0x000F
#define BKLIGHT_TRIS		TRISBbits.TRISB5
#define BKLIGHT_IO			LATBbits.LATB5

// VS1053b
#define DEC_XCS_TRIS		TRISDbits.TRISD4
#define DEC_XCS_IO			LATDbits.LATD4
#define DEC_XDCS_TRIS		TRISDbits.TRISD5
#define DEC_XDCS_IO			LATDbits.LATD5
#define DEC_XRESET_TRIS		TRISDbits.TRISD7
#define DEC_XRESET_IO		LATDbits.LATD7
#define DEC_DREQ_TRIS		TRISDbits.TRISD6
#define DEC_DREQ_IO			PORTDbits.RD6
#define DEC_SPICON			SPI3CONbits
#define DEC_SPISTAT			SPI3STATbits
#define DEC_SPIBUF			SPI3BUF
#define DEC_SPIBRG			SPI3BRG

// RDA5800C
#define FM_SDIO_TRIS		TRISDbits.TRISD9
#define FM_SDIO_IO			PORTDbits.RD9
#define FM_SCLK_TRIS		TRISDbits.TRISD10
#define FM_SCLK_IO			LATDbits.LATD10
#define FM_SEN_TRIS			TRISFbits.TRISF3
#define FM_SEN_IO			LATFbits.LATF3

// LM1972M
#define VR_LDSH_TRIS		TRISDbits.TRISD11
#define VR_LDSH_IO			LATDbits.LATD11
#define VR_CLOCK_TRIS		TRISDbits.TRISD10
#define VR_CLOCK_IO			LATDbits.LATD10
#define VR_DATA_TRIS		TRISDbits.TRISD9
#define VR_DATA_IO			LATDbits.LATD9

// MCP4922
#define DAC_CS_TRIS			TRISDbits.TRISD0
#define DAC_CS_IO			LATDbits.LATD0
#define DAC_LDAC_TRIS		TRISCbits.TRISC13
#define DAC_LDAC_IO			LATCbits.LATC13
#define DAC_SPICON			SPI3CONbits
#define DAC_SPISTAT			SPI3STATbits
#define DAC_SPIBUF			SPI3BUF
#define DAC_SPIBRG			SPI3BRG

// Other ports
#define POW_MAIN_TRIS		TRISBbits.TRISB12
#define POW_MAIN_IO			LATBbits.LATB12
#define POW_PAMP_TRIS		TRISEbits.TRISE5
#define POW_PAMP_IO			LATEbits.LATE5
#define POW_RADIO_TRIS		TRISEbits.TRISE4
#define POW_RADIO_IO		LATEbits.LATE4
#define MAINLED_TRIS		TRISEbits.TRISE7
#define MAINLED_IO			LATEbits.LATE7
#define SPMUTE_TRIS			TRISEbits.TRISE6
#define SPMUTE_IO			LATEbits.LATE6
#define CHARGE_TRIS			TRISBbits.TRISB9
#define CHARGE_IO			LATBbits.LATB9
#define POWERSW_TRIS		TRISBbits.TRISB3
#define POWERSW_IO			PORTBbits.RB3
#define POWERSW_CNMASK		_CNEN_CNEN5_MASK
#define ADAPTER_TRIS		TRISBbits.TRISB11
#define ADAPTER_IO			PORTBbits.RB11
#define BATV_TRIS			TRISBbits.TRISB10
#define BATV_PCFG			AD1PCFGbits.PCFG10
#define BATV_AN				10
#define AM_AGC_TRIS			TRISBbits.TRISB4
#define AM_AGC_PCFG			AD1PCFGbits.PCFG4
#define AM_AGC_AN			4
#define SW_TRISSET			TRISBSET
#define SW_IO				PORTB
#define SW_IOMASK			(_PORTB_RB0_MASK | _PORTB_RB1_MASK | _PORTB_RB2_MASK)
#define SW_CNMASK			(_CNEN_CNEN2_MASK | _CNEN_CNEN3_MASK | _CNEN_CNEN4_MASK)


#endif //_HONEY_SYSTEM_H_
