/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "Compiler.h"
#include "GenericTypeDefs.h"
#include "HoneySystem.h"

// Macros
#define OUTPUT			0
#define INPUT			1
#define ANALOG			0
#define DIGITAL			1

#define MAKEBYTE(h, l)	(((0x0F & (h)) << 4) | (0x0F & (l)))
#define LOBYTE(x)		((x) & 0xFF)
#define HIBYTE(x)		(((x) >> 8) & 0xFF)
#define MAKEWORD(h, l)	(((WORD)(h) << 8) | (WORD)l)
#define LOWORD(x)		((x) & 0xFFFF)
#define HIWORD(x)		(((x) >> 16) & 0xFFFF)
#define MAKEDWORD(h, l)	(((DWORD)(h) << 16) | (DWORD)l)

#include "Tick.h"
#define TICKS_OF(s)		(TICK_SECOND * (s))
#define TICKS_OFMS(ms)	((TICK_SECOND * (ms)) / 1000)

#define SW_NONE			0x00000000
#define SW_MODE			0x00000001
#define SW_FUNC			0x00000002
#define SW_PREV			0x00000004
#define SW_NEXT			0x00000008
#define SW_VUP			0x00000010
#define SW_VDOWN		0x00000020

#define CLK_80MHz		80000000UL
#define CLK_40MHz		40000000UL
#define CLK_20MHz		20000000UL
#define CLK_10MHz		10000000UL
#define CLK_8MHz		8000000UL
#define CLK_5MHz		5000000UL
#define CLK_2MHz		2500000UL
#define CLK_1MHz		1250000UL
#define CLK_32KHz		32768UL

#define DEFAULT_CLK		CLK_40MHz
#define SetDefClock()	SetClock(DEFAULT_CLK)
#define CALCBRG(f)		((GetPeripheralClock() - 1UL) / 2UL / (f))

// Functions
extern void SetOffTimer(BOOL fSet);
extern int GetPushingSW(int nSWs);
extern int GetHoldingSW(int nSWs);
extern int GetPressedSW(int nSWs);
extern void ResetInput(void);
extern void SetClock(DWORD dwClock);
extern void PushClock(DWORD dwClock);
extern void PopClock(void);
extern void TaskSleep(void);
extern void Beep(int nFreq, int nTime, BOOL fWait);
extern void INTCtrl(BOOL fEnable);
extern void DelayMS(DWORD dwMs);
extern void DelayUS(DWORD dwUs);

// Setting library
#include "ff.h"
#define DRV_SDC			0

typedef struct _setting_t {
	char buf[128];
	FIL file;
	const char* Str;
	int Num;
	BYTE Addr[6];
} setting_t;

extern BOOL OpenSettings(setting_t* pObj);
extern BOOL ReadSettingStr(setting_t* pObj, const char* pKey);
extern BOOL ReadSettingNum(setting_t* pObj, const char* pKey);
extern BOOL ReadSettingAddr(setting_t* pObj, const char* pKey, BYTE nRadix);
extern void CloseSettings(setting_t* pObj);
extern void LoadData(void);
extern void SaveData(void);

// Application data
#define FNAME_LEN		13
typedef struct _datas_t {
	BYTE nLastMode;
	BYTE nLastVolume;
	BYTE nLastFmMode;
	BYTE nLastFmChan;
	WORD nLastFmFreq;
	BYTE nLastAmMode;
	BYTE nLastAmChan;
	WORD nLastAmFreq;
	BYTE nLastNrChan;
	BYTE nLastMpMode;
	char LastMpDir[FNAME_LEN];
	char LastMpFile[FNAME_LEN];
	char Passphrase[64];
	BYTE SecurityKey[64];
	BYTE DacTbl[((1602 - 531) / 9 + 1) * 6];
} datas_t;
extern datas_t g_Data;

// Global buffer
#define BUFFER_SIZE		(109 * 1024UL)
extern BYTE g_Buffer[BUFFER_SIZE];

// Debug
extern void OutputLog(const char* pLog);

#define DISP_LOG
#ifdef DISP_LOG
#define	LOG(x)	OutputLog(x)
#else
#define	LOG(x)
#endif

#ifdef __DEBUG
extern void _Assert(BOOL cond, const char* msg, int line);
#define ASSERT(x)	_Assert(x, __FUNCTION__, __LINE__)
#define VERIFY(x)	ASSERT(x)
#else
#define ASSERT(x)
#define VERIFY(x)	(void)(x)
#endif


#endif //_MAIN_H_
