/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Network.h"
#include "TCPIP Stack/TCPIP.h"
#include "Display.h"

#define STATE_OFF		0
#define STATE_ERR		1
#define STATE_START		2
#define STATE_CNNCT		3
#define STATE_DHCPC		4
#define STATE_READY		5
#define STATE_STOP		6

///#define WIFILOG(x)		LOG(x)
#define WIFILOG(x)		
//=================================================================

static void InitAppConfig(void);
static BOOL LoadAppConfig(void);
static void WF_Connect(void);
static void ResetNet(int nState);

//=================================================================

APP_CONFIG AppConfig;
static int s_nState = STATE_OFF;
static int s_nEvent = STATE_OFF;

//=================================================================

// 
extern void InitNet(void)
{
	InitAppConfig();

	// X^bN͎̏Ԃ̂łł̓|[g̏̂
	_WF_RESET_IO = 0;
	_WF_RESET_TRIS = OUTPUT;
	_WF_HIBERNATE_IO = 1;
	_WF_HIBERNATE_TRIS = OUTPUT;
	_WF_CS_IO = 1;
	_WF_CS_TRIS = OUTPUT;
}

// ^XN
extern void TaskNet(void)
{
	static BOOL fInitialized = FALSE;
	static DWORD dwLastIP = 0;
	static DWORD dwTimeout = 0;

	switch (s_nState)
	{
	case STATE_START:
		ASSERT(_WF_RESET_IO == 0);
		ASSERT(_WF_HIBERNATE_IO == 1);
		ASSERT(_WF_CS_IO == 1);
		ASSERT(s_nEvent == STATE_OFF);

		// ̎_ŃX^bN̏
		if (!fInitialized)
		{
			LoadAppConfig();
			StackInit();
			fInitialized = TRUE;
		}
		else {
			// nCol[gAɂĂяoKv
			MACInit();
		}

		// ڑ
		dwLastIP = 0;
		WF_Connect();

		s_nState++;
		WIFILOG("Connecting...");
		break;

	case STATE_CNNCT:
		StackTask();
		if (s_nEvent == STATE_READY)
		{
			if ((AppConfig.SecurityMode == WF_SECURITY_WPA_WITH_PASS_PHRASE) ||
				(AppConfig.SecurityMode == WF_SECURITY_WPA2_WITH_PASS_PHRASE) ||
				(AppConfig.SecurityMode == WF_SECURITY_WPA_AUTO_WITH_PASS_PHRASE))
			{
				// ς݈ÍL[͎擾Ă(vZɍő30b邽)
				UINT8 st, id;
				tWFCPElements prof;
				WF_CMGetConnectionState(&st, &id);
				WF_CPGetElements(id, &prof);
	                
				// t@Cւ̕ۑp
				strcpy(g_Data.Passphrase, (char*)AppConfig.SecurityKey);
				memcpy(g_Data.SecurityKey, prof.securityKey, 32);
				SaveData();

				// AppConfig̃Gg𐶐ς݈ÍL[֒u
				memcpy((char*)AppConfig.SecurityKey, (char*)prof.securityKey, 32);
				AppConfig.SecurityKeyLength = 32;
				AppConfig.SecurityMode--;
			}
			WIFILOG("Connected!");
			dwTimeout = TickGet() + TICKS_OF(5);
			s_nState++;
		}
		else if (s_nEvent == STATE_ERR)
		{
			WIFILOG("Connect error");
			ResetNet(STATE_ERR);
		}
		break;

	case STATE_DHCPC:
		if (AppConfig.Flags.bIsDHCPEnabled)
		{
			StackTask();
			if (!DHCPIsBound(0))
			{
				if (TickGet() >= dwTimeout)
				{
					// ^CAEg(5b)
					WIFILOG("DHCP timeout");
					ResetNet(STATE_ERR);
				}
				break;
			}
			else {
				WIFILOG("DHCP Succssfull");
			}
		}
		s_nState++;
		break;

	case STATE_READY:
		StackTask();
		StackApplications();

		// IPAhXω
		if (dwLastIP != AppConfig.MyIPAddr.Val)
		{
			char buf[32];
			GetIPString(buf);
			WIFILOG(buf);
			dwLastIP = AppConfig.MyIPAddr.Val;
		}
		break;
	
	case STATE_STOP:
		ResetNet(STATE_OFF);
		break;

	default:
		ASSERT(s_nState == STATE_OFF || s_nState == STATE_ERR);
		break;
	}
}

// Ԑݒ
extern void EnableNet(BOOL fEnable)
{
	if (fEnable)
	{
		// Lɂ
		switch (s_nState)
		{
		case STATE_OFF:
		case STATE_ERR:
			s_nState = STATE_START;
			break;
		case STATE_START:
		case STATE_CNNCT:
		case STATE_DHCPC:
		case STATE_READY:
			break;
		case STATE_STOP:
			s_nState = STATE_CNNCT;
			break;
		}
	}
	else
	{
		// ɂ
		switch (s_nState)
		{
		case STATE_OFF:
			break;
		case STATE_ERR:
			s_nState = STATE_OFF;
			break;
		case STATE_START:
			s_nState = STATE_OFF;
			break;
		case STATE_CNNCT:
		case STATE_DHCPC:
		case STATE_READY:
			s_nState = STATE_STOP;
			break;
		case STATE_STOP:
			break;
		}
	}
}

// IPAhX()擾
extern void GetIPString(char* pBuf)
{
	sprintf(pBuf, "%d.%d.%d.%d",
		AppConfig.MyIPAddr.v[0], AppConfig.MyIPAddr.v[1],
		AppConfig.MyIPAddr.v[2], AppConfig.MyIPAddr.v[3]);
}

// Ԃ擾
extern int GetNetState(void)
{
	const int States[] = {
		NET_DISABLED,	// STATE_OFF
		NET_ERROR,		// STATE_ERR
		NET_CONNECTING,	// STATE_START
		NET_CONNECTING,	// STATE_CNNCT
		NET_CONNECTING,	// STATE_DHCPC
		NET_ENABLED,	// STATE_READY
		NET_DISABLED,	// STATE_STOP
	};
	ASSERT(0 <= s_nState && s_nState <=6);
	return States[s_nState];
}

// LǂԂ
extern BOOL IsEnabledNet(void)
{
	return (s_nState == STATE_READY);
}

// ǂԂ
extern BOOL IsDisableNet(void)
{
	return (s_nState == STATE_OFF || s_nState == STATE_ERR);
}

//=================================================================

// ݒ菉
static void InitAppConfig(void)
{
	// ftHglݒ
	memset((void*)&AppConfig, 0x00, sizeof(AppConfig));
	
	// Flags
	AppConfig.Flags.bIsDHCPEnabled = TRUE;
	AppConfig.Flags.bInConfigMode = TRUE;

	// MAC Address
	AppConfig.MyMACAddr.v[0] = MY_DEFAULT_MAC_BYTE1;
	AppConfig.MyMACAddr.v[1] = MY_DEFAULT_MAC_BYTE2;
	AppConfig.MyMACAddr.v[2] = MY_DEFAULT_MAC_BYTE3;
	AppConfig.MyMACAddr.v[3] = MY_DEFAULT_MAC_BYTE4;
	AppConfig.MyMACAddr.v[4] = MY_DEFAULT_MAC_BYTE5;
	AppConfig.MyMACAddr.v[5] = MY_DEFAULT_MAC_BYTE6;

	// IP Address
	AppConfig.MyIPAddr.Val = MY_DEFAULT_IP_ADDR_BYTE1 | MY_DEFAULT_IP_ADDR_BYTE2<<8ul
		| MY_DEFAULT_IP_ADDR_BYTE3<<16ul | MY_DEFAULT_IP_ADDR_BYTE4<<24ul;
	AppConfig.DefaultIPAddr.Val = AppConfig.MyIPAddr.Val;

	// Net Mask
	AppConfig.MyMask.Val = MY_DEFAULT_MASK_BYTE1 | MY_DEFAULT_MASK_BYTE2<<8ul
		| MY_DEFAULT_MASK_BYTE3<<16ul | MY_DEFAULT_MASK_BYTE4<<24ul;
	AppConfig.DefaultMask.Val = AppConfig.MyMask.Val;

	// Gateway Address
	AppConfig.MyGateway.Val = MY_DEFAULT_GATE_BYTE1 | MY_DEFAULT_GATE_BYTE2<<8ul
		| MY_DEFAULT_GATE_BYTE3<<16ul | MY_DEFAULT_GATE_BYTE4<<24ul;

	// DNS Address (Primary)
	AppConfig.PrimaryDNSServer.Val = MY_DEFAULT_PRIMARY_DNS_BYTE1 | MY_DEFAULT_PRIMARY_DNS_BYTE2<<8ul
		| MY_DEFAULT_PRIMARY_DNS_BYTE3<<16ul | MY_DEFAULT_PRIMARY_DNS_BYTE4<<24ul;

	// DNS Address (PrSecondary)
	AppConfig.SecondaryDNSServer.Val = MY_DEFAULT_SECONDARY_DNS_BYTE1 | MY_DEFAULT_SECONDARY_DNS_BYTE2<<8ul
		| MY_DEFAULT_SECONDARY_DNS_BYTE3<<16ul | MY_DEFAULT_SECONDARY_DNS_BYTE4<<24ul;

	// HostName
	ASSERT(strlen(MY_DEFAULT_HOST_NAME) < sizeof(AppConfig.NetBIOSName));
	memcpy(AppConfig.NetBIOSName, (ROM void*)MY_DEFAULT_HOST_NAME, strlen(MY_DEFAULT_HOST_NAME));
	FormatNetBIOSName(AppConfig.NetBIOSName);

	// SSID
	AppConfig.SsidLength = strlen(MY_DEFAULT_SSID_NAME);
	ASSERT(AppConfig.SsidLength < sizeof(AppConfig.MySSID));
	memcpy(AppConfig.MySSID, (ROM void*)MY_DEFAULT_SSID_NAME, AppConfig.SsidLength);

	// Netowrk type
	AppConfig.networkType = MY_DEFAULT_NETWORK_TYPE;

	// Security (Mode, Pass/Key, WEP Key index)
	AppConfig.SecurityMode = MY_DEFAULT_WIFI_SECURITY_MODE;
	switch(AppConfig.SecurityMode)
	{
	default:
		// WF_SECURITY_OPEN
		AppConfig.SecurityKeyLength = 0;
		AppConfig.SecurityKey[0] = '\0';
		AppConfig.WepKeyIndex = 0;
		break;

	case WF_SECURITY_WEP_40:
		AppConfig.SecurityKeyLength = 5;
		ASSERT(AppConfig.SecurityKeyLength < sizeof(AppConfig.SecurityKey));
		memcpy(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = MY_DEFAULT_WEP_KEY_INDEX;
		break;

	case WF_SECURITY_WEP_104:
		AppConfig.SecurityKeyLength = 13;
		ASSERT(AppConfig.SecurityKeyLength < sizeof(AppConfig.SecurityKey));
		memcpy(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = MY_DEFAULT_WEP_KEY_INDEX;
		break;

	case WF_SECURITY_WPA_WITH_PASS_PHRASE:
    case WF_SECURITY_WPA_WITH_KEY:
	case WF_SECURITY_WPA2_WITH_PASS_PHRASE:
    case WF_SECURITY_WPA2_WITH_KEY:
	case WF_SECURITY_WPA_AUTO_WITH_PASS_PHRASE:
    case WF_SECURITY_WPA_AUTO_WITH_KEY:
		AppConfig.SecurityKeyLength = strlen(MY_DEFAULT_SECURITY_KEY);
		ASSERT(AppConfig.SecurityKeyLength < sizeof(AppConfig.SecurityKey));
		memcpy(AppConfig.SecurityKey, (ROM void*)MY_DEFAULT_SECURITY_KEY, AppConfig.SecurityKeyLength);
		AppConfig.WepKeyIndex = 0;
		break;
    }
}

// ݒ胍[h
static BOOL LoadAppConfig(void)
{
	setting_t Setting;

	// ݒt@CI[v
	if (!OpenSettings(&Setting))
	{
	    WIFILOG("Settings error");
		return FALSE;
	}

	// MAC address
	if (ReadSettingAddr(&Setting, "MyMACAddr", 16)) {
		memcpy(AppConfig.MyMACAddr.v, Setting.Addr, sizeof(AppConfig.MyMACAddr));
	}
	// IP address
	if (ReadSettingAddr(&Setting, "MyIPAddr", 10)) {
		memcpy(AppConfig.MyIPAddr.v, Setting.Addr, sizeof(AppConfig.MyIPAddr));
		AppConfig.DefaultIPAddr.Val = AppConfig.MyIPAddr.Val;
	}
	// Subnet mask
	if (ReadSettingAddr(&Setting, "MyMask", 10)) {
		memcpy(AppConfig.MyMask.v, Setting.Addr, sizeof(AppConfig.MyMask));
		AppConfig.DefaultMask.Val = AppConfig.MyMask.Val;
	}
	// Default Gateway
	if (ReadSettingAddr(&Setting, "MyGateway", 10)) {
		memcpy(AppConfig.MyGateway.v, Setting.Addr, sizeof(AppConfig.MyGateway));
	}
	// Primary DNS Server
	if (ReadSettingAddr(&Setting, "PrimaryDNSServer", 10)) {
		memcpy(AppConfig.PrimaryDNSServer.v, Setting.Addr, sizeof(AppConfig.PrimaryDNSServer));
	}
	// Secondary DNS Server
	if (ReadSettingAddr(&Setting, "SecondaryDNSServer", 10)) {
		memcpy(AppConfig.SecondaryDNSServer.v, Setting.Addr, sizeof(AppConfig.SecondaryDNSServer));
	}
	// NetBIOS name
	if (ReadSettingStr(&Setting, "NetBIOSName"))
	{
		ASSERT(strlen(Setting.Str) < sizeof(AppConfig.NetBIOSName));
		strcpy((char*)AppConfig.NetBIOSName, Setting.Str);
		FormatNetBIOSName(AppConfig.NetBIOSName);
	}
	// DHCP Enabled (0 or 1)
	if (ReadSettingNum(&Setting, "bIsDHCPEnabled")) {
		AppConfig.Flags.bIsDHCPEnabled = Setting.Num;
	}
	// Wireless SSID
	if (ReadSettingStr(&Setting, "MySSID"))
	{
		AppConfig.SsidLength = strlen(Setting.Str);
		ASSERT(AppConfig.SsidLength < sizeof(AppConfig.MySSID));
		strcpy((char*)AppConfig.MySSID, Setting.Str);
	}
	// Netowrk type (WF_INFRASTRUCTURE:1 or WF_ADHOC:2)
	if (ReadSettingNum(&Setting, "NetowrkType")) {
		AppConfig.networkType = Setting.Num;
	}
	// Security mode (0 or 1 or 2 or 4 or 6 or 8)
	if (ReadSettingNum(&Setting, "SecurityMode")) {
		AppConfig.SecurityMode = Setting.Num;
	}
	// PassPhrase (WEP40: 5x4 or WEP104: 13x4 or WPA PASS_PHRASE)
	if (ReadSettingStr(&Setting, "PassPhrase"))
	{
		AppConfig.SecurityKeyLength = strlen(Setting.Str);
		ASSERT(AppConfig.SecurityKeyLength < sizeof(AppConfig.SecurityKey));
		strcpy((char*)AppConfig.SecurityKey, Setting.Str);
	}
	// WEP Key index (0 or 1 or 2 or 3)
	if (ReadSettingNum(&Setting, "WEPKeyIndex")) {
		AppConfig.WepKeyIndex = Setting.Num;
	}

	// ݒt@CN[Y
	CloseSettings(&Setting);

	return TRUE;
}

// ڑ
static void WF_Connect(void)
{
    UINT8 list[] = MY_DEFAULT_CHANNEL_LIST;
	UINT8 pid;
    
	// ς݈ÍL[ۑĂAppConfig̃Ggu
	if ((AppConfig.SecurityMode == WF_SECURITY_WPA_WITH_PASS_PHRASE) ||
		(AppConfig.SecurityMode == WF_SECURITY_WPA2_WITH_PASS_PHRASE) ||
		(AppConfig.SecurityMode == WF_SECURITY_WPA_AUTO_WITH_PASS_PHRASE))
	{
		if (strcmp((char*)AppConfig.SecurityKey, g_Data.Passphrase) == 0)
		{
			memcpy(AppConfig.SecurityKey, g_Data.SecurityKey, 32);
			AppConfig.SecurityKeyLength = 32;
			AppConfig.SecurityMode--;
		}
	}

	// ڑvt@C쐬
	WF_CPCreate(&pid);

	// p[^ݒ
	WF_CPSetSsid(pid, AppConfig.MySSID, AppConfig.SsidLength);
	WF_CPSetNetworkType(pid, AppConfig.networkType);
	if (AppConfig.networkType == WF_ADHOC) {
        WF_CPSetAdHocBehavior(pid, WF_ADHOC_CONNECT_THEN_START);
	}
	WF_CPSetSecurity(pid, AppConfig.SecurityMode, AppConfig.WepKeyIndex,
		AppConfig.SecurityKey, AppConfig.SecurityKeyLength);

	WF_CASetScanType(MY_DEFAULT_SCAN_TYPE);
	WF_CASetChannelList(list, sizeof(list));
	WF_CASetListRetryCount(MY_DEFAULT_LIST_RETRY_COUNT);
	WF_CASetEventNotificationAction(MY_DEFAULT_EVENT_NOTIFICATION_LIST);
    
	if (MY_DEFAULT_PS_POLL == WF_ENABLED) {
		WF_PsPollEnable(TRUE);
	}
    else {
		WF_PsPollDisable();
    }    
	WF_CASetBeaconTimeout(40);

	// ڑ
	s_nEvent = STATE_CNNCT;
	WF_CMConnect(pid);
}

// Zbg
static void ResetNet(int nState)
{
	// ؒf
	UINT8 st, id;
	WF_CMGetConnectionState(&st, &id);
	if (st != WF_CSTATE_NOT_CONNECTED)
		WF_CMDisconnect();

	// |[g
	_WF_RESET_IO = 0;
	_WF_HIBERNATE_IO = 1;
	_WF_CS_IO = 1;

	// ԏ
	s_nState = nState;
	s_nEvent = STATE_OFF;
}

//=================================================================

// WF_Config.c - WF_ProcessEvent()
void WF_ProcessEvent(UINT8 evt, UINT16 info)
{
	char buf[20];
  
	WFSetFuncState(WF_PROCESS_EVENT_FUNC, WF_ENTERING_FUNCTION);
      
	switch (evt)
	{
	case WF_EVENT_CONNECTION_SUCCESSFUL:
		WIFILOG("WF_Event: 1"); 
		s_nEvent = STATE_READY;
		break;
        
	case WF_EVENT_CONNECTION_FAILED:
		sprintf(buf, "WF_Event: 2 (%d)", info);
		WIFILOG(buf); 
		s_nEvent = STATE_ERR;
		break; 
            
	case WF_EVENT_CONNECTION_TEMPORARILY_LOST:
		sprintf(buf, "WF_Event: 3 (%d)", info);
		WIFILOG(buf); 
		break;
            
	case WF_EVENT_CONNECTION_PERMANENTLY_LOST:
		sprintf(buf, "WF_Event: 4 (%d)", info);
		WIFILOG(buf); 
		ResetNet(STATE_ERR);
		break;

	case WF_EVENT_CONNECTION_REESTABLISHED:
		WIFILOG("WF_Event: 5"); 
		break;

	case WF_EVENT_KEY_CALCULATION_COMPLETE:
		WIFILOG("WF_Event: 6"); 
		break;
            
	case WF_EVENT_SCAN_RESULTS_READY:
		sprintf(buf, "WF_Event: 7 (%d)", info);
		WIFILOG(buf); 
		break;
            
	case WF_EVENT_RX_PACKET_RECEIVED:
		//sprintf(buf, "WF_Event: 8 (%d)", info);
		//WIFILOG(buf); 
		break;
	}        
    
	WFSetFuncState(WF_PROCESS_EVENT_FUNC, WF_LEAVING_FUNCTION);
}    

// WF_Config.c - WF_AssertionFailed()
#ifdef WF_DEBUG
void WF_AssertionFailed(UINT8 moduleNumber, UINT16 lineNumber) 
{
	char buf[32];

	ClearDisplay();
	DisplayText(0, 0, "Assertion!");
	sprintf(buf, "WFASSERT:%d(%d)", moduleNumber, lineNumber);
	DisplayText(0, 1, buf);
	DisplayCtrl(DISPLAY_ON);

	for(;;);
}    
#endif //WF_DEBUG
