/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"

//=================================================================

#define DISPVOL_TIME	TICKS_OF(1)

//=================================================================

static void Initialize(void);
static void Write(BYTE rs, BYTE data);

//=================================================================

static int s_nType = DISPLAY_OFF;
static BOOL s_fDisplay = FALSE;
static DWORD s_dwAuto = 0;

//=================================================================

// 
extern void InitDisplay(void)
{
	// |[g
	LCD_E_IO = 0;
	LCD_E_TRIS = OUTPUT;
	LCD_RS_IO = 0;
	LCD_RS_TRIS = OUTPUT;
	LCD_DAT_IOCLR = LCD_DAT_MASK;
	LCD_DAT_TRISCLR = LCD_DAT_MASK;
	
	// OLED
	Initialize();

	// {[p
	DisplayText(16, 0, "\xD7  Volume:     \xD8");
}

// ^XN
extern void TaskDisplay(void)
{
	// DISPLAY_VOL
	if (s_dwAuto != 0)
	{
		ASSERT(s_nType == DISPLAY_VOL);
		if (TickGet() >= s_dwAuto)
		{
			Write(0, 0b00000010); // Return Home
			s_nType = (s_fDisplay)? DISPLAY_ON : DISPLAY_OFF;
			s_dwAuto = 0;
		}
	}
	else {
		ASSERT(s_nType != DISPLAY_VOL);
	}
}

// NbNύX
extern void OnClockDisp(DWORD dwOld, DWORD dwNew)
{
	// L^ĂTicklC
	if (s_dwAuto != 0)
	{
		DWORD dwTick = TickGet() + 1;
		s_dwAuto = (s_dwAuto > dwTick)?
			(dwTick + ((s_dwAuto - dwTick) * (long long)dwNew) / dwOld) : dwTick;
	}
}

// \NA
extern void ClearDisplay(void)
{
	Write(0, 0b00000001); // Display Clear
	DelayMS(7);
}

// \
extern void DisplayText(int x, int y, const char* pText)
{
	BYTE data = 0x80; // SetDDRAM address
	data |= y << 6; // Line1/2 start address
	data += x;

	Write(0, data);
	for (; *pText != '\0'; pText++) {
		Write(1, *pText);
	}
}

// \
extern void DisplayCtrl(int nType)
{
	switch (nType)
	{
	case DISPLAY_OFF:
		if (s_nType != DISPLAY_OFF)
		{
			s_fDisplay = FALSE;
			Write(0, 0b00001000); // Display Off
			s_nType = DISPLAY_OFF;
		}
		break;

	case DISPLAY_ON:
		if (s_nType != DISPLAY_ON)
		{
			Write(0, 0b00000010); // Return Home
			Write(0, 0b00001100); // Display On
			s_fDisplay = TRUE;
			s_nType = DISPLAY_ON;
			s_dwAuto = 0;
		}
		break;

	case DISPLAY_VOL:
		if (s_nType != DISPLAY_VOL)
		{
			Write(0, 0b00001000); // Display Off
			int i = 0;
			do Write(0, 0b00011000); // Display Shift
			while (++i < 16);
			Write(0, 0b00001100); // Display On
		}
		s_dwAuto = TickGet() + DISPVOL_TIME;
		s_nType = DISPLAY_VOL;
		break;

	case DISPLAY_RESET:
		s_fDisplay = FALSE;
		Write(0, 0b00001000); // Display Off
		s_dwAuto = 0;
		Write(0, 0b00000010); // Return Home
		s_nType = DISPLAY_OFF;
		break;
	}
}

// ݂̐^Cv擾
extern int GetDispType(void)
{
	return s_nType;
}

// {[\
extern void DisplayVolume(int nVol)
{
	static int s_nVol = -1;
	if (nVol != s_nVol)
	{
		char buf[17];
		sprintf(buf, "%02u", nVol);
		DisplayText(27, 0, buf);
		s_nVol = nVol;
	}
	DisplayCtrl(DISPLAY_VOL);
}

//=================================================================

// OLED(8Bit mode)
static void Initialize(void)
{
	Write(0, 0b00111001); // Function Set
	Write(0, 0b00111001); // Function Set
	Write(0, 0b00111001); // Function Set
	Write(0, 0b00111001); // Function Set

	Write(0, 0b00001000); // Display Off
	Write(0, 0b00000001); // Display Clear
	DelayMS(7);
	Write(0, 0b00000110); // Entry Mode Set
}

// OLED֏
static void Write(BYTE rs, BYTE data)
{
	LCD_RS_IO = rs;
	DelayUS(20); // tAS68:20us

	LCD_DAT_IO = data;
	LCD_E_IO = 1;
	DelayUS(250); // tPW68(W):250us

	LCD_E_IO = 0;
	DelayUS(20); // tDH68:20us

	DelayUS(230); // tCY68:500us
}
