/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"
#include "Selector.h"
#include "Amp.h"
#include "Decoder.h"
#include "Network.h"
#include "NetRadio.h"
#include "TCPIP Stack/TCPIP.h"

//=================================================================

#define ST_NONE			0
#define ST_WAIT			1
#define ST_CERR			2
#define ST_CNCT			3
#define ST_PLAY			4
#define MAX_PSET		30

#define COM_NONE		0
#define COM_START		1
#define PLS_CONNECT		2
#define PLS_RETRY		3
#define PLS_OBTAINED	4
#define	PLS_GETHEADERS	5
#define PLS_GETNUMBER1	6
#define PLS_GETNUMBER2	7
#define PLS_GETFILE1	8
#define PLS_GETFILE2	9
#define PLS_DISCONNECT	10
#define STM_CONNECT		11
#define STM_RETRY		12
#define STM_OBTAINED	13
#define STM_GETHEADERS	14
#define STM_GETNAME		15
#define STM_GETMETAINT	16
#define STM_PLAYING		17
#define STM_FOUNDMETA	18
#define STM_GETMETA		19
#define PLS_REDIRECT	20
#define STM_REDIRECT	21
#define COM_STOPPED		22

#define KEEP_SIZE		(16 * 1024UL)

//=================================================================

typedef struct _url_t {
	char host[32];
	char path[96];
	int port;
} url_t;

static void ResetPlay(BOOL fRestert);
static void PlayTask(void);
static void Disconnect(BOOL fForce);
static BOOL ParseUrl(const char* pStr, url_t* pUrl, int nPort);
static void LoadPsets(void);
static void Update(void);

//=================================================================

static struct _preset {
	char name[16];
	char url[128];
} s_Psets[MAX_PSET];
static int s_nPset = 0;

static int s_nState = ST_NONE;
static int s_nChan;
static int s_nNext;
static DWORD s_dwChan;
static DWORD s_dwTick;

static int s_nPlay;
static TCP_SOCKET s_hSocket;

static DWORD s_dwHead;
static DWORD s_dwTail;
static DWORD s_dwSize;
static DWORD s_dwKeep;
static DWORD s_dwPlay;
static int s_nStmIdx;
static int s_nEntries;
static int s_nStmRetry;
static int s_nEmptyCnt;
static BOOL s_fChange;

static struct _playinfo {
	char stream[128];
	int stmlen;
	int bufper;
	int stmtype;
	int bitrate;
} s_Info;

//=================================================================

// 
extern void InitNTR(void)
{
	// 󉽂Ȃ
}

// Jn
extern void StartNTR(void)
{
	ASSERT(s_nState == ST_NONE);

	// ݒ蕜
	s_nChan = g_Data.nLastNrChan;

	// xJn
	s_dwTick = TickGet() + TICKS_OF(3);
	s_nState = ST_WAIT;
	Update();
}

// ~
extern void StopNTR(void)
{
	ASSERT(s_nState != ST_NONE);

	// ~
	if (s_nState >= ST_PLAY)
	{
		ResetPlay(FALSE);
		DEC_Enable(FALSE);
	}
	if (s_nState >= ST_CERR)
	{
		EnableNet(FALSE);
		while (!IsDisableNet()) {
			TaskNet();
		}
	}

	SetDefClock();

	// ݒۑ
	g_Data.nLastNrChan = (BYTE)s_nChan;

	// ~
	s_nState = ST_NONE;
}

// ^XN
extern void TaskNTR(void)
{
	int nCmd;

	switch (s_nState)
	{
	case ST_WAIT:
		ASSERT(GetSystemClock() == DEFAULT_CLK);
		if (GetCommand() == CMD_ENTER) {
			s_dwTick = 0;
		}
		if (TickGet() >= s_dwTick)
		{
			// xJn
			if (s_nPset == 0)
			{
				// vZbg[h
				LoadPsets();
				ASSERT(s_nPset > 0);
			}
			// NbN_E
			SetClock(CLK_20MHz);

			// WiFiڑ
			EnableNet(TRUE);
			s_nState = ST_CNCT;
			Update();
		}
		break;

	case ST_CERR:
		nCmd = GetCommand();
		if(nCmd == CMD_PREV || nCmd == CMD_NEXT)
		{
			// WiFiĐڑ
			EnableNet(TRUE);
			s_nState = ST_CNCT;
			Update();
			Beep(4000, 50, FALSE);
		}
		break;

	case ST_CNCT:
		TaskNet();
		if (IsEnabledNet())
		{
			// ĐJn
			DEC_SetVolume(0); // -0dB
			DEC_Enable(TRUE);
			SlectSource(SRC_DECODER);

			s_nNext = s_nChan;
			s_dwChan = 0;
			s_nPlay = COM_START;
			s_hSocket = INVALID_SOCKET;
			s_nState = ST_PLAY;
		}
		else if (IsDisableNet())
		{
			// WiFiڑG[
			s_nState = ST_CERR;
			Update();
		}
		break;

	case ST_PLAY:
		nCmd = GetCommand();
		if(nCmd != CMD_PREV && nCmd != CMD_NEXT)
		{
			if(nCmd == CMD_ENTER)
			{
				// IǗ\s
				if (s_dwChan != 0)
				{
					Beep(4000, 50, FALSE);

					s_nChan = s_nNext;
					s_dwChan = 0;
					ResetPlay(TRUE);
				}
			}
		}
		else
		{
			// FIǗ\
			if (s_nPset > 0)
			{
				if (nCmd == CMD_NEXT)
				{
					if (++s_nNext >= s_nPset)
						s_nNext = 0;
				}
				else
				{
					if (--s_nNext < 0)
						s_nNext = s_nPset - 1;
				}
				s_dwChan = TickGet() + TICKS_OF(3);
				Update();
				Beep(4000, 50, FALSE);
			}
		}

		// IǗ\
		ASSERT(s_nChan == s_nNext || s_dwChan > 0);
		if (s_dwChan > 0)
		{
			if (TickGet() >= s_dwChan)
			{
				s_dwChan = 0;
				s_nNext = s_nChan;
				Update();
			}
		}

		// Đ^XN
		TaskNet();
		PlayTask();
		break;

	default:
		ASSERT(s_nState == ST_NONE);
	}
}

// R}h󂯓邩ׂ(CMD_ENTER or KEY_PREV or KEY_NEXT)
extern BOOL IsAcptCmdN(int nCmd)
{
	if (nCmd == CMD_ENTER) {
		return (s_nState == ST_WAIT || (s_nState == ST_PLAY && s_dwChan != 0));
	}
	if (nCmd == CMD_PREV || nCmd == CMD_NEXT) {
		return (s_nState >= ST_CERR);
	}
	return FALSE; 
}

//=================================================================

// ĐZbg
static void ResetPlay(BOOL fRestert)
{
	SetMute(TRUE);

	if (fRestert)
	{
		if (s_nPlay == STM_PLAYING)
		{
			// fR[h~
			DEC_StopDecode();
		}
	}

	s_nPlay = (fRestert)? COM_START : COM_NONE;

	if(s_hSocket != INVALID_SOCKET) {
		Disconnect(TRUE);
	}
}

// Đ^XN
static void PlayTask(void)
{
	static url_t s_PlsUri;
	static url_t s_StmUri[8];
	static DWORD s_dwMetaInt;
	static DWORD s_dwMetaPos;
	static WORD s_wMetaSize;
	static DWORD s_dwDisp;
	static int s_nGetCnt;

	DWORD dwSize;
	WORD wReady, wPos;
	BYTE buf[128];

	#define RETRY_IFTIMEOUT(sec, next) \
		if(TickGet() >= s_dwTick) \
		{ \
			Disconnect(FALSE); \
			s_dwTick = TickGet() + TICKS_OF(sec); \
			s_nPlay = next; \
			Update(); \
		}
	#define DECRETRY_IFTIMEOUT(sec) \
		if(TickGet() >= s_dwTick) \
		{ \
			SetMute(TRUE); \
			DEC_StopDecode(); \
			Disconnect(TRUE); \
			s_dwTick = TickGet() + TICKS_OF(sec); \
			s_nPlay = STM_RETRY; \
			Update(); \
		}
	#define PLAY_STOP() \
		{ \
			Disconnect(FALSE); \
			s_nPlay = COM_STOPPED; \
			Update(); \
		}

	switch (s_nPlay)
	{
	case STM_PLAYING:

		// f[^](1)
		ToDecoder();

		// r؂ꂪꍇXg[ύX
		if (s_fChange)
		{
			SetMute(TRUE);
			DEC_StopDecode();
			Disconnect(TRUE);
			s_nStmIdx = (s_nStmIdx + 1) % s_nEntries;
			s_nStmRetry = 0;
			s_nPlay = STM_CONNECT;
			Update();
			break;
		}

		// f[^M
		if (s_dwSize < BUFFER_SIZE)
		{
			wReady = TCPIsGetReady(s_hSocket);
			if (wReady > 0)
			{
				// L^ʒuZbg
				if (s_dwTail >= BUFFER_SIZE)
				{
					ASSERT(s_dwHead > 0 || s_dwSize == 0);
					s_dwTail = 0;
				}
				// ATCY
				if (s_dwHead <= s_dwTail) {
					dwSize = BUFFER_SIZE - s_dwTail;
				}
				else {
					dwSize = s_dwHead - s_dwTail;
				}
				// L^\TCY
				if (dwSize > wReady) {
					dwSize = wReady;
				}
				// ^f[^
				if (s_dwMetaInt > 0)
				{
					ASSERT(s_dwMetaPos > 0);
					if (dwSize > s_dwMetaPos)
						dwSize = s_dwMetaPos;
				}
				// M
				VERIFY(TCPGetArray(s_hSocket, g_Buffer + s_dwTail, dwSize) == dwSize);
				s_dwSize += dwSize;
				s_dwTail += dwSize;

				// ^f[^o
				if (s_dwMetaInt > 0)
				{
					s_dwMetaPos -= dwSize;
					if (s_dwMetaPos == 0)
						s_nPlay = STM_FOUNDMETA;
				}
		
				s_dwTick = TickGet() + TICKS_OF(3);
			}
			else
			{
				DECRETRY_IFTIMEOUT(3);
				break;
			}
		}

		// f[^](2)
		//ToDecoder();

		//@ԈXV(100ms)
		if (TickGet() >= s_dwDisp)
		{
			s_dwDisp = TickGet() + TICKS_OFMS(100);
			s_Info.bufper = (s_dwSize * 100) /  BUFFER_SIZE;
			Update();
		}
		break;

	case COM_START:
		// vCXg擾Jn
		ASSERT(0 <= s_nChan && s_nChan < MAX_PSET);
		if (!ParseUrl(s_Psets[s_nChan].url, &s_PlsUri, 80))
		{
			s_nPlay = COM_STOPPED;
			Update();
			break;
		}
		s_nPlay = PLS_CONNECT;
		Update();
		break;

	case PLS_CONNECT:
		// ڑ
		ASSERT(s_hSocket == INVALID_SOCKET);
		s_hSocket = TCPOpen((DWORD)s_PlsUri.host, TCP_OPEN_RAM_HOST, s_PlsUri.port, TCP_PURPOSE_MP3_CLIENT);
		if(s_hSocket == INVALID_SOCKET) {
			return;
		}
		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = PLS_OBTAINED;
		break;

	case PLS_RETRY:
		// w莞ԌɍĐڑ
		if(TickGet() >= s_dwTick) {
			s_nPlay = PLS_CONNECT;
		}
		break;

	case PLS_OBTAINED:
		if(!TCPIsConnected(s_hSocket))
		{
			RETRY_IFTIMEOUT(3, PLS_RETRY);
			break;
		}
		if(TCPIsPutReady(s_hSocket) < 160) {
			break;
		}
		// HTTPNGXg
		TCPPutROMString(s_hSocket, (ROM BYTE*)"GET " );
		TCPPutString   (s_hSocket, (BYTE*)s_PlsUri.path);
		TCPPutROMString(s_hSocket, (ROM BYTE*)" HTTP/1.0\r\nHost: ");
		TCPPutString   (s_hSocket, (BYTE*)s_PlsUri.host);
		TCPPutROMString(s_hSocket, (ROM BYTE*)"\r\nConnection: close\r\n\r\n" );
		TCPFlush(s_hSocket);

		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = PLS_GETHEADERS;
		break;

	case PLS_GETHEADERS:
		// _CNg
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\nLocation: http://", 18, 0, TRUE);
		if (wPos != 0xFFFF)
		{
			TCPGetArray(s_hSocket, NULL, wPos + 11);
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = PLS_REDIRECT;
			break;
		}
		// wb_[I
		wPos =  TCPFindROMArray(s_hSocket, (ROM BYTE*)"\r\n\r\n", 4, 0, FALSE); 
		if (wPos != 0xFFFF)
		{
			TCPGetArray(s_hSocket, NULL, wPos + 4);
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = PLS_GETNUMBER1;
			break;
		}
		// p
		wReady = TCPIsGetReady(s_hSocket);
		if (wReady > 18) {
			TCPGetArray(s_hSocket, NULL, wReady - 18);
		}
		RETRY_IFTIMEOUT(3, PLS_RETRY)
		break;

	case PLS_GETNUMBER1:
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"numberofentries=", 16, 0, TRUE);
		if(wPos == 0xFFFF)
		{
			wReady = TCPIsGetReady(s_hSocket);
			if(wReady > 16) {
				TCPGetArray(s_hSocket, NULL, wReady - 16);
			}
			RETRY_IFTIMEOUT(3, PLS_RETRY);
			break;
		}
		TCPGetArray(s_hSocket, NULL, wPos + 16);
		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = PLS_GETNUMBER2;
		break;

	case PLS_GETNUMBER2:
		wPos = TCPFind(s_hSocket, 0x0A, 0, FALSE);
		if(wPos == 0xFFFF)
		{
			RETRY_IFTIMEOUT(3, PLS_RETRY);
			break;
		}
		ASSERT((wPos + 1) <= sizeof(buf));
		TCPGetArray(s_hSocket, buf, wPos + 1);
		buf[wPos] = '\0';
		s_nEntries = atoi((char*)buf);
		if (s_nEntries == 0)
		{
			PLAY_STOP();
			break;
		}
		s_nGetCnt = 0;
		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = PLS_GETFILE1;
		break;

	case PLS_GETFILE1:
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"http://", 7, 0, TRUE);
		if(wPos == 0xFFFF)
		{
			wReady = TCPIsGetReady(s_hSocket);
			if(wReady > 7) {
				TCPGetArray(s_hSocket, NULL, wReady - 7);
			}
			RETRY_IFTIMEOUT(3, PLS_RETRY);
			break;
		}
		TCPGetArray(s_hSocket, NULL, wPos);
		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = PLS_GETFILE2;
		break;

	case PLS_GETFILE2:
		wPos = TCPFind(s_hSocket, 0x0A, 0, FALSE);
		if(wPos == 0xFFFF)
		{
			RETRY_IFTIMEOUT(3, PLS_RETRY);
			break;
		}
		ASSERT((wPos + 1) <= sizeof(buf));
		TCPGetArray(s_hSocket, buf, wPos + 1);
		buf[wPos] = '\0';
		if (!ParseUrl((char*)buf, s_StmUri + s_nGetCnt, 8000))
		{
			PLAY_STOP();
			break;
		}
		if (++s_nGetCnt < s_nEntries)
		{
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = PLS_GETFILE1;
			break;
		}
		s_nStmIdx = 0;
		s_nStmRetry = 0;
		s_nPlay = PLS_DISCONNECT;
		break;

	case PLS_DISCONNECT:
		// vCXg擾
		Disconnect(TRUE);
		s_nPlay = STM_CONNECT;
		Update();
		break;

	case STM_CONNECT:
		// ڑ
		ASSERT(s_hSocket == INVALID_SOCKET);
		s_hSocket = TCPOpen((DWORD)s_StmUri[s_nStmIdx].host, TCP_OPEN_RAM_HOST, s_StmUri[s_nStmIdx].port, TCP_PURPOSE_MP3_CLIENT);
		if(s_hSocket == INVALID_SOCKET) {
			return;
		}
		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = STM_OBTAINED;
		break;

	case STM_RETRY:
		if (s_nEntries > 1 && s_nStmRetry >= 2)
		{
			// Xg[ύX
			s_nStmIdx = (s_nStmIdx + 1) % s_nEntries;
			s_nStmRetry = 0;
			s_nPlay = STM_CONNECT;
			Update();
		}
		else if (TickGet() >= s_dwTick)
		{
			// w莞ԌɍĐڑ
			s_nStmRetry++;
			s_nPlay = STM_CONNECT;
			Update();
		}
		break;

	case STM_OBTAINED:
		if(!TCPIsConnected(s_hSocket))
		{
			RETRY_IFTIMEOUT(3, STM_RETRY);
			break;
		}
		if(TCPIsPutReady(s_hSocket) < 160) {
			break;
		}
		// HTTPNGXg
		TCPPutROMString(s_hSocket, (ROM BYTE*)"GET " );
		TCPPutString   (s_hSocket, (BYTE*)s_StmUri[s_nStmIdx].path);
		TCPPutROMString(s_hSocket, (ROM BYTE*)" HTTP/1.0\r\nHost: ");
		TCPPutString   (s_hSocket, (BYTE*)s_StmUri[s_nStmIdx].host);
		TCPPutROMString(s_hSocket, (ROM BYTE*)"\r\nAccept: */*\r\nConnection: close\r\n\r\n" );
		//TCPPutROMString(s_hSocket, (ROM BYTE*)"\r\nAccept: */*\r\nIcy-MetaData:1\r\nConnection: close\r\n\r\n" );
		TCPFlush(s_hSocket);

		s_Info.stream[0] = '\0';
		s_Info.stmlen = 0;
		s_dwMetaInt = 0;
		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = STM_GETHEADERS;
		break;

	case STM_GETHEADERS:
		// _CNg
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\nLocation: http://", 18, 0, TRUE);
		if (wPos != 0xFFFF)
		{
			TCPGetArray(s_hSocket, NULL, wPos + 11);
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = STM_REDIRECT;
			break;
		}
		// icy-name
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\nicy-name:", 10, 0, TRUE); 
		if (wPos != 0xFFFF)
		{
			TCPGetArray(s_hSocket, NULL, wPos + 10);
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = STM_GETNAME;
			break;
		}
		// icy-metaint
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\nicy-metaint:", 13, 0, TRUE); 
		if (wPos != 0xFFFF)
		{
			TCPGetArray(s_hSocket, NULL, wPos + 13);
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = STM_GETMETAINT;
			break;
		}
		// wb_[I
		wPos =  TCPFindROMArray(s_hSocket, (ROM BYTE*)"\r\n\r\n", 4, 0, FALSE); 
		if (wPos != 0xFFFF)
		{
			TCPGetArray(s_hSocket, NULL, wPos + 4);

			// ĐJn
			s_dwMetaPos = s_dwMetaInt;
			s_dwHead = 0;
			s_dwTail = 0;
			s_dwSize = 0;
			s_dwKeep = KEEP_SIZE;
			s_nEmptyCnt = 0;
			s_fChange = FALSE;
			s_dwPlay = 0;
			s_Info.bufper = 0;
			s_Info.stmtype = 0;
			s_Info.bitrate = 0;
			s_dwTick = TickGet() + TICKS_OF(5);
			s_nPlay = STM_PLAYING;
			s_dwDisp = 0;
			Update();
			break;
		}
		// p
		wReady = TCPIsGetReady(s_hSocket);
		if (wReady > 18) {
			TCPGetArray(s_hSocket, NULL, wReady - 18);
		}
		RETRY_IFTIMEOUT(3, STM_RETRY)
		break;

	case STM_GETNAME:
		while (TCPFindEx(s_hSocket, ' ', 0, 1, FALSE ) == 0) {
			TCPGet(s_hSocket, NULL );
		}
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\r\n", 2, 0, FALSE);
		if (wPos == 0xFFFF)
		{
			RETRY_IFTIMEOUT(3, STM_RETRY)
			break;
		}
		ASSERT(wPos < sizeof(s_Info.stream));
		TCPGetArray(s_hSocket, (BYTE*)s_Info.stream, wPos);
		s_Info.stream[wPos] = '\0';
		s_Info.stmlen = wPos;

		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = STM_GETHEADERS;
		break;

	case STM_GETMETAINT:
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\r\n", 2, 0, FALSE);
		if (wPos == 0xFFFF)
		{
			RETRY_IFTIMEOUT(3, STM_RETRY)
			break;
		}
		TCPGetArray(s_hSocket, buf, wPos);
		buf[wPos] = '\0';
		s_dwMetaInt = atol((char*)buf);

		s_dwTick = TickGet() + TICKS_OF(5);
		s_nPlay = STM_GETHEADERS;
		break;

	case STM_FOUNDMETA:
		if(!TCPIsGetReady(s_hSocket))
		{
			DECRETRY_IFTIMEOUT(3);
			break;
		}
		// ^f[^TCY擾
		VERIFY(TCPGet(s_hSocket, (BYTE*)&s_wMetaSize));
		s_wMetaSize <<= 4;

		s_dwTick = TickGet() + TICKS_OF(3);
		s_nPlay = STM_GETMETA;
		// No break

	case STM_GETMETA:
		// f[^]
		ToDecoder();

		if(TCPIsGetReady(s_hSocket) < s_wMetaSize)
		{
			DECRETRY_IFTIMEOUT(3);
			break;
		}
		// ^f[^ǂݎ̂
		TCPGetArray(s_hSocket, NULL, s_wMetaSize);
		s_dwMetaPos = s_dwMetaInt;

		s_dwTick = TickGet() + TICKS_OF(3);
		s_nPlay = STM_PLAYING;
		break;

	case PLS_REDIRECT:
		// _CNg
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\r\n", 2, 0, FALSE);
		if (wPos == 0xFFFF)
		{
			RETRY_IFTIMEOUT(3, PLS_RETRY)
			break;
		}
		ASSERT(wPos < sizeof(buf));
		TCPGetArray(s_hSocket, buf, wPos);
		buf[wPos] = '\0';
		if (!ParseUrl((char*)buf, &s_PlsUri, 80))
		{
			PLAY_STOP();
			break;
		}
		Disconnect(TRUE);
		s_nPlay = PLS_CONNECT;
		break;

	case STM_REDIRECT:
		// _CNg
		wPos = TCPFindROMArray(s_hSocket, (ROM BYTE*)"\r\n", 2, 0, FALSE);
		if (wPos == 0xFFFF)
		{
			RETRY_IFTIMEOUT(3, STM_RETRY)
			break;
		}
		ASSERT(wPos < sizeof(buf));
		TCPGetArray(s_hSocket, buf, wPos);
		buf[wPos] = '\0';
		if (!ParseUrl((char*)buf, s_StmUri + s_nStmIdx, 8000))
		{
			PLAY_STOP();
			break;
		}
		s_nPlay = PLS_DISCONNECT;
		break;

	case COM_STOPPED:
		// Ȃ
		break;

	default:
		ASSERT(s_nPlay == ST_NONE);
	}
}

// f[^]
extern void ToDecoder(void)
{
	if (s_nPlay == STM_PLAYING)
	{
		DWORD dwSize;

		BOOL fTurn, fOnce = TRUE;
		do {
			 fTurn = FALSE;
			if (s_dwSize >= s_dwKeep)
			{
				if (DEC_IsDREQ())
				{
					// oʒuZbg
					if (s_dwHead >= BUFFER_SIZE)
					{
						ASSERT(s_dwTail > 0);
						s_dwHead = 0;
					}
					// ATCY
					if (s_dwHead < s_dwTail) {
						dwSize = s_dwTail - s_dwHead;
					}
					else {
						dwSize = BUFFER_SIZE - s_dwHead;
						fTurn = (dwSize < 2048) && fOnce;
						fOnce = FALSE;
					}

					// Đ(32ByteP)
					dwSize = DEC_SendData32(g_Buffer + s_dwHead, dwSize & 0xFFFFFFE0);
					s_dwSize -= dwSize;
					s_dwHead += dwSize;

					// obt@O
					if (s_dwKeep == KEEP_SIZE)
					{
						s_dwKeep = 2048;
						s_dwPlay = dwSize;
					}
					else if (IsMute())
					{
						// Ă擪f[^߂Ń~[g
						s_dwPlay += dwSize;
						if (s_dwPlay >= 2048)
						{
							SetMute(FALSE);
							s_Info.stmtype = DEC_GetStreamInfo(&s_Info.bitrate);
						}
					}
				}
			}
			else if (s_dwKeep < KEEP_SIZE)
			{
				if (++s_nEmptyCnt < 3 || s_nEntries == 1) {
					// ēxobt@O
					s_dwKeep = KEEP_SIZE;
				}
				else {
					// 3Xg[ύX
					s_fChange = TRUE;
				}
			}
		}
		while (fTurn);
	}
}

// Sɐؒf
static void Disconnect(BOOL fForce)
{
	ASSERT(s_hSocket != INVALID_SOCKET);

	// Close socket on our end after giving a chance for any remaining 
	// RX data to be consumed.  If the RX data count doesn't change 
	// between two iterations, then we can assume that the application 
	// doesn't need any of the RX data, so we can close the socket on 
	// our end now.
	WORD wLastRX = 0xFFFF;
	for(;;)
	{
		WORD wRX = TCPIsGetReady(s_hSocket);
		if (wRX != wLastRX)
		{
			TaskNet();
			wLastRX = wRX;
			continue;
		}
		break;
	}

	// ɐؒfĂFIN҂Ȃ悤ɂ(Ô߂̑[u)
	fForce |= !TCPIsConnected(s_hSocket);

	// Send out a FIN disconnection request
	TCPDisconnect(s_hSocket);

	// Do this a second time to force an immediate disconnect via a RST
	// packet.  This keeps the user interface snappy by not waiting for
	// the remote node to send us a FIN as well.
	if (fForce) {
		TCPDisconnect(s_hSocket);
	}

	s_hSocket = INVALID_SOCKET;
}

// URLp[X
static BOOL ParseUrl(const char* pStr, url_t* pUrl, int nPort)
{
	if (pStr[0] != 'h') return FALSE;
	if (pStr[1] != 't') return FALSE;
	if (pStr[2] != 't') return FALSE;
	if (pStr[3] != 'p') return FALSE;
	if (pStr[4] != ':') return FALSE;
	if (pStr[5] != '/') return FALSE;
	if (pStr[6] != '/') return FALSE;

	const char* p = pStr + 7;
	const char* h = p;
	for(pUrl->port = nPort; ; p++)
	{
		if (*p == ':' || *p == '/' || *p == '\0')
		{
			int s = p - h;
			if (s <= 0) {
				return FALSE;
			}
			ASSERT(s < sizeof(pUrl->host));
			memcpy(pUrl->host, h, s);
			pUrl->host[s] = '\0';

			if (*p == ':')
			{
				int n = 0;
				for(p++;;p++)
				{
					if ('0' <= *p && *p <= '9')
					{
						n = n * 10 + (*p - '0');
						continue;
					}
					pUrl->port = n;
					break;
				}
			}
			break;
		}
	}
	if (*p == '\0')
	{
		pUrl->path[0] = '/';
		pUrl->path[1] = '\0';
		return TRUE;
	}
	
	ASSERT(strlen(p) < sizeof(pUrl->path));
	strcpy(pUrl->path, p);
	return TRUE;
}

//=================================================================

// vZbg[h
static void LoadPsets(void)
{
	// ݒI[v
	setting_t Setting;
	if (!InitSettings(&Setting)) {
		return;
	}

	// ݒǂݏo
	for (s_nPset = 0; s_nPset < MAX_PSET; s_nPset++)
	{
		char keyU[10];
		sprintf(keyU, "NT%02d-URL", s_nPset + 1);
		if (ReadSettingStr(&Setting, keyU))
		{
			ASSERT(strlen(Setting.Str) < sizeof(s_Psets[s_nPset].url));
			strcpy(s_Psets[s_nPset].url, Setting.Str);

			char keyN[10];
			sprintf(keyN, "NT%02d-Name", s_nPset + 1);
			if (ReadSettingStr(&Setting, keyN))
			{
				ASSERT(strlen(Setting.Str) < sizeof(s_Psets[s_nPset].name));
				strcpy(s_Psets[s_nPset].name, Setting.Str);
				continue;
			}
		}
		break;
	}

	// Xg`l폜Ăꍇ
	ASSERT(s_nPset > 0);
	if (s_nChan >= s_nPset)
		s_nChan = s_nPset - 1;
}

// \XV
static void Update(void)
{
	static DWORD s_dwLastChan;
	static DWORD s_dwLastIdx;
	static int s_nLastInfo;
	static int s_nInfoType;
	static int s_nLastType;
	static int s_nPosition;
	static int s_nDspCount;

	char buf[129];

	if (s_nState != ST_PLAY)
	{
		switch (s_nState)
		{
		case ST_WAIT:
			/* Internet Radio   */
			/*                  */
			DisplayText(0, 0, "\xD8Internet Radio ");
			DisplayText(0, 1, "                ");
			DisplayCtrl(DISPLAY_ON);
			break;
		case ST_CNCT:
			/* NR:              */
			/* Wi-Fi Connecting */
			DisplayText(0, 0, "NR:             ");
			DisplayText(0, 1, "Wi-Fi Connecting");
			break;
		case ST_CERR:
			/* NR:              */
			/* Wi-Fi Error.     */
			DisplayText(0, 1, "Wi-Fi Error.    ");
			break;
		}
		s_dwLastChan = (DWORD)-1;
		s_dwLastIdx = (DWORD)-1;
		s_nLastInfo = 0;
		return;
	}

	// `l{\
	if (s_dwChan != 0)
	{
		// I\
		if (s_dwLastChan != s_dwChan)
		{
			/* NR:>NN           */
			/* SSSSSSSSSSSSSSSS */
			sprintf(buf, "\x7E%02u          ", s_nNext + 1);
			DisplayText(3, 0, buf);
			sprintf(buf, "%s                ", s_Psets[s_nNext].name);
			buf[16] = '\0';
			DisplayText(0, 1, buf);
			s_dwLastChan = s_dwChan;
			s_nLastInfo = 0;
		}
		return;
	}
	if (s_dwLastChan != 0 || s_dwLastIdx != s_nStmIdx)
	{
		/* NR:NN-N          */
		/*                  */
		sprintf(buf, "%02u-%u", s_nChan + 1, s_nStmIdx + 1);
		DisplayText(3, 0, buf);
		s_dwLastChan = s_dwChan;
		s_dwLastIdx = s_nStmIdx;
	}

	// \
	if (s_nPlay != STM_PLAYING && s_nPlay != STM_FOUNDMETA)
	{
		switch (s_nPlay)
		{
		case PLS_CONNECT:
			/* Getting PlayList */
			DisplayText(0, 1, "Getting PlayList");
			break;
		case PLS_RETRY:
			/* Retry waiting... */
			DisplayText(0, 1, "Retry waiting...");
			break;
		case STM_CONNECT:
			/* Getting Stream.. */
			DisplayText(0, 1, "Getting Stream..");
			break;
		case STM_RETRY:
			/* Retry waiting... */
			DisplayText(0, 1, "Retry waiting...");
			break;
		case COM_STOPPED:
			/* - Can't play. -  */
			DisplayText(0, 1, "- Can't play. -  ");
			break;
		default:
			ASSERT(FALSE);
		}
		s_nInfoType = 0;
		s_nLastType = 0;
		s_nPosition = 0;
		s_nDspCount = 0;
		return;
	}

	// rbg[g
	if (s_nLastInfo != (s_Info.stmtype + s_Info.bitrate))
	{
		if (s_Info.stmtype != 0)
		{
			/* NR:NN-N NNN NNNk */
			static const char* StmTypes[] = { "WAV", "AAC ", "WMA ", "MID", "Ogg", "MP3" };
			DisplayText(8, 0, StmTypes[s_Info.stmtype - 1]);
			sprintf(buf, (s_Info.bitrate != 0)? "%uk" : "    ", s_Info.bitrate);
			DisplayText(12, 0, buf);
		}
		else {
			DisplayText(8, 0, "        ");
		}
		s_nLastInfo = s_Info.stmtype + s_Info.bitrate;
	}

	if (s_nInfoType == 0)
	{
		// obt@O\^Cg\
		if (s_Info.bufper >= 50)
			s_nInfoType = 1;
	}
	else
	{
		// ^Cg\obt@O\
		if (s_Info.bufper < 20)
			s_nInfoType = 0;
	}

	if (s_nInfoType == 0)
	{
		/* NR: NN NNNk      */
		/* Buffer: NN%  */
		const char* BufBar[5] = {
			"          ",
			"\xFF          ",
			"\xFF\xFF         ",
			"\xFF\xFF\xFF        ",
			"\xFF\xFF\xFF\xFF       ",
		};
		ASSERT(s_Info.bufper < 50);
		sprintf(buf, "Buffer:%3u%% %s", s_Info.bufper, BufBar[s_Info.bufper / 10]);
		DisplayText(0, 1, buf);
	}
	else
	{
		/* NR: NN NNNk      */
		/* SSSSSSSSSSSSSSSS */
		ASSERT(strlen(s_Info.stream) == s_Info.stmlen);
		if (s_nDspCount < 10 || s_Info.stmlen <= 16)
		{
			// 擪\
			if (s_nLastType == 0)
			{
				sprintf(buf, "%s                ", s_Info.stream);
				buf[16] = '\0';
				DisplayText(0, 1, buf);
			}
		}
		else if (s_nDspCount & 1) // u
		{
			// }[L[\
			int nLeft = 0;
			int nPos = s_nPosition % (s_Info.stmlen + 3);
			if (nPos < s_Info.stmlen)
			{
				nLeft = s_Info.stmlen - nPos;
				if (nLeft > 16)
					nLeft = 16;

				memcpy(buf, s_Info.stream + nPos, nLeft);
				buf[nLeft] = '\0';
				DisplayText(0, 1, buf);
			}
			if (nLeft < 16)
			{
				int nSpace = (nPos > s_Info.stmlen)?
					3 - nPos + s_Info.stmlen : 3;
				if (nSpace > (16 - nLeft))
					nSpace = 16 - nLeft;

				memcpy(buf, "   ", nSpace);
				buf[nSpace] = '\0';
				DisplayText(nLeft, 1, buf);
				nLeft += nSpace;
			}
			if (nLeft < 16)
			{
				int nLen = 16 - nLeft;
				memcpy(buf, s_Info.stream, nLen);
				buf[nLen] = '\0';
				DisplayText(nLeft, 1, buf);
			}

			s_nPosition++;
		}

		s_nDspCount++;
	}
	
	s_nLastType = s_nInfoType;
}
