/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "TCPIP Stack/TCPIP.h"
#include "EEPRom.h"

//=================================================================

#define SETTINGFILE		"SETTINGS.INI"
#define SETTINGDATA		"SETTINGS.DAT"
#define DUMMY_HANDLE	(FTPH)777

//=================================================================

static BOOL ExistSetting(int nType);
static BOOL IsFilePath(const char* pTest, const char* pPath);

//=================================================================

static struct flist {
	int path;
	int count;
	BOOL detail;
} s_List;

static int s_nOpen = 0;
static sfile_t s_File;
static UINT s_nFp = 0;

//=================================================================

// [U[F
extern BOOL FtpVerify(char* pUser, char* Pass)
{
	// SĎ󂯓
	return TRUE;
}

// JgfBNgύX
extern BOOL FtpChDir(char* pDir)
{
	// s(Ƀ[g)
	return (strcmp(pDir, "/") == 0);
}

// \^Cvݒ
extern BOOL FtpSetType(char* pType)
{
	// SĎ󂯓
	return TRUE;
}

// I[v
extern FTPH FtpOpen(char* pFile, int nType)
{
	if (s_nOpen != 0)
	{
		ASSERT(FALSE);
		return NULL;
	}

	switch (nType)
	{
	case FTP_FREAD:
		if (IsFilePath(pFile, SETTINGFILE))
		{
			VERIFY(ReadEEP(OFFSET_FILE, (BYTE*)&s_File, sizeof(s_File)));
			if (s_File.dwMarking == FILE0_VALID)
			{
				s_nFp = 0;
				s_nOpen++;
				return DUMMY_HANDLE;
			}
		}
		break;

	case FTP_FCREATE:
		if (IsFilePath(pFile, SETTINGFILE))
		{
			s_File.dwMarking = FILE0_VALID;
			s_File.wDataSize = 0;
			VERIFY(WriteEEP(OFFSET_FILE, (BYTE*)&s_File, sizeof(s_File)));

			s_nFp = 0;
			s_nOpen++;
			return DUMMY_HANDLE;
		}
		break;

	case FTP_FAPPEND:
		if (IsFilePath(pFile, SETTINGFILE))
		{
			VERIFY(ReadEEP(OFFSET_FILE, (BYTE*)&s_File, sizeof(s_File)));
			if (s_File.dwMarking != FILE0_VALID)
			{
				s_File.dwMarking = FILE0_VALID;
				s_File.wDataSize = 0;
				VERIFY(WriteEEP(OFFSET_FILE, (BYTE*)&s_File, sizeof(s_File)));
				s_nFp = 0;
			}
			else {
				s_nFp =s_File. wDataSize;
			}
			s_nOpen++;
			return DUMMY_HANDLE;
		}
		break;

	default:
		ASSERT(FALSE);
	}

	return NULL;
}

// N[Y
extern void FtpClose(FTPH hFile)
{
	ASSERT(hFile == DUMMY_HANDLE);
	if (s_nOpen != 1)
	{
		ASSERT(FALSE);
		return;
	}
	s_nOpen--;
}

// [h
extern BOOL FtpRead(FTPH hFile, BYTE* pBuf, UINT nSize, UINT* pSize)
{
	ASSERT(hFile == DUMMY_HANDLE);
	ASSERT(nSize > 0);

	ASSERT(s_File.dwMarking == FILE0_VALID);
	ASSERT(s_File.wDataSize <= (MAX_FILE - sizeof(sfile_t)));
	ASSERT(s_File.wDataSize >= s_nFp);
	
	UINT nRemain = s_File.wDataSize - s_nFp;
	if (nSize > nRemain) {
		nSize = nRemain;
	}
	if (nSize > 0)
	{
		VERIFY(ReadEEP(OFFSET_FILE + sizeof(sfile_t) + s_nFp, pBuf, nSize));
		s_nFp += nSize;
	}

	*pSize = nSize;
	return TRUE;
}

// Cg
extern BOOL FtpWrite(FTPH hFile, BYTE* pBuf, UINT nSize)
{
	ASSERT(hFile == DUMMY_HANDLE);
	ASSERT(nSize > 0);

	ASSERT(s_File.dwMarking == FILE0_VALID);
	ASSERT(s_File.wDataSize <= (MAX_FILE - sizeof(sfile_t)));
	ASSERT(s_File.wDataSize >= s_nFp);

	UINT nRemain = MAX_FILE - sizeof(sfile_t) - s_nFp;
	if (nSize > nRemain) {
		return FALSE;
	}
	VERIFY(WriteEEP(OFFSET_FILE + sizeof(sfile_t) + s_nFp, pBuf, nSize));
	s_nFp += nSize;

	if (s_nFp > s_File.wDataSize)
	{
		s_File.wDataSize = s_nFp;
		VERIFY(WriteEEP(OFFSET_FILE, (BYTE*)&s_File, sizeof(s_File)));
	}

	return TRUE;
}

// t@C(J)
extern FTPH FtpOpenList(char* pPath, BOOL fDetail)
{
	// [gƌŒt@ĈݔF
	if (strcmp(pPath, "/") == 0) {
		s_List.path = 0;
	}
	else if (IsFilePath(pPath, SETTINGFILE) && ExistSetting(0)) {
		s_List.path = 1;
	}
	else if (IsFilePath(pPath, SETTINGDATA) && ExistSetting(1)) {
		s_List.path = 2;
	}
	else {
		return NULL;
	}

	if (s_List.path > 0)
	{
		if (!fDetail)
			return NULL;
	}
	s_List.count = 0;
	s_List.detail = fDetail;

	return &s_List;
}

// t@C(ꍀڎ擾)
extern int FtpGetNext(FTPH hList, char* pBuf, UINT* pSize)
{
	ASSERT(hList == &s_List);

	if (s_List.path == 0)
	{
		// [gfBNg
		if (s_List.count == 0)
		{
			// SETTING.INI
			s_List.count++;
			if (ExistSetting(0))
			{
				if (s_List.detail)
				{
					sfile_t file;
					VERIFY(ReadEEP(OFFSET_FILE, (BYTE*)&file, sizeof(file)));

					*pSize += sprintf(pBuf, "-rw-rw-rw- 0 owner %u Jan 1 00:00 %s\r\n",
						(UINT)file.wDataSize, SETTINGFILE);
				}
				else {
					*pSize += sprintf(pBuf, "%s\r\n", SETTINGFILE);
				}
				return 1;
			}
		}
		if (s_List.count == 1)
		{
			// SETTING.DAT
			s_List.count++;
			if (ExistSetting(1))
			{
				if (s_List.detail)
				{
					*pSize += sprintf(pBuf, "-r--r--r-- 0 owner %u Jan 1 00:00 %s\r\n",
						(UINT)sizeof(datas_t), SETTINGDATA);
				}
				else {
					*pSize += sprintf(pBuf, "%s\r\n", SETTINGDATA);
				}
				return 1;
			}
		}
		return 0;
	}
	else if (s_List.path == 1)
	{
		// SETTING.INI ̏ڍ
		ASSERT(s_List.detail);

		sfile_t file;
		VERIFY(ReadEEP(OFFSET_FILE, (BYTE*)&file, sizeof(file)));

		*pSize += sprintf(pBuf, "-rw-rw-rw- 0 owner %u Jan 1 00:00 %s\r\n",
			(UINT)file.wDataSize, SETTINGFILE);

		return 0;
	}
	else if (s_List.path == 2)
	{
		// SETTING.DAT ̏ڍ
		ASSERT(s_List.detail);

		*pSize += sprintf(pBuf, "-r--r--r-- 0 owner %u Jan 1 00:00 %s\r\n",
			(UINT)sizeof(datas_t), SETTINGDATA);

		return 0;
	}

	ASSERT(FALSE);
	return 0;
}

// l[
extern BOOL FtpRename(char* pOld, char* pNew)
{
	// s
	return FALSE;
}

// 폜
extern BOOL FtpDelete(char* pPath)
{
	if (IsFilePath(pPath, SETTINGFILE) && ExistSetting(0))
	{
		sfile_t file;
		file.dwMarking = 0;
		file.wDataSize = 0;
		VERIFY(WriteEEP(OFFSET_FILE, (BYTE*)&file, sizeof(file)));
		return TRUE;
	}
	if (IsFilePath(pPath, SETTINGDATA) && ExistSetting(1))
	{
		DWORD dwMarking = 0;
		VERIFY(WriteEEP(OFFSET_DATA, (BYTE*)&dwMarking, sizeof(dwMarking)));
		return TRUE;
	}
	return FALSE;
}

// 쐬
extern BOOL FtpMkDir(char* pDir)
{
	// s
	return FALSE;
}

// JgfBNg̎擾
extern char* FtpGetCur(char* pPath)
{
	// Ƀ[g
	pPath[0] = '/';
	pPath[1] = '\0';
	return pPath;
}

//=================================================================

// ݒ肪݂邩ǂ𒲂ׂ
static BOOL ExistSetting(int nType)
{
	DWORD dwMarking;

	if (nType == 0)
	{
		// SETTING.INI
		VERIFY(ReadEEP(OFFSET_FILE, (BYTE*)&dwMarking, sizeof(dwMarking)));
		return (dwMarking == FILE0_VALID);
	}
	if (nType == 1)
	{
		// SETTING.DAT
		VERIFY(ReadEEP(OFFSET_DATA, (BYTE*)&dwMarking, sizeof(dwMarking)));
		return (dwMarking == FILE1_VALID);
	}

	ASSERT(FALSE);
	return FALSE;
}

// t@C̈v𒲂ׂ
static BOOL IsFilePath(const char* pTest, const char* pPath)
{
	if (strlen(pTest) > 2 && pTest[0] == '.' && pTest[1] == '/')
	{
		if (strcmp(pTest + 2, pPath) == 0) {
			return TRUE;
		}
	}
	else if (strlen(pTest) > 1 && pTest[0] == '/')
	{
		if (strcmp(pTest + 1, pPath) == 0) {
			return TRUE;
		}
	}
	else if (strcmp(pTest, pPath) == 0) {
		return TRUE;
	}

	return FALSE;
}
