/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"
#include "Selector.h"
#include "Amp.h"
#include "Decoder.h"
#include "Player.h"
#include "ff.h"

#include "USB/usb.h"
#include "USB/usb_host.h"
#include "USB/usb_host_msd.h"
#include "USB/usb_host_msd_scsi.h"

//=================================================================

#define ST_NONE			0
#define ST_WAIT			1
#define ST_NUSB			2
#define ST_PLAY			3

#define OST_CLOSE		0
#define OST_ERROR		1
#define OST_NOTFOUND	2
#define OST_OPEN		3

#define PST_STOP		0x00
#define PST_PLAY		0x01
#define PST_NEXT		0x02
#define PST_BREAK		0x03
#define PSM_SEEK		0x80
#define PSM_NEXT		0x10
#define PSM_SKIP		0x20

#define MUSICPATH		"\\"
#define MUSICDIR		"\\"

#define SECTOR_SIZE		512

//=================================================================

typedef struct _pinfo_t {
	DIR* pDir;
	int nPos;
	int nMax;
} pinfo_t;

static void PlayTask(void);
static int FirstOpen(void);
static void Play(void);
static void Seek(BOOL fNext, BOOL fSkip);
static int DoSeek(BOOL fNext, BOOL fSkip);
static int SeekDir(BOOL fForward, const char* start);
static BOOL IsValidDir(const FILINFO* pInfo);
static BOOL SetDir(void);
static BOOL SetPos(DIR* pDir, const char* pFname);
static int SeekFile(BOOL fForward);
static BOOL IsValidFile(const FILINFO* pInfo);
static BOOL SetInfo(pinfo_t* pInfo, BOOL fGetMax);
static void LastClose(void);
static void Update(void);

//=================================================================

static int s_nState = ST_NONE;
static DWORD s_dwTick;

static FATFS s_FS;
static int s_nOpen;
static int s_nPlay;
static char s_LastDir[FNAME_LEN];
static char s_LastFile[FNAME_LEN];
static DIR s_Root;
static FILINFO s_DirInfo;
static DIR s_Dir;
static FILINFO s_FileInfo;
static FIL s_File;
static pinfo_t s_DirPos;
static pinfo_t s_FilPos;
static int s_nBitRate;
static char s_sWork[FNAME_LEN];

//=================================================================

// 
extern void InitPlayer(void)
{
	s_DirPos.pDir = &s_Root;
	s_FilPos.pDir = &s_Dir;
}

// Jn
extern void StartPlayer(void)
{
	ASSERT(s_nState == ST_NONE);

	// ݒ蕜
	strcpy(s_LastDir, g_Data.LastDir);
	strcpy(s_LastFile, g_Data.LastFile);

	// xJn
	s_dwTick = TickGet() + TICKS_OF(3);
	s_nState = ST_WAIT;
	Update();
}

// ~
extern void StopPlayer(void)
{
	ASSERT(s_nState != ST_NONE);

	// ~
	if (s_nState >= ST_NUSB)
	{
		SetMute(TRUE);
		DEC_Enable(FALSE);
		
		f_mount(DRV_USB, NULL);
		USBHostShutdown();

		LastClose();
		SetDefClock();
	}

	// ݒۑ
	strcpy(g_Data.LastDir, s_DirInfo.fname);
	strcpy(g_Data.LastFile, s_FileInfo.fname);

	// ~
	s_nState = ST_NONE;
}

// ^XN
extern void TaskPlayer(void)
{
	int nCmd;

	switch (s_nState)
	{
	case ST_WAIT:
		ASSERT(GetSystemClock() == DEFAULT_CLK);
		if (GetCommand() == CMD_ENTER) {
			s_dwTick = 0;
		}
		if (TickGet() >= s_dwTick)
		{
			// NbN_E
			SetClock(CLK_20MHz);

			// USB(Host)
			VERIFY(USBHostInit(0));

			// fR[_
			DEC_SetVolume(0); // -0dB
			DEC_Enable(TRUE);
			SlectSource(SRC_DECODER);

			s_nState = ST_NUSB;
		}
		break;

	case ST_NUSB:
        USBTasks();
		if (USBHostMSDSCSIMediaDetect())
		{
			// ĐJn
			f_mount(DRV_USB, NULL);
			f_mount(DRV_USB, &s_FS);

			s_nOpen = FirstOpen();
			s_nPlay = PST_STOP;

			Play();
			s_dwTick = 0;
			s_nState = ST_PLAY;
		}
		Update();
		break;

	case ST_PLAY:
        USBTasks();
		nCmd = GetCommand();
		if(nCmd == CMD_PREV || nCmd == CMD_NEXT)
		{
			if (GetRepeat())
			{
				// FfBNgXXLbv
				if (TickGet() >= s_dwTick) // ̂
				{
					Seek(nCmd == CMD_NEXT, TRUE);
					s_dwTick = TickGet() + TICKS_OFMS(750);
					Beep(4000, 50, FALSE);
				}
			}
			else
			{
				// Ft@CXLbv
				Seek(nCmd == CMD_NEXT, FALSE);
				Beep(4000, 50, FALSE);
			}
		}

		// Đ^XN
		PlayTask();
		break;

	default:
		ASSERT(s_nState == ST_NONE);
	}
}

// R}h󂯓邩ׂ(CMD_ENTER or KEY_PREV or KEY_NEXT)
extern BOOL IsAcptCmdP(int nCmd)
{
	if (nCmd == CMD_ENTER) {
		return (s_nState == ST_WAIT);
	}
	if (nCmd == CMD_PREV || nCmd == CMD_NEXT) {
		return (s_nState >= ST_PLAY);
	}
	return FALSE; 
}

//=================================================================

// Đ^XN
static void PlayTask(void)
{
	static DWORD s_dwMute;

	switch (s_nPlay)
	{
	case PST_PLAY:
		ASSERT(s_nOpen == OST_OPEN);

		// Ȃ̐擪Ńf[R[hԃZbgyуrbg[gČvZw
		if (s_File.fptr == 0)
		{
			DEC_SetDecodeTime(0);
			s_nBitRate = 0;

			// XRESETAŏ̋Ȃ̐擪ō|bvmCY鎖΍
			// x~[g
			if (IsMute()) {
				s_dwMute = TickGet() + TICKS_OFMS(200);
			}
		}

		// f[^](1KBZN^PʂœǍ)
		UINT nRead;
		if (f_read(&s_File, g_Buffer, SECTOR_SIZE, &nRead) == FR_OK)
		{
			BYTE* pData = g_Buffer;
			int nBytes = nRead & 0x1F;
			nRead &= 0xFFFFFFE0;
			while (nRead > 0)
			{
				DEC_WaitDREQ();
				DWORD dwSend = DEC_SendData32(pData, nRead);
				nRead -= dwSend;
				pData += dwSend;
			}
			if (nBytes > 0)
			{
				DEC_WaitDREQ();
				DEC_SendData(pData, nBytes);
			}
			if (s_File.fptr >= s_File.fsize)
			{
				// I->̃t@C
				s_nPlay = PST_NEXT;
			}
			else if (s_nBitRate == 0)
			{
				// rbg[g\(ĐJn\)
				DEC_GetStreamInfo(&s_nBitRate);
				Update();
			}

			// x~[g
			if (IsMute())
			{
				if (TickGet() >= s_dwMute)
					SetMute(FALSE);
			}
		}
		else
		{
			// ُ->~
			s_nPlay = PST_BREAK;
		}
		Update();
		break;
	
	case PST_NEXT:
		ASSERT(s_nOpen == OST_OPEN);

		// fR[h~(K菇)
		DEC_StopDecode();

		// ̃t@CI
		s_nOpen = DoSeek(TRUE, FALSE);
		if (s_nOpen != OST_OPEN)
		{
			SetMute(TRUE);
			s_nPlay = PST_STOP;
		}
		else {
			s_nPlay = PST_PLAY;
		}
		Update();
		break;

	case PST_BREAK:
		ASSERT(s_nOpen == OST_OPEN);

		// fR[h~
		SetMute(TRUE);
		DEC_StopDecode();

		f_lseek(&s_File, 0);
		s_nPlay = PST_STOP;

		Update();
		break;

	case PST_STOP:
		// G[̏ꍇ֗̂Ń}Eg蒼Ă݂
		ASSERT(IsMute());
		USBHostMSDSCSIMediaReset();
		s_nState = ST_NUSB;
		break;

	default:
		ASSERT(s_nOpen == OST_OPEN);
		ASSERT(s_nPlay & PSM_SEEK);

		// fR[h~
		SetMute(TRUE);
		DEC_StopDecode();

		// Ώۃt@CI
		s_nOpen = DoSeek((s_nPlay & PSM_NEXT) != 0, (s_nPlay & PSM_SKIP) != 0);
		if (s_nOpen == OST_OPEN) {
			s_nPlay = PST_PLAY;
		}
		else {
			s_nPlay = PST_STOP;
		}
		Update();
		break;
	}
}

// I[v
static int FirstOpen(void)
{
	// yfBNgJ
	if (f_chdir(MUSICPATH) != FR_OK)
		return OST_ERROR;
	if (f_opendir(&s_Root, MUSICDIR) != FR_OK)
		return OST_ERROR;

	// XgfBNgJ
	if (*s_LastDir != '\0')
	{
		for(;;)
		{
			if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
				return OST_ERROR;
			if (*s_DirInfo.fname == '\0')
				break;
			if (strcmp(s_DirInfo.fname, s_LastDir) == 0)
			{
				if (!IsValidDir(&s_DirInfo))
					*s_DirInfo.fname = '\0';
				break;
			}
		}
		if (*s_DirInfo.fname != '\0')
		{
			if (!SetDir())
				return OST_ERROR;
			
			// Xgt@CJ
			if (*s_LastFile != '\0')
			{
				for(;;)
				{
					if (f_readdir(&s_Dir, &s_FileInfo) != FR_OK)
						return OST_ERROR;
					if (*s_FileInfo.fname == '\0')
						break;
					if (strcmp(s_FileInfo.fname, s_LastFile) == 0)
					{
						if (!IsValidFile(&s_FileInfo))
							*s_FileInfo.fname = '\0';
						break;
					}
				}
				if (*s_FileInfo.fname != '\0')
				{
					// t@C
					if (!SetInfo(&s_DirPos, TRUE))
						return OST_ERROR;
					if (!SetInfo(&s_FilPos, TRUE))
						return OST_ERROR;

					if (f_open(&s_File, s_LastFile, FA_READ) == FR_OK)
						return OST_OPEN;
				}

				// Xg͗LłȂȂ
				*s_LastDir = '\0';
				*s_LastFile = '\0';
			}
		}
	}

	// 擪V[NėLȃGgT
	if (f_readdir(&s_Root, 0) != FR_OK)
		return OST_ERROR;

	int nRes;
	do {
		nRes = SeekDir(1, 0);
		if (nRes != OST_OPEN)
			return nRes;

		nRes = SeekFile(1);
		if (nRes == OST_ERROR)
			return OST_ERROR;
	}
	while (nRes != OST_OPEN);

	// Gg
	if (!SetInfo(&s_DirPos, TRUE))
		return OST_ERROR;
	if (!SetInfo(&s_FilPos, TRUE))
		return OST_ERROR;

	return nRes;
}

// ĐJn
static void Play(void)
{
	if (s_nOpen == OST_OPEN && s_nPlay == PST_STOP) {
		s_nPlay = PST_PLAY;
	}
}

// I
static void Seek(BOOL fNext, BOOL fSkip)
{
	if (s_nPlay == PST_STOP)
	{
		// ~̓Jgړ̂
		if (s_nOpen == OST_OPEN)
		{
			s_nOpen = DoSeek(fNext, fSkip);
			Update();
		}
	}
	else if (s_nPlay == PST_PLAY)
	{
		// ĐV[PXƓĎs
		s_nPlay = PSM_SEEK;
		if (fNext) s_nPlay |= PSM_NEXT;
		if (fSkip) s_nPlay |= PSM_SKIP;
	}
}

// V[N
static int DoSeek(BOOL fNext, BOOL fSkip)
{
	char fname[FNAME_LEN];
	int nRes1, nRes2;

	// t@CV[N
	if (!fSkip)
	{
		if (!fNext)
		{
			// ĐJnĕȏo߂ꍇ͓oƂ
			if (DEC_GetDecodeTime() >= 120)
			{
				f_lseek(&s_File, 0);
				return OST_OPEN;
			}
		}
		nRes1 = SeekFile(fNext);
		if (nRes1 != OST_NOTFOUND)
		{
			// ȂN[YԂɂĂ
			if (nRes1 != OST_OPEN && s_nOpen == OST_OPEN)
			{
				f_close(&s_File);
				s_nOpen = OST_CLOSE;
			}
			if (nRes1 == OST_OPEN)
			{
				// ʒu̎擾
				if (!SetInfo(&s_FilPos, FALSE))
					return OST_ERROR;
			}
			return nRes1;
		}
	}
	// N[YĂ
	if (s_nOpen == OST_OPEN)
	{
		f_close(&s_File);
		s_nOpen = OST_CLOSE;
	}

	// fBNgV[N
	strcpy(fname, s_DirInfo.fname);
	strcpy(s_sWork, fname);
	do {
		// ̃fBNg
		nRes1 = SeekDir(fNext, fname);
		if (nRes1 == OST_ERROR)
			return OST_ERROR;

		// ̃t@C
		nRes2 = SeekFile((fSkip)? TRUE : fNext);
		if (nRes2 == OST_ERROR)
			return OST_ERROR;
	}
	while (nRes1 != OST_NOTFOUND && nRes2 != OST_OPEN);

	// \ʃG[̌o
	// ꏄČ݂ɖ߂͂Ȃ̂Œʏ킠蓾Ȃ
	if (nRes2 != OST_OPEN)
		return OST_ERROR;

	// ʒu̎擾
	if (!SetInfo(&s_DirPos, TRUE))
		return OST_ERROR;
	if (!SetInfo(&s_FilPos, TRUE))
		return OST_ERROR;

	return OST_OPEN;
}

// fBNgEhV[N
static int SeekDir(BOOL fForward, const char* pFname)
{
	if (fForward)
	{
		// tH[h
		for(;;)
		{
			if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
				return OST_ERROR;
			if (*s_DirInfo.fname == '\0')
			{
				if (f_readdir(&s_Root, 0) != FR_OK)
					return OST_ERROR;
				if (pFname == NULL)
					return OST_NOTFOUND;
				for(;;)
				{
					if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
						return OST_ERROR;
					if (*s_DirInfo.fname == '\0')
						return OST_ERROR; // ʏ킠蓾Ȃ
					if (IsValidDir(&s_DirInfo))
						break;
				}
				if (strcmp(s_DirInfo.fname, pFname) == 0) {
					return (SetDir())? OST_NOTFOUND : OST_ERROR;
				}
				break;
			}
			if (IsValidDir(&s_DirInfo)) {
				break;
			}
		}
		if (!SetDir()) {
			return OST_ERROR;
		}
	}
	else
	{
		// o[X
		FILINFO dinfo;
		dinfo.fattrib = 0;
		for(;;)
		{
			if (f_readdir(&s_Root, 0) != FR_OK)
				return OST_ERROR;
			for(;;)
			{
				if (f_readdir(&s_Root, &s_DirInfo) != FR_OK)
					return OST_ERROR;
				if (*s_DirInfo.fname == '\0')
				{
					if (*s_sWork != '\0')
						return OST_ERROR; // ʏ킠蓾Ȃ
					break;
				}
				if (IsValidDir(&s_DirInfo))
				{
					if (*s_sWork != '\0')
					{
						if (strcmp(s_DirInfo.fname, s_sWork) == 0)
							break;
					}
					dinfo = s_DirInfo;
				}
			}
			if (dinfo.fattrib != 0)
			{
				s_DirInfo = dinfo;
				if (!SetPos(&s_Root, s_DirInfo.fname))
					return OST_ERROR;

				if (*s_sWork == '\0')
				{
					if (strcmp(s_DirInfo.fname, pFname) == 0)
						return (SetDir())? OST_NOTFOUND : OST_ERROR;
				}
				if (!SetDir()) {
					return OST_ERROR;
				}

				strcpy(s_sWork, s_DirInfo.fname);
				break;
			}
			else
			{
				dinfo = s_DirInfo; // Έꏄ
				*s_sWork = '\0';
			}
		}
	}

	return OST_OPEN;
}

// LȃfBNgǂ𒲂ׂ
static BOOL IsValidDir(const FILINFO* pInfo)
{
	if ((pInfo->fattrib & (AM_HID | AM_SYS | AM_VOL | AM_DIR)) != AM_DIR)
		return FALSE;
	if (pInfo->fname[0] == '.')
		return FALSE;

	return TRUE;
}

// fBNgZbg
static BOOL SetDir(void)
{
	if (f_chdir("/") != FR_OK)
		return FALSE;
	if (f_chdir(MUSICDIR) != FR_OK)
		return FALSE;
	if (f_opendir(&s_Dir, s_DirInfo.fname) != FR_OK)
		return FALSE;
	if (f_chdir(s_DirInfo.fname) != FR_OK)
		return FALSE;

	return TRUE;
}

// fBNgʒuݒ肷
static BOOL SetPos(DIR* pDir, const char* pFname)
{
	if (f_readdir(pDir, 0) == FR_OK)
	{
		FILINFO Info;
		for(;;)
		{
			if (f_readdir(pDir, &Info) != FR_OK)
				break;
			if (*Info.fname == '\0')
				break;
			if (strcmp(Info.fname, pFname) == 0)
				return TRUE;
		}
	}
	return FALSE;
}

// t@CV[N
static int SeekFile(BOOL fForward)
{
	FILINFO finfo;
	char fname[FNAME_LEN];

	// o[XV[Nׂ̈̏
	if (!fForward)
	{
		finfo.fsize = 0;

		if (s_nOpen == OST_OPEN)
			strcpy(fname, s_FileInfo.fname);
		else
			fname[0] = '\0';

		if (f_readdir(&s_Dir, 0) != FR_OK)
			return OST_ERROR;
	}

	// N[YĂ
	if (s_nOpen == OST_OPEN)
	{
		f_close(&s_File);
		s_nOpen = OST_CLOSE;
	}
	for(;;)
	{
		if (f_readdir(&s_Dir, &s_FileInfo) != FR_OK)
			return OST_ERROR;
		
		if (*s_FileInfo.fname == '\0')
		{
			if (fForward)
				return OST_NOTFOUND;
			break;
		}
		if (IsValidFile(&s_FileInfo))
		{
			if (fname[0] != '\0')
			{
				if (strcmp(s_FileInfo.fname, fname) == 0)
					break;
			}
			if (f_open(&s_File, s_FileInfo.fname, FA_READ) == FR_OK)
			{
				if (fForward)
					return OST_OPEN;

				finfo = s_FileInfo;
			}
			// I[vłȂt@C̓G[T
		}
	}

	// RR̓o[XV[N̂ݒʂ
	if (finfo.fsize != 0)
	{
		s_FileInfo = finfo;
		if (!SetPos(&s_Dir, s_FileInfo.fname))
			return OST_ERROR;

		if (f_open(&s_File, s_FileInfo.fname, FA_READ) == FR_OK)
			return OST_OPEN;

		// I[vł͂Ȃ̂ɏoȂꍇ
		return OST_ERROR;
	}

	return OST_NOTFOUND;
}

// Lȃt@Cǂ𒲂ׂ
static BOOL IsValidFile(const FILINFO* pInfo)
{
	if ((pInfo->fattrib & (AM_HID | AM_SYS | AM_VOL | AM_DIR)) != 0)
		return FALSE;
	if (pInfo->fsize < 8)
		return FALSE;

	return TRUE;
}

// ʒu擾ݒ肷
static BOOL SetInfo(pinfo_t* pInfo, BOOL fGetMax)
{
	FILINFO info;
	BOOL fRoot = (pInfo->pDir == &s_Root);
	const char* pCur = (fRoot)? s_DirInfo.fname : s_FileInfo.fname;
	int nPos = 0;

	if (f_readdir(pInfo->pDir, 0) != FR_OK)
		return FALSE;

	for(;;)
	{
		if (f_readdir(pInfo->pDir, &info) != FR_OK)
			return 0;
		if (*info.fname == '\0')
			break;

		if (fRoot) {
			if (!IsValidDir(&info))
				continue;
		}
		else {
			if (!IsValidFile(&info))
				continue;
		}
		if (strcmp(info.fname, pCur) == 0)
		{
			pInfo->nPos = nPos;
			if (!fGetMax)
				break;
		}
		nPos++;
	}

	if (fGetMax)
	{
		pInfo->nMax = nPos;
		return SetPos(pInfo->pDir, pCur);
	}

	return TRUE;
}

// t@CN[Y
static void LastClose(void)
{
	if (s_nOpen == OST_OPEN) {
		f_close(&s_File);
	}
	s_nOpen = OST_CLOSE;
}

//=================================================================

// \XV
static void Update(void)
{
	static int s_nLastInfo;
	static int s_nLastRate;
	static WORD s_wLastTime;

	if (s_nState == ST_PLAY)
	{
		ASSERT(s_nPlay == PST_STOP || s_nPlay == PST_PLAY);
		char buf[32];
		int nInfo;

		switch (s_nOpen)
		{
		case OST_OPEN:
			/* PL:SSSSSSSS NNNk */
			/* [00] 00/00 NN:NN  */
			nInfo = s_DirPos.nPos * 100 + s_FilPos.nPos;
			if (s_nLastInfo != nInfo)
			{
				ASSERT(strlen(s_DirInfo.fname) <= 8);
				sprintf(buf, "PL:%s        ", s_DirInfo.fname);
				buf[12] = '\0';
				DisplayText(0, 0, buf);

				sprintf(buf, "[%02u] %02u/%02u", 
					s_DirPos.nPos + 1, s_FilPos.nPos + 1, s_FilPos.nMax);
				DisplayText(0, 1, buf);
			
				s_nLastInfo = nInfo;
			}
			break;

		case OST_NOTFOUND:
			/* PL:              */
			/* Not Found.       */
			DisplayText(0, 0, "PL: Not Found   ");
			DisplayText(0, 1, "                ");
			break;

		default:
			/* PL:              */
			/* FS Error.        */
			DisplayText(0, 0, "PL:  FS Error   ");
			DisplayText(0, 1, "                ");
			break;
		}
		if (s_nPlay == PST_PLAY)
		{
			if (s_nLastRate != s_nBitRate)
			{
				if (s_nBitRate != 0)
				{
					sprintf(buf, "%3uk", s_nBitRate); 
					DisplayText(12, 0, buf);
				}
				else {
					DisplayText(12, 0, "    ");
				}
			
				s_nLastRate = s_nBitRate;
			}

			WORD wTime = DEC_GetDecodeTime();
			if (s_wLastTime != wTime)
			{
				/* [00] 00/00 NN:NN  */
				sprintf(buf, "%02u:%02u", wTime / 60, wTime % 60); 
				DisplayText(11, 1, buf);
		
				s_wLastTime = wTime;
			}
		}
		else {
			DisplayText(10, 0, "     ");
		}
	}
	else if (s_nState == ST_NUSB)
	{
		/* PL: No USB       */
		DisplayText(0, 0, "PL: Detecting...");
		DisplayText(0, 1, "                ");

		s_nLastInfo = -1;
		s_nLastRate = -1;
		s_wLastTime = 0xFFFF;
	}
	else
	{
		ASSERT(s_nState == ST_WAIT);
		/* File Player      */
		/*                  */
		DisplayText(0, 0, "\xD8""File Player    ");
		DisplayText(0, 1, "                ");
		DisplayCtrl(DISPLAY_ON);
	}
}
