/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"
#include "EEPRom.h"
#include "SubMpu.h"
#include "Decoder.h"
#include "Network.h"
#include "Selector.h"
#include "Amp.h"
#include "NetRadio.h"
#include "Player.h"
#include "User.h"

//=================================================================

#define APP_OFF		(-1)

#define KEY_NONE	0x00
#define KEY_POWER	0x01
#define KEY_BTN1	0x02
#define KEY_BTN2	0x03
#define KEY_VUP		0x04
#define KEY_VDN		0x05
#define KEY_PREV	0x06
#define KEY_NEXT	0x07
#define REP_FLAG	0x80

//=================================================================

static void InitSystem(void);
static void Run(void);
static void StartApp(void);
static void StopApp(void);
static void Shutdown(void);

static void LoadSettings(void);
static void RecvCommand(void);
static void SetSpeaker(BOOL fSpeaker);
static void SetBoost(BOOL fEnable);
static void OnClock(DWORD dwOld, DWORD dwNew);
static BOOL GetLine(setting_t* pObj);

//=================================================================

DWORD g_dwSysClock = CLK_80MHz;
BYTE g_Buffer[BUFFER_SIZE];
datas_t g_Data = { FILE1_VALID };

static struct MAINSETTING {
	int nTrblLevel;
	int nTrblFreq;
	int nTrblRange;
	int nBassLevel;
	int nBassFreq;
	int nBassRange;
	int nESControl;
} s_Settings = { 0 };

static int s_nAppMode = APP_OFF;
static int s_nCmd = CMD_NONE;
static BOOL s_fRep = FALSE;
static int s_nBeepCount = 0;
static int s_nPhjCount;
static DWORD s_dwSaveVol = 0;

//=================================================================

// CGg
int main(void)
{
	InitSystem();

	TickInit();
	InitDisplay();
	InitSelector();
	InitDecoder();
	InitNet();
	InitPlayer();
	InitNTR();
	InitUser();
	InitAmp();

	Run();

	for(;;) Shutdown();
}

// n[h
static void InitSystem(void)
{
	// NbNݒ
	SetDefClock();
	mOSCSetPBDIV(OSC_PB_DIV_1);

	// JTAG
	DDPCONbits.JTAGEN = 0;

	// }`xN^荞
	INTEnableSystemMultiVectoredInt();
	
	// |[g
	LATB = LATC = LATD = LATE = LATF = LATG = 0;
	AD1PCFG = 0xFFFFFFFF; // All digital

	// Other ports
	LED_IO = 1;
	LED_TRIS = OUTPUT;

	BZ_IO = 0;
	BZ_TRIS = OUTPUT;

	PHJ_TRIS = INPUT;
	CNPUESET = PHJ_CNMASK;

	CNCONbits.ON = 1;

	// 󂫃s(SăfW^LOo)
	TRISBbits.TRISB4 = OUTPUT;
	TRISGbits.TRISG9 = OUTPUT;
	TRISCbits.TRISC14 = OUTPUT;
	TRISFbits.TRISF3 = OUTPUT;
	TRISBbits.TRISB15 = OUTPUT;
	TRISBbits.TRISB13 = OUTPUT;
	TRISBbits.TRISB12 = OUTPUT;
	TRISBbits.TRISB11 = OUTPUT;

	// I2C
	I2CConfigure(I2C1, I2C_ENABLE_HIGH_SPEED); // TAS5716, 24FC256
	I2CSetFrequency(I2C1, GetPeripheralClock(), 400000);
	I2CEnable(I2C1, TRUE);

	I2CConfigure(I2C4, I2C_ENABLE_HIGH_SPEED); // SUBMPU
	I2CSetFrequency(I2C4, GetPeripheralClock(), 400000);
	I2CEnable(I2C4, TRUE);

	// BeepTimer(T2)
	T2CON = 0;
	T2CONbits.TCKPS = 0b000; // 1:1 prescaler
	IPC2bits.T2IP = 4;

	// DelayTimer(T4/T5)
	T4CON = T5CON = 0;
	T4CONbits.T32 = 1;
	IEC0bits.T5IE = 1;

	// 荞݋
	INTEnableInterrupts();

	// Beep҂
	Beep(4000, 50, TRUE);
}

// s[v
static void Run(void)
{
	ASSERT(s_nAppMode == APP_OFF);

	// e@\̌ďo֐
	static void (*Starts[])(void) = {
		StartNTR, StartPlayer, StartDIN1, StartDIN2, StartUSB
	};
	static void (*Tasks[])(void) = {
		TaskNTR, TaskPlayer, TaskUser, TaskUser, TaskUser
	};
	static void (*Stops[])(void) = {
		StopNTR, StopPlayer, StopUser, StopUser, StopUser
	};

#ifndef __DEBUG
	EnableWDT();
#endif

	// ݒ胍[h
	LoadSettings();

	// ǂݎ̂
	RecvSubMpu();
	s_nCmd = CMD_NONE;

	// C[v
	do {
		// R}h擾
		RecvCommand();

		// [hؑ֔f
		int nNewMode;
		if (s_nCmd != CMD_POFF)
		{
			if (s_nAppMode == APP_OFF)
			{
				StartApp();
				nNewMode = g_Data.nLastMode;
			}
			else
			{
				// [h֑ؑ
				nNewMode = s_nAppMode;
				if (s_nCmd == CMD_PMODE) {
					nNewMode = (s_nAppMode > 0)? s_nAppMode - 1 : 4;
				}
				else if (s_nCmd == CMD_NMODE) {
					nNewMode = (s_nAppMode + 1) % 5;
				}
			}
		}
		else if (!GetRepeat()) {
			nNewMode = APP_OFF;
		}

		if (s_nAppMode != nNewMode)
		{
			// [hؑ֎s
			if (s_nAppMode != APP_OFF)
			{
				// ݂̃[hI
				Stops[s_nAppMode]();
				ASSERT(g_dwSysClock == DEFAULT_CLK);
			}
			if (s_nAppMode != APP_OFF && nNewMode != APP_OFF) {
				Beep(4000, 50, TRUE);
			}
			if (nNewMode != APP_OFF)
			{
				// V[hJn
				ASSERT(g_dwSysClock == DEFAULT_CLK);
				Starts[nNewMode]();
			}
			else {
				StopApp();
			}

			s_nAppMode = nNewMode;
		}
		else if (s_nAppMode != APP_OFF)
		{
			// {[
			switch (s_nCmd)
			{
			case CMD_VUP:
				if (SetVolume(GetVolume() + 1))
				{
					if (IsSpeaker()) {
						SetBoost(TRUE);
					}
					s_dwSaveVol = TickGet() + TICKS_OF(2);
				}
				DisplayVolume(GetVolume());
				break;

			case CMD_VDN:
				if (SetVolume(GetVolume() - 1))
				{
					if (IsSpeaker()) {
						SetBoost(TRUE);
					}
					s_dwSaveVol = TickGet() + TICKS_OF(2);
				}
				DisplayVolume(GetVolume());
				break;
			}
			// wbhz؂ւ
			if (PHJ_IO)
			{
				// Speaker
				if (s_nPhjCount == 0)
				{
					SetSpeaker(TRUE);
					s_nPhjCount--;
				}
				else if (s_nPhjCount > 0) {
					s_nPhjCount--;
				}
			}
			else
			{
				// Headphone
				if (s_nPhjCount == 10)
				{
					SetSpeaker(FALSE);
					s_nPhjCount++;
				}
				else if (s_nPhjCount < 10) {
					s_nPhjCount++;
				}
			}

			// e@\^XNR[
			Tasks[s_nAppMode]();

			// Ɏs^XN
			if (s_dwSaveVol != 0)
			{
				if (TickGet() >= s_dwSaveVol)
				{
					g_Data.nLastVolume = (BYTE)GetVolume();
					s_dwSaveVol = 0;
				}
			}
			TaskDisplay();
		}
		ClearWDT();
	}
	while (s_nAppMode != APP_OFF);
}

// AvN
static void StartApp(void)
{
	ASSERT(s_nAppMode == APP_OFF);
	ASSERT(IsMute());

	// LCD\
	DisplayText(0, 0, " HoneyAMP (^^)/");
	DisplayCtrl(DISPLAY_ON);
	DelayMS(1000);

	// AvON(|bvmCY̓wbhzo͂)
	ASSERT(GetSource() == SRC_DECODER);
	DEC_Enable(TRUE); // Clock
	SetSpeakerMode(FALSE);
	AmpEnable(TRUE);
	DEC_Enable(FALSE);

	if (PHJ_IO)
	{
		SetSpeaker(TRUE);
		s_nPhjCount = -1;
	}
	else
	{
		SetSpeaker(FALSE);
		s_nPhjCount = 11;
	}

	// ݒ蕜
	LoadData();
	SetVolume(g_Data.nLastVolume);
}

// AvI
static void StopApp(void)
{
	ASSERT(s_nAppMode != APP_OFF);
	ASSERT(IsMute());

	// LCD
	DisplayCtrl(DISPLAY_RESET);
	ClearDisplay();

	// AvOFF(|bvmCY̓wbhzo͂)
	SetSpeakerMode(FALSE);
	AmpEnable(FALSE);

	// ݒۑ
	g_Data.nLastMode = (BYTE)s_nAppMode;
	SaveData();
}

// Vbg_E
static void Shutdown(void)
{
	ASSERT(s_nAppMode == APP_OFF);

	Beep(500, 50, TRUE);
	INTDisableInterrupts();

	ClearWDT();
	LED_IO = 0;

	// dOFF
	SendSubMpu(CMD_POFF);
	//PowerSaveSleep();
}

//=================================================================

// ݒǍ
static void LoadSettings(void)
{
	// ݒI[v
	setting_t Setting;
	if (!InitSettings(&Setting)) {
		return;
	}

	// Level ( Treble:(1.5dB Step -8`+7C0=off) Bass:(1dB Step 0`15C0=off) )
	if (ReadSettingNum(&Setting, "TRBL-Level")) {
		s_Settings.nTrblLevel = Setting.Num;
	}
	if (ReadSettingNum(&Setting, "BASS-Level")) {
		s_Settings.nBassLevel = Setting.Num;
	}

	// Freqency ( Treble:(1KHz Step 1`15) Bass:(10Hz Step 2`15) )
	if (ReadSettingNum(&Setting, "TRBL-Freq")) {
		s_Settings.nTrblFreq = Setting.Num;
	}
	if (ReadSettingNum(&Setting, "BASS-Freq")) {
		s_Settings.nBassFreq = Setting.Num;
	}

	// Range (1 ` )
	if (ReadSettingNum(&Setting, "TRBL-Range")) {
		s_Settings.nTrblRange = Setting.Num;
	}
	if (ReadSettingNum(&Setting, "BASS-Range")) {
		s_Settings.nBassRange = Setting.Num;
	}

	// EarSpeaker control (0 ` 3)
	if (ReadSettingNum(&Setting, "ESControl")) {
		s_Settings.nESControl = Setting.Num;
	}
}

// R}hM
static void RecvCommand(void)
{
	BYTE nKey = RecvSubMpu();

	s_nCmd = nKey & ~REP_FLAG;
	s_fRep = ((nKey & REP_FLAG) != 0);

	static BOOL (*IsAccept[])(int) = {
		IsAcptCmdN, IsAcptCmdP, IsAcptCmdU, IsAcptCmdU, IsAcptCmdU
	};

	if (s_nCmd == KEY_POWER)
	{
		// KEY_POWER  CMD_POFF or CMD_ENTER
		if (s_nAppMode != APP_OFF && IsAccept[s_nAppMode](CMD_ENTER)) {
			s_nCmd = CMD_ENTER;
		}
	}
	else if (s_nCmd == KEY_PREV || s_nCmd == KEY_NEXT)
	{
		// KEY_PREV or KEY_NEXT  CMD_PMODE or CMD_NMODE or CMD_PREV or CMD_NEXT
		if (GetDispType() == DISPLAY_VOL) {
			s_nCmd -= 4;
		}
		else if (s_nAppMode == APP_OFF || !IsAccept[s_nAppMode](s_nCmd)) {
			s_nCmd -= 4;
		}
	}
}

// Xs[J[[hݒ
static void SetSpeaker(BOOL fSpeaker)
{
	if (fSpeaker)
	{
		DEC_SetEarSpeaker(0);
		SetBoost(TRUE);
		SetSpeakerMode(TRUE);
	}
	else
	{
		SetSpeakerMode(FALSE);
		SetBoost(FALSE);
		DEC_SetEarSpeaker(s_Settings.nESControl);
	}
}

// ቹݒ
static void SetBoost(BOOL fEnable)
{
	if (fEnable)
	{
		int nLvT, nLvB;

		nLvT = (s_Settings.nTrblLevel * GetVolume()) / s_Settings.nTrblRange;
		nLvT = s_Settings.nTrblLevel - nLvT;
		if (nLvT > 7) nLvT = 7;
		if (nLvT < 0) nLvT = 0;

		nLvB = (s_Settings.nBassLevel * GetVolume()) / s_Settings.nBassRange;
		nLvB = s_Settings.nBassLevel - nLvB;
		if (nLvB > 15) nLvT = 15;
		if (nLvB < 0) nLvT = 0;

		DEC_SetBoost(nLvT, s_Settings.nTrblFreq, nLvB, s_Settings.nBassFreq);
	}
	else {
		DEC_SetBoost(0, 1, 0, 2);
	}
}

//=================================================================

// R}h擾
extern int GetCommand(void)
{
	return s_nCmd;
}

// s[gtO擾
extern BOOL GetRepeat(void)
{
	return s_fRep;
}

// NbNݒ
extern void SetClock(DWORD dwClock)
{
	if (g_dwSysClock != dwClock)
	{
		int nSource = OSC_POSC_PLL;
		int nPost = OSC_PLL_POST_1;

		switch (dwClock)
		{
		case CLK_80MHz: nPost = OSC_PLL_POST_1; break;
		case CLK_40MHz: nPost = OSC_PLL_POST_2; break;
		case CLK_20MHz: nPost = OSC_PLL_POST_4; break;
		case CLK_10MHz: nPost = OSC_PLL_POST_8; break;
		case CLK_8MHz: nSource = OSC_POSC; break;
		case CLK_5MHz: nPost = OSC_PLL_POST_16; break;
		case CLK_2MHz: nPost = OSC_PLL_POST_32; break;
		case CLK_1MHz: nPost = OSC_PLL_POST_64; break;
		case CLK_32KHz: nSource = OSC_LPRC; break;
		default:
			ASSERT(FALSE);
		}

		if (dwClock > g_dwSysClock) {
			// ɂȂ鎞͐ݒO
			SYSTEMConfigPerformance(dwClock);
		}
		else {
			// Ɏs
			OnClock(g_dwSysClock, dwClock);
		}

		OSCConfig(nSource, OSC_PLL_MULT_20, nPost, OSC_FRC_POST_1);

		if (dwClock < g_dwSysClock) {
			// ᑬɂȂ͐ݒ
			SYSTEMConfigPerformance(dwClock);
		}
		else {
			// Ɏs
			OnClock(g_dwSysClock, dwClock);
		}

		g_dwSysClock = dwClock;

		// I2C{[[gĐݒ
		I2CSetFrequency(I2C1, GetPeripheralClock(), 400000);
		I2CSetFrequency(I2C4, GetPeripheralClock(), 400000);
	}
}

// NbNύXɔ
static void OnClock(DWORD dwOld, DWORD dwNew)
{
	// NbNύXʒm
	OnClockDisp(dwOld, dwNew);
}

// r[v
extern void Beep(int nFreq, int nTime, BOOL fWait)
{
	if (s_nBeepCount != 0)
		return;

	TMR2 = 0;
	PR2 = GetPeripheralClock() / (nFreq * 2);
	s_nBeepCount = (int)(((UINT64)nTime * (UINT64)GetPeripheralClock()) / ((UINT64)PR2 * 1000LL));

	IEC0bits.T2IE = 1;
	T2CONbits.ON = 1;

	if (fWait) {
		while (T2CONbits.ON);
	}
}

// fBC(ms)
extern void DelayMS(DWORD dwMs)
{
	ASSERT(IEC0bits.T5IE);

	DWORD nCount = (GetPeripheralClock() / 1000UL * dwMs);
	if (nCount < 10) {
		return;
	}
	else if (nCount <= 100) {
		nCount = 1;
	}
	else {
		nCount -= 100;
	}
	PR4 = (WORD)nCount;
	PR5 = (WORD)(nCount >> 16);
	TMR4 = TMR5 = 0;

	IFS0CLR = _IFS0_T5IF_MASK;
	T4CONSET = _T4CON_ON_MASK;
	while (!IFS0bits.T5IF);
	T4CONCLR = _T4CON_ON_MASK;
}

// fBC(us)
extern void DelayUS(DWORD dwUs)
{
	ASSERT(IEC0bits.T5IE);

	DWORD nCount = (GetPeripheralClock() / 1000000UL * dwUs);
	if (nCount < 10) {
		return;
	}
	else if (nCount <= 100) {
		nCount = 1;
	}
	else {
		nCount -= 100;
	}
	PR4 = (WORD)nCount;
	PR5 = (WORD)(nCount >> 16);
	TMR4 = TMR5 = 0;

	IFS0CLR = _IFS0_T5IF_MASK;
	T4CONSET = _T4CON_ON_MASK;
	while (!IFS0bits.T5IF);
	T4CONCLR = _T4CON_ON_MASK;
}

// ݒI[v
extern BOOL InitSettings(setting_t* pObj)
{
	sfile_t file;
	VERIFY(ReadEEP(OFFSET_FILE, (BYTE*)&file, sizeof(file)));
	if (file.dwMarking == FILE0_VALID)
	{
		pObj->size = file.wDataSize;
		pObj->fp = 0;
		return TRUE;
	}
	return FALSE;
}

// ݒǍ()
extern BOOL ReadSettingStr(setting_t* pObj, const char* pKey)
{
	int i;

	for (i = (pObj->fp == 0)? 1 : 0; i < 2; i++)
	{
		while (GetLine(pObj))
		{
			if (pObj->buf[0] != '#') // Rgs
			{
				char* p;
				const char* k = pKey;
				for (p = pObj->buf; *k != '\0' && *p != '\0'; k++, p++)
				{
					if (*k == *p)
					{
						if (p[1] == '=') // Name=Value`
						{
							int nLen = strlen(p += 2);
							if (nLen > 0 && p[nLen - 1] == '\n')
								p[nLen - 1] = '\0';

							pObj->Str = p;
							return TRUE;
						}
						continue;
					}
					break;
				}
			}
		}
		pObj->fp = 0;
	}

	return FALSE;
}

// ݒǍ(10il)
extern BOOL ReadSettingNum(setting_t* pObj, const char* pKey)
{
	if (ReadSettingStr(pObj, pKey))
	{
		pObj->Num = atoi(pObj->Str);
		return TRUE;
	}
	return FALSE;
}

// ݒǍ(IP/MACAhX)
extern BOOL ReadSettingAddr(setting_t* pObj, const char* pKey, BYTE nRadix)
{
	int i;
	for (i = (pObj->fp == 0)? 1 : 0; i < 2; i++)
	{
		while (GetLine(pObj))
		{
			if (pObj->buf[0] != '#') // Rgs
			{
				char* p;
				const char *e, *k = pKey;
				for (p = pObj->buf; *k != '\0' && *p != '\0'; k++, p++)
				{
					if (*k == *p)
					{
						if (p[1] == '=') // Name=Value`
						{
							BYTE* n = pObj->Addr;
							BYTE* s = n + sizeof(pObj->Addr);

							int nLen = strlen(p += 2);
							if (nLen > 0 && p[nLen - 1] == '\n')
								p[nLen - 1] = '\0';

							memset(n, 0, sizeof(pObj->Addr));
							for (; *p != '\0' && n < s; n++)
							{
								for(e = p; *e != '.' && *e != '\0'; e++);
								for(; p < e; p++) {
									BYTE v = ('0' <= *p && *p <= '9')? (*p - '0') :
										(('A' <= *p && *p <= 'F')? (*p - 'A' + 10) :
											(('a' <= *p && *p <= 'f')? (*p - 'a' + 10) : 0));
									*n = *n * nRadix + v;
								}
								if (*p == '.') p++;
							}
							return TRUE;
						}
						continue;
					}
					break;
				}
			}
		}
		pObj->fp = 0;
	}

	return FALSE;
}

// ݒ肩sǂݍ
static BOOL GetLine(setting_t* pObj)
{
	ASSERT(pObj->size >= pObj->fp);

	int n = pObj->size - pObj->fp;
	if (n == 0) {
		return FALSE;
	}
	if (n > (sizeof(pObj->buf) - 1)) {
		n = sizeof(pObj->buf) - 1;
	}

	VERIFY(ReadEEP(OFFSET_FILE + sizeof(sfile_t) + pObj->fp, (BYTE*)pObj->buf, n));

	char *p, *e; int i = 1;
	for (p = pObj->buf, e = p + n; p < e; p++, i++)
	{
		if (*p == '\r' || *p == '\n')
		{
			pObj->fp += i;
			if ((i < n) && *(p + 1) == '\n') {
				pObj->fp++;
			}
			*p = '\0';
			return TRUE;
		}
	}

	pObj->fp += n;
	*p = '\0';
	return TRUE;
}

// f[^[h
extern void LoadData(void)
{
	// EEPROM烊[h
	datas_t buf;
	VERIFY(ReadEEP(OFFSET_DATA, (BYTE*)&buf, sizeof(buf)));
	if (buf.dwMarking == g_Data.dwMarking)
	{
		// ɓǂ߂ꍇ
		g_Data = buf;
		return;
	}

	// f[^L^ĂȂꍇ͌ݒl(ftHg)L^Ă
	SaveData();
}

// f[^Z[u
extern void SaveData(void)
{
	ASSERT(sizeof(datas_t) <= MAX_DATA);
	VERIFY(WriteEEP(OFFSET_DATA, (BYTE*)&g_Data, sizeof(g_Data)));
}

// Oo
extern void OutputLog(const char* pLog)
{
	// LCD2sڂɕ\
	DisplayText(0, 1, "                ");
	DisplayText(0, 1, pLog);
}

// AT[V
#ifdef __DEBUG
extern void _Assert(BOOL cond, const char* msg, int line)
{
	if (!cond)
	{
		char buf[64];

		ClearDisplay();
		DisplayText(0, 0, "Assertion!");
		sprintf(buf, "L:%d F:%s", line, msg);
		DisplayText(0, 1, buf);

		for(;;);
	}
}
#endif //__DEBUG

//=================================================================

// TMR2(Beep)
void __ISR(_TIMER_2_VECTOR, ipl4) _T2Interrupt(void)
{
	if (--s_nBeepCount == 0)
	{
		BZ_IO = 0;
		IEC0bits.T2IE = 0;
		T2CONbits.ON = 0;
	}
	else
	{
		BZ_INV = BZ_MASK;
	}
	IFS0CLR = _IFS0_T2IF_MASK;
}

// C30 and C32 Exception Handlers
void _general_exception_handler(unsigned cause, unsigned status)
{
	static enum
	{
		EXCEP_IRQ = 0,		// interrupt
		EXCEP_AdEL = 4,		// address error exception (load or ifetch)
		EXCEP_AdES,			// address error exception (store)
		EXCEP_IBE,			// bus error (ifetch)
		EXCEP_DBE,			// bus error (load/store)
		EXCEP_Sys,			// syscall
		EXCEP_Bp,			// breakpoint
		EXCEP_RI,			// reserved instruction
		EXCEP_CpU,			// coprocessor unusable
		EXCEP_Overflow,		// arithmetic overflow
		EXCEP_Trap,			// trap (possible divide by zero)
		EXCEP_IS1 = 16,		// implementation specfic 1
		EXCEP_CEU,			// CorExtend Unuseable
		EXCEP_C2E			// coprocessor 2
	} _excep_code;

	static UINT _excep_addr;

	char buf[32];
	asm volatile("mfc0 %0,$13" : "=r" (_excep_code));
	asm volatile("mfc0 %0,$14" : "=r" (_excep_addr));
	_excep_code = (_excep_code & 0x0000007C) >> 2;

	ClearDisplay();
	DisplayText(0, 0, "Exception!");
	sprintf(buf, "A:%08X C:%d", _excep_addr, _excep_code);
	DisplayText(0, 1, buf);

	for(;;);
}
