/****************************************************************************

	HoneyAmp
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Display.h"
#include "Selector.h"
#include "Amp.h"
#include "Network.h"
#include "User.h"

//=================================================================

#define ST_NONE			0
#define ST_WAIT			1
#define ST_PLAY			2

//=================================================================

static void StartUser(int src);
static void Update(void);
static int GetInfoText(char** pText);

//=================================================================

static int s_nState = ST_NONE;
static DWORD s_dwTick;
static int s_nSource;

//=================================================================

// 
extern void InitUser(void)
{
	// 󉽂Ȃ
}

// Jn(DIGITAL 1)
extern void StartDIN1(void)
{
	StartUser(SRC_DIGITAL1);
}

// Jn(DIGITAL 2)
extern void StartDIN2(void)
{
	StartUser(SRC_DIGITAL2);
}

// Jn(USB AUDIO)
extern void StartUSB(void)
{
	StartUser(SRC_USBAUDIO);
}

// Jn
static void StartUser(int src)
{
	ASSERT(s_nState == ST_NONE);

	s_nSource = src;

	// xJn
	s_dwTick = TickGet() + TICKS_OF(3);
	s_nState = ST_WAIT;
	Update();
}

// ~
extern void StopUser(void)
{
	ASSERT(s_nState != ST_NONE);

	// ~
	if (s_nState >= ST_PLAY)
	{
		SetMute(TRUE);

		EnableNet(FALSE);
		while (!IsDisableNet()) {
			TaskNet();
		}
		SetDefClock();
	}

	// ~
	s_nState = ST_NONE;
}

// ^XN
extern void TaskUser(void)
{
	int nCmd;

	switch (s_nState)
	{
	case ST_WAIT:
		ASSERT(GetSystemClock() == DEFAULT_CLK);
		if (GetCommand() == CMD_ENTER) {
			s_dwTick = 0;
		}
		if (TickGet() >= s_dwTick)
		{
			// NbN_E
			SetClock(CLK_8MHz);

			// ĐJn
			SlectSource(s_nSource);
			SetMute(FALSE);

			s_nState = ST_PLAY;
		}
		break;

	case ST_PLAY:
		nCmd = GetCommand();
		if(nCmd == CMD_PREV || nCmd == CMD_NEXT)
		{
			if (IsDisableNet())
			{
				// WiFiڑ
				EnableNet(TRUE);
			}
			else if (IsEnabledNet())
			{
				// WiFiؒf
				EnableNet(FALSE);
				while (!IsDisableNet()) {
					TaskNet();
				}
			}
		}
		Update();
		TaskNet();
		break;

	default:
		ASSERT(s_nState == ST_NONE);
	}
}

// R}h󂯓邩ׂ(CMD_ENTER or KEY_PREV or KEY_NEXT)
extern BOOL IsAcptCmdU(int nCmd)
{
	if (nCmd == CMD_ENTER) {
		return (s_nState == ST_WAIT);
	}
	if (nCmd == CMD_PREV || nCmd == CMD_NEXT) {
		return (s_nState >= ST_PLAY);
	}
	return FALSE; 
}

// \XV
static void Update(void)
{
	static int s_nLastNet = -1;
	static int s_nLastSts = -1;

	if (s_nState == ST_WAIT)
	{
		/* DIGITAL 1        */
		/* DIGITAL 2        */
		/* USB Audio        */
		switch (s_nSource)
		{
		case SRC_DIGITAL1:
			DisplayText(0, 0, "\xD8""DIGITAL 1      ");
			break;
		case SRC_DIGITAL2:
			DisplayText(0, 0, "\xD8""DIGITAL 2      ");
			break;
		case SRC_USBAUDIO:
			DisplayText(0, 0, "\xD8USB Audio      ");
			break;
		}
		DisplayText(0, 1, "                ");
		DisplayCtrl(DISPLAY_ON);

		s_nLastNet = -1;
		s_nLastSts = -1;
		return;
	}

	char* pText;
	int nStatus = GetInfoText(&pText);
	if (nStatus != s_nLastSts)
	{
		/* D1: IIIIIIIIII   */
		/* D2: IIIIIIIIII   */
		/* USB:IIIIIIIIII   */
		switch (s_nSource)
		{
		case SRC_DIGITAL1:
			DisplayText(0, 0, "D1:             ");
			DisplayText(4, 0, pText);
			break;
		case SRC_DIGITAL2:
			DisplayText(0, 0, "D2:             ");
			DisplayText(4, 0, pText);
			break;
		case SRC_USBAUDIO:
			DisplayText(0, 0, "USB:            ");
			DisplayText(4, 0, pText);
			break;
		}
	
		s_nLastSts = nStatus;
	}

	int nCurrent = GetNetState();
	if (nCurrent != s_nLastNet)
	{
		/* Wi-Fi Disabled.  */
		/* Wi-Fi Connecting */
		/* #XXX.XXX.XXX.XXX */
		/* Wi-Fi Error.     */
		char buf1[32], buf2[32];
		switch (nCurrent)
		{
		case NET_DISABLED:
			DisplayText(0, 1, "                ");
			break;
		case NET_CONNECTING:
			DisplayText(0, 1, "Wi-Fi Connecting");
			break;
		case NET_ENABLED:
			GetIPString(buf1);
			sprintf(buf2, "\xC5%s        ", buf1);
			buf2[16] = '\0';
			DisplayText(0, 1, buf2);
			break;
		case NET_ERROR:
			DisplayText(0, 1, "Wi-Fi Error.    ");
			break;
		}

		s_nLastNet = nCurrent;
	}
}

// G[/Tv[g񕶎擾
static int GetInfoText(char** pText)
{
	if (IsDIRError())
	{
		*pText = "Input error";
		return -2;
	}

	int nRate = GetSampleRate();
	switch (nRate)
	{
	case 0b000: *pText = " 32k";
		 break;
	case 0b001: *pText = " 38k";
		break;
	case 0b010: *pText = " 44.1k";
		break;
	case 0b011: *pText = " 48k";
		break;
	case 0b100: *pText = " 88.2k";
		break;
	case 0b101: *pText = " 96k";
		break;
	case 0b110: *pText = " 176.4k";
		break;
	case 0b111: *pText = " 192k";
		break;
	default:
		ASSERT(FALSE);
		*pText = "";
		break;
	}

	return nRate;
}
