/****************************************************************************

	HoneyReceiver
		Copyright(C) 2013 Mr.Honey

****************************************************************************/

#include "diskio.h"

#include "USB/usb.h"
#include "USB/usb_host_msd_scsi.h"
#include "MDD File System/FSDefs.h"

//=================================================================

#define DRV_USB			0
#define SECTOR_SIZE		512

//=================================================================

static MEDIA_INFORMATION* s_pMedia;

//=================================================================

// fBXNEhCȕ
DSTATUS disk_initialize(BYTE drv)
{
	if (drv == DRV_USB)
	{
		// wǂUSB Sector=512 ʓ|Ȃ̂łȊO̓T|[gȂ
		s_pMedia = USBHostMSDSCSIMediaInitialize();
		if (s_pMedia->errorCode == MEDIA_NO_ERROR && s_pMedia->sectorSize == SECTOR_SIZE) {
			return 0;
		}
	}
	return STA_NOINIT;
}

// fBXNEhCȕԎ擾
DSTATUS disk_status(BYTE drv)
{
	if (drv == DRV_USB)
	{
		if (USBHostMSDSCSIMediaDetect()) {
			return 0;
		}
	}
	return STA_NOINIT;
}

// fBXN̓ǂݍ
DRESULT disk_read(BYTE drv, BYTE *buff, DWORD sector, BYTE count)
{
	if (drv == DRV_USB)
	{
		do {
			if (!USBHostMSDSCSISectorRead(sector++, buff)) {
				return RES_ERROR;
			}
			buff += SECTOR_SIZE;
		}
		while (--count > 0);
		return RES_OK;
	}
	return RES_PARERR;
}

// ̑̃hCu
DRESULT disk_ioctl(BYTE drv, BYTE ctrl, void *buff)
{
	return RES_PARERR;
}
