Triggers = {}

function Triggers.init()

---------------------------------HUD Color Setting------------------------------
	  HUD_background_color = { 0.02, 0.03, 0.02, 1 }
	  item_color = {1, 1, 1, 1}
	  weapon_color = { 0, 0.75, 0, 1 }  -- Only available in OpenGL rendering

------------------------------------------------------------------------


	  colortable = { slate  = { 0.0, 0.5, 0.5, 1 },
	                 red    = { 0.8, 0.0, 0.0, 1 },
	                 violet = { 0.6, 0.0, 0.4, 1 },
	                 yellow = { 0.8, 0.8, 0.0, 1 },
	                 white  = { 0.9, 0.9, 0.9, 1 },
	                 orange = { 0.9, 0.5, 0.0, 1 },
	                 blue   = { 0.0, 0.0, 0.8, 1 },
	                 green  = { 0.0, 0.8, 0.0, 1 } }

	  opengl = false
	  if Screen.renderer == "opengl" then
		    opengl = true
	  end

	  compass = Images.new{path = "kataHUDfiles/objective_circle.png"}
	  miyoco = Images.new{path = "kataHUDfiles/miyoco.png"}
	  HUD = Images.new{path = "kataHUDfiles/HUD.png"}
	  shield = Images.new{path = "kataHUDfiles/radar_shield.png"}


	  if opengl then
	  	  grid = Images.new{path = "kataHUDfiles/opengl/background_radar_detail.png"}
		  kotsu = Images.new{path = "kataHUDfiles/opengl/kotsu.png"}
	  else
	  	  grid = Images.new{path = "kataHUDfiles/background_radar_detail.png"}
		   kotsu = Images.new{path = "kataHUDfiles/kotsu.png"}
	  end


	  alien = { }
	  alien[0] = Images.new{path = "kataHUDfiles/radar_blip_enemy.png"}
	  if opengl then
		    alien[1] = alien[0]
		    alien[2] = alien[0]
		    alien[3] = alien[0]
		    alien[4] = alien[0]
		    alien[5] = alien[0]
	  else
		    alien[1] = Images.new{path = "kataHUDfiles/radar_blip_enemy_fade1.png"}
		    alien[2] = Images.new{path = "kataHUDfiles/radar_blip_enemy_fade2.png"}
		    alien[3] = Images.new{path = "kataHUDfiles/radar_blip_enemy_fade3.png"}
		    alien[4] = Images.new{path = "kataHUDfiles/radar_blip_enemy_fade4.png"}
		    alien[5] = Images.new{path = "kataHUDfiles/radar_blip_enemy_fade5.png"}
	  end
	  player = { }
	  player[0] = Images.new{path = "kataHUDfiles/radar_blip_player.png"}
	  if opengl then
		    player[1] = player[0]
		    player[2] = player[0]
		    player[3] = player[0]
		    player[4] = player[0]
		    player[5] = player[0]
	  else
		    player[1] = Images.new{path = "kataHUDfiles/radar_blip_player_fade1.png"}
		    player[2] = Images.new{path = "kataHUDfiles/radar_blip_player_fade2.png"}
		    player[3] = Images.new{path = "kataHUDfiles/radar_blip_player_fade3.png"}
		    player[4] = Images.new{path = "kataHUDfiles/radar_blip_player_fade4.png"}
		    player[5] = Images.new{path = "kataHUDfiles/radar_blip_player_fade5.png"}
	  end

	  hostile = { }
	  hostile[0] = Images.new{path = "kataHUDfiles/radar_blip_enemy-player.png"}
	  if opengl then
		    hostile[1] = hostile[0]
		    hostile[2] = hostile[0]
		    hostile[3] = hostile[0]
		    hostile[4] = hostile[0]
		    hostile[5] = hostile[0]
	  else
		    hostile[1] = Images.new{path = "kataHUDfiles/radar_blip_enemy-player_fade1.png"}
		    hostile[2] = Images.new{path = "kataHUDfiles/radar_blip_enemy-player_fade2.png"}
		    hostile[3] = Images.new{path = "kataHUDfiles/radar_blip_enemy-player_fade3.png"}
		    hostile[4] = Images.new{path = "kataHUDfiles/radar_blip_enemy-player_fade4.png"}
		    hostile[5] = Images.new{path = "kataHUDfiles/radar_blip_enemy-player_fade5.png"}
	  end

	  life1 = Images.new{path = "kataHUDfiles/health1_body.png"}
	  life1cap = Images.new{path = "kataHUDfiles/health1_cap.png"}
	  life2 = Images.new{path = "kataHUDfiles/health2_body.png"}
	  life2cap = Images.new{path = "kataHUDfiles/health2_cap.png"}
	  life3 = Images.new{path = "kataHUDfiles/health3_body.png"}
	  life3cap = Images.new{path = "kataHUDfiles/health3_cap.png"}
	  otwo = Images.new{path = "kataHUDfiles/oxygen_body.png"}
	  otwocap = Images.new{path = "kataHUDfiles/oxygen_cap.png"}


	  ammo = { }
	  if opengl then
	  ammo["energy box"] = Images.new{path = "kataHUDfiles/opengl/ammo_energy_container.png"}
	  ammo["energy ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_energy_filler.png"}
	  ammo["shotgun ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_shotgun_shell.png"}
	  ammo["pistol ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_magnum_bullet.png"}
	  ammo["smg ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_smg_bullet.png"}
	  ammo["assault rifle ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_ar_bullet.png"}
	  ammo["assault rifle grenades"] = Images.new{path = "kataHUDfiles/opengl/ammo_ar_grenade.png"}
	  ammo["missile launcher ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_spnkr_rocket.png"}

	  else
	  ammo["energy box"] = Images.new{path = "kataHUDfiles/ammo_energy_container.png"}
	  ammo["energy ammo"] = Images.new{path = "kataHUDfiles/ammo_energy_filler.png"}
	  ammo["shotgun ammo"] = Images.new{path = "kataHUDfiles/ammo_shotgun_shell.png"}
	  ammo["pistol ammo"] = Images.new{path = "kataHUDfiles/ammo_magnum_bullet.png"}
	  ammo["smg ammo"] = Images.new{path = "kataHUDfiles/ammo_smg_bullet.png"}
	  ammo["assault rifle ammo"] = Images.new{path = "kataHUDfiles/ammo_ar_bullet.png"}
	  ammo["assault rifle grenades"] = Images.new{path = "kataHUDfiles/ammo_ar_grenade.png"}
	  ammo["missile launcher ammo"] = Images.new{path = "kataHUDfiles/ammo_spnkr_rocket.png"}

	  end


	  ammo_disabled = { }
	  if opengl then
	  ammo_disabled["shotgun ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_shotgun_shell_empty.png"}
	  ammo_disabled["pistol ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_magnum_bullet_empty.png"}
	  ammo_disabled["smg ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_smg_bullet_empty.png"}
	  ammo_disabled["assault rifle ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_ar_bullet_empty.png"}
	  ammo_disabled["assault rifle grenades"] = Images.new{path = "kataHUDfiles/opengl/ammo_ar_grenade_empty.png"}
	  ammo_disabled["missile launcher ammo"] = Images.new{path = "kataHUDfiles/opengl/ammo_spnkr_rocket_empty.png"}

	  else
	  ammo_disabled["shotgun ammo"] = Images.new{path = "kataHUDfiles/ammo_shotgun_shell_empty.png"}
	  ammo_disabled["pistol ammo"] = Images.new{path = "kataHUDfiles/ammo_magnum_bullet_empty.png"}
	  ammo_disabled["smg ammo"] = Images.new{path = "kataHUDfiles/ammo_smg_bullet_empty.png"}
	  ammo_disabled["assault rifle ammo"] = Images.new{path = "kataHUDfiles/ammo_ar_bullet_empty.png"}
	  ammo_disabled["assault rifle grenades"] = Images.new{path = "kataHUDfiles/ammo_ar_grenade_empty.png"}
	  ammo_disabled["missile launcher ammo"] = Images.new{path = "kataHUDfiles/ammo_spnkr_rocket_empty.png"}
	  end


	  weapons = { }
	  if opengl then
	  weapons["fist"] = Images.new{path = "kataHUDfiles/opengl/weapon_fist_right.png"}
	  weapons["flamethrower"] = Images.new{path = "kataHUDfiles/opengl/weapon_flamethrower.png"}
	  weapons["pistol"] = Images.new{path = "kataHUDfiles/opengl/weapon_magnum_right.png"}
	  weapons["pistol2"] = Images.new{path = "kataHUDfiles/opengl/weapon_magnum_left.png"}
	  weapons["shotgun"] = Images.new{path = "kataHUDfiles/opengl/weapon_shotgun_front.png"}
	  weapons["shotgun2"] = Images.new{path = "kataHUDfiles/opengl/weapon_shotgun_back.png"}
	  weapons["smg"] = Images.new{path = "kataHUDfiles/opengl/weapon_smg.png"}
	  weapons["assault rifle"] = Images.new{path = "kataHUDfiles/opengl/weapon_ar.png"}
	  weapons["fusion pistol"] = Images.new{path = "kataHUDfiles/opengl/weapon_fusionpistol.png"}
	  weapons["missile launcher"] = Images.new{path = "kataHUDfiles/opengl/weapon_spnkr.png"}
	  weapons["alien weapon"] = Images.new{path = "kataHUDfiles/opengl/weapon_alien.png"}

	  else
	  weapons["fist"] = Images.new{path = "kataHUDfiles/weapon_fist_right.png"}
	  weapons["flamethrower"] = Images.new{path = "kataHUDfiles/weapon_flamethrower.png"}
	  weapons["pistol"] = Images.new{path = "kataHUDfiles/weapon_magnum_right.png"}
	  weapons["pistol2"] = Images.new{path = "kataHUDfiles/weapon_magnum_left.png"}
	  weapons["shotgun"] = Images.new{path = "kataHUDfiles/weapon_shotgun_front.png"}
	  weapons["shotgun2"] = Images.new{path = "kataHUDfiles/weapon_shotgun_back.png"}
	  weapons["smg"] = Images.new{path = "kataHUDfiles/weapon_smg.png"}
	  weapons["assault rifle"] = Images.new{path = "kataHUDfiles/weapon_ar.png"}
	  weapons["fusion pistol"] = Images.new{path = "kataHUDfiles/weapon_fusionpistol.png"}
	  weapons["missile launcher"] = Images.new{path = "kataHUDfiles/weapon_spnkr.png"}
	  weapons["alien weapon"] = Images.new{path = "kataHUDfiles/weapon_alien.png"}
	  end


	  weapons_disabled = { }
	  if opengl then
	  weapons_disabled["fist"] = Images.new{path = "kataHUDfiles/opengl/weapon_fist_right_empty.png"}
	  weapons_disabled["pistol"] = Images.new{path = "kataHUDfiles/opengl/weapon_magnum_right_empty.png"}
	  weapons_disabled["pistol2"] = Images.new{path = "kataHUDfiles/opengl/weapon_magnum_left_empty.png"}
	  weapons_disabled["shotgun"] = Images.new{path = "kataHUDfiles/opengl/weapon_shotgun_front_empty.png"}
	  weapons_disabled["shotgun2"] = Images.new{path = "kataHUDfiles/opengl/weapon_shotgun_back_empty.png"}

	  else
	  weapons_disabled["fist"] = Images.new{path = "kataHUDfiles/weapon_fist_right_empty.png"}
	  weapons_disabled["pistol"] = Images.new{path = "kataHUDfiles/weapon_magnum_right_empty.png"}
	  weapons_disabled["pistol2"] = Images.new{path = "kataHUDfiles/weapon_magnum_left_empty.png"}
	  weapons_disabled["shotgun"] = Images.new{path = "kataHUDfiles/weapon_shotgun_front_empty.png"}
	  weapons_disabled["shotgun2"] = Images.new{path = "kataHUDfiles/weapon_shotgun_back_empty.png"}
	  end


	  Triggers.resize()
end


function Triggers.draw()

	Screen.fill_rect(sx, sh - 160, 800, 160, HUD_background_color)

	  -------------------------------------- inventory --------------------------------------
	  do
		    local inv_h = dejaheight * 9
		    local inv_w = 135
		    local inv_x = sx + 200
		    local inv_y = sh - 130
		    local inv_y1 = sh - 130
		    clip(inv_x, inv_y, inv_w, inv_h)

		    local sec = Player.inventory_sections.current


		    -------------------------------------- content area --------------------------------------
		    inv_y = inv_y + dejaheight
		    inv_h = inv_h - dejaheight

		    if #Game.players > 1 then
			      -------------------------------------- player list and rankings --------------------------------------
			      local all_players = sorted_players()
			      local gametype = Game.type
			      if gametype == "netscript" then
				        gametype = Game.scoring_mode
			      end

			      local mw1, mh1 = deja:measure_text("00:00")
			      local mx1 = inv_x + mw1 + dejawidth
			      local mwh1 = mw1 + math.floor(dejawidth/2)

			      for i = 1,#all_players do
				        local p = all_players[i]

				        -------------------------------------- Score and TeamColor --------------------------------------
				        local score = ranking_text(gametype, p.ranking)
				        local iw1, ih1 = deja:measure_text(score)
				        deja:draw_text(score, inv_x + mw1 - iw1 , inv_y1, {1, 1, 1, 1})
      				        Screen.fill_rect(mx1 - 10, inv_y1, 9, dejaheight, colortable[p.team.mnemonic])

				        -------------------------------------- PlayerName and PlayerColor --------------------------------------
				        deja:draw_text(p.name, mx1, inv_y1, colortable[p.color.mnemonic])

						if p.name == Player.name then
							Screen.frame_rect(inv_x , inv_y1, inv_w  , dejaheight, colortable[p.color.mnemonic], 1)
						else
							Screen.frame_rect(inv_x , inv_y1, inv_w  , dejaheight, HUD_background_color, 1)
						end

				        inv_y1 = inv_y1 + dejaheight
			      end
		    end

			unclip()
		  -------------------------------------- item list --------------------------------------
		    if sec.type ~= "network statistics" and not Player.dead then
		      local mw, mh = deja:measure_text("999")
		      local mx = inv_x + mw + dejawidth
		      if #Game.players > 1 then
		        inv_a = inv_w
		      else
		        inv_a = 0
		      end
		      for i = 1,#ItemTypes do
		        local item = Player.items[i - 1]
		        local name = ItemTypes[i - 1]
		        if (item.count > 0 and item.inventory_section == sec.type ) and not (name == "knife") then
		          local ct = string.format("%d", item.count)
		          local iw, ih = deja:measure_text(ct)
		          deja:draw_text(ct, inv_x + mw - iw + inv_a, inv_y - dejaheight, item_color)

		          local iname
		          if item.count == 1 then
		            iname = item.singular
		          else
		            iname = item.plural
		          end
		          deja:draw_text(iname, mx + inv_a, inv_y - dejaheight, item_color)
		          inv_y = inv_y + dejaheight
		        end
		      end
		    elseif Player.dead then
				miyoco:draw(inv_x + 150, inv_y - 10)
		    end
	  end

	  local left_x = sx - 7
	  local left_y = sy + sh - 160

	  -------------------------------------- motion sensor --------------------------------------
  	 if Player.motion_sensor.active then
	    if not env_damage_hide then
		      grid:draw(left_x, left_y)
			  grid.tint_color = weapon_color
		      local sens_rad = 56
		      local sens_brad = player[0].width
		      sens_rad = sens_rad + sens_brad/2
		      local sens_xcen = left_x + 85
		      local sens_ycen = left_y + 77

		      local compass_xoff = left_x + 47
		      local compass_yoff = left_y + 39
		      if Player.compass.nw then
			        compass.crop_rect.x = 0
			        compass.crop_rect.y = 0
			        if Player.compass.ne then
				          compass.crop_rect.width = compass.width
			        else
				          compass.crop_rect.width = compass.width / 2
			        end
			        if Player.compass.sw then
				          compass.crop_rect.height = compass.height
			        else
				          compass.crop_rect.height = compass.height / 2
			        end
			        compass:draw(compass_xoff, compass_yoff)
		      elseif Player.compass.ne then
			        compass.crop_rect.x = compass.width / 2
			        compass.crop_rect.y = 0
			        compass.crop_rect.width = compass.width / 2
			        if Player.compass.se then
				          compass.crop_rect.height = compass.height
			        else
				          compass.crop_rect.height = compass.height / 2
			        end
			        compass:draw(compass_xoff + compass.width/2, compass_yoff)
		      elseif Player.compass.sw then
				        compass.crop_rect.x = 0
				        compass.crop_rect.y = compass.height / 2
				        if Player.compass.se then
						          compass.crop_rect.width = compass.width
				        else
						          compass.crop_rect.width = compass.width / 2
				        end
				        compass.crop_rect.height = compass.height / 2
				        compass:draw(compass_xoff, compass_yoff + compass.height/2)
		      elseif Player.compass.se then
				        compass.crop_rect.x = compass.width / 2
				        compass.crop_rect.y = compass.height / 2
				        compass.crop_rect.width = compass.width / 2
				        compass.crop_rect.height = compass.height / 2
				        compass:draw(compass_xoff + compass.width/2, compass_yoff + compass.height/2)
		      end


		      for i = 1,#Player.motion_sensor.blips do
				        local blip = Player.motion_sensor.blips[i - 1]
				        local mult = blip.distance * sens_rad / 8
				        local rad = math.rad(blip.direction)
				        local xoff = sens_xcen + math.cos(rad) * mult
				        local yoff = sens_ycen + math.sin(rad) * mult

				        local alpha = 1
				        local int = blip.intensity
				        if int > 0 then
					          alpha = 1 / (int + 1)
				        end
				        local img = player[int]
				        if blip.type == "alien" then
						          img = alien[int]
				        end
				        if blip.type == "hostile player" then
						          img = hostile[int]
				        end
				        img.tint_color = { 1, 1, 1, alpha }
				        img:draw(xoff - math.floor(img.width/2), yoff - math.floor(img.height/2))
		      end
	    end
	else

	end

	HUD:draw(sx, sh - 160)

	if not Player.motion_sensor.active then
		shield:draw(left_x, left_y)
	end
	  -------------------------------------- GameType and TimeRemaining@--------------------------------------

	  if #Game.players > 0 then
		    local net_w = 394
		    local net_h = math.floor(20)
		    local net_x = sx + sw - 272
		    local net_y = sy + sh - 158

		    local gametype = Game.type
		    if gametype == "netscript" then
			      gametype = Game.scoring_mode
		    end
		    netrow_header(net_x, net_y, net_w, net_h, gametype)
	  end


	  -------------------------------------- LocalPlayerName@--------------------------------------

			local text_x = left_x + 391 - netf:measure_text(Player.name)/2
			netf:draw_text(Player.name, text_x , sy + sh - 158 , colortable[Player.color.mnemonic])


	  -------------------------------------- oxygen bar --------------------------------------
	  do
		    local otwo_x = left_x + 483
		    local otwo_y = left_y + 143

		    draw_bar(otwo, otwocap, otwo_x, otwo_y, Player.oxygen, 10800)
			local oxygen_percentage = math.floor(Player.oxygen/108)
			local op_width = netf:measure_text(oxygen_percentage)
		    netf:draw_text(oxygen_percentage.. " \%", otwo_x + 225 - op_width, otwo_y - 4, { 1, 1, 1, 1 })
	  end


	  -------------------------------------- health bar --------------------------------------
	  do
		    local life_x = left_x + 185
		    local life_y = left_y + 143

			local health_percentage = math.floor(Player.life/1.5)
			local hp_width = netf:measure_text(health_percentage)

		    local life_amt = Player.life
		    if life_amt > 0 then
			      draw_bar(life1, life1cap, life_x, life_y, math.min(150, life_amt), 150)
		    end
		    if life_amt > 150 then
			      draw_bar(life2, nil, life_x, life_y, math.min(150, life_amt - 150), 150)
		    end
		    if life_amt > 300 then
			      draw_bar(life3, nil, life_x, life_y, math.min(150, life_amt - 300), 150)
		    end
			netf:draw_text(health_percentage.." \%", life_x + 225 - hp_width , life_y - 4, { 1, 1, 1, 1 })
	  end


	  local right_x = sx + sw - 300
	  local right_y = sy + sh - 160


	 -------------------------------------- ammo/weapons --------------------------------------
	  local weapon = Player.weapons.desired
	  if Player.dead then
    		wep = nil
    	  return
  	  end
      	  if weapon then
		    if not wep then
			      wep = { }
			      wep[1] = { p = weapon, t = Game.ticks }
		    end
		    if not (wep[#wep].p == weapon) then
			      wep[#wep].t = wep[#wep].t - 1
			      table.insert(wep, { p = weapon, t = Game.ticks })
		    else
			      wep[#wep].t = Game.ticks
		    end
		    while (Game.ticks - wep[1].t) >= 2 do
			      table.remove(wep, 1)
		    end

		    local h = 137
		    local sty = h
		    local frac = h
		    for i,v in ipairs(wep) do
			      local t = Game.ticks - v.t
			      local edy = math.floor(t*frac)
			      if edy < sty then
				        Screen.clip_rect.y = right_y + edy
				        Screen.clip_rect.height = sty - edy
				        draw_weapons(v.p, right_x, right_y)
			      end
			      sty = edy - math.floor(frac)
		    end

		    Screen.clip_rect.y = 0
		    Screen.clip_rect.height = Screen.height

	  end
end

function Triggers.resize()
	  Screen.clip_rect.width = Screen.width
	  Screen.clip_rect.x = 0
	  Screen.clip_rect.height = Screen.height
	  Screen.clip_rect.y = 0

	  Screen.map_rect.width = Screen.width
	  Screen.map_rect.x = 0
	  Screen.map_rect.height = Screen.height
	  Screen.map_rect.y = 0

	  local h = math.min(Screen.height, Screen.width / 1.5)
	  local w = math.min(Screen.width, h*2)

	  Screen.world_rect.width = Screen.width
	  Screen.world_rect.x = 0
	  Screen.world_rect.height = Screen.height - 160
	  Screen.world_rect.y = 0

	  sx = Screen.width/2 -400
	  sy = 0
	  sw = 800
	  sh = Screen.height

	  deja = Fonts.new{size = 10, style = 0}
	  dejawidth, dejaheight = deja:measure_text("  ")



	  bgf = Fonts.new{file = "Themes/Default/bankgthd.ttf", size = 20, style = 0}
	  netf = Fonts.new{file = "Themes/Default/bankgthd.ttf", size = 14, style = 0}

	  local th = math.max(320, math.floor(sh - 192))
	  local tw = math.max(640, sw)
	  h = math.min(tw / 2, th)
	  w = h*2
	  Screen.term_rect.width = w
	  Screen.term_rect.x = sx + (sw - w)/2
	  Screen.term_rect.height = h
	  Screen.term_rect.y = sy + (th - h)/2

end


function draw_weapons(weapon, right_x, right_y)
	  if not weapon then return end
	  if env_damage_hide then return end
	  local wp = weapon.primary
	  local ws = weapon.secondary
	  local primary_ammo = nil
	  local secondary_ammo = nil

	  if wp and wp.ammo_type then
		    primary_ammo = wp.ammo_type
	  end

	  if ws and ws.ammo_type then
		    secondary_ammo = ws.ammo_type
		    if secondary_ammo == primary_ammo then
			      if Player.items[weapon.type.mnemonic].count < 2 then
				        secondary_ammo = nil
				        ws = nil
			      end
		    end
	  end

	  local force_primary = false
	  local force_secondary = false
	  if not dim_weapon then
		    if not (weapon == Player.weapons.current) then
			      if (wp and wp.rounds > 0) or (primary_ammo and Player.items[primary_ammo].count > 0) then
				        force_primary = true
			      elseif ws and ws.rounds > 0 then
				        force_secondary = true
			      end
		    end
	  end

	  local item = nil
	  if primary_ammo then
		    item = Player.items[primary_ammo]
	  end
	  local item2 = nil
	  if secondary_ammo then
		    item2 = Player.items[secondary_ammo]
	  end

	  local img = player
	  local img2 = player

	  img = weapons[weapon.type.mnemonic]
	  if img then
		    if wp.weapon_drawn or force_primary then
			      img.tint_color = weapon_color
		    else
			      if weapons_disabled[weapon.type.mnemonic] then
				        img = weapons_disabled[weapon.type.mnemonic]
			      end
			      img.tint_color = weapon_color
		    end
		    img:draw(right_x, right_y)
	  end

	  if primary_ammo == secondary_ammo then
		    img2 = weapons[weapon.type.mnemonic .. "2"]
		    if img2 then
			      if ws.weapon_drawn or force_secondary then
				        img2.tint_color = weapon_color
			      else
				        if weapons_disabled[weapon.type.mnemonic .. "2"] then
					          img2 = weapons_disabled[weapon.type.mnemonic .. "2"]
				        end
				        img2.tint_color = weapon_color
			      end
			      img2:draw(right_x, right_y)
		    end
	  end

	  local bullet = nil
	  if primary_ammo then
		    bullet = primary_ammo.mnemonic
	  end
	  local bullet2 = nil
	  if secondary_ammo then
		    bullet2 = secondary_ammo.mnemonic
	  end


	  if weapon.type == "pistol" then
		    draw_bullet(bullet, right_x, right_y, 158, 104, wp.rounds, wp.total_rounds, true)
		    if ws then
			      draw_bullet(bullet2, right_x, right_y, 60, 104, ws.rounds, ws.total_rounds)
		    end
		    draw_reserve(item, right_x, right_y, 135, 102)

	  elseif weapon.type == "shotgun" then
		    draw_bullet(bullet, right_x, right_y, 74, 104, wp.rounds, 1)
		    if ws then
			      draw_bullet(bullet2, right_x, right_y, 116, 104, ws.rounds, 1)
		    end
		    draw_reserve(item, right_x, right_y, 40, 102)
	  elseif weapon.type == "fusion pistol" then
		    draw_energy(right_x, right_y, 75, 43, wp.rounds, wp.total_rounds)
		    draw_reserve(item, right_x, right_y, 40, 102)
	  elseif weapon.type == "flamethrower" then
		    draw_energy(right_x, right_y, 75, 43, wp.rounds, wp.total_rounds)
		    draw_reserve(item, right_x, right_y, 40, 102)
	  elseif weapon.type == "missile launcher" then
		    draw_bullet(bullet, right_x, right_y, 10, 45, wp.rounds, wp.total_rounds)
		    draw_reserve(item, right_x, right_y, 110, 102)
	  elseif weapon.type == "assault rifle" then
		    local r = math.floor(16)
		    draw_bullet(bullet, right_x, right_y, 13, 36, wp.rounds, 13)
		    draw_bullet(bullet, right_x, right_y, 13, 36 + r, wp.rounds - 13, 13)
		    draw_bullet(bullet, right_x, right_y, 13, 36 + 2*r, wp.rounds - 26, 13)
		    draw_bullet(bullet, right_x, right_y, 13, 36 + 3*r, wp.rounds - 39, 13)
		    draw_bullet(bullet2, right_x, right_y, 11, 110, ws.rounds, ws.total_rounds)
		    draw_reserve(item,  right_x, right_y, 110, 88)
		    draw_reserve(item2, right_x, right_y, 110, 106)
	  elseif weapon.type == "smg" then
		    local r = math.floor(15)
		    draw_bullet(bullet, right_x, right_y, 30, 43, wp.rounds, 8)
		    draw_bullet(bullet, right_x, right_y, 30, 43 + r, wp.rounds - 8, 8)
		    draw_bullet(bullet, right_x, right_y, 30, 43 + 2*r, wp.rounds - 16, 8)
		    draw_bullet(bullet, right_x, right_y, 30, 43 + 3*r, wp.rounds - 24, 8)
		    draw_reserve(item, right_x, right_y, 40, 102)
	  elseif weapon.type == "alien weapon" then
		    if opengl then
			      if math.random() < 0.6 then
				        alien_wstatic = math.random(6)
			      end
			      if math.random() < 0.6 then
				        alien_wstatic2 = math.random(6)
			      end
		    end
	  end

	  if Player.items["ball"].count == 1 then
		kotsu:draw(right_x, right_y)
		kotsu.tint_color = weapon_color
	  end
end

function draw_bar(bar, cap, x, y, cur, max)
	  if cur == max then
		    -- draw completely full bar, cap is ignored
		    bar.crop_rect.width = bar.width
		    bar:draw(x, y)
	  elseif cur > 0 then
		    local w = math.floor(bar.width * cur / max)
		    if not cap then
			      -- if no cap, just crop bar directly
			      bar.crop_rect.width = w
			      bar:draw(x, y)
		    elseif w >= cap.width*2 then
			      -- add cap onto end of cropped bar
			      bar.crop_rect.width = w - cap.width
			      bar:draw(x, y)
			      cap.crop_rect.width = cap.width
			      cap.crop_rect.x = 0
			      cap:draw(x + w - cap.width, y)
		    else
			      -- crop both bar and cap equally
			      local lh = math.floor(w / 2)
			      local rh = w - lh
			      if lh then
				        bar.crop_rect.width = lh
				        bar:draw(x, y)
			      end
			      cap.crop_rect.width = rh
			      cap.crop_rect.x = cap.width - rh
			      cap:draw(x + lh, y)
		    end
	  end
end

function draw_energy(xstart, ystart, xoff, yoff, cur, max)
	  local box = ammo["energy box"]
	  if not box then return end

	  local x = xstart + xoff
	  local y = ystart + yoff
	  box.tint_color = weapon_color
	  box:draw(x, y)

	  if cur <= 0 then return end
	  local fill = ammo["energy ammo"]
	  if not fill then return end

	  local w = box.width
	  local h = box.height
	  if cur == max then
		    fill:rescale(w, h)
	  else
		    local fh = math.floor(h * cur / max)
		    if fh <= 0 then return end
		    fill:rescale(w, fh)
	  end
	  fill.tint_color = weapon_color
	  fill:draw(x, y + h - fill.height)
end

function draw_bullet(item, xstart, ystart, xoff, yoff, cur, max, reverse)
	  local img_act = ammo[item]
	  if not img_act then return end
	  local img_dis = ammo_disabled[item]
	  if not img_dis then img_dis = img_act end
	  local x = xstart + xoff
	  local y = ystart + yoff
	  for i = 1,max do
		    local active = false
		    local img = nil
		    if reverse and (i > (max - cur)) then
			      active = true
		    elseif (not reverse) and (i <= cur) then
			      active = true
		    end
		    if active then
			      img = img_act
			      img.tint_color = weapon_color
		    else
			      img = img_dis
			      img.tint_color = weapon_color
			end
		    img:draw(x, y)
		    x = x + img.width
	  end
end



function draw_reserve(item, xstart, ystart, xoff, yoff)
	  if not item then return end
	  local txt = item.count .. "x"
	  local tw, th = bgf:measure_text(txt)
	  bgf:draw_text(txt,
	                xstart + xoff - tw/2,
	                ystart + yoff,weapon_color)
end

function format_time(ticks)
	   local secs = math.ceil(ticks / 30)
	   return string.format("%d:%02d", math.floor(secs / 60), secs % 60)
end

function net_gamename(gametype)
	  if not gamename then
		    gamename = { }
		    gamename["kill monsters"] = "EMfH"
		    gamename["cooperative play"] = "Co-op"
		    gamename["capture the flag"] = "CTF"
		    gamename["king of the hill"] = "Koth"
		    gamename["kill the man with the ball"] = "Kotsu"
		    gamename["rugby"] = "Rugby"
		    gamename["tag"] = "Onigoko"
		    gamename["defense"] = "Defense"

		    gamename["most points"] = "Netscript"
		    gamename["least points"] = "Netscript"
		    gamename["most time"] = "Netscript"
		    gamename["least time"] = "Netscript"
	  end

	  return gamename[gametype.mnemonic]
end

function net_gamelimit()
	  if Game.time_remaining then
		    return format_time(Game.time_remaining)
	  end
	  if Game.kill_limit then
		    local max_kills = 0
		    for i = 1,#Game.players do
			      max_kills = math.max(max_kills, Game.players[i - 1].kills)
		    end
		    return string.format("%d", Game.kill_limit - max_kills)
	  end
	  return nil
end

function ranking_text(gametype, ranking)
	  if (gametype == "kill monsters") or
		     (gametype == "capture the flag") or
		     (gametype == "rugby") or
		     (gametype == "most points") then
		    return string.format("%d", ranking)
	  end
	  if (gametype == "least points") then
		    return string.format("%d", -ranking)
	  end
	  if (gametype == "cooperative play") then
		    return string.format("%d%%", ranking)
	  end
	  if (gametype == "most time") or
	     (gametype == "least time") or
	     (gametype == "king of the hill") or
	     (gametype == "kill the man with the ball") or
	     (gametype == "defense") or
	     (gametype == "tag") then
		    return format_time(math.abs(ranking))
	  end

	  -- unknown
	  return nil
end

function comp_player(a, b)
	  if a.ranking > b.ranking then
		    return true
	  end
	  if a.ranking < b.ranking then
		    return false
	  end
	  if a.name < b.name then
		    return true
	  end
	  return false
end

function sorted_players()
	  local tbl = {}
	  for i = 1,#Game.players do
		    table.insert(tbl, Game.players[i - 1])
	  end
	  table.sort(tbl, comp_player)
	  return tbl
end

function netrow_header(x, y, w, h, gametype)
	  local lt = net_gamename(gametype).. " : "
	  local rt = net_gamelimit()
	  if not rt then
		    rt = "No Timelimit"
	  end
	  netrow_text(x, y, w, h, lt, rt)
end

function netrow_text(x, y, w, h, left_text, right_text)
	  if Game.time_remaining then
			if (Game.time_remaining <= 1800) and (Game.time_remaining >= 900) then
				time_color = {1, 1, 0, 1}
			elseif (Game.time_remaining <= 900) then
				time_color = {1, 0, 0, 1}
			else
				time_color = {1, 1, 1, 1}
			end
	  else
		time_color = {1, 1, 1, 1}
	  end

	  if left_text then
		    local lw, lh = netf:measure_text(left_text)
		    local lx = x + 60
		    local ly = math.floor(y + (h - lh)/2) - 2
		    netf:draw_text(left_text, lx, ly, time_color)
	  end
	  if right_text then
		    local lw, lh = netf:measure_text(right_text)
		    local lx = x + netf:measure_text(left_text) + 60
		    local ly = math.floor(y + (h - lh)/2) - 2
		    netf:draw_text(right_text, lx, ly, time_color)
	  end
end

function clip(x, y, w, h)
	  local rect = Screen.clip_rect
	  rect.x = x
	  rect.y = y
	  rect.width = w
	  rect.height = h
end

function unclip()
	  local rect = Screen.clip_rect
	  rect.x = 0
	  rect.y = 0
	  rect.width = Screen.width
	  rect.height = Screen.height
end

function net_header()
	  if Game.time_remaining then
		    return format_time(Game.time_remaining)
	  end
	  if Game.kill_limit then
		    local max_kills = 0
		    for i = 1,#Game.players do
			      max_kills = math.max(max_kills, Game.players[i - 1].kills)
		    end
		    return string.format("%d", Game.kill_limit - max_kills)
	  end
	  return nil
end

