/*============================================
//薼FGLCD֐
//t@CFglcd_my.h
//tF2012/03/17
//OFKK
============================================*/
/*==============================`==============================*/
#define	SDA		LATAbits.LATA0
#define	CS		LATAbits.LATA1
#define	SCK		LATAbits.LATA2
#define	RES		LATAbits.LATA3

/* Epson S1D15G10 Command Set */
#define DISON       0xaf
#define DISOFF      0xae
#define DISNOR      0xa6
#define DISINV      0xa7
#define SLPIN       0x95
#define SLPOUT      0x94
#define COMSCN      0xbb
#define DISCTL      0xca
#define PASET       0x75
#define CASET       0x15
#define DATCTL      0xbc
#define RGBSET8     0xce
#define RAMWR       0x5c
#define RAMRD       0x5d
#define PTLIN       0xa8
#define PTLOUT      0xa9
#define RMWIN       0xe0
#define RMWOUT      0xee
#define ASCSET      0xaa
#define SCSTART     0xab
#define OSCON       0xd1
#define OSCOFF      0xd2
#define PWRCTR      0x20
#define VOLCTR      0x81
#define VOLUP       0xd6
#define VOLDOWN     0xd7
#define TMPGRD      0x82
#define EPCTIN      0xcd
#define EPCOUT      0xcc
#define EPMWR       0xfc
#define EPMRD       0xfd
#define EPSRRD1     0x7c
#define EPSRRD2     0x7d
#define NOP         0x25
/*F`*/
#define	RED			0x00F
#define	GREEN		0x0F0
#define	BLUE		0xF00
#define	CYAN		0xFF0
#define	MAGENTA		0xF0F
#define	YELLOW		0x0FF
#define LIGHTGREEN	0x2FF
#define	PINK		0xCCF
#define	ORANGE		0x0AF
#define	BROWN		0x22A
#define	NAVY		0x800
#define	PURPLE		0x808
#define	GRAY		0x888
#define	DARKGRAY	0xAAA
#define	BLACK		0x000
#define	WHITE		0xFFF

#define	X_MIN		0
#define	X_MAX		131
#define	Y_MIN		0
#define	Y_MAX		131
#define	X_CHAR		(unsigned char)(X_MAX / 5)
#define	Y_CHAR		(unsigned char)(Y_MAX / 8)
#define	X_OFFSET	2	/*W̃YC*/

/*==============================֐`==============================*/
void GLCD_Init(void);
void GLCD_Locate(unsigned int,unsigned int);
void GLCD_RAMWrite(unsigned int);
void GLCD_Clear(unsigned int);
void GLCD_Pixel(unsigned int,unsigned int,unsigned int);
void GLCD_Line(unsigned int,unsigned int,unsigned int,unsigned int,unsigned int);
void GLCD_Rect(unsigned int,unsigned int,unsigned int,unsigned int,unsigned int);
void GLCD_RectFull(unsigned int,unsigned int,unsigned int,unsigned int,unsigned int);
void GLCD_Circle(unsigned int,unsigned int,unsigned int,unsigned int);
void GLCD_CircleFull(unsigned int,unsigned int,unsigned int,unsigned int);
void GLCD_Character(unsigned int,unsigned int,unsigned char,unsigned int,unsigned int);
void spi_command(unsigned char);
void spi_data(unsigned char);
void Delay_ms(unsigned int);


/*==============================LCDݒ==============================*/
void GLCD_Init(void)
{
	/*Reset*/
	RES = 0;
	Delay_ms(100);	/*100ms wait*/
	RES = 1;
	
	spi_command(DISCTL);
	spi_data(0x00);			/*P1:0x00=2 divisions,switching period=8 (default)*/
	spi_data(0x20);			/*P2:0x20=nlines/4-1 = 132/4 - 1 = 32*/
	spi_data(0x00);			/*P3:0x00=no inversely highlighted lines*/
	spi_data(0x00);
	
	spi_command(COMSCN);
	spi_data(0x01);			/*Scan 1->80 160<-81 ރAhXB̏ꍇォ牺*/
	
	spi_command(OSCON);		/*internal oscilator ON*/
	
	spi_command(SLPOUT);	/*sleep out*/
	
	spi_command(PWRCTR);	/*power ctrl*/
	spi_data(0x0F);			/*everything on, no external reference resistors*/
	Delay_ms(100);
	
	spi_command(DISINV);	/*invert display mode*/
	
	spi_command(DATCTL);	/*data control*/
	spi_data(0x01);			/*normal display of page/column address, page scan direction*/
	spi_data(0x00);			/*normal RGB arrangement*/
	spi_data(0x04);			/*16-bit grayscale type B*/
    
	spi_command(VOLCTR);
	spi_data(33);
	spi_data(3);
	Delay_ms(100);
    
	spi_command(DISON);		/*display on*/
}	

/*==============================LCDWw==============================*/
void GLCD_Locate(unsigned int x,unsigned int y)
{
	/*Page Set*/
	spi_command(PASET);
	spi_data(y);
	spi_data(y);
	
	/*Colum Set*/
	spi_command(CASET);
	spi_data(x + X_OFFSET);
	spi_data(x + X_OFFSET);	
}

/*==============================LCD RAM==============================*/
void GLCD_RAMWrite(unsigned int data)
{
	/*16 gray-scale type-B 8bit-mode*/
	spi_data((unsigned char)((data >> 8) & 0x0F));
	spi_data((unsigned char)(data & 0xFF));
}	
	
/*==============================LCDNA==============================*/
void GLCD_Clear(unsigned int color)
{
	int i;
	
	/*Page Set*/
	spi_command(PASET);
	spi_data(Y_MIN);
	spi_data(Y_MAX);
	
	/*Colum Set*/
	spi_command(CASET);
	spi_data(X_MIN + X_OFFSET);
	spi_data(X_MAX + X_OFFSET);
	
	/*RAM Write*/
	spi_command(RAMWR);
	for (i = 0 ; i < ((131*131) / 1) ; i++){
		GLCD_RAMWrite(color);
	}	
}

/*==============================hbgo==============================*/
void GLCD_Pixel(unsigned int x,unsigned int y,unsigned int color)
{
	/*Ww*/
	GLCD_Locate(x,y);
	/*RAM֏*/
	spi_command(RAMWR);
	GLCD_RAMWrite(color);
}

/*==============================Co==============================*/
void GLCD_Line(unsigned int x0,unsigned int y0,unsigned int x1,unsigned int y1,unsigned int color)
{
	int dx = x1 - x0;
	int dy = y1 - y0;
	int stepx = 0;
	int stepy = 0;
	int frac = 0;
	
	if (dx < 0){
		dx = -dx;
		stepx = -1;
	}else{
		stepx = 1;
	}
	if (dy < 0){
		dy = -dy;
		stepy = -1;
	}else{
		stepy = 1;
	}		
	
	GLCD_Pixel(x0,y0,color);
	
	if (dx > dy){
		frac = dy - (dx >> 1);
		while (x0 != x1){
			if (frac >= 0){
				y0 += stepy;
				frac -= dx;
			}
			x0 += stepx;
			frac += dy;
			GLCD_Pixel(x0,y0,color);
		}
	}else{
		frac = dx - (dy >> 1);
		while (y0 != y1){
			if (frac >= 0){
				x0 += stepx;
				frac -= dy;
			}
			y0 += stepy;
			frac += dx;
			GLCD_Pixel(x0,y0,color);
		}
	}			
}

/*==============================lp`óiĝ݁j==============================*/
void GLCD_Rect(unsigned int x0,unsigned int y0,unsigned int x1,unsigned int y1,unsigned int color)
{
	GLCD_Line(x0,y0,x1,y0,color);
	GLCD_Line(x0,y1,x1,y1,color);
	GLCD_Line(x0,y0,x0,y1,color);
	GLCD_Line(x1,y0,x1,y1,color);
}

/*==============================lp`óiShj==============================*/
void GLCD_RectFull(unsigned int x0,unsigned int y0,unsigned int x1,unsigned int y1,unsigned int color)
{
	int i;
	int xmin = (x0 <= x1) ? x0 : x1;
	int xmax = (x0 > x1) ? x0 : x1;
	int ymin = (y0 <= y1) ? y0 : y1;
	int ymax = (y0 > y1) ? y0 : y1;
	
	spi_command(PASET);
	spi_data(ymin);
	spi_data(ymax);
	
	spi_command(CASET);
	spi_data(xmin + X_OFFSET);
	spi_data(xmax + X_OFFSET);
	
	spi_command(RAMWR);
	for (i = 0 ; i < ((xmax - xmin + 1) * (ymax - ymin + 1)) ; i++){
		GLCD_RAMWrite(color);		
	}	
}

/*==============================~óiĝ݁j==============================*/
void GLCD_Circle(unsigned int x0,unsigned int y0,unsigned int round,unsigned int color)
{
	int x = round;
	int y = 0;
	int f = -2 * round + 3;
	
	while (x >= y){
		GLCD_Pixel(x0 + x,y0 + y,color);
		GLCD_Pixel(x0 - x,y0 + y,color);
		GLCD_Pixel(x0 + x,y0 - y,color);
		GLCD_Pixel(x0 - x,y0 - y,color);
		GLCD_Pixel(x0 + y,y0 + x,color);
		GLCD_Pixel(x0 - y,y0 + x,color);
		GLCD_Pixel(x0 + y,y0 - x,color);
		GLCD_Pixel(x0 - y,y0 - x,color);
		
		if (f >= 0){
			x--;
			f -= 4 * x;
		}
		y++;
		f += 4 * y + 2;	
	}	
}

/*==============================~óiShj==============================*/
void GLCD_CircleFull(unsigned int x0,unsigned int y0,unsigned int round,unsigned int color)
{
	int i;
	for (i = round ; i > 0 ; i--){
		GLCD_Circle(x0,y0,i,color);
	}	
}

/*==============================o==============================*/
void GLCD_Character(unsigned int x,unsigned int y,unsigned char c,unsigned int c_cl,unsigned int b_cl)
{
	int dx;
	int dy;
	unsigned char offset_x = 2;		/*Ԃ̋󔒒@*/
	unsigned char offset_y = 1;		/*Ԃ̋󔒒@c*/
	unsigned int colum = x * (5 + offset_x);
	unsigned int row = y * (8 + offset_y);
	unsigned char rom_data;
	unsigned char buff = 0;
	unsigned int addr;
	
	/*AhXZbg*/
	addr = (unsigned int)(c - 0x20) * 10;

	/*\͈͓̂ݏo*/
	if ((X_CHAR >= x) && (x >= 0) && (Y_CHAR >= y) && (y >= 0)){
		for (dx = 0 ; dx < ((offset_x * 2) + 5) ; dx++){
			/*ItZbgo*/
			if ((dx < offset_x) || (dx >= (offset_x + 5))){
				buff = 0x00;
			}else{
				/*4rbg擾*/
				rom_data = EE_Read(0,addr++);
				if (rom_data > 0x60){
					buff = ((rom_data - 0x61) + 0x0A) << 4;
				}else{
					buff = (rom_data - 0x30) << 4;
				}
				/*4rbg擾*/
				rom_data = EE_Read(0,addr++);
				if (rom_data > 0x60){
					buff += ((rom_data - 0x61) + 0x0A);
				}else{
					buff += (rom_data - 0x30);
				}		
			}			
			
			/*1byteo(ItZbg)*/
			for (dy = 0 ; dy < ((offset_y * 2) + 8) ; dy++){
				if ((dy < offset_y) || (dy > (offset_y + 8))){
					GLCD_Pixel(colum + dx , row + dy , b_cl);
				}else{		
					if (buff & 0x01){
						GLCD_Pixel(colum + dx , row + dy , c_cl);
					}else{
						GLCD_Pixel(colum + dx , row + dy , b_cl);	
					}
					buff >>= 1;	
				}	
			}
		}
	}			
}
	
/*==============================LCDR}hM==============================*/
void spi_command(unsigned char data)
{
	int i;
	
	CS = 0;
	/*R}hMM*/
	SDA = 0;
	SCK = 0;
	SCK = 1;
	/*R}hM*/
	for(i = 7 ; i >= 0 ; i--){
		SCK = 0;
		if ((data >> i) & 0x01){
			SDA = 1;
		}else{
			SDA = 0;
		}
		SCK = 1;
	}
	CS = 1;			
}	

/*==============================LCDf[^M==============================*/
void spi_data(unsigned char data)
{
	int i;
	
	CS = 0;
	/*f[^MM*/
	SDA = 1;
	SCK = 0;
	SCK = 1;
	/*f[^M*/
	for(i = 7 ; i >= 0 ; i--){
		SCK = 0;
		if ((data >> i) & 0x01){
			SDA = 1;
		}else{
			SDA = 0;
		}
		SCK = 1;
	}
	CS = 1;			
}	

/*==============================msx==============================*/
void Delay_ms(unsigned int time)
{
	int i;
	for (i = 0 ; i < time ; i++){
		Delay1KTCYx(12);
	}	
}	
