/*============================================
//薼FI2C EEP@ǂݍ݁^
//t@CFi2c_eep_my.h
//tF2012/03/18
//OFKK
============================================*/

/*==============================֐`==============================*/
unsigned char EE_Read(char, unsigned int);
void EE_Write(char,int,unsigned char);

/*=====I2C EEPROM ǂݍ=====*/
unsigned char EE_Read(char chip, unsigned int address){
	unsigned char data;
	
	StartI2C();
	while (SSPCON2bits.SEN);
	
	WriteI2C((0xA0 | ((chip & 0x07) << 1)) & 0xFE);
	IdleI2C();
	WriteI2C(address >> 8);
	IdleI2C();
	WriteI2C(address & 0xff);
	IdleI2C();
	
	RestartI2C();
	while (SSPCON2bits.RSEN);

	WriteI2C((0xA0 | ((chip & 0x07) << 1)) | 0x01);
	IdleI2C();
	data = ReadI2C();
	
	SSPCON2bits.ACKDT = 1;
	SSPCON2bits.ACKEN = 1;
	while (SSPCON2bits.ACKEN);
	StopI2C();
	while (SSPCON2bits.PEN);
	return (data);
}

/*=====I2C EEPROM =====*/
void EE_Write(char chip, int address ,unsigned char data){

	StartI2C();
	while (SSPCON2bits.SEN);
	
	WriteI2C((0xA0 | ((chip & 0x07) << 1)) & 0xFE);
	IdleI2C();
	WriteI2C(address >> 8);
	IdleI2C();
	WriteI2C(address & 0xff);
	IdleI2C();
	WriteI2C(data);
	IdleI2C();

	StopI2C();
	while (SSPCON2bits.PEN);
	Delay10KTCYx(1);
}
